/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.nanoScheduler;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.MultiThreadedErrorTracker;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.sting.utils.nanoScheduler.EOFMarkedValue;

class InputProducer<InputType>
implements Runnable {
    private static final Logger logger = Logger.getLogger(InputProducer.class);
    final Iterator<InputType> inputReader;
    final SimpleTimer inputTimer;
    final BlockingQueue<InputValue> outputQueue;
    final MultiThreadedErrorTracker errorTracker;
    boolean readLastValue = false;
    int nRead = 0;
    int inputID = -1;
    final CountDownLatch latch = new CountDownLatch(1);

    public InputProducer(Iterator<InputType> inputReader, MultiThreadedErrorTracker errorTracker, SimpleTimer inputTimer, BlockingQueue<InputValue> outputQueue) {
        if (inputReader == null) {
            throw new IllegalArgumentException("inputReader cannot be null");
        }
        if (errorTracker == null) {
            throw new IllegalArgumentException("errorTracker cannot be null");
        }
        if (inputTimer == null) {
            throw new IllegalArgumentException("inputTimer cannot be null");
        }
        if (outputQueue == null) {
            throw new IllegalArgumentException("OutputQueue cannot be null");
        }
        this.inputReader = inputReader;
        this.errorTracker = errorTracker;
        this.inputTimer = inputTimer;
        this.outputQueue = outputQueue;
    }

    public synchronized int getNumInputValues() {
        return this.allInputsHaveBeenRead() ? this.nRead : -1;
    }

    public synchronized boolean allInputsHaveBeenRead() {
        return this.readLastValue;
    }

    private synchronized InputType readNextItem() throws InterruptedException {
        this.inputTimer.restart();
        if (!this.inputReader.hasNext()) {
            this.readLastValue = true;
            this.inputTimer.stop();
            return null;
        }
        InputType input = this.inputReader.next();
        this.inputTimer.stop();
        ++this.nRead;
        return input;
    }

    @Override
    public void run() {
        try {
            while (true) {
                InputType value;
                if ((value = this.readNextItem()) == null) break;
                this.outputQueue.put(new InputValue(++this.inputID, value));
            }
            this.outputQueue.put(new InputValue(this.inputID + 1));
            this.latch.countDown();
        }
        catch (Exception ex) {
            this.errorTracker.notifyOfError(ex);
        }
    }

    public void waitForDone() throws InterruptedException {
        this.latch.await();
    }

    class InputValue
    extends EOFMarkedValue<InputType> {
        final int id;

        private InputValue(int id, InputType datum) {
            super(datum);
            if (id < 0) {
                throw new IllegalArgumentException("id must be >= 0");
            }
            this.id = id;
        }

        private InputValue(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("id must be >= 0");
            }
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public InputValue nextEOF() {
            if (!this.isEOFMarker()) {
                throw new IllegalArgumentException("Cannot request next EOF marker for non-EOF marker InputValue");
            }
            return new InputValue(this.getId() + 1);
        }
    }
}

