(game-module "u-e50-1998"
  (title "Earth 50km/cell + 1998 Places")
  (blurb "Places in 1998 on the 50km/cell map")
  (variants
   (world-seen)
   (see-all)
   ;; The following is useful for hacking on the file
   (bare true
    (true
     (set synthesis-methods nil)
     (add u* start-with 0)
     (add city start-with 1)
     (add u* independent-near-start 0)
     (table independent-density (u* t* 0))
     (set sides-min 1)
     (set sides-max 1)
     ))
   )
  )

(include "earth-50km")

(include "t-e50-river")

(set synthesis-methods '(make-countries))

;; Rules: every country of at least 1,000,000 people gets at least
;; one town.  Beyond that, to qualify as a town, a place must have
;; both population and manufacturing capability.

;; Cities must be known megalopoli.  They must also contain sufficient
;; resources (scientific & technical) to develop nuclear weapons.

(base 263 283 0 (n "Aberdeen") (x (sides "British")))
(base 92 191 0 (n "Acapulco") (x (sides "Mexican")))
(base 680 76 0 (n "Adelaide") (x (sides "Australian")))
(base 600 245 0 (n "Akita") (x (sides "Japanese")))
(base 122 249 0 (n "Albany") (x (sides "American")))
(base 376 235 0 (n "Aleppo") (x (sides "Syrian")))
(base 485 211 0 (n "Allahabad") (x (sides "Indian")))
(base 120 244 0 (n "Allentown") (x (sides "American")))
(base 283 265 0 (n "Amiens") (x (sides "French")))
(base 464 225 0 (n "Amritsar") (x (sides "Indian")))
(base 732 290 0 (n "Anchorage") (x (sides "American")))
(base 360 236 0 (n "Antalya") (x (sides "Turk")))
(base 203 101 0 (n "Antofagasta") (x (sides "Chilean")))
(base 191 118 0 (n "Arequipa") (x (sides "Peruvian")))
(base 350 298 0 (n "Archangel'sk") (x (sides "Russian")))
(base 600 253 0 (n "Asahikawa") (x (sides "Japanese")))
(base 379 207 0 (n "Aswan") (x (sides "Egyptian")))
(base 372 214 0 (n "Asyut") (x (sides "Egyptian")))
(base 238 67 0 (n "Bahia Blanca") (x (sides "Argentinian")))
(base 594 151 0 (n "Balikpapan") (x (sides "Indonesian")))
(base 591 146 0 (n "Banjarmasin") (x (sides "Indonesian")))
(base 547 240 0 (n "Baoding") (x (sides "Chinese")))
(base 322 245 0 (n "Bari") (x (sides "Italian")))
(base 297 260 0 (n "Basel") (x (sides "Swiss")))
(base 407 221 0 (n "Basra") (x (sides "Iraqi")))
(base 97 222 0 (n "Baton Rouge") (x (sides "American")))
(base 377 247 0 (n "Batumi") (x (sides "Georgian")))
(base 90 221 0 (n "Beaumont") (x (sides "American")))
(base 487 211 0 (n "Benares") (x (sides "Indian")))
(base 342 225 0 (n "Benghazi") (x (sides "Libyan")))
(base 283 289 0 (n "Bergen") (x (sides "Norwegian")))
(base 477 208 0 (n "Bhopal") (x (sides "Indian")))
(base 325 272 0 (n "Bialystok") (x (sides "Polish")))
(base 278 250 0 (n "Bilbao") (x (sides "Spanish")))
(base 560 267 0 (n "Blagoveshchenk") (x (sides "Russian")))
(base 339 256 0 (n "Brasov") (x (sides "Romanian")))
(base 298 270 0 (n "Braunschweig") (x (sides "German")))
(base 273 262 0 (n "Brest") (x (sides "French")))
(base 584 164 0 (n "Brunei"))
(base 156 163 0 (n "Buenaventura") (x (sides "Colombian")))
(base 314 272 0 (n "Bydgoszcz") (x (sides "Polish")))
(base 279 235 0 (n "Cadiz") (x (sides "Spanish")))
(base 676 117 0 (n "Cairns") (x (sides "Australian")))
(base 326 236 0 (n "Catania") (x (sides "Italian")))
(base 580 261 0 (n "Chabarovsk") (x (sides "Russian")))
(base 119 226 0 (n "Charleston") (x (sides "American")))
(base 113 232 0 (n "Charlotte") (x (sides "American")))
(base 104 231 0 (n "Chattanooga") (x (sides "American")))
(base 66 217 0 (n "Chihuahua") (x (sides "Mexican")))
(base 439 248 0 (n "Chimkent") (x (sides "Kazakh")))
(base 527 270 0 (n "Chita") (x (sides "Russian")))
(base 513 203 0 (n "Chittagong") (x (sides "Bangladeshi")))
(base 185 172 0 (n "Ciudad Guayana") (x (sides "Venezuelan")))
(base 334 258 0 (n "Cluj-Napoca") (x (sides "Romanian")))
(base 205 116 0 (n "Cochabamba") (x (sides "Bolivian")))
(base 492 179 0 (n "Coimbatore") (x (sides "Indian")))
(base 146 174 0 (n "Colon") (x (sides "Panamanian")))
(base 212 71 0 (n "Concepcion") (x (sides "Chilean")))
(base 347 253 0 (n "Constanta") (x (sides "Romanian")))
(base 280 238 0 (n "Cordoba") (x (sides "Argentinian")))
(base 257 271 0 (n "Cork") (x (sides "Irish")))
(base 86 215 0 (n "Corpus Christi") (x (sides "American")))
(base 337 252 0 (n "Craiova") (x (sides "Romanian")))
(base 163 171 0 (n "Cucuta") (x (sides "Colombian")))
(base 557 189 0 (n "Da Nang") (x (sides "Vietnamese")))
(base 565 243 0 (n "Dandong") (x (sides "Chinese")))
(base 637 126 0 (n "Darwin") (x (sides "Australian")))
(base 604 170 0 (n "Davao") (x (sides "Filipino")))
(base 102 243 0 (n "Dayton") (x (sides "American")))
(base 328 260 0 (n "Debrecen") (x (sides "Hungarian")))
(base 80 246 0 (n "Des Moines") (x (sides "American")))
(base 381 237 0 (n "Diyarbakir") (x (sides "Turk")))
(base 417 179 0 (n "Djibouti"))
(base 278 268 0 (n "Dover") (x (sides "British")))
(base 428 210 0 (n "Dubai"))
(base 75 206 0 (n "Durango") (x (sides "Mexican")))
(base 444 249 0 (n "Dzambul") (x (sides "Kazakh")))
(base 381 242 0 (n "Erzurum") (x (sides "Turk")))
(base 11 252 0 (n "Eugene") (x (sides "American")))
(base 284 229 0 (n "Fez") (x (sides "Moroccan")))
(base 569 212 0 (n "Fuzhou") (x (sides "Chinese")))
(base 345 255 0 (n "Galati") (x (sides "Romanian")))
(base 376 236 0 (n "Gaziantep") (x (sides "Turk")))
(base 197 169 0 (n "Georgetown"))
(base 281 234 0 (n "Gibraltar") (x (sides "British")))
(base 242 116 0 (n "Goiania") (x (sides "Brazilian")))
(base 96 249 0 (n "Grand Rapids") (x (sides "American")))
(base 386 251 0 (n "Grozny") (x (sides "Russian")))
(base 541 213 0 (n "Guiyang") (x (sides "Chinese")))
(base 556 198 0 (n "Haikou") (x (sides "Chinese")))
(base 600 250 0 (n "Hakodate") (x (sides "Japanese")))
(base 141 253 0 (n "Halifax") (x (sides "Canadian")))
(base 108 251 0 (n "Hamilton") (x (sides "Canadian")))
(base 567 220 0 (n "Hangzhou") (x (sides "Chinese")))
(base 709 59 0 (n "Hobart") (x (sides "Australian")))
(base 557 226 0 (n "Huainan") (x (sides "Chinese")))
(base 102 231 0 (n "Huntsville") (x (sides "American")))
(base 457 210 0 (n "Hyderabad PAK") (x (sides "Pakistani")))
(base 333 170 0 (n "Ibadan") (x (sides "Nigerian")))
(base 573 237 0 (n "Inchon") (x (sides "Korean")))
(base 476 205 0 (n "Indore") (x (sides "Indian")))
(base 307 258 0 (n "Innsbruck") (x (sides "Austrian")))
(base 175 145 0 (n "Iquitos") (x (sides "Peruvian")))
(base 296 263 0 (n "Karlsruhe") (x (sides "German")))
(base 297 268 0 (n "Kassel") (x (sides "German")))
(base 295 275 0 (n "Kiel") (x (sides "German")))
(base 389 155 0 (n "Kisangani") (x (sides "Zairean")))
(base 410 125 0 (n "Kitwe") (x (sides "Zambian")))
(base 318 278 0 (n "Klaipeda") (x (sides "Lithuanian")))
(base 580 267 0 (n "Komsomol'sk") (x (sides "Russian")))
(base 326 262 0 (n "Kosice") (x (sides "Slovakian")))
(base 370 254 0 (n "Krasnodarsk") (x (sides "Russian")))
(base 307 252 0 (n "La Spezia") (x (sides "Italian")))
(base 265 220 0 (n "Las Palmas") (x (sides "Spanish")))
(base 103 239 0 (n "Lexington") (x (sides "American")))
(base 285 266 0 (n "Lille") (x (sides "French")))
(base 284 257 0 (n "Limoges") (x (sides "French")))
(base 99 238 0 (n "Louisville") (x (sides "American")))
(base 326 268 0 (n "Lublin") (x (sides "Polish")))
(base 407 128 0 (n "Lubumbashi") (x (sides "Zairean")))
(base 482 214 0 (n "Lucknow") (x (sides "Indian")))
(base 495 175 0 (n "Madurai") (x (sides "Indian")))
(base 454 119 0 (n "Mahajanga") (x (sides "Madagascaran")))
(base 282 236 0 (n "Malaga") (x (sides "Spanish")))
(base 420 211 0 (n "Manama"))
(base 203 147 0 (n "Manaus") (x (sides "Brazilian")))
(base 523 203 0 (n "Mandalay") (x (sides "Burmese")))
(base 159 165 0 (n "Manizales") (x (sides "Colombian")))
(base 247 69 0 (n "Mar del Plata") (x (sides "Argentinian")))
(base 369 141 0 (n "Matadi") (x (sides "Zairean")))
(base 71 205 0 (n "Mazatlan") (x (sides "Mexican")))
(base 374 154 0 (n "Mboudaka") (x (sides "Zairean")))
(base 392 208 0 (n "Medina") (x (sides "Saudi")))
(base 217 80 0 (n "Mendoza") (x (sides "Argentinian")))
(base 110 200 0 (n "Merida") (x (sides "Mexican")))
(base 325 238 0 (n "Messina") (x (sides "Italian")))
(base 291 263 0 (n "Metz") (x (sides "French")))
(base 103 222 0 (n "Mobile") (x (sides "American")))
(base 426 145 0 (n "Mombasa") (x (sides "Kenyan")))
(base 389 234 0 (n "Mosul") (x (sides "Iraqi")))
(base 457 223 0 (n "Multan") (x (sides "Pakistani")))
(base 331 308 0 (n "Murmansk") (x (sides "Russian")))
(base 352 258 0 (n "Mykolayiv") (x (sides "Ukrainian")))
(base 559 217 0 (n "Nanchang") (x (sides "Chinese")))
(base 276 261 0 (n "Nantes") (x (sides "French")))
(base 261 141 0 (n "Natal") (x (sides "Brazilian")))
(base 570 220 0 (n "Ningbo") (x (sides "Chinese")))
(base 275 271 0 (n "Norwich") (x (sides "British")))
(base 333 172 0 (n "Ogbomosho") (x (sides "Nigerian")))
(base 122 216 0 (n "Orlando") (x (sides "American")))
(base 391 237 0 (n "Orumiyah") (x (sides "Iranian")))
(base 290 230 0 (n "Oujda") (x (sides "Moroccan")))
(base 570 147 0 (n "Palembang") (x (sides "Indonesian")))
(base 626 273 0 (n "P. Kamchatkij") (x (sides "Russian")))
(base 204 167 0 (n "Paramaribo"))
(base 160 157 0 (n "Pasto") (x (sides "Colombian")))
(base 341 237 0 (n "Patra") (x (sides "Greek")))
(base 342 248 0 (n "Plovdiv") (x (sides "Bulgarian")))
(base 267 266 0 (n "Plymouth") (x (sides "British")))
(base 308 264 0 (n "Plzen") (x (sides "Czech")))
(base 355 264 0 (n "Poltava") (x (sides "Ukrainian")))
(base 576 153 0 (n "Pontaniak") (x (sides "Indonesian")))
(base 344 164 0 (n "Port Harcourt") (x (sides "Nigerian")))
(base 370 222 0 (n "Port Said") (x (sides "Egyptian")))
(base 274 267 0 (n "Portsmouth") (x (sides "British")))
(base 332 249 0 (n "Pristina") (x (sides "Yugoslavian")))
(base 128 246 0 (n "Providence") (x (sides "American")))
(base 442 225 0 (n "Qandahar") (x (sides "Afghan")))
(base 553 260 0 (n "Qiqihar") (x (sides "Chinese")))
(base 121 259 0 (n "Quebec") (x (sides "Canadian")))
(base 159 153 0 (n "Quito") (x (sides "Ecuadorean")))
(base 119 233 0 (n "Raleigh") (x (sides "American")))
(base 458 229 0 (n "Rawalpindi") (x (sides "Pakistani")))
(base 287 263 0 (n "Reims") (x (sides "French")))
(base 119 237 0 (n "Richmond") (x (sides "American")))
(base 114 236 0 (n "Roanoke") (x (sides "American")))
(base 89 247 0 (n "Rockford") (x (sides "American")))
(base 234 80 0 (n "Rosario") (x (sides "Argentinian")))
(base 301 274 0 (n "Rostock") (x (sides "German")))
(base 293 263 0 (n "Saarbruecken") (x (sides "German")))
(base 39 244 0 (n "Salt Lake City") (x (sides "American")))
(base 33 231 0 (n "San Bernardino") (x (sides "American")))
(base 84 203 0 (n "San Luis Potosi") (x (sides "Mexican")))
(base 210 115 0 (n "Santa Cruz de la Sierra") (x (sides "Bolivian")))
(base 142 198 0 (n "Santiago de Cuba") (x (sides "Cuban")))
(base 117 224 0 (n "Savannah") (x (sides "American")))
(base 299 272 0 (n "Schwerin") (x (sides "German")))
(base 359 253 0 (n "Sevastopol") (x (sides "Ukrainian")))
(base 420 219 0 (n "Shiraz") (x (sides "Iranian")))
(base 344 275 0 (n "Smolensk") (x (sides "Russian")))
(base 276 269 0 (n "Southend") (x (sides "British")))
(base 321 250 0 (n "Split") (x (sides "Croatian")))
(base 163 260 0 (n "St. John's") (x (sides "Canadian")))
(base 296 262 0 (n "Strasbourg") (x (sides "French")))
(base 371 221 0 (n "Suez") (x (sides "Egyptian")))
(base 473 201 0 (n "Surat") (x (sides "Indian")))
(base 326 257 0 (n "Szeged") (x (sides "Hungarian")))
(base 394 238 0 (n "Tabriz") (x (sides "Iranian")))
(base 91 203 0 (n "Tampico") (x (sides "Mexican")))
(base 280 232 0 (n "Tangier") (x (sides "Moroccan")))
(base 330 256 0 (n "Timisoara") (x (sides "Romanian")))
(base 298 250 0 (n "Toulon") (x (sides "French")))
(base 280 260 0 (n "Tours") (x (sides "French")))
(base 376 245 0 (n "Trabzon") (x (sides "Turk")))
(base 286 297 0 (n "Trondheim") (x (sides "Norwegian")))
(base 316 289 0 (n "Turku") (x (sides "Finnish")))
(base 605 143 0 (n "Ujung Pendang") (x (sides "Indonesian")))
(base 276 246 0 (n "Valladolid") (x (sides "Spanish")))
(base 327 232 0 (n "Valletta"))
(base 347 251 0 (n "Varna") (x (sides "Bulgarian")))
(base 311 255 0 (n "Venice") (x (sides "Italian")))
(base 266 248 0 (n "Vigo") (x (sides "Spanish")))
(base 496 194 0 (n "Vijayawada") (x (sides "Indian")))
(base 340 276 0 (n "Vitebsk") (x (sides "Belarussian")))
(base 62 264 0 (n "Winnipeg") (x (sides "Canadian")))
(base 358 163 0 (n "Yaounde") (x (sides "Cameroonian")))
(base 588 136 0 (n "Yogyakarta") (x (sides "Indonesian")))
(base 556 230 0 (n "Xuzhou") (x (sides "Chinese")))
(base 428 141 0 (n "Zanzibar") (x (sides "Tanzanian")))

(town 319 165 0 (n "Abidjan") (x (sides "Ivorian")))
(town 340 174 0 (n "Abuja") (x (sides "Nigerian")))
(town 326 166 0 (n "Accra") (x (sides "Ghanaian")))
(town 370 236 0 (n "Adana") (x (sides "Turk")))
(town 419 182 0 (n "Aden") (x (sides "Yemeni")))
(town 408 175 0 (n "Adis Abeba") (x (sides "Ethiopian")))
(town 470 205 0 (n "Ahmadabad") (x (sides "Indian")))
(town 57 232 0 (n "Albuquerque") (x (sides "American")))
(town 365 223 0 (n "Alexandria") (x (sides "Egyptian")))
(town 300 235 0 (n "Algiers") (x (sides "Algerian")))
(town 455 250 0 (n "Alma-Ata") (x (sides "Kazakh")))
(town 378 225 0 (n "Amman") (x (sides "Jordanian")))
(town 285 270 0 (n "Amsterdam") (x (sides "Dutch")))
(town 362 242 0 (n "Ankara") (x (sides "Turk")))
(town 460 112 0 (n "Antananarivo") (x (sides "Madagascaran")))
(town 286 268 0 (n "Antwerp") (x (sides "Belgian")))
(town 601 248 0 (n "Aomori") (x (sides "Japanese")))
(town 421 241 0 (n "Ashgabat") (x (sides "Turkmen")))
(town 401 189 0 (n "Asmera") (x (sides "Eritrean")))
(town 389 257 0 (n "Astrachan'") (x (sides "Russian")))
(town 233 98 0 (n "Asuncion") (x (sides "Paraguayan")))
(town 344 238 0 (n "Athens") (x (sides "Greek")))
(town 108 229 0 (n "Atlanta") (x (sides "American")))
(town 762 72 0 (n "Auckland") (x (sides "New Zealander")))
(town 83 221 0 (n "Austin") (x (sides "American")))
(town 396 227 0 (n "Baghdad") (x (sides "Iraqi")))
(town 399 243 0 (n "Baku") (x (sides "Azerbaijani")))
(town 120 241 0 (n "Baltimore") (x (sides "American")))
(town 300 184 0 (n "Bamako") (x (sides "Malian")))
(town 580 138 0 (n "Bandung") (x (sides "Indonesian")))
(town 488 186 0 (n "Bangalore") (x (sides "Indian")))
(town 541 184 0 (n "Bangkok") (x (sides "Siamese")))
(town 369 163 0 (n "Bangui") (x (sides "Central African")))
(town 154 179 0 (n "Baranquilla") (x (sides "Colombian")))
(town 292 246 0 (n "Barcelona") (x (sides "Spanish")))
(town 460 273 0 (n "Barnaul") (x (sides "Russian")))
(town 375 229 0 (n "Beirut") (x (sides "Lebanese")))
(town 227 150 0 (n "Belem") (x (sides "Brazilian")))
(town 257 278 0 (n "Belfast") (x (sides "British")))
(town 329 253 0 (n "Belgrade") (x (sides "Yugoslavian")))
(town 258 109 0 (n "Belo Horizonte") (x (sides "Brazilian")))
(town 297 258 0 (n "Bern") (x (sides "Swiss")))
(town 293 270 0 (n "Bielefeld") (x (sides "German")))
(town 103 228 0 (n "Birmingham AL") (x (sides "American")))
(town 451 249 0 (n "Bishkek") (x (sides "Kyrgyz")))
(town 428 119 0 (n "Blantyre") (x (sides "Malawian")))
(town 163 164 0 (n "Bogota") (x (sides "Colombian")))
(town 309 253 0 (n "Bologna") (x (sides "Italian")))
(town 281 255 0 (n "Bordeaux") (x (sides "French")))
(town 350 272 0 (n "Br'ansk") (x (sides "Russian")))
(town 244 118 0 (n "Brasilia") (x (sides "Brazilian")))
(town 318 261 0 (n "Bratislava") (x (sides "Slovakian")))
(town 370 146 0 (n "Brazzaville") (x (sides "Congolese")))
(town 293 272 0 (n "Bremen") (x (sides "German")))
(town 705 93 0 (n "Brisbane") (x (sides "Australian")))
(town 269 269 0 (n "Bristol") (x (sides "British")))
(town 316 263 0 (n "Brno") (x (sides "Czech")))
(town 286 267 0 (n "Brussels") (x (sides "Belgian")))
(town 342 253 0 (n "Bucharest") (x (sides "Romanian")))
(town 322 260 0 (n "Budapest") (x (sides "Hungarian")))
(town 241 77 0 (n "Buenos Aires") (x (sides "Argentinian")))
(town 111 249 0 (n "Buffalo") (x (sides "American")))
(town 404 147 0 (n "Bujumbura") (x (sides "Burundi")))
(town 23 267 0 (n "Calgary") (x (sides "Canadian")))
(town 159 162 0 (n "Cali") (x (sides "Colombian")))
(town 705 75 0 (n "Canberra") (x (sides "Australian")))
(town 411 79 0 (n "Cape Town") (x (sides "South African")))
(town 173 177 0 (n "Caracas") (x (sides "Venezuelan")))
(town 278 229 0 (n "Casablanca") (x (sides "Moroccan")))
(town 597 177 0 (n "Cebu") (x (sides "Filipino")))
(town 562 251 0 (n "Changchun") (x (sides "Chinese")))
(town 575 246 0 (n "Changjin") (x (sides "Chinese")))
(town 551 219 0 (n "Changsha") (x (sides "Chinese")))
(town 409 276 0 (n "Chelabinsk") (x (sides "Russian")))
(town 305 267 0 (n "Chemnitz") (x (sides "German")))
(town 531 223 0 (n "Chengdu") (x (sides "Chinese")))
(town 765 57 0 (n "Christchurch") (x (sides "New Zealander")))
(town 102 241 0 (n "Cincinnati") (x (sides "American")))
(town 105 246 0 (n "Cleveland") (x (sides "American")))
(town 291 267 0 (n "Cologne") (x (sides "German")))
(town 504 169 0 (n "Colombo") (x (sides "Sri Lankan")))
(town 104 243 0 (n "Columbus") (x (sides "American")))
(town 293 175 0 (n "Conakry") (x (sides "Guinean")))
(town 225 84 0 (n "Cordoba") (x (sides "Spanish")))
(town 331 168 0 (n "Cotonou") (x (sides "Beninese")))
(town 252 97 0 (n "Curitiba") (x (sides "Brazilian")))
(town 508 206 0 (n "Dacca") (x (sides "Bangladeshi")))
(town 559 240 0 (n "Dairen") (x (sides "Chinese")))
(town 278 186 0 (n "Dakar") (x (sides "Senegalese")))
(town 80 226 0 (n "Dallas") (x (sides "American")))
(town 377 228 0 (n "Damascus") (x (sides "Syrian")))
(town 429 139 0 (n "Dar es Salaam") (x (sides "Tanzanian")))
(town 357 261 0 (n "Dnipropetrovsk") (x (sides "Ukrainian")))
(town 292 269 0 (n "Dortmund") (x (sides "German")))
(town 350 163 0 (n "Douala") (x (sides "Cameroonian")))
(town 306 268 0 (n "Dresden") (x (sides "German")))
(town 259 274 0 (n "Dublin") (x (sides "Irish")))
(town 435 85 0 (n "Durban") (x (sides "South African")))
(town 442 240 0 (n "Dusanbe") (x (sides "Tajik")))
(town 291 268 0 (n "Dusseldorf") (x (sides "German")))
(town 264 278 0 (n "Edinburgh") (x (sides "British")))
(town 21 273 0 (n "Edmonton") (x (sides "Canadian")))
(town 61 224 0 (n "El Paso") (x (sides "American")))
(town 412 228 0 (n "Esfahan") (x (sides "Iranian")))
(town 292 268 0 (n "Essen") (x (sides "German")))
(town 460 224 0 (n "Faisalabad") (x (sides "Pakistani")))
(town 310 251 0 (n "Florence") (x (sides "Italian")))
(town 252 145 0 (n "Fortaleza") (x (sides "Brazilian")))
(town 296 266 0 (n "Frankfurt") (x (sides "German")))
(town 295 172 0 (n "Freetown") (x (sides "Sierra Leonan")))
(town 79 226 0 (n "Ft Worth") (x (sides "American")))
(town 585 230 0 (n "Fukuoka") (x (sides "Japanese")))
(town 418 99 0 (n "Gaborone") (x (sides "Motswana")))
(town 314 274 0 (n "Gdansk") (x (sides "Polish")))
(town 304 252 0 (n "Genoa") (x (sides "Italian")))
(town 298 282 0 (n "Goteborg") (x (sides "Swedish")))
(town 80 200 0 (n "Guadalajara") (x (sides "Mexican")))
(town 559 205 0 (n "Guangzhou") (x (sides "Chinese")))
(town 116 186 0 (n "Guatemala") (x (sides "Guatemalan")))
(town 157 150 0 (n "Guayaquil") (x (sides "Ecuadorean")))
(town 545 201 0 (n "Ha-noi") (x (sides "Vietnamese")))
(town 562 256 0 (n "Haerbin") (x (sides "Chinese")))
(town 375 227 0 (n "Haifa") (x (sides "Israeli")))
(town 296 270 0 (n "Hannover") (x (sides "German")))
(town 422 114 0 (n "Harare") (x (sides "Zimbabwean")))
(town 125 247 0 (n "Hartford") (x (sides "American")))
(town 321 288 0 (n "Helsinki") (x (sides "Finnish")))
(town 590 233 0 (n "Hiroshima") (x (sides "Japanese")))
(town 559 177 0 (n "Ho Chi Minh City") (x (sides "Vietnamese")))
(town 758 204 0 (n "Honolulu") (x (sides "American")))
(town 273 273 0 (n "Hull") (x (sides "British")))
(town 486 195 0 (n "Hyderabad") (x (sides "Indian")))
(town 97 242 0 (n "Indianapolis") (x (sides "American")))
(town 507 271 0 (n "Irkutsk") (x (sides "Russian")))
(town 351 239 0 (n "Izmir") (x (sides "Turk")))
(town 118 221 0 (n "Jacksonville") (x (sides "American")))
(town 471 214 0 (n "Jaipur") (x (sides "Indian")))
(town 578 139 0 (n "Jakarta") (x (sides "Indonesian")))
(town 357 282 0 (n "Jaroslavi") (x (sides "Russian")))
(town 387 243 0 (n "Jerevan") (x (sides "Armenian")))
(town 376 225 0 (n "Jerusalem") (x (sides "Israeli")))
(town 397 202 0 (n "Jiddah") (x (sides "Saudi")))
(town 553 235 0 (n "Jinan") (x (sides "Chinese")))
(town 448 232 0 (n "Kabul") (x (sides "Afghan")))
(town 589 224 0 (n "Kagoshima") (x (sides "Japanese")))
(town 405 154 0 (n "Kampala") (x (sides "Ugandan")))
(town 597 238 0 (n "Kanazawa") (x (sides "Japanese")))
(town 339 181 0 (n "Kano") (x (sides "Nigerian")))
(town 481 213 0 (n "Kanpur") (x (sides "Indian")))
(town 79 241 0 (n "Kansas City") (x (sides "American")))
(town 576 204 0 (n "Kaohsiun") (x (sides "Chinese")))
(town 440 264 0 (n "Karaganda") (x (sides "Kazakh")))
(town 492 215 0 (n "Kathmandu") (x (sides "Nepalese")))
(town 319 266 0 (n "Katowice") (x (sides "Polish")))
(town 325 275 0 (n "Kaunas") (x (sides "Lithuanian")))
(town 381 277 0 (n "Kazan'") (x (sides "Russian")))
(town 463 277 0 (n "Kemerovo") (x (sides "Russian")))
(town 358 265 0 (n "Kharkiv") (x (sides "Ukrainian")))
(town 389 188 0 (n "Khartoum") (x (sides "Sudanese")))
(town 403 150 0 (n "Kigali") (x (sides "Rwandan")))
(town 142 194 0 (n "Kingston") (x (sides "Jamaican")))
(town 372 144 0 (n "Kinshasa") (x (sides "Zairean")))
(town 344 259 0 (n "Kishinev") (x (sides "Moldovan")))
(town 586 231 0 (n "Kitakyushu") (x (sides "Japanese")))
(town 318 275 0 (n "Konigsberg") (x (sides "Russian")))
(town 322 265 0 (n "Krakow") (x (sides "Polish")))
(town 476 279 0 (n "Krasnojarsk") (x (sides "Russian")))
(town 556 161 0 (n "Kuala Lumpur") (x (sides "Malaysian")))
(town 386 272 0 (n "Kujbyshev") (x (sides "Russian")))
(town 588 226 0 (n "Kumamoto") (x (sides "Japanese")))
(town 317 173 0 (n "Kumasi") (x (sides "Ghanaian")))
(town 533 210 0 (n "Kunming") (x (sides "Chinese")))
(town 408 219 0 (n "Kuwait City") (x (sides "Kuwaiti")))
(town 417 275 0 (n "Kurgan") (x (sides "Russian")))
(town 576 232 0 (n "Kwangju") (x (sides "Korean")))
(town 125 205 0 (n "La Habana") (x (sides "Cuban")))
(town 200 117 0 (n "La Paz") (x (sides "Bolivian")))
(town 333 168 0 (n "Lagos") (x (sides "Nigerian")))
(town 462 225 0 (n "Lahore") (x (sides "Pakistani")))
(town 278 264 0 (n "Le Havre") (x (sides "French")))
(town 268 275 0 (n "Leeds") (x (sides "British")))
(town 272 271 0 (n "Leicester") (x (sides "British")))
(town 302 269 0 (n "Leipzig") (x (sides "German")))
(town 354 154 0 (n "Libreville") (x (sides "Gabonese")))
(town 175 126 0 (n "Lima") (x (sides "Peruvian")))
(town 310 261 0 (n "Linz") (x (sides "Austrian")))
(town 270 240 0 (n "Lisbon") (x (sides "Portuguese")))
(town 267 273 0 (n "Liverpool") (x (sides "British")))
(town 314 256 0 (n "Ljubljana") (x (sides "Slovenian")))
(town 320 269 0 (n "Lodz") (x (sides "Polish")))
(town 330 167 0 (n "Lome") (x (sides "Togolese")))
(town 372 134 0 (n "Luanda") (x (sides "Angolan")))
(town 413 120 0 (n "Lusaka") (x (sides "Zambian")))
(town 331 264 0 (n "L'viv") (x (sides "Ukrainian")))
(town 293 255 0 (n "Lyon") (x (sides "French")))
(town 497 183 0 (n "Madras") (x (sides "Indian")))
(town 300 270 0 (n "Magdeburg") (x (sides "German")))
(town 405 272 0 (n "Magnitogorsk") (x (sides "Russian")))
(town 128 181 0 (n "Managua") (x (sides "Nicaragua")))
(town 586 186 0 (n "Manila") (x (sides "Philippine")))
(town 296 264 0 (n "Mannheim") (x (sides "German")))
(town 434 96 0 (n "Maputo") (x (sides "Mozambican")))
(town 161 178 0 (n "Maracaibo") (x (sides "Venezuelan")))
(town 280 224 0 (n "Marrakech") (x (sides "Moroccan")))
(town 296 250 0 (n "Marseilles") (x (sides "French")))
(town 424 236 0 (n "Mashhad") (x (sides "Iranian")))
(town 591 230 0 (n "Matsuyama") (x (sides "Japanese")))
(town 398 202 0 (n "Mecca") (x (sides "Saudi")))
(town 548 162 0 (n "Medan") (x (sides "Indonesian")))
(town 157 168 0 (n "Medellin") (x (sides "Colombian")))
(town 94 232 0 (n "Memphis") (x (sides "American")))
(town 91 197 0 (n "Mexico City") (x (sides "Mexican")))
(town 126 211 0 (n "Miami") (x (sides "American")))
(town 90 250 0 (n "Milwaukee") (x (sides "American")))
(town 77 253 0 (n "Minneapolis-St. Paul") (x (sides "American")))
(town 335 273 0 (n "Minsk") (x (sides "Belarussian")))
(town 432 158 0 (n "Mogadishu") (x (sides "Somalian")))
(town 302 167 0 (n "Monrovia") (x (sides "Liberian")))
(town 81 211 0 (n "Monterrey") (x (sides "Mexican")))
(town 247 77 0 (n "Montevideo") (x (sides "Uruguayan")))
(town 292 270 0 (n "Muenster") (x (sides "German")))
(town 440 206 0 (n "Muscat") (x (sides "Omani")))
(town 354 180 0 (n "N'djamena") (x (sides "Chadian")))
(town 586 226 0 (n "Nagasaki") (x (sides "Japanese")))
(town 484 203 0 (n "Nagpur") (x (sides "Indian")))
(town 588 212 0 (n "Naha") (x (sides "Japanese")))
(town 417 151 0 (n "Nairobi") (x (sides "Kenyan")))
(town 561 225 0 (n "Nanjing") (x (sides "Chinese")))
(town 319 244 0 (n "Naples") (x (sides "Italian")))
(town 100 234 0 (n "Nashville") (x (sides "American")))
(town 99 220 0 (n "New Orleans") (x (sides "American")))
(town 123 244 0 (n "Newark") (x (sides "American")))
(town 268 277 0 (n "Newcastle") (x (sides "British")))
(town 323 183 0 (n "Niamey") (x (sides "Negerien")))
(town 301 251 0 (n "Nice") (x (sides "French")))
(town 600 241 0 (n "Niigata") (x (sides "Japanese")))
(town 402 283 0 (n "Niznij Tagil") (x (sides "Russian")))
(town 123 235 0 (n "Norfolk") (x (sides "American")))
(town 278 193 0 (n "Nouakchott") (x (sides "Mauritanian")))
(town 466 273 0 (n "Novokuzneck") (x (sides "Russian")))
(town 302 264 0 (n "Nuremberg") (x (sides "German")))
(town 349 257 0 (n "Odessa") (x (sides "Ukrainian")))
(town 592 233 0 (n "Okayama") (x (sides "Japanese")))
(town 76 233 0 (n "Oklahoma City") (x (sides "American")))
(town 74 245 0 (n "Omaha") (x (sides "American")))
(town 435 275 0 (n "Omsk") (x (sides "Russian")))
(town 294 233 0 (n "Oran") (x (sides "Algerian")))
(town 398 269 0 (n "Orenburg") (x (sides "Russian")))
(town 292 287 0 (n "Oslo") (x (sides "Norwegian")))
(town 319 264 0 (n "Ostrava") (x (sides "Czech")))
(town 114 255 0 (n "Ottawa") (x (sides "Canadian")))
(town 316 181 0 (n "Ouagadougou") (x (sides "Burkinabe")))
(town 321 238 0 (n "Palermo") (x (sides "Italian")))
(town 147 173 0 (n "Panama City") (x (sides "Panamanian")))
(town 494 211 0 (n "Patna") (x (sides "Indian")))
(town 393 283 0 (n "Perm'") (x (sides "Russian")))
(town 626 83 0 (n "Perth") (x (sides "Australian")))
(town 426 275 0 (n "Petropavlovsk") (x (sides "Russian")))
(town 554 180 0 (n "Phnom-Penh") (x (sides "Kampuchean")))
(town 46 228 0 (n "Phoenix") (x (sides "American")))
(town 110 244 0 (n "Pittsburgh") (x (sides "American")))
(town 480 195 0 (n "Poona") (x (sides "Indian")))
(town 428 79 0 (n "Port Elizabeth") (x (sides "South African")))
(town 672 133 0 (n "Port Moresby") (x (sides "Papuan")))
(town 152 195 0 (n "Port-au-Prince") (x (sides "Haitian")))
(town 10 255 0 (n "Portland") (x (sides "American")))
(town 267 245 0 (n "Porto") (x (sides "Portuguese")))
(town 253 87 0 (n "Porto Alegre") (x (sides "Brazilian")))
(town 313 271 0 (n "Poznan") (x (sides "Polish")))
(town 310 265 0 (n "Prague") (x (sides "Czech")))
(town 424 97 0 (n "Pretoria") (x (sides "South African")))
(town 581 232 0 (n "Pusan") (x (sides "Korean")))
(town 569 241 0 (n "Pyongyang") (x (sides "Korean")))
(town 561 234 0 (n "Qingdao") (x (sides "Chinese")))
(town 279 230 0 (n "Rabat") (x (sides "Moroccan")))
(town 528 191 0 (n "Rangoon") (x (sides "Burmese")))
(town 264 136 0 (n "Recife") (x (sides "Brazilian")))
(town 209 287 0 (n "Reykjavik") (x (sides "Icelander")))
(town 324 280 0 (n "Riga") (x (sides "Latvian")))
(town 262 103 0 (n "Rio de Janeiro") (x (sides "Brazilian")))
(town 410 208 0 (n "Riyadh") (x (sides "Saudi")))
(town 113 250 0 (n "Rochester") (x (sides "American")))
(town 369 259 0 (n "Rostov") (x (sides "Russian")))
(town 280 264 0 (n "Rouen") (x (sides "French")))
(town 19 240 0 (n "Sacramento") (x (sides "American")))
(town 263 125 0 (n "Salvador") (x (sides "Brazilian")))
(town 439 242 0 (n "Samarkand") (x (sides "Uzbek")))
(town 81 219 0 (n "San Antonio") (x (sides "American")))
(town 36 226 0 (n "San Diego") (x (sides "American")))
(town 135 176 0 (n "San Jose") (x (sides "Costa Rican")))
(town 20 237 0 (n "San Jose CA") (x (sides "American")))
(town 166 195 0 (n "San Juan") (x (sides "American")))
(town 120 184 0 (n "San Salvador") (x (sides "Salvadoran")))
(town 213 79 0 (n "Santiago") (x (sides "Chilean")))
(town 157 195 0 (n "Santo Domingo") (x (sides "Dominican")))
(town 599 252 0 (n "Sapporo") (x (sides "Japanese")))
(town 324 251 0 (n "Sarajevo") (x (sides "Bosnian")))
(town 378 268 0 (n "Saratov") (x (sides "Russian")))
(town 604 242 0 (n "Sendai") (x (sides "Japanese")))
(town 278 237 0 (n "Seville") (x (sides "Spanish")))
(town 602 234 0 (n "Shizuoka") (x (sides "Japanese")))
(town 334 247 0 (n "Skopje") (x (sides "Macedonian")))
(town 338 249 0 (n "Sofia") (x (sides "Bulgarian")))
(town 90 239 0 (n "St. Louis") (x (sides "American")))
(town 334 287 0 (n "St. Petersburg") (x (sides "Russian")))
(town 306 273 0 (n "Stettin") (x (sides "Polish")))
(town 307 286 0 (n "Stockholm") (x (sides "Swedish")))
(town 299 262 0 (n "Stuttgart") (x (sides "German")))
(town 590 138 0 (n "Surabaya") (x (sides "Indonesian")))
(town 404 280 0 (n "Sverdlovsk") (x (sides "Russian")))
(town 575 210 0 (n "T'aipei") (x (sides "Chinese")))
(town 415 280 0 (n "T'umen'") (x (sides "Russian")))
(town 579 234 0 (n "Taegu") (x (sides "Korean")))
(town 322 286 0 (n "Tallinn") (x (sides "Estonian")))
(town 120 215 0 (n "Tampa") (x (sides "American")))
(town 440 246 0 (n "Tashkent") (x (sides "Uzbek")))
(town 386 246 0 (n "Tbilisi") (x (sides "Georgian")))
(town 124 185 0 (n "Tegucigalpa") (x (sides "Honduran")))
(town 410 234 0 (n "Tehran") (x (sides "Iranian")))
(town 375 225 0 (n "Tel Aviv") (x (sides "Israeli")))
(town 339 244 0 (n "Thessaloniki") (x (sides "Greek")))
(town 550 241 0 (n "Tianjin") (x (sides "Chinese")))
(town 333 245 0 (n "Tirane") (x (sides "Albanian")))
(town 101 247 0 (n "Toledo") (x (sides "American")))
(town 459 280 0 (n "Tomsk") (x (sides "Russian")))
(town 300 254 0 (n "Torino") (x (sides "Italian")))
(town 289 250 0 (n "Toulouse") (x (sides "French")))
(town 313 255 0 (n "Trieste") (x (sides "Italian")))
(town 326 226 0 (n "Tripoli") (x (sides "Libyan")))
(town 51 225 0 (n "Tucson") (x (sides "American")))
(town 218 94 0 (n "Tucuman") (x (sides "Argentinian")))
(town 357 274 0 (n "Tula") (x (sides "Russian")))
(town 80 236 0 (n "Tulsa") (x (sides "American")))
(town 315 235 0 (n "Tunis") (x (sides "Tunisian")))
(town 518 260 0 (n "Ulaan Bataar") (x (sides "Mongolian")))
(town 515 269 0 (n "Ulan Ude") (x (sides "Russian")))
(town 460 264 0 (n "Ust' Kamenogorsk") (x (sides "Kazakh")))
(town 288 242 0 (n "Valencia") (x (sides "Spanish")))
(town 210 80 0 (n "Valparaiso") (x (sides "Chilean")))
(town 5 263 0 (n "Vancouver") (x (sides "Canadian")))
(town 98 197 0 (n "Veracruz") (x (sides "Mexican")))
(town 307 255 0 (n "Verona") (x (sides "Italian")))
(town 543 194 0 (n "Vientiane") (x (sides "Laotian")))
(town 329 275 0 (n "Vilnius") (x (sides "Lithuanian")))
(town 341 263 0 (n "Vinnytysa") (x (sides "Ukrainian")))
(town 579 250 0 (n "Vladivostok") (x (sides "Russian")))
(town 377 262 0 (n "Volgograd") (x (sides "Russian")))
(town 596 231 0 (n "Wakayama") (x (sides "Japanese")))
(town 73 238 0 (n "Wichita") (x (sides "American")))
(town 396 103 0 (n "Windhoek") (x (sides "Namibian")))
(town 315 267 0 (n "Wroclaw") (x (sides "Polish")))
(town 553 222 0 (n "Wuhan") (x (sides "Chinese")))
(town 535 232 0 (n "Xi'an") (x (sides "Chinese")))
(town 517 236 0 (n "Xining") (x (sides "Chinese")))
(town 604 235 0 (n "Yokohama") (x (sides "Japanese")))
(town 317 256 0 (n "Zagreb") (x (sides "Croatian")))
(town 284 246 0 (n "Zaragoza") (x (sides "Spanish")))
(town 544 234 0 (n "Zhengzhou") (x (sides "Chinese")))
(town 300 259 0 (n "Zurich") (x (sides "Swiss")))

(city 547 242 0 (n "Beijing") (x (sides "Chinese")))
(city 304 271 0 (n "Berlin") (x (sides "German")))
(city 270 271 0 (n "Birmingham") (x (sides "British")))
(city 475 196 0 (n "Bombay") (x (sides "Indian")))
(city 128 248 0 (n "Boston") (x (sides "American")))
(city 369 220 0 (n "Cairo") (x (sides "Egyptian")))
(city 504 204 0 (n "Calcutta") (x (sides "Indian")))
(city 92 246 0 (n "Chicago") (x (sides "American")))
(city 538 219 0 (n "Chongqing") (x (sides "Chinese")))
(city 299 278 0 (n "Copenhagen") (x (sides "Danish")))
(city 473 218 0 (n "Delhi") (x (sides "Indian")))
(city 56 241 0 (n "Denver") (x (sides "American")))
(city 101 248 0 (n "Detroit") (x (sides "American")))
(city 363 260 0 (n "Donets'k") (x (sides "Ukrainian")))
(city 262 278 0 (n "Glasgow") (x (sides "British")))
(city 368 279 0 (n "Gorky") (x (sides "Russian")))
(city 295 273 0 (n "Hamburg") (x (sides "German")))
(city 562 204 0 (n "Hong Kong") (x (sides "Chinese")))
(city 87 220 0 (n "Houston") (x (sides "American")))
(city 352 245 0 (n "Istanbul") (x (sides "Turk")))
(city 424 96 0 (n "Johannesburg") (x (sides "South African")))
(city 455 209 0 (n "Karachi") (x (sides "Pakistani")))
(city 345 266 0 (n "Kiev") (x (sides "Ukrainian")))
(city 594 233 0 (n "Kobe") (x (sides "Japanese")))
(city 595 234 0 (n "Kyoto") (x (sides "Japanese")))
(city 275 269 0 (n "London") (x (sides "British")))
(city 31 230 0 (n "Los Angeles") (x (sides "American")))
(city 280 243 0 (n "Madrid") (x (sides "Spanish")))
(city 268 273 0 (n "Manchester") (x (sides "British")))
(city 697 70 0 (n "Melbourne") (x (sides "Australian")))
(city 303 255 0 (n "Milan") (x (sides "Italian")))
(city 118 255 0 (n "Montreal") (x (sides "Canadian")))
(city 355 277 0 (n "Moscow") (x (sides "Russian")))
(city 306 261 0 (n "Munich") (x (sides "German")))
(city 599 235 0 (n "Nagoya") (x (sides "Japanese")))
(city 124 244 0 (n "New York") (x (sides "American")))
(city 456 277 0 (n "Novosibirsk") (x (sides "Russian")))
(city 595 233 0 (n "Osaka") (x (sides "Japanese")))
(city 284 262 0 (n "Paris") (x (sides "French")))
(city 122 242 0 (n "Philadelphia") (x (sides "American")))
(city 315 246 0 (n "Rome") (x (sides "Italian")))
(city 285 269 0 (n "Rotterdam") (x (sides "Dutch")))
(city 18 238 0 (n "San Francisco") (x (sides "American")))
(city 255 102 0 (n "Sao Paulo") (x (sides "Brazilian")))
(city 9 259 0 (n "Seattle") (x (sides "American")))
(city 574 237 0 (n "Seoul") (x (sides "Korean")))
(city 569 223 0 (n "Shanghai") (x (sides "Chinese")))
(city 560 248 0 (n "Shengyang") (x (sides "Chinese")))
(city 562 157 0 (n "Singapore") (x (sides "Singaporean")))
(city 707 78 0 (n "Sydney") (x (sides "Australian")))
(city 540 238 0 (n "Taiyuan") (x (sides "Chinese")))
(city 604 236 0 (n "Tokyo") (x (sides "Japanese")))
(city 109 252 0 (n "Toronto") (x (sides "Canadian")))
(city 316 261 0 (n "Vienna") (x (sides "Austrian")))
(city 322 270 0 (n "Warsaw") (x (sides "Polish")))
(city 118 240 0 (n "Washington DC") (x (sides "American")))

