/* Compute complex natural logarithm.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ float
c_logf (__complex__ float x)
{
  __complex__ float result;

  if (x == 0.0)
    {
      /* Real and imaginary part are 0.0.  */
      __imag__ result = signbit (__real__ x) ? M_PI : 0.0;
      __imag__ result = __copysignf (__imag__ result, __imag__ x);
      /* Yes, the following line raises an exception.  */
      __real__ result = -1.0 / fabsf (__real__ x);
    }
  else if (__real__ x == __real__ x && __imag__ x == __imag__ x)
    {
      /* Neither real nor imaginary part is NaN.  */
      __real__ result = logf (hypotf (__real__ x, __imag__ x));
      __imag__ result = atan2f (__imag__ x, __real__ x);
    }
  else
    {
      __imag__ result = NAN;
      if (INFINITEF_P (__real__ x) || INFINITEF_P (__imag__ x))
	/* Real or imaginary part is infinite.  */
	__real__ result = HUGE_VALF;
      else
	__real__ result = NAN;
    }

  return result;
}
