// Locale support -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by

// Warning: this file is not meant for user inclusion.  Use <locale>.

#ifndef _CPP_BITS_LOCCORE_TCC
#define _CPP_BITS_LOCCORE_TCC 1

#include <bits/std_vector.h>

namespace std
{
  export template<typename _Facet>
    locale 
    locale::combine(const locale& __other)
    {
      locale __copy(*this);
      __copy._M_impl->_M_replace_facet(__other._M_impl, &_Facet::id);
      __copy._M_impl->_M_has_name = false;
      return __copy;
    }

  export template<typename _CharT, typename _Traits, typename _Alloc>
    bool
    locale::operator()(const basic_string<_CharT,_Traits,_Alloc>& __s1,
		       const basic_string<_CharT,_Traits,_Alloc>& __s2) const
    {
      return use_facet< std::collate<_CharT> > (*this) ( 
       __s1.data(), __s1.data() + __s1.length(),
       __s2.data(), __s2.data() + __s2.length()) < 0;
    }

 export template<typename _Facet>
    const _Facet&
    use_facet(const locale& __loc)
   {
    const locale::facet* __fp = (const _Facet*)0;    // check derivation
    locale::id& __id = _Facet::id;         // check member id
    size_t __i = __id._M_index;
    const locale::_Impl* __tmp = __loc._M_impl;
    if (__id._M_index >= __loc._M_impl->_M_facets->size() ||
	(__fp = (*(__tmp->_M_facets))[__i]) == 0)
      return _Use_facet_failure_handler<_Facet>(__loc);
    return static_cast<const _Facet&>(*__fp);
   }

  template<typename _Facet>
    inline bool
    has_facet(const locale& __loc) throw()
    {
      const locale::facet* __fp = (const _Facet*)0;   // check derivation
      locale::id& __id = _Facet::id;         // check member id
      size_t __i = __id._M_index;
      const locale::_Impl* __tmp = __loc._M_impl;
      return (__id._M_index < (*(__tmp->_M_facets))->size() &&
	      (*(__tmp->_M_facets))[__i] != 0);
    }

} // namespace std

#endif /* _CPP_BITS_LOCCORE_TCC */

// Local Variables:
// mode:c++
// End:





