// Output streams -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.6.2  Output streams
//

#ifndef _CPP_OSTREAM
#define _CPP_OSTREAM	1

#include <bits/c++config.h>
#include <bits/std_ios.h>
#include <bits/sbuf_iter.h>

namespace std {

  // 27.6.2.1 Template class basic_ostream
  template<typename _CharT, typename _Traits>
    class basic_ostream : virtual public basic_ios<_CharT, _Traits>
    {
      // Types (inherited from basic_ios (27.4.4)):
      typedef _CharT                     		char_type;
      typedef typename _Traits::int_type 		int_type;
      typedef typename _Traits::pos_type 		pos_type;
      typedef typename _Traits::off_type 		off_type;
      typedef _Traits                    		traits_type;
      
      // Non-standard Types:
      typedef basic_streambuf<_CharT, _Traits> 		__streambuf_type;
      typedef basic_ios<_CharT, _Traits>		__ios_type;
      typedef basic_ostream<_CharT, _Traits>		__ostream_type;
      typedef ostreambuf_iterator<_CharT>		__ostreambuf_iter;
      typedef num_put<_CharT, __ostreambuf_iter>        __numput_type;

    protected:
      // Data Members:
      const __numput_type* 	_M_fnumput;

    public:
      // 27.6.2.2 Constructor/destructor:
      explicit 
      basic_ostream(__streambuf_type* __sb) : __ios_type(__sb)  
      { 
	// XXX Need to fix for imbue events, as currently _M_fnumput
	// is not updated on pubimbue calls. Need a callback? Needs to
	// be moved down do basic_ios??
	_M_fnumput =  &use_facet<__numput_type>(this->getloc());
      }

      // Needed for [io]stringstream/[io]fstream classes. This assumes
      // that basic_ios has already been initialized _M_streambuf with
      // some relevant buffer.
      explicit 
      basic_ostream() 
      { 
	// XXX Need to fix for imbue events, as currently _M_fnumput
	// is not updated on pubimbue calls. Need a callback? Needs to
	// be moved down do basic_ios??
	_M_fnumput =  &use_facet<__numput_type>(this->getloc());
      }

      virtual 
      ~basic_ostream() 
      { _M_fnumput = NULL; }

      // 27.6.2.3 Prefix/suffix:
      class sentry;
      friend class sentry;
      
      // 27.6.2.5 Formatted output:
      __ostream_type&
      operator<<(__ostream_type& (*__pf)(__ostream_type&))
      {
	__pf(*this);
	return *this;
      }
      
      __ostream_type&
      operator<<(__ios_type& (*__pf)(__ios_type&))
      {
	__pf(*this);
	return *this;
      }
      
      __ostream_type&
      operator<<(ios_base& (*__pf) (ios_base&))
      {
	__pf(*this);
	return *this;
      }

      // 27.6.2.5.3  basic_ostream::operator<<
      __ostream_type& 
      operator<<(long __n);
      
      __ostream_type& 
      operator<<(unsigned long __n);

      __ostream_type& 
      operator<<(bool __n);

      __ostream_type& 
      operator<<(short __n)
      { return operator<<(static_cast<long>(__n)); }

      __ostream_type& 
      operator<<(unsigned short __n)
      { return operator<<(static_cast<unsigned long>(__n)); }

      __ostream_type& 
      operator<<(int __n)
      { return operator<<(static_cast<long>(__n)); }

      __ostream_type& 
      operator<<(unsigned int __n)
      { return operator<<(static_cast<unsigned long>(__n)); }

#ifdef _G_USE_LONG_LONG
      __ostream_type& 
      operator<<(long long __n);

      __ostream_type& 
      operator<<(unsigned long long __n);
#endif

      __ostream_type& 
      operator<<(double __f);

      __ostream_type& 
      operator<<(float __f)
      { return operator<<(static_cast<double>(__f)); }

      __ostream_type& 
      operator<<(long double __f);

      __ostream_type& 
      operator<<(const void* __p);

      __ostream_type& 
      operator<<(__streambuf_type* __sb);

      // Unformatted output:
      // XXX Fixme: these need to create sentry objects, for MT safety.
      __ostream_type& 
      put(char_type __c)
      { 
	rdbuf()->sputc(__c); 
	return *this; 
      }

      __ostream_type& 
      write(const char_type* __s, streamsize __n);

      __ostream_type& 
      flush()
      {
	if (this->rdbuf()->pubsync())
	  this->setstate(ios_base::badbit);
	return *this;
      }

      // Seeks:
      pos_type 
      tellp();

      __ostream_type& 
      seekp(pos_type);

      __ostream_type& 
      seekp(off_type, ios_base::seekdir);
    };


  // 27.6.2.3  Class basic_ostream::sentry
  template <typename _CharT, typename _Traits>
    class basic_ostream<_CharT, _Traits>::sentry
    {
      // Data Members:
      bool 				_M_ok;
      basic_ostream<_CharT,_Traits>& 	_M_ostr;
      
    public:
      explicit 
      sentry(basic_ostream<_CharT,_Traits>& __os)
      : _M_ok(__os.good()), _M_ostr(__os)
      {
	// XXX MT 
	// XXX The flush() call does not occur if the function
	// can determine that no synchronization is necessary.
	if (_M_ok && __os.tie())
	  __os.tie()->flush();  
      }

      ~sentry()
      {
	// XXX MT
	if (_M_ostr.flags() & ios_base::unitbuf && ! uncaught_exception())
	  _M_ostr.flush();
      }

      operator bool() 
      { return _M_ok; }
    };


  // 27.6.2.5.4 Character inserters
  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>&
    operator<<(basic_ostream<_CharT, _Traits>& __out, _CharT __c)
    {
      // XXX need sentry
      return __out.put(__c);
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>&
    operator<<(basic_ostream<_CharT, _Traits>& __out, char __c)
    {
      // XXX need sentry
      return __out.put(widen(__c));
    }

  // Specialization
  template <class _Traits>
    basic_ostream<char, _Traits>&
    operator<<(basic_ostream<char, _Traits>& __out, char __c)
    {
      // XXX need sentry
      return __out.put(__c);
    }

  // Signed and unsigned
  template<class _Traits>
    basic_ostream<char, _Traits>&
    operator<<(basic_ostream<char, _Traits>& __out, signed char __c)
    {
      // XXX need sentry
      return __out.put(static_cast<char>(__c));
    }
  
  template<class _Traits>
    basic_ostream<char, _Traits>&
    operator<<(basic_ostream<char, _Traits>& __out, unsigned char __c)
    {
      // XXX need sentry
      return __out.put(static_cast<char>(__c));
    }
  
  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>&
    operator<<(basic_ostream<_CharT, _Traits>& __out, const _CharT* __s)
    {
      // XXX need sentry
      return __out.write(__s,_Traits::length(__s));
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits> &
    operator<<(basic_ostream<_CharT, _Traits>& __out, const char* __s)
    {
      // XXX need sentry
      // XXX should narrow, not cast.
      return __out.write(static_cast<const _CharT*>(__s),
			  _Traits::length(static_cast<const _CharT*>(__s)));
    }

  // Partial specializationss
  template<class _Traits>
    basic_ostream<char, _Traits>&
    operator<<(basic_ostream<char, _Traits>& __out, const char* __s)
    {
      // XXX need sentry
      return __out.write(__s,_Traits::length(__s));
    }
  
  // Signed and unsigned
  template<class _Traits>
    basic_ostream<char, _Traits>&
    operator<<(basic_ostream<char, _Traits>& __out, const signed char* __s)
    {
      // XXX need sentry
      return __out.write(static_cast<const char*>(__s),
			  _Traits::length(static_cast<const char*>(__s)));
    }

  template<class _Traits>
    basic_ostream<char, _Traits> &
    operator<<(basic_ostream<char, _Traits>& __out, const unsigned char* __s)
    {
      // XXX need sentry
      return __out.write(static_cast<const char*>(__s),
			  _Traits::length(static_cast<const char*>(__s)));
    }

    // XXX need sentry
  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    endl(basic_ostream<_CharT, _Traits>& __os)
    { return flush(__os.put(__os.widen('\n'))); }

    // XXX need sentry
  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    ends(basic_ostream<_CharT, _Traits>& __os)
    { return __os.put(_Traits::eos ()); }
  
    // XXX need sentry
  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    flush(basic_ostream<_CharT, _Traits>& __os)
    { return __os.flush(); }

} // namespace std


#ifdef _G_NO_TEMPLATE_EXPORT
# define export
# include <bits/ostream.tcc>
#endif

#endif	/* _CPP_OSTREAM */



