/* 
Copyright (C) 1988 Free Software Foundation
    written by Dirk Grunwald (grunwald@cs.uiuc.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/
#include <builtin.h>
#include <Random.h>

double Random::operator()()
{
    (*lib_error_handler)("Random", "Unimplemented");
}

#include <Binomial.h>

double Binomial::operator()()
{
    int s = 0;
    for (int i = 0; i < pN; i++) {
	if (pGenerator -> asDouble() < pU) {
	    s++;
	}
    }
    return(double(s));
}

#include <Geometric.h>

double Geometric::operator()()
{
    int samples;
    for (samples = 1; pGenerator -> asDouble() < pMean; samples++);
    return((double) samples);
}

#include <HyperGeometric.h>

double HyperGeometric::operator()()
{
    double d = (pGenerator -> asDouble() > pP) ? (1.0 - pP) :  (pP);
    return(-pMean * log(pGenerator -> asDouble()) / (2.0 * d) );
}

#include <NegativeExpntl.h>

double NegativeExpntl::operator()()
{
    return(-pMean * log(pGenerator -> asDouble()));
}

#include <Normal.h>

//
//	See Simulation, Modelling & Analysis by Law & Kelton, pp259
//
//	This is the ``polar'' method.
// 

double Normal::operator()()
{
    
    if (haveCachedNormal == 1) {
	haveCachedNormal = 0;
	return(cachedNormal * pStdDev + pMean );
    } else {
	
	for(;;) {
	    double u1 = pGenerator -> asDouble();
	    double u2 = pGenerator -> asDouble();
	    double v1 = 2 * u1 - 1;
	    double v2 = 2 * u2 - 1;
	    double w = (v1 * v1) + (v2 * v2);
	    
//
//	We actually generate two IID normal distribution variables.
//	We cache the one & return the other.
// 
	    if (w <= 1) {
		double y = sqrt( (-2 * log(w)) / w);
		double x1 = v1 * y;
		double x2 = v2 * y;
		
		haveCachedNormal = 1;
		cachedNormal = x2;
		return(x1 * pStdDev + pMean);
	    }
	}
    }
}

#include <Poisson.h>

double Poisson::operator()()
{
    double bound = exp(-1.0 * pMean);
    int count = 0;

    for (double product = 1.0;
	 product >= bound;
	 product *= pGenerator -> asDouble()) {
	     count++;
	 }
    return(count - 1);
}

#include <DiscreteUniform.h>

double DiscreteUniform::operator()()
{
    long tmp = long(floor(delta * pGenerator -> asDouble()));
    return( double(pLow + tmp) );
}

#include <Uniform.h>

double Uniform::operator()()
{
    return( pLow + delta * pGenerator -> asDouble() );
}

#include <Weibull.h>

//
//	See Simulation, Modelling & Analysis by Law & Kelton, pp259
//
//	This is the ``polar'' method.
// 

double Weibull::operator()()
{
    return( pow(pBeta * ( - log(1 - pGenerator -> asDouble()) ), pInvAlpha) );
}

#include <Erlang.h>

double Erlang::operator()()
{
    double prod = 1.0;

    for (int i = 0; i < k; i++) {
	prod *= pGenerator -> asDouble();
    }
    return(-log(prod)/a);
}

#include "LogNormal.h"

//
//	See Simulation, Modelling & Analysis by Law & Kelton, pp260
//
// 

double LogNormal::operator()()
{
    return( pow(M_E, this->Normal::operator()() ) );
}
