/*
 test/demo of BST tree classes
*/

#include <stream.h>
#include "intintBSTSet.h"
#include "intintBSTAssoc.h"

int my_compare(int a, int b)
{
  return a - b;
}

void printint(int x)
{
  cout << x << " ";
}



void printBSTAssoc(intintBSTAssoc& h)
{
  cout << "count = " << h.count() << ", contents:\n";
  for (intintBSTAssocTrav p(h); p; p.advance())
    cout << "(" << p.key() << ", " << p.get() << ")";
  cout << "\n";
}

void printintBSTSet(intintBSTSet& l)
{
  l.apply(printint);
  cout << "\n";
}


void some_ints(intintBSTSet& a, int lo, int hi)
{
  for (int i = hi; i >= lo; --i)
    a.add(i);
}

void some_rands(intintBSTSet& a, int n)
{
  while (n-- > 0)
    a.add((int)rand() % 50);
}

main()
{
  intintBSTSet::item_item_comparison_function = my_compare;
  intintBSTSet::key_item_comparison_function = my_compare;
  intintBSTAssoc::key_key_comparison_function = my_compare;
  int i;

  cout << "using BSTSet tree of ints\n";
  intintBSTSet a; some_ints(a, 1, 20);
  intintBSTSet b; some_ints(b, 11, 30);
  intintBSTSet c; some_rands(c, 20);
  intintBSTSet d; some_rands(d, 20);
  
  cout << "a        ="; printintBSTSet(a);
  cout << "b        ="; printintBSTSet(b);
  cout << "c        ="; printintBSTSet(c);
  cout << "d        ="; printintBSTSet(d);
  intintBSTSet f = a;
  cout << "f = a    ="; printintBSTSet(f);

  cout << "a.contains(5)= " << a.contains(5) << "\n";
  cout << "a.del(5) ="; a.del(5); printintBSTSet(a);

  intintBSTSet e;
  cout << "e        ="; printintBSTSet(e);
  e |= a;
  cout << "e |= a   ="; printintBSTSet(e);
  e &= b;
  cout << "e &= b   ="; printintBSTSet(e);
  e -= c;
  cout << "e -= c   ="; printintBSTSet(e);
  e ^= d;
  cout << "e ^= d   ="; printintBSTSet(e);
  cout << "deleting elements of e from f, one-by-one...\n";
  for (intintBSTSetTrav ep(e); ep; ep.advance())
    f.del(ep.get());
  cout << "f        ="; printintBSTSet(f);
  e.destructive_union(a);
  cout << "after e.destructive_union(a):\n";
  cout << "e        ="; printintBSTSet(e);
  cout << "a        ="; printintBSTSet(a);
  cout << "after e.balance()\n"; e.balance();
  cout << "e        ="; printintBSTSet(e);
  cout << "b via traverser:\n";
  for (intintBSTSetTrav bp(b); bp; bp.advance())
    cout << bp.get() << ", ";
  cout << "\n";


  intintBSTAssoc t;
  cout << "\nusing intintBSTAssoc t...\n";
  printBSTAssoc(t);
  t[1000] = 1000;
  cout << "after t[1000] = 1000, t[1000] = " << t[1000] << "\n";
  printBSTAssoc(t);
  cout << "t.contains(1000) = " << t.contains(1000) << "\n";
  cout << "t.contains(2000) = " << t.contains(2000) << "\n";
  cout << "t[2000] = " << t[2000] << "\n";
  cout << "inserting...\n";
  for (i = 0; i < 10; ++i)
  {
    int key = rand() % 100;
    int cont = rand() % 100 + 500;
    cout << "(" << key << ", " << cont << ")";
    t[key] = cont;
  }
  cout << "\n";
  printBSTAssoc(t);
  t.del(1000);
  cout << "after t.del(1000), t.contains(1000) = " << t.contains(1000) << "\n";
  printBSTAssoc(t);
  t.clear();
  cout << "after t.clear()\n";
  printBSTAssoc(t);

  cout << "\nEnd of test\n";
}
