/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/

#include <stream.h>
#include <stdarg.h>
#include <ctype.h>
#include "libconfig.h"

ostream::ostream() {}

ostream::ostream(const char* filename, io_mode m, access_mode a)
:(filename, m, a) {}

ostream::ostream(const char* filename, const char* m)
:(filename, m) {}

ostream::ostream(int filedesc, io_mode m = io_writeonly)
:(filedesc, m) {}

ostream::ostream(FILE* fileptr)
:(fileptr) {}

ostream::~ostream() {}

istream::istream()
{ 
  tied_to = 0; 
}

istream::istream(const char* filename, io_mode m, access_mode a) 
:(filename, m, a) 
{ 
  tied_to = 0; 
}

istream::istream(const char* filename, const char* m)
:(filename, m) 
{ 
  tied_to = 0;
}

istream::istream(int filedesc, io_mode m = io_readonly)
:(filedesc, m) 
{ 
  tied_to = 0; 
}

istream::istream(FILE* fileptr)
:(fileptr) 
{ 
  tied_to = 0;
}

istream::~istream() {}

void istream::_flush()
{
  if (tied_to)
    tied_to->flush();
}

ostream* istream::tie(ostream* s) 
{ 
  ostream* t = tied_to; 
  tied_to = s; 
  return t; 
}

istream& istream::operator>>(whitespace&)
{
  _flush();
  char ch;
  while((get(ch)) && isspace(ch));
  if (good())
    unget(ch);
  return *this;
}

istream& istream::scan(const char* fmt ...)
{
  _flush();
  va_list args;
  va_start(args, fmt);
  stat = _doscan(fp, fmt, args);
  va_end(args);
  failif(stat <= 0);
  return *this;
}

ostream& ostream::form(const char* fmt ...)
{
  va_list args;
  va_start(args, fmt);
#ifndef HAVE_VPRINTF
  stat = _doprnt(fmt, args, fp);
#else
  stat = vfprintf(fp, fmt, args);
#endif
  va_end(args);
  failif(stat < 0);
  return *this;
}

void eatwhite(istream& s)
{
  s >> WS;
}

/*
 * predeclared streams
 */

istream  cin(stdin);
ostream  cout(stdout);
ostream  cerr(stderr);

whitespace WS;

