// g++ 1.37.1 bug 900403_02

// g++ (and gcc) will generate code for the following array declaration
// which may result in mysterious assembly-time or link-time errors.

// The problem is that this code can result in the generation of a ".comm"
// assembly directive which gives a negative number as the byte count.

// This problem could be easily fixed in gcc/g++ by changing the format
// strings used by the ASM_OUTPUT_COMMON macros in the tm-*.h file so that
// they use %u instead of %d.

// The format strings in the ASM_OUTPUT_LOCAL, ASM_OUTPUT_SKIP, and
// ASM_OUTPUT_ALIGN macros should probably be fixed also in a similar manner.

// keywords: arrays, array bound, humongous

char array[(unsigned) 0x90000000];		// ERROR - bad test case

int main () { return 0; }
