#ifndef CYGONCE_VAR_SH_REGS_H
#define CYGONCE_VAR_SH_REGS_H
//=============================================================================
//
//      sh_regs.h
//
//      SH CPU definitions
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jskov
// Contributors:jskov
// Date:        1999-04-24
// Purpose:     Define CPU memory mapped registers etc.
// Usage:       #include <cyg/hal/sh_regs.h>
// Notes:
//   This file describes registers for on-core modules found in all
//   the SH3 CPUs supported by the HAL. For each CPU is defined a
//   module specification file (mod_<CPU model number>.h) which lists
//   modules (and their version if applicable) included in that
//   particular CPU model.  Note that the versioning is ad hoc;
//   it doesn't reflect Hitachi internal versioning in any way.
//              
//####DESCRIPTIONEND####
//
//=============================================================================

// Find out which modules are supported by the chosen CPU
#include <pkgconf/system.h>
#include CYGBLD_HAL_CPU_MODULES_H

//==========================================================================
//                             CPU Definitions
//==========================================================================

//--------------------------------------------------------------------------
// Status register
#define CYGARC_REG_SR_MD                0x40000000
#define CYGARC_REG_SR_RB                0x20000000
#define CYGARC_REG_SR_BL                0x10000000
#define CYGARC_REG_SR_M                 0x00000200
#define CYGARC_REG_SR_Q                 0x00000100
#define CYGARC_REG_SR_IMASK             0x000000f0
#define CYGARC_REG_SR_I3                0x00000080
#define CYGARC_REG_SR_I2                0x00000040
#define CYGARC_REG_SR_I1                0x00000020
#define CYGARC_REG_SR_I0                0x00000010
#define CYGARC_REG_SR_S                 0x00000002
#define CYGARC_REG_SR_T                 0x00000001


//==========================================================================
//                             Module Definitions
//==========================================================================

#include <cyg/hal/mod_regs_cpg.h>
#include <cyg/hal/mod_regs_mmu.h>
#include <cyg/hal/mod_regs_ser.h>
#include <cyg/hal/mod_regs_ubc.h>

#if (CYGARC_SH_MOD_BSC == 1)
# include <cyg/hal/mod_regs_bsc.h>
#elif (CYGARC_SH_MOD_BSC == 2)
# include <cyg/hal/mod_regs_bsc_2.h>
#else
# error "Unknown BSC header type"
#endif
#if (CYGARC_SH_MOD_WDT == 1)
# include <cyg/hal/mod_regs_wdt.h>
#elif (CYGARC_SH_MOD_WDT == 2)
# include <cyg/hal/mod_regs_wdt_2.h>
#else
# error "Unknown WDT header type"
#endif
#if (CYGARC_SH_MOD_CAC == 1)
# include <cyg/hal/mod_regs_cac.h>
#elif (CYGARC_SH_MOD_CAC == 2)
# include <cyg/hal/mod_regs_cac_2.h>
#else
# error "Unknown CAC header type"
#endif
#if (CYGARC_SH_MOD_INTC == 1)
# include <cyg/hal/mod_regs_intc.h>
#elif (CYGARC_SH_MOD_INTC == 2)
# include <cyg/hal/mod_regs_intc_2.h>
#else
# error "Unknown INTC header type"
#endif
#ifdef CYGARC_SH_MOD_DMAC
#include <cyg/hal/mod_regs_dma.h>
#endif
#ifdef CYGARC_SH_MOD_PFC
# if (CYGARC_SH_MOD_PFC == 1)
#  include <cyg/hal/mod_regs_pfc.h>
# elif (CYGARC_SH_MOD_PFC == 2)
#  include <cyg/hal/mod_regs_pfc_2.h>
# else
#  error "Unknown PFC header type"
# endif
#endif
#ifdef CYGARC_SH_MOD_FRT
#include <cyg/hal/mod_regs_frt.h>
#endif
#ifdef CYGARC_SH_MOD_PCM
#include <cyg/hal/mod_regs_pcm.h>
#endif
#ifdef CYGARC_SH_MOD_ETH
#include <cyg/hal/mod_regs_eth.h>
#endif
#ifdef CYGARC_SH_MOD_CMT
#include <cyg/hal/mod_regs_cmt.h>
#endif
#ifdef CYGARC_SH_MOD_ADC
#include <cyg/hal/mod_regs_adc.h>
#endif

//--------------------------------------------------------------------------
#endif // ifndef CYGONCE_VAR_SH_REGS_H
// End of var_regs.h
