/*
 * localtime.c
 */

/*
FUNCTION
<<localtime>>---convert time to local representation

INDEX
	localtime

ANSI_SYNOPSIS
	#include <time.h>
	struct tm *localtime(time_t *<[clock]>);
	struct tm *localtime_r(time_t *<[clock]>, struct tm *<[res]>);

TRAD_SYNOPSIS
	#include <time.h>
	struct tm *localtime(<[clock]>)
	time_t *<[clock]>;
	struct tm *localtime(<[clock]>, <[res]>)
	time_t *<[clock]>;
	struct tm *<[res]>;

DESCRIPTION
<<localtime>> converts the time at <[clock]> into local time, then
converts its representation from the arithmetic representation to the
traditional representation defined by <<struct tm>>.

<<localtime>> constructs the traditional time representation in static
storage; each call to <<gmtime>> or <<localtime>> will overwrite the
information generated by previous calls to either function.

<<mktime>> is the inverse of <<localtime>>.

RETURNS
A pointer to the traditional time representation (<<struct tm>>).

PORTABILITY
ANSI C requires <<localtime>>.

<<localtime>> requires no supporting OS subroutines.
*/

#include <time.h>

#ifndef _REENT_ONLY

struct tm *
_DEFUN (localtime, (tim_p),
	_CONST time_t * tim_p)
{
  static struct tm tim_s;
  return localtime_r (tim_p, &tim_s);
}

#endif
