/* This testcase is part of GDB, the GNU debugger.

   Copyright 2004, 2007, 2008, 2009, 2010 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#ifdef __VLE__
#define STWU "e_stwu"
#define STW "e_stw"
#define BLR "se_blr"
#define LWZ "e_lwz"
#define STB "e_stb"
#define MR "mr"
#else
#define STWU "stwu"
#define STW "stw"
#define BLR "blr"
#define LWZ "lwz"
#define STB "stb"
#define MR "mr"
#endif

void arg_passing_test2 (void);

int
main (void)
{
  arg_passing_test2 ();
  return 0;
}


/* Asm for procedure arg_passing_test2.

   The challenge here is getting past the 'mr 0,3' and 'stb'
   instructions.  */

asm ("	.section	\".text\"\n"
     "	.align 2\n"
     "	.globl arg_passing_test2\n"
     "	.type	arg_passing_test2, @function\n"
     "arg_passing_test2:\n"
     "	" STWU " 1,-64(1)\n"
     "	" STW " 31,60(1)\n"
     "	" MR " 31,1\n"
     "	" MR " 0,3\n"
     "	evstdd 4,16(31)\n"
     "	" STW " 5,24(31)\n"
     "	" STW " 7,32(31)\n"
     "	" STW " 8,36(31)\n"
     "	" STW " 9,40(31)\n"
     "	" STB " 0,8(31)\n"
     "	" LWZ " 11,0(1)\n"
     "	" LWZ " 31,-4(11)\n"
     "	" MR " 1,11\n"
     "	" BLR "\n"
     "	.size	arg_passing_test2, .-arg_passing_test2\n");
