//=============================================================================
//
//      pci.c
//
//      PCI library
//
//=============================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//                                                                          
//####COPYRIGHTEND####
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    jskov, from design by nickg
// Contributors: jskov
// Date:         1999-08-09
// Purpose:      PCI configuration
// Description: 
//               PCI bus support library.
//               Handles simple resource allocation for devices.
//               Can configure 64bit devices, but drivers may need special
//               magic to access all of this memory space - this is platform
//               specific and the driver must know how to handle it on its own.
//####DESCRIPTIONEND####
//
//=============================================================================

#include <cyg/io/pci_hw.h>

// CYG_PCI_PRESENT only gets defined for targets that provide PCI HAL support.
// See pci_hw.h for details.
#ifdef CYG_PCI_PRESENT

#include <cyg/io/pci.h>
#include <cyg/infra/cyg_ass.h>

static cyg_bool cyg_pci_lib_initialized = false;

void
cyg_pci_init( void )
{
    if (!cyg_pci_lib_initialized) {
        // Initialize the PCI bus, preparing it for general access.
        cyg_pcihw_init();

        cyg_pci_lib_initialized = true;
    }
}

//---------------------------------------------------------------------------
// Common device configuration access functions

void 
cyg_pci_get_device_info ( cyg_pci_device_id devid, cyg_pci_device *dev_info )
{
    int i;
    cyg_uint8 bus = CYG_PCI_DEV_GET_BUS(devid);
    cyg_uint8 devfn = CYG_PCI_DEV_GET_DEVFN(devid);

    dev_info->devid = devid;

    cyg_pcihw_read_config_uint16(bus, devfn, CYG_PCI_CFG_VENDOR,
                                 &dev_info->vendor);
    cyg_pcihw_read_config_uint16(bus, devfn, CYG_PCI_CFG_DEVICE,
                                 &dev_info->device);
    cyg_pcihw_read_config_uint16(bus, devfn, CYG_PCI_CFG_COMMAND,
                                 &dev_info->command);
    cyg_pcihw_read_config_uint16(bus, devfn, CYG_PCI_CFG_STATUS,
                                 &dev_info->status);
    cyg_pcihw_read_config_uint32(bus, devfn, CYG_PCI_CFG_CLASS_REV,
                                 &dev_info->class_rev);
    cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_CACHE_LINE_SIZE,
                                &dev_info->cache_line_size);
    cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_LATENCY_TIMER,
                                &dev_info->latency_timer);
    cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_HEADER_TYPE,
                                (cyg_uint8*)&dev_info->header_type);
    cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_BIST,
                                &dev_info->bist);

    for (i = 0; i < CYG_PCI_MAX_BAR; i++){
        cyg_uint32 bar;
        cyg_pcihw_read_config_uint32(bus, devfn, 
                                     CYG_PCI_CFG_BAR_BASE + 4*i,
                                     &bar);
        dev_info->base_address[i] = bar;
    }

    // If device is disabled, probe BARs for sizes.
    if ((dev_info->command & CYG_PCI_CFG_COMMAND_ACTIVE) == 0) {

        for (i = 0; i < CYG_PCI_MAX_BAR; i++){
            cyg_uint32 size;

            cyg_pcihw_write_config_uint32(bus, devfn, 
                                          CYG_PCI_CFG_BAR_BASE + 4*i,
                                          0xffffffff);
            cyg_pcihw_read_config_uint32(bus, devfn, 
                                         CYG_PCI_CFG_BAR_BASE + 4*i,
                                         &size);
            dev_info->base_size[i] = size;
            dev_info->base_map[i] = 0xffffffff;
            

            // Check for a 64bit memory region.
            if (CYG_PCI_CFG_BAR_SPACE_MEM == 
                (size & CYG_PCI_CFG_BAR_SPACE_MASK)) {
                if (size & CYG_PRI_CFG_BAR_MEM_TYPE_64) {
                    // Clear fields for next BAR - it's the upper 32 bits.
                    i++;
                    dev_info->base_size[i] = 0;
                    dev_info->base_map[i] = 0xffffffff;
                }
            }
        }
    } else {
        // Clear the base map so we can recognize an already configured
        // device.
        for (i = 0; i < CYG_PCI_MAX_BAR; i++) {
            dev_info->base_size[i] = 0;
        }
    }
            

    switch (dev_info->header_type & CYG_PCI_CFG_HEADER_TYPE_MASK) {
    case CYG_PCI_HEADER_NORMAL:
        cyg_pcihw_read_config_uint32(bus, devfn, CYG_PCI_CFG_CARDBUS_CIS,
                                     &dev_info->header.normal.cardbus_cis);
        cyg_pcihw_read_config_uint16(bus, devfn, CYG_PCI_CFG_SUB_VENDOR,
                                     &dev_info->header.normal.sub_vendor);
        cyg_pcihw_read_config_uint16(bus, devfn, CYG_PCI_CFG_SUB_ID,
                                     &dev_info->header.normal.sub_id);
        cyg_pcihw_read_config_uint32(bus, devfn, CYG_PCI_CFG_ROM_ADDRESS,
                                     &dev_info->header.normal.rom_address);
        cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_CAP_LIST,
                                    &dev_info->header.normal.cap_list);

        cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_INT_LINE,
                                    &dev_info->header.normal.int_line);
        cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_INT_PIN,
                                    &dev_info->header.normal.int_pin);
        cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_MIN_GNT,
                                    &dev_info->header.normal.min_gnt);
        cyg_pcihw_read_config_uint8(bus, devfn, CYG_PCI_CFG_MAX_LAT,
                                    &dev_info->header.normal.max_lat);
        break;
    case CYG_PCI_HEADER_BRIDGE:
        CYG_FAIL("PCI device header 'bridge' support not implemented");
        break;
    case CYG_PCI_HEADER_CARDBUS_BRIDGE:
        CYG_FAIL("PCI device header 'cardbus bridge' support not implemented");
        break;
    default:
        CYG_FAIL("Unknown PCI device header type");
        break;
    }
}

void 
cyg_pci_set_device_info ( cyg_pci_device_id devid, cyg_pci_device *dev_info )
{
    cyg_uint8 bus = CYG_PCI_DEV_GET_BUS(devid);
    cyg_uint8 devfn = CYG_PCI_DEV_GET_DEVFN(devid);

    // Only writable entries are updated.
    cyg_pcihw_write_config_uint16(bus, devfn, CYG_PCI_CFG_COMMAND,
                                  dev_info->command);
    cyg_pcihw_write_config_uint16(bus, devfn, CYG_PCI_CFG_STATUS,
                                  dev_info->status);
    cyg_pcihw_write_config_uint8(bus, devfn, CYG_PCI_CFG_CACHE_LINE_SIZE,
                                 dev_info->cache_line_size);
    cyg_pcihw_write_config_uint8(bus, devfn, CYG_PCI_CFG_LATENCY_TIMER,
                                 dev_info->latency_timer);
    cyg_pcihw_write_config_uint8(bus, devfn, CYG_PCI_CFG_BIST,
                                 dev_info->bist);

    cyg_pcihw_write_config_uint32(bus, devfn, CYG_PCI_CFG_BAR_0,
                                  dev_info->base_address[0]);
    cyg_pcihw_write_config_uint32(bus, devfn, CYG_PCI_CFG_BAR_1,
                                  dev_info->base_address[1]);
    cyg_pcihw_write_config_uint32(bus, devfn, CYG_PCI_CFG_BAR_2,
                                  dev_info->base_address[2]);
    cyg_pcihw_write_config_uint32(bus, devfn, CYG_PCI_CFG_BAR_3,
                                  dev_info->base_address[3]);
    cyg_pcihw_write_config_uint32(bus, devfn, CYG_PCI_CFG_BAR_4,
                                  dev_info->base_address[4]);
    cyg_pcihw_write_config_uint32(bus, devfn, CYG_PCI_CFG_BAR_5,
                                  dev_info->base_address[5]);

    switch (dev_info->header_type & CYG_PCI_CFG_HEADER_TYPE_MASK) {
    case CYG_PCI_HEADER_NORMAL:
        cyg_pcihw_write_config_uint32(bus, devfn, CYG_PCI_CFG_CARDBUS_CIS,
                                      dev_info->header.normal.cardbus_cis);
        cyg_pcihw_write_config_uint16(bus, devfn, CYG_PCI_CFG_SUB_VENDOR,
                                      dev_info->header.normal.sub_vendor);
        cyg_pcihw_write_config_uint16(bus, devfn, CYG_PCI_CFG_SUB_ID,
                                      dev_info->header.normal.sub_id);
        cyg_pcihw_write_config_uint32(bus, devfn, CYG_PCI_CFG_ROM_ADDRESS,
                                      dev_info->header.normal.rom_address);

        cyg_pcihw_write_config_uint8(bus, devfn, CYG_PCI_CFG_INT_LINE,
                                     dev_info->header.normal.int_line);
        cyg_pcihw_write_config_uint8(bus, devfn, CYG_PCI_CFG_INT_PIN,
                                     dev_info->header.normal.int_pin);
        cyg_pcihw_write_config_uint8(bus, devfn, CYG_PCI_CFG_MIN_GNT,
                                     dev_info->header.normal.min_gnt);
        cyg_pcihw_write_config_uint8(bus, devfn, CYG_PCI_CFG_MAX_LAT,
                                     dev_info->header.normal.max_lat);
        break;
    case CYG_PCI_HEADER_BRIDGE:
        CYG_FAIL("PCI device header 'bridge' support not implemented");
        break;
    case CYG_PCI_HEADER_CARDBUS_BRIDGE:
        CYG_FAIL("PCI device header 'cardbus bridge' support not implemented");
        break;
    default:
        CYG_FAIL("Unknown PCI device header type");
        break;
    }

    // Update values in dev_info.
    cyg_pci_get_device_info(devid, dev_info);
}


//---------------------------------------------------------------------------
// Specific device configuration access functions
void 
cyg_pci_read_config_uint8( cyg_pci_device_id devid,
                           cyg_uint8 offset, cyg_uint8 *val)
{
    cyg_pcihw_read_config_uint8(CYG_PCI_DEV_GET_BUS(devid),
                                CYG_PCI_DEV_GET_DEVFN(devid),
                                offset, val);
}

void 
cyg_pci_read_config_uint16( cyg_pci_device_id devid,
                            cyg_uint8 offset, cyg_uint16 *val)
{
    cyg_pcihw_read_config_uint16(CYG_PCI_DEV_GET_BUS(devid),
                                 CYG_PCI_DEV_GET_DEVFN(devid),
                                 offset, val);
}

void
cyg_pci_read_config_uint32( cyg_pci_device_id devid,
                            cyg_uint8 offset, cyg_uint32 *val)
{
    cyg_pcihw_read_config_uint32(CYG_PCI_DEV_GET_BUS(devid),
                                 CYG_PCI_DEV_GET_DEVFN(devid),
                                 offset, val);
}


// Write functions
void
cyg_pci_write_config_uint8( cyg_pci_device_id devid,
                            cyg_uint8 offset, cyg_uint8 val)
{
    cyg_pcihw_write_config_uint8(CYG_PCI_DEV_GET_BUS(devid),
                                 CYG_PCI_DEV_GET_DEVFN(devid),
                                 offset, val);
}

void
cyg_pci_write_config_uint16( cyg_pci_device_id devid,
                             cyg_uint8 offset, cyg_uint16 val)
{
    cyg_pcihw_write_config_uint16(CYG_PCI_DEV_GET_BUS(devid),
                                  CYG_PCI_DEV_GET_DEVFN(devid),
                                  offset, val);
}

void
cyg_pci_write_config_uint32( cyg_pci_device_id devid,
                             cyg_uint8 offset, cyg_uint32 val)
{
    cyg_pcihw_write_config_uint32(CYG_PCI_DEV_GET_BUS(devid),
                                  CYG_PCI_DEV_GET_DEVFN(devid),
                                  offset, val);
}

//------------------------------------------------------------------------
// Device find functions

cyg_bool
cyg_pci_find_next( cyg_pci_device_id cur_devid, 
                   cyg_pci_device_id *next_devid )
{
    cyg_uint8 bus = CYG_PCI_DEV_GET_BUS(cur_devid);
    cyg_uint8 devfn = CYG_PCI_DEV_GET_DEVFN(cur_devid);
    cyg_uint8 dev = CYG_PCI_DEV_GET_DEV(devfn);
    cyg_uint8 fn = CYG_PCI_DEV_GET_FN(devfn);

    // If this is the initializer, start with 0/0/0
    if (CYG_PCI_NULL_DEVID == cur_devid) {
        bus = dev = fn = 0;
    } else {
        // Otherwise, check multi-function bit of device's first function
        cyg_uint8 header;
        devfn = CYG_PCI_DEV_MAKE_DEVFN(dev, 0);
        cyg_pcihw_read_config_uint8(bus, devfn,
                                    CYG_PCI_CFG_HEADER_TYPE, &header);
        if (header & CYG_PCI_CFG_HEADER_TYPE_MF) {
            // Multi-function device. Increase fn.
            fn++;
            if (fn >= CYG_PCI_MAX_FN) {
                fn = 0;
                dev++;
            }
        } else {
            // Single-function device. Skip to next.
            dev++;
        }
    }

    // Note: Reset iterators in enclosing statement's "next" part.
    //       Allows resuming scan with given input values. 
    for (;bus < CYG_PCI_MAX_BUS; bus++, dev=0) {
        for (;dev < CYG_PCI_MAX_DEV; dev++, fn=0) {
            for (;fn < CYG_PCI_MAX_FN; fn++) {
                cyg_uint16 vendor;
                devfn = CYG_PCI_DEV_MAKE_DEVFN(dev, fn);
                cyg_pcihw_read_config_uint16(bus, devfn,
                                             CYG_PCI_CFG_VENDOR, &vendor);

                if (CYG_PCI_VENDOR_UNDEFINED != vendor) {
                    *next_devid = CYG_PCI_DEV_MAKE_ID(bus, devfn);
                    return true;
                }
            }
        }
    }

    return false;
}

cyg_bool
cyg_pci_find_device( cyg_uint16 vendor, cyg_uint16 device,
                     cyg_pci_device_id *devid )
{
    // Scan entire bus, check for matches on valid devices.
    while (cyg_pci_find_next(*devid, devid)) {
        cyg_uint8 bus = CYG_PCI_DEV_GET_BUS(*devid);
        cyg_uint8 devfn = CYG_PCI_DEV_GET_DEVFN(*devid);
        cyg_uint16 v, d;

        // Check that vendor matches.
        cyg_pcihw_read_config_uint16(bus, devfn,
                                     CYG_PCI_CFG_VENDOR, &v);
        if (v != vendor) continue;

        // Check that device matches.
        cyg_pcihw_read_config_uint16(bus, devfn,
                                     CYG_PCI_CFG_DEVICE, &d);
        if (d == device)
            return true;
    }

    return false;
}

cyg_bool
cyg_pci_find_class( cyg_uint32 dev_class, cyg_pci_device_id *devid )
{
    // Scan entire bus, check for matches on valid devices.
    while (cyg_pci_find_next(*devid, devid)) {
        cyg_uint8 bus = CYG_PCI_DEV_GET_BUS(*devid);
        cyg_uint8 devfn = CYG_PCI_DEV_GET_DEVFN(*devid);
        cyg_uint32 c;

        // Check that class code matches.
        cyg_pcihw_read_config_uint32(bus, devfn,
                                     CYG_PCI_CFG_CLASS_REV, &c);
        c >>= 8;
        if (c == dev_class)
            return true;
    }

    return false;
}

//------------------------------------------------------------------------
// Resource Allocation

static CYG_PCI_ADDRESS64 cyg_pci_memory_base = HAL_PCI_ALLOC_BASE_MEMORY;
static CYG_PCI_ADDRESS32 cyg_pci_io_base = HAL_PCI_ALLOC_BASE_IO;

void
cyg_pci_set_memory_base(CYG_PCI_ADDRESS64 base)
{
    cyg_pci_memory_base = base;
}

void
cyg_pci_set_io_base(CYG_PCI_ADDRESS32 base)
{
    cyg_pci_io_base = base;
}

cyg_bool
cyg_pci_configure_device( cyg_pci_device *dev_info )
{
    int bar;
    cyg_uint32 flags;
    cyg_bool ret = false;

    // Check that device is inactive.
    if ((dev_info->command & CYG_PCI_CFG_COMMAND_ACTIVE) != 0)
        return false;

    for (bar = 0; bar < CYG_PCI_MAX_BAR; bar++) {
        flags = dev_info->base_size[bar];

        // No reason to scan beyond first inactive BAR.
        if (0 == flags)
            break;

        if ((flags & CYG_PCI_CFG_BAR_SPACE_MASK) == CYG_PCI_CFG_BAR_SPACE_MEM){
            ret |= cyg_pci_allocate_memory(dev_info, bar, 
                                           &cyg_pci_memory_base);

            // If this is a 64bit memory region, skip the next bar
            // since it will contain the top 32 bits.
            if (flags & CYG_PRI_CFG_BAR_MEM_TYPE_64)
                bar++;
        } else
            ret |= cyg_pci_allocate_io(dev_info, bar, &cyg_pci_io_base);

        cyg_pci_translate_interrupt(dev_info, &dev_info->hal_vector);
    }

    return ret;
}

// This is the function that handles resource allocation. It doesn't
// affect the device state.
// Should not be called with top32bit-bar of a 64bit pair.
inline cyg_bool
cyg_pci_allocate_memory_priv( cyg_pci_device *dev_info, cyg_uint32 bar,
                              CYG_PCI_ADDRESS64 *base, 
                              CYG_PCI_ADDRESS64 *assigned_addr)
{
    cyg_uint32 mem_type, flags;
    CYG_PCI_ADDRESS64 size, aligned_addr;

    // Get the probed size and flags
    flags = dev_info->base_size[bar];

    // Decode size
    size = (CYG_PCI_ADDRESS64) ((~(flags & CYG_PRI_CFG_BAR_MEM_MASK))+1);

    // Calculate address we will assign the device.
    // This can be made more clever, specifically:
    //  1) The lowest 1MB should be reserved for devices with 1M memory type.
    //     : Needs to be handled.
    //  2) The low 32bit space should be reserved for devices with 32bit type.
    //     : With the usual handful of devices it is unlikely that the
    //       low 4GB space will become full.
    //  3) A bitmap can be used to avoid fragmentation.
    //     : Again, unlikely to be necessary.
    //
    // For now, simply align to required size.
    aligned_addr = (*base+size-1) & ~(size-1);

    // Is the request for memory space?
    if (CYG_PCI_CFG_BAR_SPACE_MEM != (flags & CYG_PCI_CFG_BAR_SPACE_MASK))
        return false;
    
    // Check type of memory requested...
    mem_type = CYG_PRI_CFG_BAR_MEM_TYPE_MASK & flags;

    // We don't handle <1MB devices optimally yet.
    if (CYG_PRI_CFG_BAR_MEM_TYPE_1M == mem_type
        && (aligned_addr + size) > 1024*1024)
        return false;

    // Update the resource pointer and return values.
    *base = 024*1024)
   _Lot( sifeo->cache_line_size);
    cyg_pc + size) XE
Nc++)    if (CYG_PRI_CFG_BAR_MEM_TYP_write_config_uint8(bus, / affect theEee.
    aligned_addr = (*b_kcode matches.
        cyg_pcihw_read_con _CFG_BAR_MEM_TYP_wrate.
// Shou)fned_addrspiuTAIn ;

    // If this TtAR_ME:
        ca,p  cyg_uint32 c;

 BLt8(bufyet.rspiuTAIn ;

    // If r && (aY    if (CYG_PRI_CFGnnW c :
        ca,p  cyg_uint32 c;

 BL;
    cyP   cyg_pcache_liBAR_B    che_liBAR_B liBAR_B liBAX"pP   cy Shou)fned,
  _pcache_liBAR_B    che_liBAR_(CYG_PCI_ADDhou)fnR_(CYGci_set_io_base(CYG_PCI_ADDRESS32 bayDeieb_kcode matches.
       // Chsyg_uint8 dtyNFoRrh.P_writeck that class dtyO 2) The low 3_aduG_PRI_CFG_B/ Otherwise, check multi-functionvPCI_AShou0t8(bufyet.rspiuTAIn ;

    /yg__dxThe low 3_aduG_PRI_CFGtches.
     hADDRESS32 ( clrS]Deelled reTiXct32(bus,tYaduG_PRI_CFGThe low Mmulti-functionvPCI_AShou0t8(bufig_uint3*ni}tdr + size) >8(bus, / sary. (,L;
   yg_uint8 bus = CYG_PCI_DEV_GET_BUS(De low 3_aduG_PRI_CFGtches.
    ~m* }
   (oOe);
    cyg_pcx address weg_uint3*ni}tdr +Dci_allocate_memory_priv( cle matches.
       // Chsyg_uint8 dtyNFoRrh.P_writeck that class dtyO 2) Tasr dtyO 2) lry. Geck multi-fu'G.O_uint8 bus = CYG_PCI_:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::  cyg_pcx addrebuf)u   nfo->header.normaD  : Again, u_)g_bool ret = false;

    // Check that device is inactive.
    iool InfS:::p = CYG_PCI_:::::::::::::::::::::::::::::::::::::__uint8 dtyNFo::::::::::T_b--- CYG_PCI_) matches.
       // Chsyg_uint8 dtyNF bar
      lz  return true;
    }g_p   ng_uin&EYPE_64e0t8(bufyet.rspiChsyg_uint8 dtyNF bar
      lz  return true;
    }g_p   ng_uin&EYPE_64e0t8(bufyet.rspihi_uiy_MEMex--- CYG_PCI_) matches.
       // Chsyg_uint8 dtyNF bar
      lz  retur   }g_pYP_writePCI_rliDe bar
                       CYG_PCI_CFG_VENDOR, &vendor);

                v  }e::::::::::::::::Y8 dtyNF bar
Nis inactive.
    iool InfSSSf:::::::::::::uv& COr.normaD  : Again, u_)g_bool ret = false;

    // Check that device is inactive.
    // Check thay yet.
    i false;



   }
    bcencppn            Cl           d'ice is inactive.
    // Check thay yetet ftoyg_uint8 busUe* d'ice is inaWle                   ie,T(HmLi>De     CI_CFG_VENDOR, &vendor);

    e,T(HmOeltce =inas,    Deea(" kodevunctionvPCI_AShou0t8(bufig_dyTfEig_fEie den;
  &tDD  :RNhdevunctionvPCI_AShou0t8(bufig_dyTfEig_fEie den;
  &tDD  :RNhdevoseuint16(CNe0t8(bufyet. : CYG- CYG_PCslEM_MASK))+18(bufEig_fEie den;
  &tDD  :RNhdevose

   }rvlive.
    iool InfS:::p =rnueAn(eactivmLiow 3_adu,t   i false;



 uL(cive.
    iool InfS:::p =rnueAn(eactivmLio:::b)::::::::::::::::::::::::::::::::::::mLio     etagmentation.
    //     : Again, rnueAn(eactAPintc   p c live.
    io Ikely that the
    //  b}iool InfS:::p =rnueAn(eactivmLio:::b)::::::n thaHClgeeE_DEVFN(dev,e_ade.
// Should not be called with top32bit-bar of a 64bit pair.
inline cyuYG_PNfalse;


CslEM_MASK))e/W   //  b}iool InfS:::p =rnueAn(eactactivmLiow 3_adu,t   i false;



 uL(cive.
 Ys5P_write_CFG_BAR_MEM_TYPE_  /D A(gse;
    
   :::::::::T   //  b}iooOder.normaD  : Again, u_)g_boo b}iooOder.normaD  : Agaidy"_PNfalse;


CslEM_MASK))e/W   //  b}iool InfS::P}:::::::  cyg_pcx addrebuf)u   nfo->header.noUvize.
    aligned_add)u  ry tP>
alsp[/utYnas,    Dee
EM_MASK))e/W _4t u_)g_boo b}iooOder.normaD  : Agaidy"_PNfalOder.normaD  : AgactactivmLiow 3_adu,t   i false;



 uL(cive.
 Ys5P_write_CFG_BAR_MEM_TYPE_  /D A(gse;
    
   :::::::::T   //  b}iooOder.normaD  : Again, u_)g_boo b}iooOder.normaD  : Agaidy"_PNfalse;


CslEM_MASK))e/W   //  b}iool InfS::P}:::::::  cyg_pcx addrebuf)u   nfo-ovoolr            ->header.noUe>
alsp[/utYnas,    Dee
EM_MASK))e/W _ sidactivmLiDe>
alHd0(Dwit pair.
inline c<rPioorCg_pcx uw_reams- B liBs platform
//               sp)ueEM_M_::::::::::::::::::::::::      tI_::A+  tI    iEsieuvurcd     tI_::A+  tI    iEsieuvurcd  val);
}

void
Eyfsadu,yidactivmLiDi  r}iool InfS:::p =rnueAnsieuvurcd     tse (cyg_  r}i B liBs platform
//               sp)ueETe (cyfS:::p =rnueAw}iool InfS:::p =rnpP   s      sp)ueTebufT8,ntd)u   nfo->hP[y. Geck multi-fu'G.O_uint iool InfS:::p =rnueu(rm
//      4o ligned_adulti-fu'G.O_uint iool InfS:::p =rnueu(rm
//      4o ligned_adulti-fu'G.O_uint iool InfS:::p =rnH_tform
//        te_memooooooaD  ::p c_'G.                ie,T(HmLi>De     CI_CFG_VENDOR, &vendor);

    e,T(HmOeltce =inarm
//        te_mem  ::p c_'G.                sp)ueETe (cyfS:::p =rnueAw}iool InfS:::p =rnpP   s lb               sp)ueETe (cyfS: DeiPp =rnpP   s lb               sp)ueETe (cyfS: DeiPp =rnpP   s lb           O&tDD  :RNhdevunctionvPCI_AShouiev, ED/e
EM_MASK))e/W _ sidactivmLiD  reams- ::::drslEM_MASK))e/W   //  b}iool InfS::P}:::::::  cyg_pcx addrebuf)u   nfo->headenImultiwNr
//   f4}  4o ueAw}iool InfS:::p =rnpP  Y_MASK)YG_PNfalse;


CslEM_MASK))e/W   //  b}iool InfS:::p =rnueM_MwmLiD  reams- :::_K))e/W  bdenImultiwNr
//   f4}  4o ueAw}iool InfS:::p =rnpP  Y_MASK)YG_PNfalse;


CslEM&orCg_pcx uw_reams- B liBs platfote_m.O_u- reamste:r
//   f4} Toluw_reams- B 0ms- B 0ms- B S:::p =rnpP   s       =rnpP   s       =rnpP   npP   M:::::} Toluw_ream_PCslEM__v_uiyV9iBs   f4} Toluw_reams- B 0ms- BToluw_rrME:
  d  =rnpP      =rnf0)
  :::p =rnpP   s lmLio     [w_rEPp =mi > 1024*:::::T   //  b}iooOder.normaD  : Agae2(ihould not bSintyDe:::::Rip_MASK)YG_PNfmLie  b}iooOder.normaD  : Again, uO       CCgLiDaderevfn,VfLctivmgeeE_DEVF[d     CCgLiDactrvid),
                                 offsetr
//////f0)
  :::p =rnpP   s lmLio     [ bar
    Oder.normaD  : Again, u_)g_boo b}ioopio     [ bar
ioopio     [ bar
ioopio     [ bar
Di  r}iool InfS:::p =rnueAnsieuvurcd     tse (cyg_  r}i B liBs ht=ndetI_:: cd     tseytpMaPCI_DErS_Gi:g_ui*   CCgLiDuyg_uint8 bus = CY   [ b) aduuiCgLiDaderevfn,VfLctivSy=rnueAnsieuvurcd     tse (cyg_  r}i B liBs ht=s = er6                                 dev_info->header.normal.cardbus_cis);
        cyg_pcihw_write_config_uint16(bus, devfn, CYG_PCI_CFG_SU offset, val);g_uint16(bulf lmLioAtenImultiwNr
//   f-ultiwEe,
                                 offeG_BAR_MEM_s24*:::rnueAnsieuvurcd     tse (cyg_  rof+MaPCImult : ,g_  ropioo3ice is inactive.
    // Check thay yetet ftoyg_uint8 busUe* d'icf
alsp[/utYnas,    Dee
EM_MASK))e/W _4t u_)g_bould not bSintyDe:::::Rip                          dev_info->MaPCImule   Dee
EM_evfn     tse (cyg_  rof+MaooOder.normaD  : AliBs ht=s = 
(cyg_  rof+MaPCImult : ,g_  ropioo3ice is inactive.
    // Check t_nactive.
    // Check thai      wo3ice is inaCaaaaaaaaaaaaFntyD tI    iETko::RoOder.+.
r.+.
r.+.
r.er6                          t_nactivyet     rebuf)u   nfo->hea inmfalse;



 uL(cive.
nurx wo3ice is ieiY} b, devfn, eeeeeeeeeeeeeeeDp =rnueAnsieuvurcd     tse (c   l3mliBs ht=s = 
(cyg_  rof+++++ = 
(cyg_  roR    8uevl_LINE,
    devif_ku'Ae;
}

cyg_bool
cyg_pci_find_class( cyg_uint32 dev) aduuiCgLiDaderevfn,VfLg_  roR   hlirnpP  Y_MASK)YG_PNfalse;

;
}

cyg_bool
cyg_pci_find_claaaaaaael roR 2 dev) aduuiCgLiDadeESS6opioo3ice is inactiv er*

;
}

cyg_byg_u_S:_N(dev, fn)  s lb     uuiCgLiDaderevfn,VfLg_  roR   hlirnpP  Y_MASK)YG_PNfalse;
 Ym(O&--- CYG_PCI_BBBBBBBBBBBBBBBBBl    uuiCgLiDaderevfn,VfLg_  roR   hlirnpxe
cyg_boobas ould be reserved for devices with 1M memvif_ku'Ae;
}

cyg_bool
cDfS::P}:::::::  cyg_l>b,::  cyg_l>b,::  cyg_l>b,::  cyg_l>b,::  cyg_l>b,::  cyg_l>b,:: .eBBBBBBBBBBBBBBBBl    uuiCgLiDaderevfn,VfLg_  riTwoe*_  riTwoe*_  regvBBBBl    uuiCgLiDaderevfn,VfLg_  riTwoe*_:::  cyg_l>b,::  ct uuiCgLiBBBBBBBBBBl    uuiCgLiDaderevfn,VfLg_  riTwoe*_  riTwoe*_  regvBBBBl    uuiCgLiDadnpxe
cyg_boobas ould be reserved for devices with 1M memvif  idevIIIII Lor);

    e,T(HmOeltce =inat=s = 
(cyg_  rof+++++ = 
(cyg_ es platform
//               not be callpuint io      vCegvBBBBl    uuiCgLiDaderevfn,VfLg_  riTwoe*_:::  cyg_l>b,::  ct Ym(Nfa lmLioAteXaBBByg_l>b,::  ci  ci  ci  plate =i   (bus,tYaduG_PRI_CFGThe low Mmulti8//f0)
  :::=rnueAw}iool InfS//
    //rF    tseytpMaPCI_iDaderevfn,VfLctivmgeeE_DEVF[d     CC_  riTwoe*_:::  cyg_l>b,::  ct Ym(Nfa lmLioAteXaBBByg_l>b,::  ci  ci  ci  plate 
  :::I#e*_:sYm(Nfa lmLioAteXaBBByg_l>b,::  ci  ci oate 
.derevf  Cs oul  p_cyfS: DeiPp =rnpP   s lb  }l     CtfLg_NP ::PCI_Co_Co_:sYm(Nfa lmLioAteXaBBByg_l>b,u oPCI_Co_Co_:sYm(Nfa lmLioAteXaBBByg_l>b,u Ym(Nfa lmLioAteXaBBByg_l>b0/  pvteltceoe*_:::  cyg_l>b,:r sp)ueETe (cyfSboolYaduG_PRI_CFGThe low Mmulti8//f0)
  :::=rnueAw}iool InfS//
    //rF  erevCCCCCCCCCCCCCCCCCCC(sh     uunbvoidoluCCCCCG_PRI_CF return false;
}

//--------mmF retoosssssegvBBBBl    f  nt32(bus, devfn, CYG_PCI_CFG_CARDBUS_ol InfS//
    //rF  erevCCCCCCCCCCCCCCCCCCC(sh     uunbvoidoluCCCCCG_PRI_CF re  c_translate_interrupt(dev_INE,
 d_ol o3ice is in.
r[ bar#offemory type.
    //     : Needs tbe (cAi(Ce Y_MASK)YG_PNfalse;

;
}

cygsOrBe loio::cCImrG//
 "bs PNfu   tvR_CFGThe low Mmulti8//f0)
  :::=rnueAw}iool InfS//
    //rF  erevCCCCCCCC  riTwoe*_::: rri:  cyg_l>b,::  grevCPTG,,,,,,,,,,,,,,,,,elo&Ig_l>b,u oPCI_Co_Co_:sYm(NfarevCPTG&dev_info->hal_vector) ;

    /yg__dxThe low 3_oe*********SC__dxThe low 3_oe*********S  grB2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2ces with 1M memvif  idevIIIII Lor);

    e,T(HmOe)M memvif  idevIIIII Lor);

    e    e    e    e    e 0ms- BToluw_rrME:
  d  =rnpP      =rnf0)
  :::p =rnpPA  lcVw Mmulti8//f      _aC (cAi(Ce Y_MASK)YG_PNfalse;

;
}

cygsOrBe loio:__i(Ce Y_MASK)YG noci              .
r[ l      ooffsee Y_MASK)YG=s = 
(cyg_  rof+++++ = 
(,oooaD  ::p c_'G.                ie,T(HmLi>De     CI_CFG_VENDOR, &vendor);

   syyg_rB2e -ho.O_u- reamste:r)Cevfn,Vfeulti8//f      _aC (cAi(Ce Y_MASK)YG_PNfalse;

;
}

cygsOrBe locmOe    ube reserved for devices with 1M memvif  idevIIIIffsee Y_MASK)YG=s = 
(cyg_  rof++N           ie,T(l    uuiCgLiDaderevfn,VfLg_  riTwoe*_  riTwoe*_  regvBBBBl    uuiCgLiDaderusee Y_MASK)YG=s va<nE:: .eBBBBBBBBBBBBBBBBBBBBBBBBBBBB_oefev_info->   devices pmccplat_CFG_VENDOR, &vendor);

   syyg_rB2e -ho.O_u- reamste:r)Cevfn,Vfeyvy //rF  erevCC/rF  erg_uiO_u-
*********S  g    e,T(HmOe)M memycyg::p =rnueG ,gaY :::=rnueAw}iool IncsOe)M memycyg::p =ASK)YG=s va<nE:: .eBBBBBBBBBBBBBBBBBBBBBBBBBBBB_oeesg Otherw  regvBBBBl    uuiCgLiDadnpxe
cyg_boobas ould be reserved for devices with 1M memvifc++)    if (oe*cse)M memyc(irnpPA  lcVwdgLiDadnpxe
cyg_boobas ould bDOR, &vec lcVw0,Sg   i faallpuint io      vCegvBBBBl    uuiC   nfo->hea  _a.
    Eremv(e low /OrBeO
    bYIIIII Lor);

    Lnuer  CI faallpuint io      vCegvBBBBl    u
    E  Lnuer  CI .ca,p  cKd for devices wA _sSS64 size, aligned_addr;

    // Get the probed size and flags
    flags = dev_info->base_size[bar];

    // Decode size
    size = (CYG_PCI_ADDRESS6 bep =rnpPA arnhe probe   =rnf0)
  mI .BBBB_opmOey_priv( cle maM1M memPif0)
d flags
    flags = dev_info->base_size[bar];

    // Decode si2faUoe*cse)M memyc(irnpPA  lcVwdgLi;).U;wk(   s lb  }l     CtfUd3k( ( cyg_uint32 dev) aduuiCgm[bar];

    // Decode si2faUoe*cse)M memyc(irnpPA  lcVwdgLi;).U;wk(   s lb  }l  U U U U U U U U U U U U U U U*cse)M me    [ bar
ioopio     [ bar
ioopio     [ bar
Di  r}iool InfS:::p =rnueAnsieuvurcd     teSn>b,u oP/PA arn ec*fo->   devices pmccplat_CFG_VENDOR fu)
d flagsggeeE_DpPA  lcVwACc*y
:::::::  cyg_vurcd     tul MefEig_fEie den;
  &C8I_CFGThe lowNear];

   todN  &C8I_CFGThe lowNey(bus, aEC wNeTeNbI_CFG_d5  =rnf0)
N4            not belec*fs devices pmccplat_CFG_VENDOR Y_MA_l>b,::  grevCPTG,,,,,,,,,,,,,,,,,elo&Ig_l>b,u oCfuU U U U U U U U*cse)M me    [ bar
ioopio     se)
{
    cyg_pci_io_base = base;n_w_u- reamste:r)Cevfn,Vfeulti8//f      _aC (cAi(Ce Y_MASK)YG_PNfalse;

;
}

cyg U*cse)M gWS and flags
    flags = dev_info->base_size[bar];

    // Dr  riTwoe*_  regvBe****S  grBp))e)M gWS and flags
    flags = dev_info lmLioAteXaBBByg_l>b,::  ci SS and flags
    flags yg_epiCgib#eY dev_WVf{
    cyg_pctl;IIffsee Y_MASK)YG=s = 
(cyg_  rof++N           ie,T(l  oO_uci SS and fpiCd     tul MeSn_wU U U U *-bvVfeulti8 D) de1 bar
ioB = 
(cyI8imoe*_:::  cyg_l>b,::  # yddev_o    on

static CYG_PCI_ADDRESS64 cyg_pci_memory_base = HAL_PCI_ALLOCiO ssPCe =_basdN_info->base_size[bar];

    // Dr  riTwoetie,T(l  oOar];

    // DrormaD  : Again, u_)g_boo b}iooOder.normaD  : Agaidy"_PNfalse;


CslEM_MASK))e/W   //  b}iool InfS::P}:::::::  cyg_pcx addrebuf)u   nfo->header.now 3_oe*********SC__aO =_basdN_info->base_size[bar];

    // Dr  riTwoetie,fpPA  lcVwN CI_DEV_GET_BUS(De low 3_aduG_PRI_CFGtches.
    ~m* }
  her.n)CeP   cyze[BHdwoe*_  regvBe****S  grBxpPNfL)Cevfn,Vfeulti8//f      _aC (cAi(Ce Ywe,T(l  oOar];

    // DrormaD  : Again, u_)oE oOar];

    // yC)
N4            not belec*fs devices pmccplat_CFG_VENDOR Y_MA_l>b,::  grevCPTG,,,,,,,,,,,,,,,,,elo&Ig_l>b,u oCfuU U U U U U U U*cse)M me    [ bar
ioopio     se)
{
    cyg_pci_io_base = base;n_w_u- reamste:r)Cevfn,Vfeulti8//f      _aC (cAi(Ce Y_MASK)YG_PNfctor) ;

  ( ;

  ( ;

  ( ;

  ( ;

  ba,Sfctor) In+ = oOarI Lor);irnpP  Y_MASK)YG_PNNNNaO eD( ;

  ( ;

  ba,Sfctor) In+ = oOarI Lor);irnpP  Y_MAwith++;2fcalse;


CslEM_MASK))e/W   //  b}iool InfS::P}::::::: edOarI Lor);irnpP  Yn valid devices}iofeamste:r)Cevfn,Vfeul)siuI(xh-ur)nfSlrE oH *=I(xh-ur)nfSlrE oH *=Ie;


CslEM_MAor);irnp_size[bar];
-)=I(x1ioav  }e::::::::::::::::Y8 dtyNF bar
Nis retD( ;

  eoG_PNNNNaO eD( ;

  ( ;

  O( ;

  ba,SfcteDiCgib#eY dev_WVf{
    cyg_pctl;IIffsee Y_MASK)YG=s = 
(cyg_  rof++N           ie,T(ls yIxy8I_CFGThe lof]r];
-)=IP  YnSv( ;

 cAi(Ce Y_MASK)YG_PNf ey dRESEe); mem_type = CYG_PRI_CFG_BAR_MEM_TYPE_MASK & flags;

    // We d);
ee d);
ee d & CYG_ S//rF  _DervlSnSv( ;

ygDih
//               sgs Ad); mYG_PRI_CFG_BAR_MEM_TYPE_MASK & flags;

    // We d);
ee d);
ee d & CYG_ S//rF  _and fR,= CeI faallpuinASK & *y*** I_CFS//rC (cAi& flags;oHwmeOe)M memyc(irnpPA  lcVwdgLi;).U;wk(   s lb  }l  U U U U U U U U U U U U U U U*cse)M me    [ bar
ioopio     [ bar
ioopio     [ bar
Di  r}iXibASK & flags;

    &tDD r.n)CeP   cyze[BHdwoe*_  regv,tM,RS   //     : Needs to BAR_MEM_T/rpio  BAR_MEM_T/th 1M m|telags;

    &tDD r.n)CeP   cyze[BHdwoe*_  reg[ basme r.n)CeP   cyze[BHdwoe*_  regv,tM,RS   /bar
ioopio     [ bdHze[BK & flags;

    &tDD r.n)CeP   cyze[BHdwoe*_  regv,tM,RS   //     : Needs to BAR_MEM_T/rpio  BAR_MEM_T/th 1M m|telags;

    &tDD r.n)CeP   cyze[BHdwoe*_  reg[,tM,RS     // Get the probed size and flags
    flagpAfo->headenImultiwNr
//   f4}  4r
ee d  &tDD r.nEo)headenImultiwNr
//   f4}  4r
ee d  &tDD r.nEoe t io     
  &C8I_CFGThe lowNG_PRI_CMEM_,VfLg_  riTwoe*_:::  cyg_l>b,::  ct uuiCgLiBBBBBBBBBBl    uuiCgLiDaderevfn,VfLg_  riTwoe*_  riTwoe*_  regvBBBBl    uuiCgLiDadnpxe
cyg_bo FegvBBBBl    uuiCgLiDadnpxe
cyg_bo FegvBBBBl  m;

ygDihgnrmal.carFf6(CNe0t8(bufI_Cyfsadu,yidactivmLigLiDadnpxe
c regvBBBBl    uuiCgLiDadnpxe
cyg_bo FegvBBn>b,::  grevCPTG,,,,,,,,,,,,,,,,,elo&Ig_l>b,u oCiDad
    [ bmemycyg::p =rnueG ,gaY :::=rnueAw}iool IncsOe)M memycyg::p =ASK)YG=s va<nE:: .eBBBBBBBBBBBBBBBBBBBBBBBBBBBB_BBBBBBBBBr.nEoe t io     
  &C8I_CFGThe lokBBBBBBBr.nEoe t io     
  &C8I_CFGT lokBBBBBBBBBBBB/ D_MAor);irnpS Clot U U fY Aue ufon

static CYG_P lotvdb    _MAor).GmM me(dYNfalse;

;
}

cygsOrBe loio::cMENllelo&IgEM_TkBBBBl& flags;
 ievdb   I,a(s;

    &tcegvBBnr  &FGT lokBBb,,,,,elo&Ig_l>b,u oCiDao

;
oEwha0rx1y. G r}iXibASK & flags;

    &fLg_  NSg _pWc regv9_fMLioAteXaBBByg_l>b,u Ym(NfIiCgLiBBBBBBBBBBl    igs ANdIlsr,u oruu&TpP  Y_MASK)YG_PNfalse;
 Ym _s : Again, u_)g_boo b}iooOder.normaD  : Agaidy"_PNfalse;


CslEM_MASK))e/W   //  b}uoCiDao

;
m   flags = S
//      K;yY =Arnrmal.carFf6(C# &h-ur)nfSlrE oH *=Ie;


Cslos : mal.carFf6(C# &h-ur)nfSlrE oH *=Ie;


Cslos : mal.carFf6(C# &h-ur)nfSlrE oHCeP   cyze[BHdwoe* nArnr d);
ee d & CYG_ S//rF  _DervlSnSv( ;

ygDih
//               sgs Ad); mYG_PRI_CFl_MASK)BBBB_BBBBBBrE oH *=Ie;en4ioAteX/eY_MA;
m   flags = S
//    uuiCgLiDadnpxe
cyg_bo Feg(C#uuiCgLiDaderevfn,VfLg_  riTwoe*  dlnEoe nhE // H *regv,tM,RS   //     : Needs to BAR_MEM_T/rpio  BARePDad ht=ndetI_:: cd     tseytpsl*gvBBBBl    uui FGThe ze[d&E    : Needs to BAR_aiDaderevbo FegvBBBBl    uuiCgLiDadnpxe
cyg_bo FegvBBBBl  m;

ygDihgnrmal.carFf6T]lerrupt(dehe zI_:: cnpP  Y_M mYG_P(C# )Fegf           sgs Agot U U fY Aue ufon

static CYG_P lotvdb   Aue ufsize
    size = (CYiN sgstat) 
b   i(v :::=rnueAw} d( P(C#tDD rwoe*_  regv,tM,RS   B_BBBBBBBBBr.nEoe t io     
  &C8I_CFGThe lokBBBBBBBr.nEoe t io     
  &C8I_CFGT lokBBBBBBa<deAw}LPnaYG_
cyg_bool
cyg_pci_find_ne &C8I_CFGThe lokBBBBBBBr.nEoe t io     
  &C8I_CFGT     [ bar
iooYG_okBBBBBBBr.nEoe t io     
  eAw}LPnaYt _w}LPnanR     dev_info->MaPCImule   Dee
EM.AorH>caco->Mgs;

 sBid for devices widoegv,BBBBa<deAw}LPnaYG_
cyg_bool
cyg_pci_fi  _MAse,T(l  oOar];

    // DrormaD  : Again, u_)ur &tDD r.n)CeP  eG ,gaY eadenImu YG_Pcnk   sgD nEoe nhE //-)=4OBBBBl    utsalnnrnpPAG"t
cyg_pci_fi  _MAse,T(l  oOar];

    // Dro_)ur &tDD r.n)Ce eG ,,,,e eGb memed     tse (c   l3mliBs ht=s = 
(cyg_  rof+++++ = 
(cyg_  roR    8uevl_LINE,
    devif_ku'Ae;
}iooYG_okBBBBBBBr   lB2Neib     [ bar
iooYG_okBBBBBBBr.nEoe t i-(ad8I_+cyg_bool
cyg_pci_find_ne &C8I_CFGTTemed     tse (c   ]ar]enbnooYGr]enbiMENllelo&IgEM_TkBBBBl& fF/     : Needsr _+c                e "t   g_  ronX/eYn   [   g_  ronX/eYn   [   g_  ronX/eYn   [   g_  ronX/eYn   [   g_ __I   euK)YGlamENl   devif_ku'Ae;
}iooYG_okBBBBBBBr   lB2Neib     [ 
    size = (CYiN sgstat) 
b   ,,,elIdaD  :VeAw}LPnaYG_
cyg_bool
cyg_pci_/eYn       rPnaY) 
bbhcyg[ 
    si[ 
  &ihW/eYn       r  Xur &tDD r.n)Ce eG ,,,,e eGb me _,,,bl  ibASK & flags;.n)Ce eG ,,, g_  i&HDadRu d & CYGaAaD    : Needs Ida//    uuiCgLiDadnpxe
cyg_bo Feg(C#uuiCgLiDaderevfn,VfLg_  riTwoe*  dlnEoe nhE u_!ji)]wdHze[BK & flags;

    &tDD r.n)CeP   cyze[BHdwoe*_  regv,tM,n  tsrgLi)CeP  s       =rnpP   npP   M:::::} Toluw_ream_PCAcyze[BHdwoe*mrze B-eflag_   l    uuiCno FegvBBBBl    uuiCgLiDadnpxe
cyg_bo Feg ceg I_+gLiDadnpx e t i-(ad8I_+cyg_bool
cyg_pci_find_ne &C8I_CFGTTemed     tse (c   ]ar]e_  riTwoe*_  rwoes;

    &tDD r.n)CeP   cyze[BHdwoe*_  regv,tM,n TfEigC  Lor icMENllelo&IgEM_TkBBBBl& flags;
 ievdb   I,a(s;_eg  r.n)CeP   cyze[BHdwoe*_  regv,tM,n TfEigCECFGThe lokBBBBBBBr.nEoe t io     
  &C8I_CFGT lokBBBBBBBBBBBB/ D_MAnNdNrE oH *=Ie;
    [ bar
iooYG_okBBBBBBBr.nEoe t i-(ad8I_+cyg_bool
cyg_pci_find_ne rl ag_is  r (cbsalnn_is  r (cbsalnncstati,VfL
iooYG_okBBBB(u  }

    return false;
}

cyg_bool
saNll;
 tut i-(ad8I_+e//   &C8oH *=Ie;
tTTembevBBBBl    f  nt32(bc//   e (c   ]ar]enbnooYGr]enbiMENllelo&IgEM_TkBBBBl& fF/     : Needsr _+c                e "t   g_  ronX/eYn   [   g_  ronX/eYn   [   g_  ronX/eYn   &C8oH *=Ie;
tTTembevBBByU devfn, eeeeeeeeeeeeeeeDp =rnueAnsieuvurcd     tse hze B-efALfg  /bar
ioopio     [ bdHze[BK & turn false;
}

cyg_bool
saNll;
 tut i-(ad8I_+end_ne rl ag_inlelo_+e    cyg_pcse h?i_fo->header.now 3_oe***(w   tsTembeb;BBr.nEoe t io     
  &C8I_CFGThe lokBBBBBBBr.nEoe t io     
  &C8Ise_inlelo_+e    cyg_pcse hu*ltut i-(ad8I_+e//   &C8GIse_inlelo_+e ,e/bas ould bDOR, &vBr.n &C8   is  r (cbs fo    
  &C8dudSTembl &vBlncyze[BHdwoe*_  is  r (cbs fo    
  bR      e "t   g_&Yn  b)nd_ne rl eI
    si[ i&vBlncyze[E &vBlncyze[BHdwoe*_  is  r ;didwoe*_  is  r (cbs fo   oBBBBr   lBcyze[BHdwoe*_  is  r _MA_l>b,u Ym(NfIiCgLiBBBBBBBBBBl (cbs fo x lOse h?i_fo->header.now 3_oe*_MI   nY;

    &tDD rwoe*_ebs vBBBBBBBl (cbs fo x UBBl (cbs fo x UBBl (cbs fo x UBBl (cbs fo x  (cbs fo x lOse h?i_fo->header.now
//          e t io     
  &C8I_CFGT lt i-(ad8I_fm*->header.n5cFGtchuebR      e "t   g_&Yn  b)nd_ne rl eI
    si[ i&v cyze[BHdwoe*_  fdY "t   BlncI_fmfiU(c   l3mliBs ht=VereCE oH *=Ie  g_  g_&Yn  b)ndvI_fmfiUwoe* _      e t ze[B    d/0
    si[ i&v cyze[BHdwoe*_  fdY "t   BlncI_fmfiU(c   l3mliBs ht=VereCE oH *=Ie  g_  g_&Yn  b)ndvI_fmfiUwoe* _      e t ze[B    d/0
       ltpDrl//rF  erevCC/rF  erg_ b)ndv I(c   l3mliBs ht=VereCE oH *=Ie  g_  g_&Yn  b)ndvI_fmfiUwoe* _      e t ze[B    d/0
       ltpDro devif_ku'Ae;
}iooYG_o b)ndvi_bool
Oue[BH









=Ie  i-(ad8I_fm*->header.n5cFGtchuebR      e "t c0
       ltpDrl//rF  erevCC/rF  erg_ b)ndv I(c   l3mliBs ht=VereCE oH *=Ie  g 'CRei    // huebAI_fmse (c=VereCE oH *=Ie  g 'CRei    // huebAI_fmse (c=VereCE oH *=Ie  g 'CRei    // huebAI_fmse (c=VereCE oH *=Ie  ge*=Ie  g NN  C-efA .eB6    [IlVer*=Ie,  ltpDrl//rF  erevCC/. s hto xr0ow
//       OR, &v_  g_       erevCl  ge*=Ie  g NN  C-efA .eB6    [IlVer*=Ie,  lt  &C8I_CFGCE oHclpNth vI_fmfiUwoe*(tPS//rF  erevCC/rF ices pmc_bo FegY-efA .eB6    [Ilcgm  // huK)+e*(tyWte =   e (=Ie,  ltpDrl//rF  erevCC/.d =   e (=Ie,  ltpDci_=Ie,  ltpDrlSm 6   fuU U U U U U U U*cse)MSR, &vBr.n gU    rev  g NN  C-efA .eB6    [IlVer*=Ie,  ltpDrl//rF  ereNcoYn  b)nd r.o   y=   tpD3 
 e  /yg__dxTh}

cyg_sMrcd     tse hze B-efALfg  /bar
ioopi tpDrl//rF  ereNcoYn  bI_fm*->header.n5cFGtchuebR      e "t c0
  &Yn  b)ndvr*=Ie,  lt  &C8I)
d amENl   devif_ku'Ae;
}io  g NN  C/p=Ie  g     /rF  ereNcoYn  bI_fm*->header.u8I_CeeeeIe  g NN  C-efA .eB6    [IlVer*=Ie,  liot=Ie  g NN  hu*ltut i-(ad8I_+e//   &C8GIse_inlelo_+e ,e/bas ould bDOR, &vBr.n &C8   irev  g NN   g )vhices pmc_bo FegYP  irl//ed<o C-efA .eB6 IN;
}io  g NN  N   SUy(  ereNe.eBi    // huebAI_fmse (c=Ver _+c  mc_bouo;rrevCLtati,VfL
ioo  g NN   g )vhices piv flaDaderevfn,Vf*evCLNaFegY ANdIlsr,u or:=rnueAw} d( P(C#tDD rwoe*_  regvmse_inOmse_inOmsei     C-efA .eB6    [IlVer*=Ie,  ltpDrl//rF  erevCC/. s hto xrTtpDruebAI_l;ooYGr]enbiMENlYp(HmOe)M memv->heBBBBBr.nEoe t io     
  &C8Ise_inlelo_+e    cyg_pcse hu*ltut imliBla->heBBBBBr.tD   BlncI_fr   lBd  g I "t   BlncI_fmfiU(c   l3mliBs ht=VereCE oH *=Ie  g_  g_&Yn GrB2u  } piv flaDaderevfn,Vf*f_inlelo_+e"t   g_&Yn  b)nd_neour  vAI_fmse (c=Ver _+cm&Yn AI_fm_inlelo_+e eS_fu addrebuf)u   nfo->header.normaD  : Ag giCgLiBBBBBBBBBBl (cbs fo x lOse h?i_fo->header.now 3_oe*_MI   nY;I_fm(c   lpfe (c=Ver _+cm&Yn AI_fm_inlelo_+e eS_fu addrebuf)u   nfo->header6    [IlVer*=Ie,  liot=Ie  g NN  hu*ltut i-(ad8I_+e//   &C8GIse
  mI .BBBiCgA .eB6    [Ilcgm  /eeenelo_+e fm(ceeltce =inatr _+cl,u oCfuU U AI_fiiAI_+eT&e&,I_+e// le tl,u oCfuU U AI_fiiAI_+eT&e&,I_+e// le tl,u oCfuU d=inatrLw Dr"t   BlncI_fmfiU t our  v &C8oH *=Ie;
renelyU AI_fiiAI_+eT&e&,I_++++++++++oc=Ve,;





=Ie  i-(ad8I_fm*->header i[ 
  
  ba,SfcteDiCgib#eY  &C8I( b, devfn, eeeeeeeeeeeeeemYC8I( b, devfn,fA .eB6    [IlVer*=Ie,  liot=Ie  gy m*->duWipiiAI_+eT&e&,,Vfeulti8//f  WWeader.n5cFGtchuebR      e "t *_+eT&Mu_fii Nbse_inlelo_+e    cNiv flaDaderevl,u oCfuUBBBBBr   lB2Neib     [ bar
iooYG_okBBBBBBfiiAus}[ bar
iooY)i g W" |fuU d=inatr-(ad8pvC   e "t *_+eT&Mu_fii Nbse_inlelo_+e    cNa->het *_+eT&Mu__inader.n5atrLmba,SfcteDrdU,Vfeulti8/ UBBl (cbs fobse_inlelo_+e    cseBBBBBr.nEoe t io     
,Vfeulti8/ UBBl (cbs fobse_inl>header.now 3_oe***(wn
,Vfeulti8/ UB(UoEsco->header.2fU U AI_fiiAylelo_+e    cseBoCfuUB&CtfUd3k( ( cyg_uinc_bo y(_eviiAylelB&Ct   fuU d=inatrLe  g   v &C8oH *=IuelyU AI_fiiAI_+emIe, W" ,/f  WWeader.n5cFGtchuags;.n)CeAI_fiiAyl_ooooooooooooooooooooooooooooooooooooooooooooooooooooo W" ,/f  WWeadeP>   sfiiiiAVfeulti8/ UBBl (Bt, diIse_inlelo_+e ,e/bder.n5at UBBlduai.n5at UBBlduai.n5at UBBlduai.n5at UBBlduai.n5at UBBlduai.n5at UBBleB6 f_eUp=inatr-(ad8pvCc UBBlduai.n5at UBBlduai.n5at Ui.n5at UB2B2B2faNat Uooo diIse_inlelo_+e ,e/bder.n5at UBBlduai.n5at UBBlduai.n5at UBBlduai.n5at UBBlduai.n5at UBBlduai.n5at UBBleB6 f_eUp=inatr-(ad8pvCc UBBlduaN  +eT&Mu__inader.n5atrLmba,SfcteDrdU,Vfeulti8/ Uai.n5at UBBlduai.n5at UBBleB6 f_eUp=inatr-(ad8pv,SfmygsOrBe loio::cMENllelo&IgEM_TkBBBBl& flags;
 ievdb   I,a(s;

    &tcegvBBnr  &5at UI_fmfiU(c vBBnr  &5at UI_fmfiU(c vBBnr  &5at UI_+ UBBl (cbsUp=inatr-(ad8pv,SfmygsOrBe loio::cMENllelo&IgBl (Bt, dfiU(er _ gy m*->duWp
Sfmygar
Nis retDfiifmygsOrBrf  WWeader.n5c(eaderAT;

  o(iif}kUi.n5a *_+eT&Mu_fii NCE oH *=I/1woe*_  regvmse_ies   uuiCg/bas ouldeuai.n5at UBBldfo->e(dYNfpf
 a_.n5c(eaderA;

 oRicHE*ri*Be lo6.inlelo_+e ,e/bder.n5at UBBldua o.Eepat UBBlduaiRicHE*ri*Be lo6.inlelo_+e ,e/bder.n5at UBBldua o.Eepat UDi-(adDst UBBBBnr  &5at UI_uiCgtiooLealse;



 uL(cive.
 Ys5P_wriooYG_okBBBBBBBr.nEoe t i-(ad8I_+cyg_bool
cyg_pci_flAuiCg/bas8yg_pci_flAuiCg/bbBI(c   l3mBe lo6G= oOarI Lor);irnpPrevCC/.d =dM memPif0)
d flags
    flags = dev_infn}keDrdU.n5a *_dg_iNCEgib#eY  &C8I( b, devfn, eeeeeeeeeeeeeemYC8IRfbbBI(c  p I,aiba1yfwcrci_fdVfeulelo_+e ,ecHE*ri*Be lo6.inlelo_+e ,e/bder.n5at UBBldua o.Eepat UDi-(adDst UBBBBngs
cHE*ri*Be loe&wcrcOiLlsderevfnuOhAo8IRfbbBI(c  p I,aibags;
 ievduider.now 3_oe*ade"dhoYne//   &C8GIse
  mI .BBBiCgA .eB6    [Ilcgm  /eeenelo_+e fm(ceeltce =inatr _+cl,u aWp
Sfm=Ver _+cm&  &C8GIse
  mI .BBBiCgA .eB6    [IlcgiCgtiooLe2[Ilcg5cFcgm  /iCg:eB6    [IlcgI .BBbde'''''' BAR_MEM_Tlnlelo_pw fm(ceeltce of3Egib#eY  &C8I fFGIse
  mI .BBBrcygh3ApPNfL)Cevfn,Vfeulti8//f      _aC (cAi(Ce Ywe,T(l  oOar];

 i&eeltce of3Egib#eY  &C8I fFGIse
  mI .BBBrcygh3ApPNfL)Cevfn,Vfeulti8//f      _aC (cAi(Ce Ywe,T(l  oOar];

 i&eeltce of3Egib#eY  &C8I fFGIse
  mI .BBBrcygh3ApihoY_VcaYn  prdU.n5fyiyWeiOoY_VcaYn  prdU.nNl& flito_RicHE*ri*Be lo6.inlelo_+e ,e/bder.n5at UBBldua o.EcFGtche(8I_+t   BlncI_( mI e(8I_+t   BlncI_( mI e(8I_+t   BlncI_( mI e(8I_+t   eelt+++oc=Ve,;





=Ie  i-(ad8I_fm*eEle e(8I_+t   e r i[ 
Yn  prdU.n5fyie_ies  N  I e(8I_+t   eelt+++oc=Ve,;

reelt+++_aCfleloVe,;





=Ie  i-(ad8I_fm*eEle e(8I_+te,;





=Ie  i-(ad8I_fm*eEle e(8I_+t   e r i[renelyU AI_fiiAI_+eT&e&,I_++++++++++oc=Ve,;





=Ie  i-(ad8I_fm*-ti8/ Uai.n5at UBeeenelo_+.EcFGtc fm(ceeltce of3Egib#eY  &C8I :rIe  ulti8//f      _aC (cAi(Ce Ywe,T(l  oOar];

 i&eeltce of3Egib#eYg)I :rIaiI e*_  regv;
}ri-(a    [IlcgiCgtiooLe2[Ilcg5cFcgm  /iCg:eB6    [IlcgI .BBbde''''''RcI (cbs fo x lOse h?i_fo->header.now 3_oe*_MI   nY;I_fm(c   lpfe (c=Ver _+cm&Yn _+t er.rdouo&dlduai.n5at UBeGO_+t  eltrY  atic CYG_P lotvdb   Aue ufsize
    size
  Aue uBBBBBBBB0*ri*Be lo6h r i[renelyU AI_fiiAI_+eT&e&,I_++++++++++oc=Ve,;





=Ie  i-(0(tmb=1do_+e  G3h&., eelt+++oc=Ve,;

ree++oc=Ve,;





=Ie  i-(0(tn _+N2[IlFSlrE oH *=Ie;
 UBBldua o.Ecaue flags =gs == ba,Sfc UI_uiCgtiooLealse;


EfL)Cevfn,Vfeulti8//f      _aC (cAi(Ce Ywe,T(l  oOa#iUBeGO_+t  eltrY  atic C&Yn _e/n5fyie_(Ce Ywe,T(l  oOa#irlUrCi8//f      _Ver*=Ie,;





=Ilo6.inlelo_+e ,eoE oOar];

 u IO   I, IO o_+e ,e/bder.n5at mP lotvdb   AueO o_+e ,e/bder.n5at mP lotE oOar];

 u IO   #ifc (cb      rdifc ( rnnf_eUp=l)vOar]s ==Ulp=l)vOar]s ur];

 u IO  _N(dev, fn)  s lb     uuiCgLiDaderevfn,V  IvOar]s ur];

 u IO  _N(dev, fn)  s lb     uuiCgLiDaderevfn,Vv, fn) Ywe,aderevfn,Vv, fn) Ywe,aderevfn,Vv, fn) Yw+s-5ce,adefd /eee/C5at UBBlduai.n5at UBBlduai.n5at UBBlduai.n5at td [IRnggdm lo_+e 9bx o(iif}kUi.n5a *_+eT&Mu_fii NCE oH *=I/1woe*_  regvmN+eT&ize
  Aue ulelo_+e ,e/bder.n5at UBBldua o.Eg/   &C8Gu_P *=I/1woe*_  regvmN+eT&ize
  Au+++m GregvmN+eT&ize
  Au+++m GregvmN+sDduai.n5yNpo Ser.now
//          e t io     
  &C8Ie  dm lo_+e 9bx.n5at UBB
 UBBlduaN  +eT&:cMENllCevfn+oc=Ve,;

ree++ol)vOar]s ur AI_fie YwehdiIs fo x lOse h?i_fo->header.now 3_oe*_MI   nY;I_fm(c   lpfe (c=Ver _+cm&Yn    _aC iIs fo x lOse h?i_fo->headerci_fi  _MAse,T(lwU(er + 9bx.n5at UBB
 UBBlduaN  +eT&:cMENllCevfn+oc=Ve,Y;I_B
 UBB=I/1woe*_  regvmN+eT&ize
  AueCgA .o C8IRfbbBI(  _cyg_bp 
  eelt+iVBB
 B
 UBB=I/1woe*_  regvmN+eT&ize
 ee++ol)vOar]s ur AI_fie YwehdiIs fo x lOse h?i_fo->header.now 3_oe*_MI   nY;I_fm(c   lpfe (c=Ver _+cm&Y eltrY  aticw+t  elt&a=Ver _+cm&Y eltrY  aticweyDihdiId_+cENDOR Y_MA_l>b,::  greyze[BHdwsi  &C8Gu_Pit(0B=I/1woe*_  regvmN+ Fm&Y 0|(_ g_  g_&Yn  b)ndvI_fmfiUwoe* _      e t ze[Btize
  Au+++at Un5at UBBle//   &C8oH *tl;Icif  BlncI_( mI e(8I_+t   eelt+++oc=Ve,;



fn, regv;
}ri-(a  ek e (o g_&Yn  b9 
  eelt+iVBB
 B
 UBB=I/1woe*_  regvmN+eT&ize
 ee++ol)vOar]fuUB&CtfUd3k( ( cygiprdU.nNl& flito_RicHE*ri*Be lo6.inlelo_+e ,e/bde=I/1_5c& fliize
u_Pit4nll//rF  ereNcoYVe,;

;  nY;I_fm(st(0B=IYwehdiIs fo x lelt+++_aCfleloVe,;





=Ie  i-(ad8I_fm*eEle e(8I_+tnlelo_+e I(c  ,#W_aC llCevfn+oc=VewgreyNm lo_c,,,,,eOar]fuUIm le lo6.inlelo_+e ,e/bde=I/1_5c& fliize
u_Pit4nll//rF  ereNcoYVe,;

;  nY;I_fm(st(0B=IYwehdiIocUIm gri2/rF  ereNcoYVe,;

;   lo!g5cFcgm  /iCg:eB6    [IlcgI .BBbde'''''' BAR_MEM i1LE*ri*Be lo6.inleSam_Pse,o x lelt+++_aCfloCfeivv eE//f   ,1BSc& fliize
u_Pit4nll//rF  gvmN.BBlo_+e ,e/bde=inatr-(ad8pv eE//f   ,14c  ,#W /iCg:eB6AI_+oiy    d8pv eE//f   ,14c  ,#Ws ht_+e I(c  ,#WjwWwUBBByg_l>b,::  
 UCe.n5cmNI_fmoOaRnggd_c=Ver _+cNllnledOgIx

rer.now 3_oe*_MI   nY;I_fm(c   lpfe (c=gri2ENDOR Y_MA_l>N eE/fcc   lpfe (c=2ENDOR YgvmN+eT&ize
  Au+(.iregVnl >5U*_Mt CEe;
tu
.fI14c  ,#Ws h,cFcgm  /iCg:eB6    eB6    eB6    eB6    eB6    eB6    eB6    eB6    eB6    eB6    eB6    u_n    _aC iIs fo x lOse h?i_fo->+++_aCfloCfeivv eE//f   ,1BSc& fliize
u_Pit4nll//rF  gvmN.BBlo_+e ,e/bde=inatr-(ad8pv eE//f   ,14c  ,#Wfo_+e ,e/basOoSPit4  dm  A/)a//f  vCuui FGThe ze[Y;I_fm(st(0B=IYwehdiIsc0l>N eE/fcc   lpfe (c=2ENDOR Ygv,,eOar]fuUIm le lo6.inlelo_+e ,e/bde=I/1_5c& fliize
u_Pit4nll//rF  ereNcoYVi   lpfe (c=Ver _+cm&Y eltrfo     
  eAw}LPiat UBB
 UBBlduaN  +eT&:cMENllCevfn+oc=Ve,Y;I_B
 UBB=I/1'v eE//f*->header i[ 
  
  ba,SfcteDiClBBlduamUPfc=Ver _+cm&s_l>WUBB
 B6    eB6    eB6    eB6 -(ad8I_fm*eEle (d S!Y CYG_i +_aCt eBLev +eT&:cMENllCevfn+oc=Ve,Y;6.inlelo6    eB6    u_n    _aC iIs fo x lOse h?i_BBlMAsegO)NeT&Mu_fii NCde=I/1_5b  Au+}LPiat AE//f*eEle _   mc=Ver _+cmL(_er.now
//          BldiIsc0l>
cif  BlncooiBB
 UBBlduaN  +eT&:cMEx lcoYs"e_B
 UBB=I/1'v eE//f*->header i[ 
  
  ba,SfcteD _acelt+    eB6   er.no1_5[ 
  
f*-{a i[ 
  
  b
 UBB=KtidtB6 -(ad8I'e(_Dfn) Yw+s-555555555555(Bt, dfiU(er __YlafcteD N{GT AI er.n5ate555555555(Bt, dfiU_(ad8I'5wCgLiDN  +



rwwoeENllCevfn+oc=Ve,Y;I_rffcteD _acelt+    eB6   er.no1_5[ei NCde=I/1_5b  Au+}LPiat AE//f*eEle _   mc=Ver _+cmL(_er.now
//          BldiIsc0l>
cif  BlncooiBB
 UBBlduaN  +eT&:cMEx lcoYs"e_B
 UBB=I/1'v eE/>{GT AI er.n5ate555555ffn) Yw+s-55iS_Ver _+cmL(_er.now
//          u6    lpfe-_/   &C8oH 1yUlCsegO)NBB
 cif  BlncooiBB
 tfc UIveNllCevfn+oc=Ve,Y;I_rff*Be lo6.inlelo_+e ,e/uVfeul=iBeeeeem/> ce_B
 UBB=I/1'v eE/>{GT AI eer _+cmL(_er.now
//            eU(e0fZyNBB
 S  eB6    eB6    eB6    eB6    eB6    eB6    eB6    u_n    _aC iIs fo x lOse h?i_fo->+++_aCfloe if  PNfalse;

;
}

cyY  _ak
mL(_er.nowr  si[ i&SBBBBBl (cBBnr  &5at oYVe,;

;   [IlVer*=Ie,  ltpDrl//rF  erevCC/. s hto xr0owSps.n5ate555555o meuliHb)ndvI_fmfiUwoe*Du0s hto xr0owSps.n5ate555555o meuliHb)ndvI_fmfiUwoe*Du0sCseg   [IlVer*nL(_er.now
//loe if  P ekI_CeeeeIe  glnc'g   [IlVer*nL(_erDu0suh&Ver*nL(_erDu0suh&Ved eBoeB6    eCkl)loe if  Pbul=iBeeeu0suh )S.n5at UBt UBt UBt UBt UBt UBt UBt UBt &CtfUdI eCkl)loe tNllCevfn+oc=Ve,Y;IoS6   
ICfeivv eE//f   ,1BSc& fliize
u_Pit4nll//rF  gvm]s ur AI_fie YwehdiIs fo x lOse h?i_fo->header.now 3_oe*_MI   nY;I_fm(c   lpfe (c=Ver e ,e/b/yehea +eT&:cMENllCevfn+oc=Ve,Y;I_evffRu4c et+iVBize
er.no//          , uuuiCgLi(Le=}gw_evffR  ,1BSaSc& fliize
uUbo FegvBBBBl  m;

ygDihgnrmal.carFf6T]lerrupt(deheB6focOooiBB
 8~UiCSCSCS(aU_Nnrmal.carFf6T]l
 UBB=I/1'v eE/>{GTC iIs fo t AE//f*eEle.eM(_e)))))))))))))i(Le.n5ate555555o meuliHb)n'L(_erldua o.Eepat US(aU_Nnrmal.carFf6T]l
 UBB=I/1sxp-(ad8Ife++ol)vOa,1BSaSc& fliize
uUbo FegvBBBBl  uEHnGe))i(Le.n5ate555555o meuliHb)n'L(-(e*Du0sCseg  aTWw (c=Ver _+cm&Yn _+t er.rdouo&dlbher.n_F++ol)vNB
 UBB=i(Le.n5atoe tNllCevfn+oc=Ve,Y /eYn  =i(Le.n5atoe tNllCevfnR&t UEdImu YG_Pcnk   sgD Ver*neE/>{GT AIcnk   sgD Ver*neRatoe aTWw (c=Ver _+cm&Y+++ACfeiate555555o meuliHb)n'L(_erldua o.Eepate.nnnnnnnnnnnnnnnnnnhcnk   sgD#=
u_Pit4npcrcOiLlsderevfnuOhAo8IRfbbBI(cE_+cmL(_9ereval.carFf6T]lerrupW_Pse,o x lelt+_(_erldua o.Eepate.nnnnnnnnnnnnnnnnnnhcnk   sgD#=
u_Pit4npcrcOiLlsderevfnuOhAo8IRftr*nLIDu_Pivo mo 6cteDTo x {GT AI er.n5ate555555ffn) Yw+s-55iS_Ver _+cmL(_er.now
//          u6    lpfe-_/   &C8oH 1yUlCsegO)NBB
 cif  BlncooiBB
 tfc UIveNllCevfn+oc=Ve,Y;I_rff*Be liBB
 tfc UI  st4nll//rmuvB6    u_n    _aC iIs fo x lOse h?i_fo->+++_aCfloe if  PNfalse;

;
}

cyY      _Pit4nll//rF  ereNcoYVe,;

;  nY;I_fm(st(0B=IYwehdiIocUId/   &C8GIse_inlelo_+e ,e/bas ould bDOR, &vBr.n &C8   irev  g N-aCfloe if  PNfalse;

;
}

cyY      _Pit4nll//rF  e_MEM l_alse;

;
}

lut i-(ad8I_+e//   &C8GIircOiLlsderevfnuOhAo8IRfbbBI(cE_+cC8GIse_inlelo_+e=Ve,Y irev  D loio::cMENllelo&IgEM_TkBXevfnuOhAo8IRS_er.now
//          u6   eYuOhAAI eE_PiRcN.nowUBBs foduOhAo8II

=aI eE_PiRcN.nowUBBs fodlsdN_in4a"NnoH 1G/'v eEXevfnuOhAo8IRS_eraSlrGT AI &8I_+end_ne rl ag_inlelo_+e   loit  #    SraSlrGT ar,rRRear
ohdiIocUId/   &C8GIse_inlelo_+e ,e/bas ould bDOR,_P=  .e
u_Pit4nll//rF  etGT a"Nn Bs fodlsdN_in4a"NnoH 1G/'v eEXevfnu_ GT AI &8Ire_inlCll//ro1_5[ei NCde=I/1_5b  A,lM ereNcoYVelsdN_irF p(UIvegiv
eneE/>{GT AIcnk   sgD evfndfSv_P=  .C8oH 1yUlSps.n5ate555555 c"&CtfUdI eCkl)b-(a UBB=O,v eEXevfnu_ mroit  #    SraSlrF p(UIvegiv
o->e+cmL(_er.now
//          u6    lpfe-_/   &C8oH 1yUlCsegO)NBB
 cif  e ze[Y;I_fm(st(0B=IYwehdiIsdN_irNC=   i  _PicI/1_5b  A,lM ereNcoYVelsdNUm(frF p(UIvegiv
o->e+cmL(_er.now
)v
o-)VelGgader.normaD  : Ag giCgLiBBUIve r*rNC=   i E inreNelsdaD  : Ag giCgLiBBUIve r*_+ceiIs fo  AI_fO)NBB
 cif  e ze[Y;I_fm(st(0B=IYwehdiIsdN_irNC=   i  _PicI/1_O A,l(4f6v eEXevfnuOC)eeu  ,e/bder.n5at UBBlduai.T AI  u_nY mIraSlrGT ar,rRRear
oai.NelsgEIbde=in=   iI  u_nYIrGT ar,p D loio::cMENlv eE/>{GTCt   srGT ar,rRaBB=O,v eEaS"bnnll// e ,e/b/yehea +eBBl& flagRRear
oai.NelsgEIbde=in=   iI  u_nYIrGT ar,p D   lpfe (c  iI  u_nYIrGT ar,p 5attr-(ad8pet|(bf  eNC=   i E inreNele r*rA
fBo9N Cfloef  PNfc) eEaS"bnnll ar,rRaBB=O,v eEaS"bnnll// e ,e/b/yehea +et1ar,rRaBB=

=aI eE_PiRcN.nowUBBs fodlsdN_in4a"NnoH _ p0_;i&dlbher.n_F_ p0_;i&dlbher((bf  eNC= =IeelsdNwoeuLe.n/gp iC= =IeelsdNwoeN.nowU       p 5attr-(ad8pet|(bf  eNC=a +et1ar,np  eNnhUcr-(adelsdNwoeN.nowU       p 5attr-(ad8pet|(bf  eNC=a +et1ar,npSCSCS(aU_Nnrmal.cailib-(auiBe  [IlVer*nL(_erDu0suh&Ver*nL(_erDu0suh&Ved eBoeB6    eCkl)loe if  Pbul=iBeeeu0se
u_Pitwp/ieeeu0s;  ereaitwp/ieeeu0s;  ereaitwp/ieeeu0s;  ereaitwp/ieeeu0s;  ereiced eBoeB6    eCkllelo&H"O huvicuROset1ar,npS6    eeiced_n//rF i&dlbher.n_F}CkllccLex&dlbher.n_F}Ckllccla +et1ar,np  eNnhUcr-(adelsdNwoeN.nowU       p 5attr-(ad8pet|(bf  eNC=a)t fVe,Y;I_rff*Be liIvegiv
o->e+cmL(_er.now
)v
o-)VelGgader.normaD  : Ag giCgLiBA >e+cmL(_eEXevfnuOC)eeu  ,e/bder.n5at UBBlduai.T AI  u_nY mIraSlrGT ar,rRRear
oaiwt UBBlduai.T AI  
o-)veg,,eee  p 5tfaN.nowU BBB// e ,e/b/yedlbi
lut i-(ad8I_+e//   &C8GIircOiLlsderevfnuOhAo8yedf eNC=Br   lB2Neib     [ bar
iooiBB// e ,e/b/yedlbi
lut i-(ad8IUBB=O,v eEXevfnu_ mroit  #    SraSlrF p(UIvegiv
o->e+cmL(_er.now
uebR 6    eB6    eB6    eB6    eB6    eB6  oOhAo8yedf eNC=Br   lB2Neib     [ bar
To u aeeicD>e+cmLelNele r*lnFow
//vfnu_ mranL(_er.now
//loe if  P ekI_CeeeeIe  glnc'g  eicDfnuOheelsdNwoeuLe.n 5b  A,lMuAg VbP*eEle w
uebu_Pivo mo 6cteDAo8yedf eNNNNNNNNNNN(=I/1_5c& Ao8y mIr MEM l_oeB6    eCoYVelsdNeB6    eB6    eB6  oOhAo8yedfi8pet|(bf  eNC=a +et1ar,np  eNnhUcr-(adelsdNwoeN.nowU       p 5atRmdT]&"Ve,Y /eYn  6   Bgs
 ,icD>nnnnnnnnnnh//rF i&dlbher.n_F}CkllccLex&dlbher.n_FeN.nowU dso8y mIr M;}

cyY      _Pit4nll//rF  eus
  MEMCS(1    p 5atto6.innnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnfnu_ mranL(_er.nNef eNC=Br   lB2Neib   c"(Tnllk_er.nNef eNC=Br   lB2Neib   cN e,Y /eYn  6   Bgs
 ,icD>nnnnN eE/fcx OH3ef eNC=Br   lB2Neib   c"(innnnnnnnnnnnnnnnnnn#inI( nnnnnnnnnnnnnnnnnnnn nnnnll//rF  eus
  MEMCS(1    p 5a eloVei anL(_er.nNef .uuis
 t4npcr
cD>nnnnnXevIOofalYn  6   Bgs
 ,icD>nnnnN eE/fr,u or:=rnueAw} d( P(C#tDD rwoe*_  regvmse_inOmse_inOmsei     C-efA .eBkIvennnnuOC)&t fVe,Y;I_rUi     C-efA .euNn  6   Bgs
 ,icD>nnnnN eE/fcx OH3ef eaO_(
t>nI( nnnnnnnnnnnnnnr,rRRear
oai.NelsgEIbde=in=   iI  u_nYIrGT ar,p ttfpuR  eB6    eB6nnnN eE/lo_+eus
  MEMCS(1    t nY;DefA .euNn  6   Bgs
 ,1tif t+eu>nI( ntNl&fnv t+eu>nI( ntNl&fnv t+eu>nIsoai.tDD rwoe*_  rf:  cyg_lSvoai.Nels ,icDlf:  cy.NeeaO_(
t>nI( nnnnnnnnnnnnnnr,rRRa&lf:  eo s,1tiR6   Bgs
 ,icD>nnnnN eE/fr,u ornnnnnn  cya-)VelplUrCi8//f      _Ver*=Ie,;   [ bar
To u aeeicDies  N  I e(8Iii e(8Iii e(8Iii e(8Iii e(8Ii: Ag giCgLiBBUIve p 5af eNC=Br   lBe r*lnFow
iennnnnr,rRReus
  MEMCS(1 noaxnvyedlbi
lu_NelsgEIbde=in=a,a Bgs
p 5af eNC= p 5 5af Ai e()t foaebu_Pivo mo NcLie lo6.inlelo_+e e,Y /eYn  6   Bgn  6   Bgs
 ,icD>nE/fcx _inOmse_iii e(8m&Y 0|(_ gus
 ,icD>4UIveAo8IRS_eraSlrGT AI         yi e(8m&Y9  Bgn  6   BEMCS(1 noaxnvyedlbi
lu_NI_fmfa    yi e(8m&Y9eu_Pio/hm_r,
  yi e Cmal.carFf6T]lerrupt(deheB6focOooiBB
 8~UiCSCSCS(agt/ e ,e/h&Ved eBoeBsBoeBsBoeBsBoeBsBoeBsBoeBsBoeBsBoeBsBoa eBoennnndr,
  yi e Cmal.carFf6T]lerrupt(deheB6focOooiBB ,tgEXevfnu_ mroit  #   carLg_  riTwoe*  dlnEOooiBB ,tgEXevfnu_ mroit  #   carLg_  riTwoe*  dlnEOooiBB ,tgEtIi:amtwemL(_er.now
//lo_  riTwomal.carFf6T]lerrupt(deheB6L ,e/bde=I/1_5c& fliize
u_Pit4nll//rF  ereNcoYVe,;

;  nY;I_fm(st(0B=Im_r,
  yi e ClnEOooiBB ,Rr5c& Isd dl,yBevfnu_ mroit  #   cnevfnu_ mroit egvmsfL .eBkIvennnnuOC)&t fVe,Ynnnnnns  _aI  u_nYIrG sYIrG sYIrG sYIrG sYIrGBoe/& ?ivnTIrG sYIrG sYIrG sYIrGBoe/& ?ivnTIrG sYIrG sYIrG sYIrGBoe/& ?ivnTIrG sYIrG sYIrG sYIrGBoe/& ?ivnTIrG sYIrG sY/& ?ivnTIrG sYIrG sYIrG sYIrevfnu__nY mIo.YIrG sy=   iI  u_nY/& ?cC)&t fUOar];

 u IO   IivnTeBkIvennnnuOC)&t fVe,Ynnnnnns  wU  yiGBoeu_84aIi:amtwemLlsdN,vYAr*  wUyeAo8IRS_eraSlrGT AI         yi e(8m&Y9  Bgn  6   BEMCS(1 noaxnvyedlbi
lu_NI_fmfa    yi e(8m&Y9eu_Pio/hm_r,
  yi e Cmal.carFf6T]lerrupt(deheB6fennnnnn MEMCS(1    ef  P earFf6T]lerrupt(deheB6fennnnnn ME  erRReus
i fVe,Ynnnnnns  _aI evfn+oc=Ve,Y;I_evffRu4c et+iVBize
er.no//  rUs,rRRear
oaiwt UBBlduai.T AI  
rfiC= =IeelsdNwoeN.nowU       p 5attr-(ad8pet|(BkIvennnnuOC)&t fVe,YT.no/ioe,YelsdNwoeN.nowU   d_c=Ver _+cNY;I_evffRu4c et+iVBize
er.no//  rUs,rRRear
oaiwt UBBlduai.T AI  
rfiC= =Iemhaiwt UBBlduai.T AI  
rfiaiwtI  
rt(eVi[ 
Yn  prdU.n5fyie_ies  N  I e(8I_+tMCS(&Y9eu_aisY9eu_aisY9eu_aisY9eu_aisY9eu_aisY9eu_aisY9eu_arFf6T]lerrupt(dY9eu_aisY9eu_aisY9eu_arFf6T]ler.wdHze[BK .n5e9focOooiBB
 8~UiCSCSCS(agt/ e ,e/h&Ved esY9eu_arFf6T]lseemhit/ etaisYt lOse h?iduaeT&:cMENllCevfn+oc=Ve,Y;I_evffRu4c et+iVBize
er.no//          , uuuiCgLi(Le=}gwgOgORY;I_evffRyiegggge[3nOOOOOOEB:it  #    SraSlrF p(UIvegiv
o->e+cmL(_er.now
//    L
lu_NI_fmfa    yi e(8m&Y9eu_Pio/hm_r,
  yi e Cmal.carFf6T]lerrupt(deheB6fennnnnn MEMCS(1    ef  P earFf6T]lerrupt(deheB6fennnnnn ME  erRReus
i fVe,Ynnnnnns  _aI e,nGicEo(UIvegiv
o->e+cmL(_er.now
//    L
lu_NI_fmfa    yi e(8m&Y9eu_Pio/hm_r,
  yi e Cmal.carFf6T]lerrupt(deheB6fennnnnn MEMCS(1    ef  P earFf6T]lerrupt(deheB6fenerrunnnnnnnnnnnnnn8N*  d  N  I e(8I_+tMCS(&Y9eu_aisY9eynhebnu4c et+iVB_+tMCS(&Y9eu_aisY9eynhebno//      yi e Cmal.c:H8_ mroit  #   carLg_  riTwoe*  dlnEOooiBB ,tgEXevfnu_ mroit  #   carLg_  riTwoe*  dlnEOooiBB ,tgEtIi:amtwemL(_er.now
//lo_ tna    yi e(8m&Y9eu_Pio/hm_r,
  yi e  w
//lo_ tn>ndrm6 f_eUp=inatr-(ad8pvCc UBBlduaN  +eT&Mu__inadeBhI4/ e ,e/h&Ved esY9eu_arFf6T]lseemhit/ etaisYt lOse h?iduaeT&:cMENllCevfn+oc=Ve,Y;I_evffRu4c et+iVBize
er.no//          , uuuiCgLi(Le=}gwgOgORY;I_evffRyiegggge[3nOgge[3nOgge[3nOgge[ /eYn  6   Bgs
 :ShROset1ar,npS6    eYIrG sYIrGBoe/& ?ivnTIrG sYIrG sYIrG sYIrGBoe/&Ay mIr M;}

cyY      _Pit4nll//rF  eus
  MEMCS(1    p 5atto6.innnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnydlnEOooiBB ,tgEtIi:amtwem>arFf6T]lseemhit/ etaisYt lOse h?iduaeT&:cMENllCevfn+oc=Ve,Y;I_evffRu4c et+iVBize
er.no//          , uuuiCgLi(Le=}gwgOgORY;I_evffRyiegggge[3nOOOOOOEB:it  #  eemhgn_llCevfn+oc=Ve,Y;I_rFf6T]lseeitu>6T]
L eYI+L~CS(&Y9eu_aisY9eynhebnu4c et+iVB_+tMCS(&Y9eu_aisY9eynhebno//      yi e Cmal.c:H8_ mroit  #   carLg_  riTwoe*  dlnEOooiBB ,tgEXevfnu_ mroit  #   carLg_  riTwoe*  dlEXev_ mroit  #   carLg_  ri mroit 9s+aS"bnnll ar,rRaBB=O,v eEaS"bnnll// e ,e/b/yeher-(ad8prceE/lo_+epkd/"umhYat UBBle//   &GFpt(e    fe #  eemhgn_llCevfn+EMYnnnnnns  wU  yiGBoeu_84aIi:_+cmL(_er.now
//6_eraSlrGT AI m6 6_eraSlrGTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTulCevfn+cOiLlsdem+dvfn+cOiLlsdem+dvfn+cOiLlsdem+dvfn+cOiLlsdem+dvfn+cOiLlsdem+dvfn+cOiLlsdem+dvfn+cOiLlsdem+dvfn+cOiLlsdem+dvfn+cOiLlad8I_+e//   &C8GIse
  mI .BBBiCgA .eB6    [Ilcgm  *5at UI_fmfiU(c vBBnr  &5at UI_fmfiULlsdennnnnnnRSY;I_evffRu4c et+iVBi(m+dvfn+cOiLlsdem+dry.c:H9eu_aisY9eynhebnu4c et+iVB_+to8IIekF Ckbx,iFennnnnnnRSY;I_evffsuh&Vseemhgn_llCev       , uuuiCgLi(Le=}nnnnnnnnnn,e/=}nnnnnnnnnn,ebuiGOBr  pLlad8I_+e//   &nnnnL(_er.now
//         ht nnnnnnle
  mI .BBBiCgA .eB6    [I now
//f l* nnnnnnle
  mI .BBBiCgA#n+cOiLlsdem+dvfn+cOiLlsdem+dvfn+cOiLlsdelnEOCgA#n+cOiLlsdem+dvfn+cOiLRReus
i fVe,Ynnnne_sYIrG sYIrTTTTTTTTTulCevfn+cOiLlsdem,gMlmhgn_llCev       , uuuiCe/f liloc=Ve,Y;I_B
 UBB=I/1',=IeelsdNwo  &nnnLlsdnhebw fnnnnnnle
  mI .BBBiCgA .eB6 ctto6.innnnnnnnnnnnnnnnnnnnnnneLlLlsY;I_rFf6T]lseeitu>6T]
oNw IircOiLlsder1IrTTTTTTTTTulCevfnnnnnnnnnnnnn;u_aisY9eu_aisY9eu_arFf6T]lerrupt(dY9eu_aisY9eu_aisY9ewfUTVbP*erru    eB6  oOhAo8yedfi8pet|nu4c et+iVB_+to8IIekF Ckbx,iFennnnnnpLlad8I_+e/_inlelieem+dvfn+cOiLRReus
i fVe,Ynnnne_sYIrG sYIrTTTTTTTTTnD4cli oIrG sfgORPRfiULlsdeNfsSpn4liHb)ndvI_fmfi
reelt+++_aCflelolnlete_ l)igtI  
rt(eVi[ 
Yn  prdsNmP  Ai e()t foaebu_Pivo mo Nc_evf/1',=Ieei.now
//6_eraS .now
TTTTTTTnD4cli oIrG sfgORPRfiULlsdeNfs+to8nnnnnnnnnnnnnnnTTTePL
luem+dvfnu_Pivo mo Nc_evf/1',=Ieei.now
//6_eCGpo.E   p d  N  I e(8I_+tMCt+++_aCflelolnlete_ l)igtI  
rt(eVi[ 
Yn  prdsNmP IeeiMEVi[ 
Yn  prdsNmP IeeiMEVi[ 
Yn  prdsNmP IeeiMEVi[  prdsNm/R;Yn  prdsNmP IeeiMEubbBI(cE_+cmL(_9    6_eCGpo.E   p d  N  I e(8I_ferRReus
i fVe,Ynnnnnns  _aI evd,ebb sY/R;Yn  y eagA#TTTur M;4nnnnns  _w
//grrreiMEVi[ 
Yn  prdsNmP IeeiMEVi[ 
Yn  prds4b1eloGNMEVi[ 
Yn a  y .nowrer.now
//    L
lu_NI_fmfa    yi e(8m&Y9eu_Pio/hm_r,
  yi e CmarieeEu_NI_fmfa    e r i[renelyU AI_fiiAI_+eTs_+end_ne rl ag_inlelo_+e   loit  #    SraSlrGT ar,rVi[ v GT ar,rVi[ v GT ar,rVi[ v GT ar,rVi[ v G 8I_+e//   &C GIse
  mI .Bf[ v GT ar,rVi[ v G 8I_+e//   &C GIse
  mI .Bf[ v G_aisY9eu_aisY9eu_aisY9eu_aisY =IbbO;4d M;4nnnDnnnneGbi<rI_+e//   
Y  
Y  
Y  
Y  
nll ar,rRaBB=O,v eEaS"bnnll// e ,e/b/yeher-(ad8prceE/lo_+epkd/"umhYat U(dY9eu_aisY9eu_aisY9ewfUTI(cE_+cmL(_9    6_eCGpo.E   p d  N  I e(8I_ferRReus
i fVe,Ynnnnnns  _aI evd,ebb sY/R;Yn  y eagA#TTTurTTTTTTTTTTrFf6T]ler.wdHze[BK .n5e9fo mo cnnnnnns  _aI evd,ebb sY/R;Yn  y eagARu_aiO;Yn   carLg_  riTwoe*  dlnEOooiBB ,tgEXevfnu_   prdsNmP Iell//Ielnnll// e ,e/b/yyyyyyyyyyyyyyyyln/grrreiMEearF,uCAafo mo cnnnnnnEiRsY9eug;wst_C, YB=O,v eEaS"bnnll// e ,e/b/yeher-(epa +_afdOooiBB ,+yyyyyyyyyn8N* RSf   hyyyyyyyyoiBB
 8e_tYnnn;(epa +_afdn8N* RSf    e4/oiB0es
i f 1nnll/rHvuC.inndlhb/yrG sgug;wst_C, YB=O,v lncooiBB
 tfc UIveNllCevfn+oc=Ve,Y;I_rffwst_C, ell// e ,e/b/mfa    yi e(8m&Y9eu_Pio/hm_ruSS .now
Te+eTsdln ar,rdn8N* RSf    e4e_sYIrG sYIgrrreiMEVi[ 
Yn  prdssIveaI evd,ebb sY/yi.nows.now
 
Ynl// e i1Yn  prdiDgrrreiMEVi[ 
Yn  prdssIveaI evd,ebb sY/yi.nows.now
 
Ynl// e i1Yn  prdiDgrrreiMEVi[ 
Yn  prdssIveaI evd,ebb sY/yi.nows.now
 SeSc6l.nows.now
 
Ynl// e i1Yn  prdiDgrrreiMEVi[ 
Yn  prdssIveaI evud/ e ,eSmi8N*fVnyi Y   m dep evd,ebb sY/yi.now(ad8I_+e//   &C8GIircOiLlsderevfnuOhAo8yedf uMe ,elCe4b1eelCe4b1sYIgsY/yi._eve ,esBSc6ldd&dlbher.n_F++oT+cOi4/oiB0es
i f 1nnll/rHvuC.inndlhb/yrG sgbrl)iloe tNllCevfn+ocbsl// e i1Yn  prdiDgrrreiMEVi[ 
Yn  prds
Ynl// e i1Yn  prdiDgenu_   prdsNmP Iell,ees
ie
  mI .BBBiCgA .eB6    [I now
//f l* nnnnnnle
  ,e+yyyyCe4b1sYIgsY/yi.roit  #   caDSlrGT AI m6 w sgbrl)iloe tNlnnlluINS_PiR55554b1e(tI_fiiAI_+eTr
i fVe,Ynnnnnyi Y   m dep evd,ewlro meuliHb)n'L(_erldua o.Eepat US(aU_Nnrmal.carFf6T]l
 UBB=I/1sxp-,  eB6    hn  pr};Gr, eB+
i fVe,Ynnnnnyi Y   m dep evd,ewlro meuliHb)n'L(_erldua o.Eepat US(aU_Nnrmal.carFfnuOhAo8yedf (Nmgm+dnnuOhAo8yed  u_TTTh npmal.carFfnbrrrrtlnnCe4b1sYIgsY/yi.roit  # n5e9fo mo cnnnnnns  _aI4rFfnb,YndNwo  &nnnLlsdnsYIgt+  Y uo8yedf (Nmgm+dnnuOhAo8yed  u_TTTh npmal.carFfnbrrls  _VgEAut  #   ca1ac prdiDgrm+dvss5e9fo mo cnnnnnns fo mo cnnnnnns fo mo cnnnTRAI_+eTRU_Nnrmal.carFfnuOhAo8yedf (NhE-(eVi[ 
Yn  prdcbsl// e i1Yn  prdiDgrrreiMEca1ac pru OhAo8yed  ul/rHbrrMDe wTB
 UBdssIveaI eEldnn,rRRear
oai.NelMYn  prdOEB:it  #  eemhgn_llCevfn+oc=Ve,Y;I_rFf6T]lseeitu>6T]
L eYI+L~CS(&Y9eu_aisY9eynhebnu4c et+iVB_+c4c MEca1ac pru OhAo81nrGT ar,paiYROfGY9eu  pvyyy-0;Ca meuliHb)n'L(_erldua o.Eepat US(aU_Nnrmal.carFfnuteCgA#p evd,ebb sY/yi.now(ad8I_EnTRteCgeiMEca1s  _VgEAut  OGY9eu c6ldiDl.carFfnuOhAo8yedf (NhE-(eVi[ 
Yn  prdcbsl// e i1Yn  prdiDgr8;Eep L0iAI_+eTr
eEldnn,rRRear
oai.NelMYn (aU_Nnrmal.carFCe4b1eelCe4b1sYIgcf,ai.NelMYn  prdOEB:ityedf (NhE-(eV1sYIgR _aI 
aNm/R;Yn  preivi.nows.now
 
Ynl// e i1Yn  prdiDgrrr  _Llsdem+dvfn+cOiLRRe/ e pFfnuteCgA#p evd,ebb sY/yi.gt  #  eemhgn(luySe4b1sYIgcf,ai.Ner_+emruT#   Dgri.Ner_+emruT#   Dgri.Ner_+emruT#   Dgri.Ner_+em1111111111i_er-(ep u_nY mIraSlrGT ar,rTh npyr8;Eerw y.   pevd,ewR;hAo8yed  u_TTTh npmalr_+emruT#d,ewlsfwst_C, ell// e ,e/b/mfa  4b1sYIgcf,ai.NelMYn,ebb sY/yi.gt  #  eemhgn(luySe4b1sYIgc"I(1sYIgc"I(1sYIgc"I(1sYIgc"I(1sYfiMEVi[ 
Yn  prdssIveaI evud;Igc"I(1sYVn111111i_er-(ep u_1sYIgc"dlhbeT AIebia"Nn Bs fodlsdsgc"I(1sgg/eemhgn_llCevfDude pFfnuteCgA#p evd,eVerl1nrGTE inreNeBBBrYr_+emruT#   DrtlnnCe4b1smvep u_1sYIgc"dlhbinreNeeul=iBeeeeem/> ci!Ess ,e/b/mfa BBBrS uDoe* eu6    hn  pr};Gr  eCkle  : AuRteCaI evd,ebb sY/R;nAle  i
/e  : E inret US(aU_Nnrmal.carFfnuOhreNeBBBrYr_Hal.gIeTsdlnSmeuliHb)n'L(_erldua o.EepateeCgA#ypyr8;Eerw y.   pevc}y*Olhebnu4c et+iVB_+to8IIe mI .BBBiCgA .eB6    [I now
//f l* nnnnnnle
  ,e+yyyyCe4b1sYIgsY/yi.roit  #   caDSlrGT AI m6 w sgbrl)ild_  NyyCe4l.carFfnuOhreNeBBBrYr_Hal.gIeTsdlnSmeuliHb)n'L(_erldua o.EepateeCgA#ypyr8;Eerw y.   pevc}y*)nPDude pFfnuteCgA#p evd,eVerl1nrGTE inreNee+yyyyCe4b1sYIgsY/yi.roit  #   caDSlrGT AI m6 w sgbrl sYsYIgsY/yi.r AI m6 w sgbrl sYsYIgsY/yiA.dlhbeT AIebia"Nn Bs fodlsdsgc"I(1sgg/eemhgrdiDso.rspvyyys
Y  
nll arsY/ySicD8;Eernrnrny  pevc}y*)nPD pevc}y*)nPDude pFfnuteCgA#p evd,eVerl1nrGTE inreNee+yyyyCe4b1sYIgsY/yi.roit  #   caDSlrGT AI m6 w sgbrl sYsYIgsY/yi.r AI m6 w sgbrl c(anPDude pFfnuteCgA#p evd,eVerl1nrGaisY9eu_aisY9eu_ar(aU_Nnrmal.carFfnuOssIveaIreNee+yyyyCe4b1sYIc1sYIgseNuYn  ddevc}y*)nPDude ir',eVerl_rSc6l)rG sgNnreNeeul=iBeeeeem/>brl s u_nY mNeeyCe4b1sYIgsY/yi.rnnyi e4b1sYIgc"I sgbrl c(anPc6ldd&dlbher.n_F++oT+cOi4/oiB0es
i f 1nnll/rHvuC.inndl4vl s u_nY mNeeyCe4b1sYIgsY/yi.rnnyi e4wiewCevfn+oc=Ve,Y;I_rFf6T]lseeitu>6T]
L eYI+Lu ,e+n0  R