#ifndef CYGONCE_HAL_PLATFORM_INTS_H
#define CYGONCE_HAL_PLATFORM_INTS_H
//==========================================================================
//
//      hal_platform_ints.h
//
//      HAL Interrupt and clock support
//
//==========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    Eric Miniere 
// Contributors: Eric Miniere 
// Modification : adaptation to EVMCAN 
// Date:         2001-09-00
// Purpose:      Define Interrupt support
// Description:  The interrupt details for the EVMCAN/EASYCAN3 are defined here.
// Usage:
//               #include <cyg/hal/hal_platform_ints.h>
//               ...
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

#define CYGNUM_HAL_INTERRUPT_FIQ            0
#define CYGNUM_HAL_INTERRUPT_SWIRQ0         1
#define CYGNUM_HAL_INTERRUPT_WD             2
#define CYGNUM_HAL_INTERRUPT_WT             3
#define CYGNUM_HAL_INTERRUPT_USART0         4
#define CYGNUM_HAL_INTERRUPT_USART1         5 
#define CYGNUM_HAL_INTERRUPT_USART2         6
#define CYGNUM_HAL_INTERRUPT_SPI            7
#define CYGNUM_HAL_INTERRUPT_CAN1           8
#define CYGNUM_HAL_INTERRUPT_CAN2           9
#define CYGNUM_HAL_INTERRUPT_ADC0           8
#define CYGNUM_HAL_INTERRUPT_ADC1           9
#define CYGNUM_HAL_INTERRUPT_GPT0CH0        12
#define CYGNUM_HAL_INTERRUPT_GPT0CH1        13
#define CYGNUM_HAL_INTERRUPT_GPT0CH2        14
#define CYGNUM_HAL_INTERRUPT_GPT1CH0        15
#define CYGNUM_HAL_INTERRUPT_PWM            16
#define CYGNUM_HAL_INTERRUPT_SWIRQ1         17
#define CYGNUM_HAL_INTERRUPT_SWIRQ2         18
#define CYGNUM_HAL_INTERRUPT_SWIRQ3         19
#define CYGNUM_HAL_INTERRUPT_CAN0           20
#define CYGNUM_HAL_INTERRUPT_PIOA           21
#define CYGNUM_HAL_INTERRUPT_CAPT0          22
#define CYGNUM_HAL_INTERRUPT_CAPT1          23
#define CYGNUM_HAL_INTERRUPT_ST0            24
#define CYGNUM_HAL_INTERRUPT_ST1            25
#define CYGNUM_HAL_INTERRUPT_SWIRQ4         26
#define CYGNUM_HAL_INTERRUPT_SWIRQ5         27
#define CYGNUM_HAL_INTERRUPT_IRQ_0          28
#define CYGNUM_HAL_INTERRUPT_IRQ_1          29
#define CYGNUM_HAL_INTERRUPT_SWIRQ6         30
#define CYGNUM_HAL_INTERRUPT_SWIRQ7         31


#define CYGNUM_HAL_ISR_MIN    0
#define CYGNUM_HAL_ISR_MAX    31
#define CYGNUM_HAL_ISR_COUNT  32

// The vector used by the Real time clock
#define CYGNUM_HAL_INTERRUPT_RTC                  CYGNUM_HAL_INTERRUPT_GPT0CH0

#endif // CYGONCE_HAL_PLATFORM_INTS_H
