/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtInitialize()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xatom.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
char *args11[] = {
	"-background", "green",
	"-bd", "green",
	"-bg", "green",
	"-borderwidth", "3",
	"-bordercolor", "red",
	"-bw", "3",
	"-fg", "green",
	"-font", XtDefaultFont,
	"-fn", XtDefaultFont,
	"-foreground", "blue",
	"-geometry", "100x100",
	"-iconic", 
	"-reverse",
	"-rv",
	"+rv",
	"-selectionTimeout", "50",
	"-synchronous",
	"+synchronous",
	"-title", "ApTest",
	"-xnlLanguage", "C",
	NULL};


typedef struct _instance_variables {
        long foreground;
        String label;
} instance_variable_rec;

static XtResource resources[] = {
        {
        XtNforeground,
        XtCForeground,
        XtRPixel, sizeof(Pixel),
        XtOffsetOf(instance_variable_rec, foreground),
        XtRString, "XtDefaultForeground"
        },
        {
        XtNlabel,
        XtCLabel,
        XtRString, sizeof(String),
        XtOffsetOf(instance_variable_rec, label),
        XtRString, "very bad idea"
        },
};


#define T_XtInitialize	1
char    *TestName = "XtInitialize";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtInitialize-1.(A)");
	report_assertion("A call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("initialize the Intrinsics internals, open a display, create");
	report_assertion("a top-level shell widget that is the root of a widget tree,");
	report_assertion("and return the shell widget instance.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argcount,
		(String *)NULL
		);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("main", name_good, "Application Name");
	check_str("TInitialize", class_good, "Application Class");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t002(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext;
Display *display;
int queued_events, events;
int argc = 2;
pid_t pid2;
int	pstatus;
    /*
    ** -synchronous on
    ** +synchronous off
    */
char *argv[] = { "tinitlize", "-synchronous", NULL };
Widget widget_good;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtInitialize-2.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("create a resource database for the display opened.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argc,
		argv
		);
	display = XtDisplay(widget_good);
	tet_infoline("PREP: Create a window for events");
	scr = DefaultScreen(display);
	window = XCreateWindow(display, RootWindow(display, scr),
	       0, 0, 5, 5, 0, /* x,y,wid,ht,brd width */
	       DefaultDepth(display, scr),
	       InputOutput,
	       DefaultVisual(display, scr),
	       (XtValueMask) 0,
	       (XSetWindowAttributes *) 0);
	tet_infoline("TEST: Check Xlib is in synchronous mode");
	queued_events = XQLength(display);
	XSelectInput(display, window,
	     (unsigned long)PropertyChangeMask);
	for (events = 0; events < 3; events++)
		XChangeProperty(display, window, XA_RESOURCE_MANAGER,
			XA_STRING, 8,0, (unsigned char *)property_data, 16);
	check_dec(3+queued_events, XQLength(display), "queue length");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t003(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
Boolean status;
pid_t pid2;
int	pstatus;
int     argc_count;
char    **argv_string;
int     count = 3;
char    *argvals[4];
char    *display_name;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtInitialize-3.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the -display option is specified in argv shall use this");
	report_assertion("value as the display to be opened and initialized.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	tet_infoline("PREP: Set arguments to include -display");
	argvals[0] = "tinitlize";
        argvals[1] = "-display";
        argvals[2] = (char *)config.display;
        argvals[3] = (char *)NULL;
        argc_count = count;
        argv_string = &argvals[0];
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argc_count,
		argv_string
		);
	display_good = XtDisplay(widget_good);
	tet_infoline("TEST: Display name is correct");
        display_name = XDisplayString(display_good);
        check_str(config.display, display_name, "Display name");

	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t004(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
char    *display_name;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtInitialize-4.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the -display option is not specified in argv and the DISPLAY");
	report_assertion("environment variable is set shall use this value as the");
	report_assertion("display to be opened and initialized.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	tet_infoline("PREP: Set DISPLAY");
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argcount,
		(String *)NULL
		);
	tet_infoline("TEST: Display name is correct");
	display_good = XtDisplay(widget_good);
        display_name = XDisplayString(display_good);
        check_str(config.display, display_name, "Display name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t005(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
int     argc_count;
char    **argv_string;
int     count = 3;
char    *argvals[4];
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtInitialize-5.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the -name option is specified in argv shall use this value");
	report_assertion("as the application name to query the server and screen");
	report_assertion("resource databases for the name.xnlLanguage resource to");
	report_assertion("create the resource database for the display.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	argvals[0] = "tinitlize";
        argvals[1] = "-name";
        argvals[2] = "testname";
        argvals[3] = (char *)NULL;
        argc_count = count;
        argv_string = &argvals[0];
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argc_count,
		argv_string
		);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("testname", name_good, "Application Name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t006(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int pstatus;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtInitialize-6.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the -name option is not specified in argv and the");
	report_assertion("environment variable RESOURCE_NAME is set shall use this");
	report_assertion("value as the application name to query the server and screen");
	report_assertion("resource databases for the name.xnlLanguage resource to");
	report_assertion("create the resource database for the display.");
	FORK(pid);
	initconfig();

	FORK(pid2);
        tet_infoline("PREP: Set up env variable RESOURCE_NAME");
        putenv("RESOURCE_NAME=testname2");
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argcount,
		NULL
		);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("testname2", name_good, "Application Name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t007(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
int     argc_count;
char    **argv_string;
int     count = 1;
char    *argvals[4];
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtInitialize-7.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the -name option is not specified in argv, the environment");
	report_assertion("variable RESOURCE_NAME is not set, and argv[0] is not an");
	report_assertion("empty string shall use this value as the application name to");
	report_assertion("query the server and screen resource databases for the");
	report_assertion("name.xnlLanguage resource to create the resource database");
	report_assertion("for the display.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	argvals[0] = "testname3";
        argvals[1] = (char *)NULL;
        argc_count = count;
        argv_string = &argvals[0];
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argc_count,
		argv_string
		);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("testname3", name_good, "Application Name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t008(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
int     argc_count;
char    **argv_string;
int     count = 1;
char    *argvals[4];
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtInitialize-8.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the -name option is not specified in argv, the environment");
	report_assertion("variable RESOURCE_NAME is not set, and argv[0] is an empty");
	report_assertion("string shall use the string main as the application name to");
	report_assertion("query the server and screen resource databases for the");
	report_assertion("name.xnlLanguage resource to create the resource database");
	report_assertion("for the display.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	argvals[0] = "testname3";
        argvals[1] = (char *)NULL;
        argc_count = count;
        argv_string = &argvals[0];
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argcount,
		NULL
		);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("main", name_good, "Application Name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t009(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext;
Display *display;
int queued_events, events;
int argc = 2;
pid_t pid2;
int	pstatus;
    /*
    ** -synchronous on
    ** +synchronous off
    */
char *argv[] = { "tinitlize", "-synchronous", NULL };
Widget widget_good;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtInitialize-9.(A)");
	report_assertion("When the synchronize resource is set to True in the");
	report_assertion("resource database created by a successful call to Widget");
	report_assertion("XtInitialize(shell_name, application_class, options,");
	report_assertion("num_options, argc, argv) it shall put Xlib into synchronous");
	report_assertion("mode for this display connection.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argc,
		argv
		);
	display = XtDisplay(widget_good);
	tet_infoline("PREP: Create a window for events");
	scr = DefaultScreen(display);
	window = XCreateWindow(display, RootWindow(display, scr),
	       0, 0, 5, 5, 0, /* x,y,wid,ht,brd width */
	       DefaultDepth(display, scr),
	       InputOutput,
	       DefaultVisual(display, scr),
	       (XtValueMask) 0,
	       (XSetWindowAttributes *) 0);
	tet_infoline("TEST: Check Xlib is in synchronous mode");
	queued_events = XQLength(display);
	XSelectInput(display, window,
	     (unsigned long)PropertyChangeMask);
	for (events = 0; events < 3; events++)
		XChangeProperty(display, window, XA_RESOURCE_MANAGER,
			XA_STRING, 8,0, (unsigned char *)property_data, 16);
	check_dec(3+queued_events, XQLength(display), "queue length");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtInitialize-10.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Widget XtInitialize(shell_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall determine a language");
	report_assertion("string for the display by searching the following sources in");
	report_assertion("the specified order: - the resource database created from");
	report_assertion("the command line. - the resource");
	report_assertion("application_name.xnlLanguage, class");
	report_assertion("application_class.XnlLanguage in the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("if it exists, or in the user preference resource file");
	report_assertion("otherwise. - the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtInitialize-11.(D)");
	report_assertion("If the implementation is X11R5 or later and is POSIX-based:");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("use the LANG environment variable as the environment value");
	report_assertion("to search when determining the language string for the");
	report_assertion("display.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtInitialize-12.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Widget XtInitialize(shell_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall set the language");
	report_assertion("string for the display to the empty string if the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("exists, and a language string is not found on the command");
	report_assertion("line, in this property, or in the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtInitialize-13.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Widget XtInitialize(shell_name, application_class,");
	report_assertion("options, num_options, argc, argv) shall set the language");
	report_assertion("string for the display to the empty string if the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("does not exist and a language string is not found on the");
	report_assertion("command line, in the user preference resource file, or in");
	report_assertion("the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtInitialize-14.(B)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("associate with the default screen of the display a resource");
	report_assertion("database created by combining entries from the following");
	report_assertion("sources, in order, with the first named source having the");
	report_assertion("highest precedence: - the application command line - the");
	report_assertion("user's environment resource file - per-screen resource");
	report_assertion("specifications from the server, as returned by");
	report_assertion("XScreenResourceString() - per display resource");
	report_assertion("specifications from the server (the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen");
	report_assertion("zero) if they exist, otherwise the user preference file -");
	report_assertion("the application-specific user resource file. - the");
	report_assertion("application-specific class resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

static void t015(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 20;
instance_variable_rec base;
pid_t pid2;
Widget widget_good;
XtAppContext app_ctext_return;
pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtInitialize-15.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("recognize options specified on the command line that are in");
	report_assertion("the standard table of options in section 4.4 of the");
	report_assertion("specification or in the table specific to the application");
	report_assertion("specified by options and num_options.");
	FORK(pid);
	initconfig();

        FORK(pid2);
	tet_infoline("PREP: Set DISPLAY");
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argcount,
		args11
		);
        tet_infoline("TEST: Retrieve resource values from resource database");
        XtGetApplicationResources(widget_good,
                        &base,
                        resources,
                        1,
                        (ArgList)NULL,
                        (Cardinal)0);
        LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

static void t016(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext;
Display *display;
int queued_events, events;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
int argc = 2;
char *argv[] = { "tdsplyintl2", "+rv", NULL };
Screen *screen;
Colormap colormap;
pid_t pid2;
Pixel res;
Boolean status;
XtAppContext app_ctext_return;
Widget widget_good;
pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtInitialize-16.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the reverseVideo resource is define as True on the command");
	report_assertion("line shall use the value of XtDefaultForeground instead of");
	report_assertion("XtDefaultBackground and vice versa in the resource database");
	report_assertion("created for the display.");
	FORK(pid);
	initconfig();

        FORK(pid2);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize and application with +rv in args");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argc,
		argv
		);
	display = XtDisplay(widget_good);
	tet_infoline("PREP: Set up required conversion args");
        screen = DefaultScreenOfDisplay(display);
        args[0].addr = (XtPointer )&screen;
        args[0].size = sizeof(Screen*);
        colormap = DefaultColormapOfScreen(screen);
        args[1].addr = (XtPointer) &colormap;
        args[1].size = sizeof(Colormap);
        num_args = 2;
        tet_infoline("TEST: Convert XtDefaultForeground");
        fromVal.addr = XtDefaultForeground;
        fromVal.size = strlen(XtDefaultForeground)+1;
        toVal.addr = (XtPointer) &res;
        toVal.size = sizeof(Pixel);
        status = XtCvtStringToPixel(display,
                        &args[0],
                        &num_args,
                        &fromVal,
                        &toVal,
                        &closure_ret);
        check_dec(True, status, "XtCvtStringToPixel return value");
        tet_infoline("TEST: Conversion result");
        check_dec(XBlackPixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
        tet_infoline("TEST: Convert XtDefaultBackground");
        fromVal.addr = XtDefaultBackground;
        fromVal.size = strlen(XtDefaultBackground)+1;
        toVal.addr = (XtPointer) &res;
        toVal.size = sizeof(Pixel);
        status = XtCvtStringToPixel(display,
                        &args[0],
                        &num_args,
                        &fromVal,
                        &toVal,
                        &closure_ret);
        check_dec(True, status, "XtCvtStringToPixel return value");
        tet_infoline("TEST: Conversion result");
        check_dec(XWhitePixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t017(){

pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtInitialize-17.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtInitialize(shell_name, application_class, options,");
	report_assertion("num_options, argc, argv) when the environment variable");
	report_assertion("XENVIRONMENT exists shall use the value of this variable as");
	report_assertion("the name of the user environment resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t018(){

pid_t	pid;

 	report_purpose(18);

	report_assertion("Assertion XtInitialize-18.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtInitialize(shell_name, application_class, options,");
	report_assertion("num_options, argc, argv) when the environment variable");
	report_assertion("XENVIRONMENT does not exist shall use the file.Xdefaults-host,");
	report_assertion("where host is the name of the system running the");
	report_assertion("application, in the user's home directory as the user");
	report_assertion("environment resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t019(){

pid_t	pid;

 	report_purpose(19);

	report_assertion("Assertion XtInitialize-19.(B)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("set the values from the higher precedence sources of the");
	report_assertion("resource database being created for the display as the");
	report_assertion("current resource database before determining the file name");
	report_assertion("for the application-specific user resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t020(){

pid_t	pid;

 	report_purpose(20);

	report_assertion("Assertion XtInitialize-20.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtInitialize(shell_name, application_class, options,");
	report_assertion("num_options, argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) with the value of this variable as path as");
	report_assertion("the name of the application-specific user resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t021(){

pid_t	pid;

 	report_purpose(21);

	report_assertion("Assertion XtInitialize-21.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtInitialize(shell_name, application_class, options,");
	report_assertion("num_options, argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is not defined and the environment");
	report_assertion("variable XAPPLRESDIR is not defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) as the name of the application-specific user");
	report_assertion("resource file where path contains at least entries");
	report_assertion("containing $HOME as the directory prefix plus the following");
	report_assertion("substitutions, in the order specified: - %C, %N, %L or %C,");
	report_assertion("%N, %l, %t, %c - %C, %N, %l - %C, %N - %N, %L or %N, %l, %t,");
	report_assertion("%c - %N, %l - %N");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t022(){

pid_t	pid;

 	report_purpose(22);

	report_assertion("Assertion XtInitialize-22.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtInitialize(shell_name, application_class, options,");
	report_assertion("num_options, argc, argv) when the environment variable");
	report_assertion("XUSERFILESEARCHPATH is not defined and the environment");
	report_assertion("variable XAPPLRESDIR is defined shall use the result of");
	report_assertion("calling XtResolvePathname(display, path, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) as the name of the application-specific user");
	report_assertion("resource file where path contains at least entries");
	report_assertion("containing the following directory prefixes and");
	report_assertion("substitutions, in the order specified: - $XPPLRESDIR with");
	report_assertion("%C, %N, %L or %C, %N, %l, %t, %c - $XPPLRESDIR with %C, %N,");
	report_assertion("%l - $XPPLRESDIR with %C, %N - $XPPLRESDIR with %N, %L or");
	report_assertion("%N, %l, %t, %c - $XPPLRESDIR with %N, %l - $XPPLRESDIR with");
	report_assertion("%N - $HOME with %N");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t023(){

pid_t	pid;

 	report_purpose(23);

	report_assertion("Assertion XtInitialize-23.(B)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("use the result of calling XtResolvePathname(display,");
	report_assertion("app-defaults, NULL, NULL, NULL, NULL, 0, NULL) as the name");
	report_assertion("of the application-specific class resource file, with the");
	report_assertion("values from the higher precedence sources of the resource");
	report_assertion("database being created for the display set as the current");
	report_assertion("resource database before the call is made.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t024(){

pid_t	pid;

 	report_purpose(24);

	report_assertion("Assertion XtInitialize-24.(B)");
	report_assertion("On a successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) the");
	report_assertion("shell widget instance created shall have WM_COMMAND property");
	report_assertion("set from the values of the XtNargv and XtNargc resources.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

static void t025(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
pid_t	pid;

 	report_purpose(25);

	report_assertion("Assertion XtInitialize-25.(A)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) shall");
	report_assertion("name the shell widget instance with the name shell_name.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	sleep(config.reset_delay);
	widget_good = XtInitialize("TestInitialize",
		"TInitialize",
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,
		&argcount,
		(String *)NULL
		);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("main", name_good, "Application Name");
	check_str("TInitialize", class_good, "Application Class");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.248332 */
/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t026(){

pid_t	pid;

 	report_purpose(26);

	report_assertion("Assertion XtInitialize-26.(B)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the resource database of the default screen for display");
	report_assertion("specifies the resource name.screen, class");
	report_assertion("application_class.screen shall create the resource database");
	report_assertion("for the shell widget using the resource values from the");
	report_assertion("resource database of the screen specified in the resource");
	report_assertion("database of the default screen.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* Including from file Mdefcode.tmc.248332 */
static void t027(){

pid_t	pid;

 	report_purpose(27);

	report_assertion("Assertion XtInitialize-27.(B)");
	report_assertion("A successful call to Widget XtInitialize(shell_name,");
	report_assertion("application_class, options, num_options, argc, argv) when");
	report_assertion("the resource database of the default screen for display does");
	report_assertion("not specify the resource name.screen, class");
	report_assertion("application_class.screen shall create the resource database");
	report_assertion("for the shell widget using the resource values from the");
	report_assertion("resource database of the default screen.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.248332 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
