/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtMenuPopup()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/ShellP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
ShellWidget menuw;
Widget labelw_good;
Widget pushb_good, rowcolw_good;

/*timeout callback*/
void XtTI1_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is popped-up");
	if (menuw->shell.popped_up == False) {
		tet_infoline("ERROR: Shell is not popped up");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Grab is exclusive");
	if (menuw->shell.grab_kind != XtGrabExclusive) {
		sprintf(ebuf, "ERROR: Expected XtGrabExclusive(%d), grab type = %d", XtGrabExclusive, menuw->shell.grab_kind);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}
/*timeout callback*/
void XtTI1a_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is popped-up");
	if (menuw->shell.popped_up == False) {
		tet_infoline("ERROR: Shell is not popped up");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Grab is non-exclusive");
	if (menuw->shell.grab_kind != XtGrabNonexclusive) {
		sprintf(ebuf, "ERROR: Expected XtGrabNonexclusive(%d), grab type = %d", XtGrabNonexclusive, menuw->shell.grab_kind);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}
/*timeout callback*/
void XtTI2_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
        tet_infoline("TESTING: Shell is popped-up");
        if (menuw->shell.popped_up == False) {
                tet_infoline("ERROR: Shell is not popped up");
                tet_result(TET_FAIL);
        }
        tet_infoline("TESTING: Grab is exclusive");
        if (menuw->shell.grab_kind != XtGrabExclusive) {
                sprintf(ebuf, "ERROR: Expected XtGrabExclusive(%d), grab type = %d", XtGrabExclusive, menuw->shell.grab_kind);
		tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	exit(0);
}
/*timeout callback*/
void XtTI8_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is popped-up");
	if (menuw->shell.popped_up == False) {
		tet_infoline("ERROR: Shell is not popped up");
		tet_result(TET_FAIL);
	}
	exit(0);
}
/*timeout callback*/
void XtTI9a_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is not spring loaded");
	if (menuw->shell.spring_loaded != False) {
		tet_infoline("ERROR: Shell is spring loaded");
		tet_result(TET_FAIL);
	}
	exit(0);
}
/*timeout callback*/
void XtTI9b_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is spring loaded");
	if (menuw->shell.spring_loaded = False) {
		tet_infoline("ERROR: Shell is not spring loaded");
		tet_result(TET_FAIL);
	}
	exit(0);
}
void XtCB2_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(1,1);
	exit(0);
}
/*timeout callback*/
void XtTI3_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}
void XtWMH3_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(2,1);
}
void XtCB3_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(1,1);
	exit(0);
}
void XtCB7_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	tet_infoline("TEST: call_data passed to callback");
	if (*(XtGrabKind *)call_data != XtGrabNonexclusive) {
		sprintf(ebuf, "ERROR: Expected call_data to be XtGrabNonexclusive (%d), is %d", XtGrabNonexclusive, *(XtGrabKind *)call_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	avs_set_event(1,1);
}
void XtCB8_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(2,1);
	tet_infoline("TEST: call_data passed to callback");
	if (*(XtGrabKind *)call_data != XtGrabNonexclusive) {
		sprintf(ebuf, "ERROR: Expected call_data to be XtGrabNonexclusive (%d), is %d", XtGrabNonexclusive, *(XtGrabKind *)call_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
void XtCB7e_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	tet_infoline("TEST: call_data passed to callback");
	if (*(XtGrabKind *)call_data != XtGrabExclusive) {
		sprintf(ebuf, "ERROR: Expected call_data to be XtGrabExclusive (%d), is %d", XtGrabExclusive, *(XtGrabKind *)call_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	avs_set_event(1,1);
}
void XtCB8e_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(2,1);
	tet_infoline("TEST: call_data passed to callback");
	if (*(XtGrabKind *)call_data != XtGrabExclusive) {
		sprintf(ebuf, "ERROR: Expected call_data to be XtGrabExclusive (%d), is %d", XtGrabExclusive, *(XtGrabKind *)call_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
/*timeout callback*/
void XtTIe_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}
/*timeout callback*/
void XtTI4_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
        tet_infoline("TESTING: Shell is popped-up");
        if (menuw->shell.popped_up == False) {
                tet_infoline("ERROR: Shell is not popped up");
                tet_result(TET_FAIL);
        }
        tet_infoline("TESTING: Grab is exclusive");
        if (menuw->shell.grab_kind != XtGrabExclusive) {
                sprintf(ebuf, "ERROR: Expected XtGrabExclusive(%d), grab type = %d", XtGrabExclusive, menuw->shell.grab_kind);
		tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	exit(0);
}
/*popup's parent's event handler*/
void XtEV4a_Proc(w, client_data, event, contin)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *contin;
{
	if (event->type == KeyPress) {
        	tet_infoline("ERROR: Events were dispatched to non-modal widget");
        	tet_result(TET_FAIL);
	}
}
/*popup's event handler*/
void XtEV4b_proc(w, client_data, event, contin)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *contin;
{
        avs_set_event(2, avs_get_event(2)+1);
}

void XtCB4_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(1,1);
        tet_infoline("PREP: Create event handler for popup");
        XtAddEventHandler((Widget)menuw, KeyPressMask, False, &XtEV4b_proc, NULL);
	tet_infoline("PREP: Send KeyPress event to the popup's parent - should go to popup");
	send_event(labelw_good, KeyPress, KeyPressMask, TRUE);
}
/*timeout callback*/
void XtTI5_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is popped-up");
	if (menuw->shell.popped_up == False) {
		tet_infoline("ERROR: Shell is not popped up");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Grab is non-exclusive");
	if (menuw->shell.grab_kind != XtGrabNonexclusive) {
		sprintf(ebuf, "ERROR: Expected XtGrabNonexclusive(%d), grab type = %d", XtGrabNonexclusive, menuw->shell.grab_kind);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}
/*timeout callback*/
void XtTI6_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is popped-up");
	if (menuw->shell.popped_up == False) {
		tet_infoline("ERROR: Shell is not popped up");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Grab is nonexclusive");
	if (menuw->shell.grab_kind != XtGrabNonexclusive) {
		sprintf(ebuf, "ERROR: Expected XtGrabNonexclusive(%d), grab type = %d", XtGrabNonexclusive, menuw->shell.grab_kind);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}
/*boxw2's event handler*/
void XtEV6a_Proc(w, client_data, event, contin)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *contin;
{
	tet_infoline("ERROR: Events were dispatched to non-modal widget");
	tet_result(TET_FAIL);
}
/*popup's parent's event handler*/
void XtEV6b_Proc(w, client_data, event, contin)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *contin;
{
	if (event->type == ButtonPress)
		avs_set_event(2,1);
}
/*popup's event handler*/
void XtEV6c_Proc(w, client_data, event, contin)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *contin;
{
	if (event->type == ButtonPress)
		avs_set_event(3,1);
}
/*timeout callback*/
void XtTI7_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is not popped-up");
	if (menuw->shell.popped_up == True) {
		tet_infoline("ERROR: Shell is popped up");
		tet_result(TET_FAIL);
	}
	exit(0);
}

void XtWMH7_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(2,1);
}
void cpc_proc(w)
Widget w;
{
	avs_set_event(2, 1);
	tet_infoline("TEST: create_popup_child_proc argument");
	if (w != (Widget)menuw) {
		sprintf(ebuf, "ERROR: expected argument to point to popup, is %p", w);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}


#define T_XtMenuPopup	1
char    *TestName = "XtMenuPopup";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtMenuPopup-1.(A)");
	report_assertion("A successful invocation of void XtMenuPopup(shell_name)");
	report_assertion("when the widget specified by shell_name is among the pop-up");
	report_assertion("children of the widget in which the call is invoked shall");
	report_assertion("map the window of the pop-up widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup1", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	labelw_good = (Widget) CreateLabelWidget("ApTest", boxw1);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw", overrideShellWidgetClass,
				labelw_good, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget( "Hello", rowcolw_good);
	tet_infoline("PREP: Add translation into popup's parent");
	translations = XtParseTranslationTable(trans_good);
	XtOverrideTranslations(labelw_good, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI1_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to popup's parent");
	send_event(labelw_good, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t002(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtMenuPopup-2.(A)");
	report_assertion("A successful invocation of void XtMenuPopup(shell_name)");
	report_assertion("when the widget specified by shell_name is not among the");
	report_assertion("pop-up children of the widget in which the call is invoked");
	report_assertion("but is a pop-child of an ancestor widget shall traverse the");
	report_assertion("parent chain till it finds the pop-up child with the");
	report_assertion("specified name and map the window of the pop-up child");
	report_assertion("widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI2_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to popup's parent's child");
	send_event(test2_w, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t003(){

pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtMenuPopup-3.(A)");
	report_assertion("An invocation of void XtMenuPopup(shell_name) when the");
	report_assertion("widget specified by shell_name is neither among the pop-up");
	report_assertion("children of the widget in which the call is invoked nor is");
	report_assertion("it among the pop-up children of any of the widget ancestors");
	report_assertion("up to and including the top-level shell widget shall issue a");
	report_assertion("warning and return immediately.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup3", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	labelw_good = (Widget) CreateLabelWidget("Test", boxw1);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				labelw_good, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into shell's parent's parent");
	XtOverrideTranslations(boxw1, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI3_Proc, NULL);
	tet_infoline("PREP: Set Warning Message Handler");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH3_Proc);
	tet_infoline("PREP: Add callback to shell for popup");
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB3_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to shell's parent's parent");
	send_event(boxw1, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("TEST: Shell was not popped up");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	status = avs_get_event(1);
	check_dec(0, status, "shell popped up");
	tet_infoline("TEST: Warning message was generated");
	status = avs_get_event(2);
	check_dec(1, status, "warning handler invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t004(){

pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <BtnDown>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtMenuPopup-4.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("ButtonPress event it shall make the widget specified by");
	report_assertion("shell_name modal and add it to the modal cascade if one");
	report_assertion("exists or create a modal cascade starting at this widget");
	report_assertion("when no prior modal cascade exists.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup4", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	labelw_good = (Widget) CreateLabelWidget("Test", boxw1);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				labelw_good, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent");
	XtOverrideTranslations(labelw_good, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI4_Proc, NULL);
	tet_infoline("PREP: Create event handler for popup's parent");
	XtAddEventHandler(labelw_good, ButtonPressMask, False, &XtEV4a_Proc, NULL);
	tet_infoline("PREP: Add callback to shell for popup");
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB4_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to popup's parent to cause popup");
	send_event(labelw_good, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Popup received KeyPress");
	status = avs_get_event(2);
	check_dec(1, status, "events received by popup count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t005(){

String myargvector[] = {"menuw", NULL};
pid_t pid2;
Display *display;
int status = 0;
int i;
XEvent event_good;
XtTranslations translations;
XEvent testevent;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtMenuPopup-5.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a KeyPress");
	report_assertion("event it shall make the widget specified by shell_name modal");
	report_assertion("and add it to the modal cascade if one exists or create a");
	report_assertion("modal cascade starting at this widget when no prior modal");
	report_assertion("cascade exists.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup5", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	labelw_good = (Widget) CreateLabelWidget("Test", boxw1);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw", overrideShellWidgetClass,
				labelw_good, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget( "Hello", rowcolw_good);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI5_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Call action procedure");
	testevent.xkey.window = XtWindow(labelw_good);
	testevent.type = KeyPress;
	XtCallActionProc(labelw_good, "XtMenuPopup", &testevent, myargvector, 1);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t006(){

XEvent event;
int i;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <EnterNotify>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtMenuPopup-6.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("EnterWindow event it shall make the widget specified by");
	report_assertion("shell_name modal and add it to the modal cascade if one");
	report_assertion("exists or create a modal cascade starting at this widget");
	report_assertion("when no prior modal cascade exists.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup6", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	labelw_good = (Widget) CreateLabelWidget("Test", boxw1);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				labelw_good, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent");
	XtOverrideTranslations(labelw_good, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI6_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send EnterNotify event to popup's parent to cause popup");
	send_event(labelw_good, EnterNotify, EnterWindowMask, TRUE);
	for (i = 0; i< 10;) {
	 XtAppNextEvent(app_ctext, &event);
	 XSync(display, False);
		if (event.type == MapNotify) {
		if (event.xmap.window == XtWindow((Widget)menuw)) {
				avs_set_event(1,1);
			tet_infoline("PREP: Make popup's parent modal, exclusive");
			XtAddGrab(labelw_good, True, False);
			tet_infoline("PREP: Create event handler for boxw2");
			XtAddEventHandler(boxw2, ButtonPressMask, False, &XtEV6a_Proc, NULL);
			tet_infoline("PREP: Create event handler for popup's parent");
			XtAddEventHandler(labelw_good, ButtonPressMask, False, &XtEV6b_Proc, NULL);
			tet_infoline("PREP: Create event handler for popup");
			XtAddEventHandler((Widget)menuw, ButtonPressMask, False, &XtEV6c_Proc, NULL);
			tet_infoline("PREP: Send ButtonPress event to the popup's parent - should be dispatched");
			send_event(labelw_good, ButtonPress, ButtonPressMask, TRUE);
			tet_infoline("PREP: Send ButtonPress event to the popup - should be dispatched");
			send_event((Widget)menuw, ButtonPress, ButtonPressMask, TRUE);
			tet_infoline("PREP: Send ButtonPress event to boxw2 - should not be dispatched");
			send_event(boxw2, ButtonPress, ButtonPressMask, TRUE);
		}
	 }
	 XtDispatchEvent(&event);
	} /* end for */
	KROF(pid2);
	status = avs_get_event(1);
	check_dec(1, status, "MapNotify for shell count");
	tet_infoline("TEST: Popup's parent received ButtonPress");
	status = avs_get_event(2);
	check_dec(1, status, "events received by popup's parent count");
	tet_infoline("TEST: Popup received ButtonPress");
	status = avs_get_event(3);
	check_dec(1, status, "events received by popup parent count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t007(){

pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <FocusIn>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtMenuPopup-7.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on an event");
	report_assertion("other than KeyPress, ButtonPress, or EnterWindow, the");
	report_assertion("translation manger shall generate a warning message and");
	report_assertion("ignore the action.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup7", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	labelw_good = (Widget) CreateLabelWidget("Test", boxw1);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				labelw_good, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent");
	XtOverrideTranslations(labelw_good, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI7_Proc, NULL);
	tet_infoline("PREP: Set Warning Message Handler");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH7_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send FocusIn event to popup's parent");
	send_event(labelw_good, FocusIn, FocusChangeMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Warning message was sent");
	status = avs_get_event(2);
	check_dec(1, status, "warning message handler invoked count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t008(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <EnterNotify>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtMenuPopup-8.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("EnterWindow event it shall call the callback procedures on");
	report_assertion("the popup_callback list of the widget specified by");
	report_assertion("shell_name, passing to them a pointer to XtGrabNonexclusive");
	report_assertion("as the call_data argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTIe_Proc, NULL);
	tet_infoline("PREP: Add callbacks to shell for popup");
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB7_Proc, NULL);
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB8_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send EnterNotify event to popup's parent to cause popup");
	send_event(test2_w, EnterNotify, EnterWindowMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Callbacks called");
	status = avs_get_event(1);
	check_dec(1, status, "callback 1 invocation count");
	status = avs_get_event(2);
	check_dec(1, status, "callback 2 invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t009(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <EnterNotify>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtMenuPopup-9.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("EnterWindow event it shall set the popped_up field in the");
	report_assertion("widget instance structure of shell_name to True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI8_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send EnterNotify event to popup's parent to cause popup");
	send_event(test2_w, EnterNotify, EnterWindowMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t010(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <EnterNotify>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtMenuPopup-10.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("EnterWindow event it shall set the spring_loaded field in");
	report_assertion("the widget instance structure of shell_name to False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI9a_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send EnterNotify event to popup's parent to cause popup");
	send_event(test2_w, EnterNotify, EnterWindowMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t011(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <EnterNotify>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtMenuPopup-11.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("EnterWindow event it shall set the grab_kind field in the");
	report_assertion("widget instance structure of shell_name to");
	report_assertion("XtGrabNonExclusive.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI1a_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send EnterNotify event to popup's parent to cause popup");
	send_event(test2_w, EnterNotify, EnterWindowMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t012(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <EnterNotify>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtMenuPopup-12.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("EnterWindow event and the create_popup_child_proc field in");
	report_assertion("the widget instance structure of shell_name is non-NULL it");
	report_assertion("shall call the procedure specified by that field with the");
	report_assertion("popped up shell as the parameter.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTIe_Proc, NULL);
	tet_infoline("PREP: Set create_popup_child_proc value");
	menuw->shell.create_popup_child_proc = cpc_proc;
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send EnterNotify event to popup's parent to cause popup");
	send_event(test2_w, EnterNotify, EnterWindowMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: create_popup_child_proc was called");
	status = avs_get_event(2);
	check_dec(1, status, "count of invokations of create_popup_child_proc procedure");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t013(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <KeyPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtMenuPopup-13.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a KeyPress");
	report_assertion("event it shall call the callback procedures on the");
	report_assertion("popup_callback list of the widget specified by shell_name,");
	report_assertion("passing to them a pointer to XtGrabNonexclusive as the");
	report_assertion("call_data argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTIe_Proc, NULL);
	tet_infoline("PREP: Add callbacks to shell for popup");
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB7_Proc, NULL);
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB8_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyPress event to popup's parent to cause popup");
	send_event(test2_w, KeyPress, KeyPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Callbacks called");
	status = avs_get_event(1);
	check_dec(1, status, "callback 1 invocation count");
	status = avs_get_event(2);
	check_dec(1, status, "callback 2 invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t014(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <KeyPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtMenuPopup-14.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a KeyPress");
	report_assertion("event it shall set the popped_up field in the widget");
	report_assertion("instance structure of shell_name to True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI8_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyPress event to popup's parent to cause popup");
	send_event(test2_w, KeyPress, KeyPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t015(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <KeyPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtMenuPopup-15.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a KeyPress");
	report_assertion("event it shall set the spring_loaded field in the widget");
	report_assertion("instance structure of shell_name to False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI9a_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyPress event to popup's parent to cause popup");
	send_event(test2_w, KeyPress, KeyPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t016(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <KeyPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtMenuPopup-16.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a KeyPress");
	report_assertion("event it shall set the grab_kind field in the widget");
	report_assertion("instance structure of shell_name to XtGrabNonExclusive.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI1a_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyPress event to popup's parent to cause popup");
	send_event(test2_w, KeyPress, KeyPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t017(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <KeyPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtMenuPopup-17.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a KeyPress");
	report_assertion("event and the create_popup_child_proc field in the widget");
	report_assertion("instance structure of shell_name is non-NULL it shall call");
	report_assertion("the procedure specified by that field with the popped-up");
	report_assertion("shell as the parameter.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTIe_Proc, NULL);
	tet_infoline("PREP: Set create_popup_child_proc value");
	menuw->shell.create_popup_child_proc = cpc_proc;
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyPress event to popup's parent to cause popup");
	send_event(test2_w, KeyPress, KeyPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: create_popup_child_proc was called");
	status = avs_get_event(2);
	check_dec(1, status, "count of invokations of create_popup_child_proc procedure");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t018(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <ButtonPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(18);

	report_assertion("Assertion XtMenuPopup-18.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("ButtonPress event it shall call the callback procedures on");
	report_assertion("the popup_callback list of the widget specified by");
	report_assertion("shell_name, passing to them a pointer to XtGrabExclusive as");
	report_assertion("the call_data argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTIe_Proc, NULL);
	tet_infoline("PREP: Add callbacks to shell for popup");
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB7e_Proc, NULL);
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB8e_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to popup's parent to cause popup");
	send_event(test2_w, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Callbacks called");
	status = avs_get_event(1);
	check_dec(1, status, "callback 1 invocation count");
	status = avs_get_event(2);
	check_dec(1, status, "callback 2 invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t019(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <ButtonPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(19);

	report_assertion("Assertion XtMenuPopup-19.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("ButtonPress event it shall set the popped_up field in the");
	report_assertion("widget instance structure of shell_name to True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI8_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to popup's parent to cause popup");
	send_event(test2_w, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t020(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <ButtonPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(20);

	report_assertion("Assertion XtMenuPopup-20.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("ButtonPress event it shall set the spring_loaded field in");
	report_assertion("the widget instance structure of shell_name to True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI9b_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to popup's parent to cause popup");
	send_event(test2_w, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t021(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <ButtonPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(21);

	report_assertion("Assertion XtMenuPopup-21.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("ButtonPress event it shall set the grab_kind field in the");
	report_assertion("widget instance structure of shell_name to XtGrabExclusive.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTI1_Proc, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to popup's parent to cause popup");
	send_event(test2_w, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

static void t022(){

Widget test_w, test2_w;
pid_t pid2;
Display *display;
int status = 0;
XtTranslations translations;
static char trans_good[] = "#replace	\n\
	 <ButtonPress>:	XtMenuPopup(menuw)";
pid_t	pid;

 	report_purpose(22);

	report_assertion("Assertion XtMenuPopup-22.(A)");
	report_assertion("When void XtMenuPopup(shell_name) is invoked on a");
	report_assertion("ButtonPress event and the create_popup_child_proc field in");
	report_assertion("the widget instance structure of shell_name is non-NULL it");
	report_assertion("shall call the procedure specified by that field with the");
	report_assertion("popped-up shell as the parameter.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tmpopup2", "XtMenuPopup");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create a popup shell");
	test_w = (Widget) XtCreateWidget("test", compositeWidgetClass, boxw1, (ArgList)NULL, 0);
	ConfigureDimension(topLevel, test_w);
	test2_w = CreateRowColWidget(test_w);
	ConfigureDimension(topLevel, test2_w);
	menuw = (ShellWidget)XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				test_w, NULL);
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Compile new translation table entry");
	translations = XtParseTranslationTable(trans_good);
	tet_infoline("PREP: Add translation into popup's parent's child");
	XtOverrideTranslations(test2_w, translations);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, &XtTIe_Proc, NULL);
	tet_infoline("PREP: Set create_popup_child_proc value");
	menuw->shell.create_popup_child_proc = cpc_proc;
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event to popup's parent to cause popup");
	send_event(test2_w, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: create_popup_child_proc was called");
	status = avs_get_event(2);
	check_dec(1, status, "count of invokations of create_popup_child_proc procedure");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360672 */
/* End of included file Mdefcode.tmc.360672 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
