/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtManageChildren()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xaw/Label.h>	/* label widget defs */

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtWMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(1,1);
	exit(1);
}



#define T_XtManageChildren	1
char    *TestName = "XtManageChildren";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Boolean status1, status2;
Widget labelw1, labelw2;
Widget children[2];
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtManageChildren-1.(A)");
	report_assertion("A call to void XtManageChildren(children, num_children)");
	report_assertion("shall call the change_managed procedure of the parent of the");
	report_assertion("specified widgets, realize the widgets which have not been");
	report_assertion("realized, and map each previously unmanaged widget window");
	report_assertion("that has the mapped_when_managed field set to True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmngchdrn1", "XtManageChildren");
	tet_infoline("PREP: Create unmanaged widget labelw1");
	labelw1 = XtVaCreateWidget(
			"Hello",	 /* widget name */
			labelWidgetClass,	/* widget class */
			boxw1,		/* parent widget */
			(char *)NULL		/* terminate list */
			);
	tet_infoline("PREP: Create unmanaged widget labelw2");
	labelw2 = XtVaCreateWidget(
			"World",	 /* widget name */
			labelWidgetClass,	/* widget class */
			boxw1,		/* parent widget */
			(char *)NULL		/* terminate list */
			);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add list of children to parent managed widget list");
	children[0] = labelw1;
	children[1] = labelw2;
	XtManageChildren(&children[0], 2);
	tet_infoline("TEST: Child widget labelw1 is managed shall return True");
	status1 = XtIsManaged(labelw1);
	check_dec(True, status1, "XtIsManaged return value");
	tet_infoline("TEST: Child widget labelw2 is managed shall return True");
	status2 = XtIsManaged(labelw2);
	check_dec(True, status2, "XtIsManaged return value");
	tet_infoline("TEST: Child widget labelw1 is realized shall return True");
	status1 = XtIsRealized(labelw1);
	check_dec(True, status1, "XtIsRealized return value");
	tet_infoline("TEST: Child widget labelw2 is realized shall return True");
	status2 = XtIsRealized(labelw2);
	check_dec(True, status2, "XtIsRealized return value");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364564 */
/* End of included file Mdefcode.tmc.364564 */

/* Including from file Mdefcode.tmc.364564 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtManageChildren-2.(B)");
	report_assertion("A call to void XtManageChildren(children, num_children)");
	report_assertion("shall not map the windows of the widgets that have the");
	report_assertion("mapped_when_managed field set to a value other than True.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364564 */

static void t003(){

Boolean status1, status2;
Widget labelw1, labelw2;
Widget children[2];
int invoked;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtManageChildren-3.(A)");
	report_assertion("A call to void XtManageChildren(children, num_children)");
	report_assertion("when the widgets specified by children do not all have the");
	report_assertion("same parent shall issue a warning message.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmngchdrn1", "XtManageChildren");
	tet_infoline("PREP: Create unmanaged widget labelw1");
	labelw1 = XtVaCreateWidget(
			"Hello",	 /* widget name */
			labelWidgetClass,	/* widget class */
			boxw1,		/* parent widget */
			(char *)NULL		/* terminate list */
			);
	tet_infoline("PREP: Create unmanaged widget labelw2");
	labelw2 = XtVaCreateWidget(
			"World",	 /* widget name */
			labelWidgetClass,	/* widget class */
			labelw1,		/* parent widget */
			(char *)NULL		/* terminate list */
			);
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Manage a child and its child");
	children[0] = labelw1;
	children[1] = labelw2;
	XtManageChildren(&children[0], 2);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler was invoked");
	invoked = avs_get_event(1);
	if (!invoked) {
		sprintf(ebuf, "ERROR: Warning handler was not invoked");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364564 */
/* End of included file Mdefcode.tmc.364564 */

static void t004(){

Boolean status1, status2;
Widget labelw_good, labelw_good2;
Widget children[2];
int invoked;
pid_t pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtManageChildren-4.(A)");
	report_assertion("A call to void XtManageChildren(children, num_children)");
	report_assertion("when the parent of the widgets specified by children does");
	report_assertion("not belong to a subclass of compositeWidgetClass shall issue");
	report_assertion("an error.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmngchdrn1", "XtManageChildren");
	XtAppSetErrorMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create test widgets");
	labelw_good = XtVaCreateWidget(
			"labelw_good",
			coreWidgetClass,
			boxw1,
			NULL
			);
	labelw_good2 = XtVaCreateWidget(
			"labelw_good2",
			coreWidgetClass,
			labelw_good,
			NULL
			);
	ConfigureDimension(topLevel, labelw_good);
	ConfigureDimension(topLevel, labelw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Manage a widget with a non-composite parent");
	children[0] = labelw_good2;
	XtManageChildren(&children[0], 1);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Error handler was invoked");
	invoked = avs_get_event(1);
	if (!invoked) {
		sprintf(ebuf, "ERROR: Error handler was not invoked");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364564 */
/* End of included file Mdefcode.tmc.364564 */

/* Including from file Mdefcode.tmc.364564 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtManageChildren-5.(B)");
	report_assertion("A call to void XtManageChildren(children, num_children)");
	report_assertion("when the parent of the widgets specified by children is in");
	report_assertion("the process of being destroyed shall return immediately.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364564 */

/* Including from file Mdefcode.tmc.364564 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtManageChildren-6.(B)");
	report_assertion("On a call to void XtManageChildren(children, num_children)");
	report_assertion("when a widget in the list of widgets specified by children");
	report_assertion("is in the process of being destroyed it shall not be");
	report_assertion("considered for being managed by its parent.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364564 */

/* Including from file Mdefcode.tmc.364564 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtManageChildren-7.(B)");
	report_assertion("On a call to void XtManageChildren(children, num_children)");
	report_assertion("when a widget in the list of widgets specified by children");
	report_assertion("is already managed it shall not be considered for being");
	report_assertion("managed by its parent.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.364564 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
