/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtCreateManagedWidget()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xaw/Label.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtCreateManagedWidget	1
char    *TestName = "XtCreateManagedWidget";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Boolean status;
Widget widget_good , labelw_good;
Widget rowcolw_good;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCreateManagedWidget-1.(A)");
	report_assertion("A call to Widget XtCreateManagedWidget(name, widget_class,");
	report_assertion("parent, args, num_args) shall create an instance of a widget");
	report_assertion("belonging to the class widget_class, set the widget to be");
	report_assertion("managed by its parent, and return a pointer to the newly");
	report_assertion("created widget instance structure.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tcramnwid1", "XtCreateManagedWidget");
	tet_infoline("PREP: Create rowcolw_good widget in box1w widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("TEST: Create label widget Hello");
	labelw_good = XtCreateManagedWidget(
			"Hello",
			labelWidgetClass,
			rowcolw_good,
			(ArgList)NULL,
			(Cardinal)NULL);
	tet_infoline("TEST: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: labelw_good widget is managed");
	status = XtIsManaged(labelw_good);
	check_dec(True, status, "XtIsManaged return value");
	tet_infoline("TEST: labelw_good widget is child of rowcolumn widget");
	widget_good = (Widget)XtParent(labelw_good);
	if (widget_good == NULL) {
	 	sprintf(ebuf, "ERROR: Expected parent widget instance returned NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	check_str("rowcolw", XtName(widget_good), "Widget name");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.365212 */
/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCreateManagedWidget-2.(B)");
	report_assertion("A successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) shall initialize the");
	report_assertion("resource fields of the widget instance using the");
	report_assertion("CoreClassPart resource list specified for widget_class and");
	report_assertion("all superclasses, overridden by the resource values");
	report_assertion("specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCreateManagedWidget-3.(B)");
	report_assertion("When parent is a subclass of constraintWidgetClass a");
	report_assertion("successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) shall initialize the");
	report_assertion("resource fields of the constraint record by using the");
	report_assertion("constraint resource list specified for the parent's class");
	report_assertion("and all superclasses up to constraintWidgetClass, overridden");
	report_assertion("by the resource values specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtCreateManagedWidget-4.(B)");
	report_assertion("When parent is a subclass of compositeWidgetClass a");
	report_assertion("successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) shall call the");
	report_assertion("insert_child procedure of the parent.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtCreateManagedWidget-5.(B)");
	report_assertion("A call to Widget XtCreateManagedWidget(name, widget_class,");
	report_assertion("parent, args, num_args) when widget_class is not a member of");
	report_assertion("coreWidgetClass, the class of parent is a subclass of");
	report_assertion("compositeWidgetClass, and there is no extension record in");
	report_assertion("the composite class part extension field of parent with the");
	report_assertion("record_type equal to NULLQUARK shall issue a fatal error.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtCreateManagedWidget-6.(B)");
	report_assertion("A call to Widget XtCreateManagedWidget(name, widget_class,");
	report_assertion("parent, args, num_args) when widget_class is not a member of");
	report_assertion("coreWidgetClass, the class of parent is a subclass of");
	report_assertion("compositeWidgetClass, and the accepts_object field in");
	report_assertion("parent's composite class part extension record is False");
	report_assertion("shall issue a fatal error.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtCreateManagedWidget-7.(B)");
	report_assertion("A successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) shall invoke the");
	report_assertion("class_initialize procedure for the class widget_class and");
	report_assertion("all superclasses for which this procedure has not been");
	report_assertion("invoked prior to this call in a superclass-to-subclass");
	report_assertion("order.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtCreateManagedWidget-8.(B)");
	report_assertion("A successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) when parent belongs to");
	report_assertion("the class constraintWidgetClass or a subclass thereof shall");
	report_assertion("allocate memory for the constraints of parent and store the");
	report_assertion("address of this memory in the constraints field of the");
	report_assertion("widget instance structure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtCreateManagedWidget-9.(B)");
	report_assertion("A successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) shall initialize the");
	report_assertion("Core non-resource data fields of the widget instance");
	report_assertion("structure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtCreateManagedWidget-10.(B)");
	report_assertion("A successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) shall call the");
	report_assertion("initialize procedure of Object and all the initialize");
	report_assertion("procedures down to initialize procedure of the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtCreateManagedWidget-11.(B)");
	report_assertion("A successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) when parent belongs to");
	report_assertion("the class contraintWidgetClass or a subclass thereof shall");
	report_assertion("call all the ConstraintClassPart initialize procedures");
	report_assertion("starting at constraintWidgetClass down to");
	report_assertion("ConstraintClassPart initialize procedure of the parent.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtCreateManagedWidget-12.(B)");
	report_assertion("A call to Widget XtCreateManagedWidget(name, widget_class,");
	report_assertion("parent, args, num_args) when the newly created widget has");
	report_assertion("the map_when_managed field set to True and parent is");
	report_assertion("realized shall call the change_managed procedure of the");
	report_assertion("parent, realize the widget, and map the widget window.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtCreateManagedWidget-13.(B)");
	report_assertion("On a successful call to Widget XtCreateManagedWidget(name,");
	report_assertion("widget_class, parent, args, num_args) when the newly created");
	report_assertion("widget has the map_when_managed field set to a value other");
	report_assertion("than True shall not have its window mapped.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtCreateManagedWidget-14.(B)");
	report_assertion("A call to Widget XtCreateManagedWidget(name, widget_class,");
	report_assertion("parent, args, num_args) when parent does not belong to a");
	report_assertion("subclass of compositeWidgetClass shall issue an");
	report_assertion("invalidParent error.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* Including from file Mdefcode.tmc.365212 */
static void t015(){

pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtCreateManagedWidget-15.(B)");
	report_assertion("A call to Widget XtCreateManagedWidget(name, widget_class,");
	report_assertion("parent, args, num_args) when parent is in the process of");
	report_assertion("being destroyed shall return immediately.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.365212 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
