/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtCloseDisplay()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
Display	*display_good;

/*
** XtEMH_Proc
*/
void XtEMH_Proc(str, str2, str3, str4, str5, car)
String str, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(2, 1);
	exit(0);
}

/*timeout callback*/
void XtTI_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
        exit(0);
}

/*
** Registered procedure XtEVT_Proc to be invoked
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{

    if (event->type == ButtonPress){
	display_good= XtDisplay(topLevel);
	tet_infoline("PREP: Close the display during a dispatch");
        XtCloseDisplay(display_good);
	tet_infoline("TEST: Display is still good inside handler");
	if (XtDisplay(labelw) == NULL) {
	   	sprintf(ebuf, "ERROR: Expected valid display pointer");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
        avs_set_event(1,1);
        exit(0);
    }
}


#define T_XtCloseDisplay	1
char    *TestName = "XtCloseDisplay";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char	string[10];
Widget	labelw_good , widget_good;
Window	window_good;
pid_t	pid2;
int	invoked;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCloseDisplay-1.(A)");
	report_assertion("A call to void XtCloseDisplay(display) shall close the");
	report_assertion("display specified by the argument display and remove it from");
	report_assertion("the application context of the calling program.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tclsdsply1", "XtCloseDisplay");
	display_good = XtDisplay(topLevel);
	tet_infoline("PREP: Create label widget `Hello' in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);	
        tet_infoline("PREP: Register timeout");
        XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTI_Proc, topLevel);
        tet_infoline("PREP: Register error handler");
	XtAppSetErrorMsgHandler(app_ctext, XtEMH_Proc);
	tet_infoline("TEST: Close the display");
	XtCloseDisplay(display_good);
	/*the safest thing to do, as best we can tell, as it
	actually validates the pointer and gives an error message
	if the display isn't valid*/
	tet_infoline("TEST: Display is no longer valid");
	FORK(pid2);
	XtCloseDisplay(display_good);
	KROF(pid2);
	invoked = avs_get_event(2);
	check_dec(1, invoked, "Error handler invoked status");
	/*ensure as best we can that the appcontext is still valid*/
	tet_infoline("TEST: Application context is still valid");
	FORK(pid2);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365136 */
/* End of included file Mdefcode.tmc.365136 */

static void t002(){

Widget	labelw_msg;
char	*msg = "Event widget";
int	status;
pid_t	pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCloseDisplay-2.(A)");
	report_assertion("void XtCloseDisplay(display) when called from within an");
	report_assertion("event dispatch shall not close the display until the");
	report_assertion("dispatch is complete.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tclsdsply2", "XtCloseDisplay");
	tet_infoline("PREP: Create labelw_msg widget in boxw1 widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register procedure to handle ButtonPress events");
	XtAddEventHandler(labelw_msg,
		  ButtonPressMask,
		  False,
		  XtEVT_Proc,
		  (Display *)display_good
		  );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress over wire to labelw_msg widget");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, FALSE);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	status = avs_get_event(1);
	check_dec(1, status, "Callback invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365136 */
/* End of included file Mdefcode.tmc.365136 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
