/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;


#define T_XtSpecificationRelease	1
char    *TestName = "XtSpecificationRelease";



int 	tet_thistest;

static void t001(){

pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtSpecificationRelease-1.(C)");
	report_assertion("If the implementation is X11R5: XtSpecificationRelease");
	report_assertion("shall be defined and shall be equal to 5.");
	FORK(pid);
	initconfig();

#if XT_X_RELEASE == 5
	if (XtSpecificationRelease != 5) {
		sprintf(ebuf, "ERROR: Expected XtSpecificationRelease = 5, is %d", XtSpecificationRelease);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);
#else
	sprintf(ebuf, "INFO: Implementation being tested is X11R%d.", XT_X_RELEASE);
	tet_infoline(ebuf);
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.356992 */
/* End of included file Mdefcode.tmc.356992 */

static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtSpecificationRelease-2.(C)");
	report_assertion("If the implementation is X11R4: XtSpecificationRelease");
	report_assertion("shall be defined and shall be equal to 4.");
	FORK(pid);
	initconfig();

#if XT_X_RELEASE == 4
	if (XtSpecificationRelease != 4) {
		sprintf(ebuf, "ERROR: Expected XtSpecificationRelease = 4, is %d", XtSpecificationRelease);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);
#else
	sprintf(ebuf, "INFO: Implementation being tested is X11R%d.", XT_X_RELEASE);
	tet_infoline(ebuf);
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.356992 */
/* End of included file Mdefcode.tmc.356992 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
