/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtFree()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;



#define T_XtFree	1
char    *TestName = "XtFree";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *ptr, *ptr1;
size_t max_limit;
int i;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtFree-1.(A)");
	report_assertion("When ptr points to a block of storage allocated by a prior");
	report_assertion("call to XtMalloc, XtCalloc or XtRealloc a successful call to");
	report_assertion("void XtFree(ptr) shall free the specified block.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tfree1", "XtFree");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Determine largest malloc");
	max_limit = mem_limit();
	tet_infoline("PREP: Allocate memory and free the memory, then try and re malloc it");
	ptr = (char *) XtMalloc(max_limit);
	if (ptr == (char *)0) {
		sprintf(ebuf, "ERROR: XtMalloc could not allocate %d bytes", max_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	XtFree(ptr);
	ptr = (char *)XtMalloc(max_limit);
	if (ptr == (char *)0) {
		sprintf(ebuf, "ERROR: XtMalloc could not re-allocate space after Xtfree");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	XtFree(ptr);
	tet_infoline("CLEANUP: Free it again");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363256 */
/* End of included file Mdefcode.tmc.363256 */

static void t002(){

char *ptr, *ptr1;
size_t max_limit;
int i;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtFree-2.(A)");
	report_assertion("When ptr is NULL a call to void XtFree(ptr) shall return");
	report_assertion("immediately.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tfree1", "XtFree");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Call XtFree(NULL)");
	XtFree(NULL);
	avs_set_event(1,1);
	LKROF(pid2, AVSXTTIMEOUT-2);
	if (avs_get_event(1) != 1) {
		tet_infoline("ERROR: XtFree(NULL) causes process to exit");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363256 */
/* End of included file Mdefcode.tmc.363256 */

/* Including from file Mdefcode.tmc.363256 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtFree-3.(B)");
	report_assertion("The behavior of a call to void XtFree(ptr) when ptr does");
	report_assertion("not specify a pointer returned by a prior call to XtMalloc,");
	report_assertion("XtCalloc or XtRealloc.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.363256 */

/* Including from file Mdefcode.tmc.363256 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtFree-4.(B)");
	report_assertion("The behavior of a call to void XtFree(ptr) when the storage");
	report_assertion("pointed to by ptr has been previously deallocated.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.363256 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
