/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtRegisterCaseConverter()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtCPP_Proc(dpy, sym, lower, upper)
Display *dpy;
KeySym sym;
KeySym *lower;
KeySym *upper;
{
	avs_set_event(1,1);
	exit(0);
}
void XtCPP_Proc2(dpy, sym, lower, upper)
Display *dpy;
KeySym sym;
KeySym *lower;
KeySym *upper;
{
	avs_set_event(2,1);
	exit(0);
}


#define T_XtRegisterCaseConverter	1
char    *TestName = "XtRegisterCaseConverter";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display;
KeySym keysym;
KeySym lower_return;
KeySym upper_return;
int invoked;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtRegisterCaseConverter-1.(A)");
	report_assertion("A call to void XtRegisterCaseConverter(display, proc,");
	report_assertion("start, stop) shall register proc as the procedure that will");
	report_assertion("be called when a case conversion is requested by a call to");
	report_assertion("XtConvertCase for a KeySym value that is in the range");
	report_assertion("specified by start and stop and associated with the display");
	report_assertion("display.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tregccon1", "XtRegisterCaseConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'a'");
	keysym = XStringToKeysym("a");
	tet_infoline("PREP: Register case converter XtCPP_Proc");
	XtRegisterCaseConverter(display, &XtCPP_Proc, keysym, keysym);
	tet_infoline("PREP: Get upper and lower case version of a keysym");
	XtConvertCase(display, keysym, &lower_return, &upper_return);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Case converter was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCPP_Proc invoked count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363716 */
/* End of included file Mdefcode.tmc.363716 */

static void t002(){

Display *display;
KeySym keysym;
KeySym lower_return;
KeySym upper_return;
int invoked;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtRegisterCaseConverter-2.(A)");
	report_assertion("On a call to void XtRegisterCaseConverter(display, proc,");
	report_assertion("start, stop) when a converter has already been registered");
	report_assertion("for the KeySym range specified by start and stop the");
	report_assertion("converter proc shall override the existing converter.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tregccon1", "XtRegisterCaseConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'a'");
	keysym = XStringToKeysym("a");
	tet_infoline("PREP: Register case converter XtCPP_Proc");
	XtRegisterCaseConverter(display, &XtCPP_Proc, keysym, keysym);
	tet_infoline("PREP: Register a second case converter for same range");
	XtRegisterCaseConverter(display, &XtCPP_Proc2, keysym, keysym);
	tet_infoline("PREP: Get upper and lower case version of a keysym");
	XtConvertCase(display, keysym, &lower_return, &upper_return);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Second Case converter was invoked");
	invoked = avs_get_event(2);
	check_dec(1, invoked, "XtCPP_Proc2 invoked count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.363716 */
/* End of included file Mdefcode.tmc.363716 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
