/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtVaGetSubresources()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

typedef struct _instance_variables {
	long background;
	String label;
} instance_variable_rec;
static XtResource resources[] = {
	{
	XtNbackground,
	XtCBackground,
	XtRPixel, sizeof(Pixel),
	XtOffsetOf(instance_variable_rec, background),
	XtRString, "XtDefaultbackground"
	},
	{
	XtNlabel,
	XtCLabel,
	XtRString, sizeof(String),
	XtOffsetOf(instance_variable_rec, label),
	XtRString, "XtDefaultLabel"
	},
};
int def = 2002;
static XtResource resources2[] = {
	{
	XtNbackground,
	XtCBackground,
	XtRPixel, sizeof(Pixel),
	XtOffsetOf(instance_variable_rec, background),
	XtRString, "XtDefaultBackground"
	},
	{
	XtNlabel,
	XtCLabel,
	XtRString, sizeof(String),
	XtOffsetOf(instance_variable_rec, label),
	XtRInt, &def
	},
};

char whereitsat[64];

Boolean XtCVT_Proc(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	sprintf(whereitsat, "%d", *(int *)from_val->addr);
	*(String*)to_val->addr = whereitsat;
	to_val->size = sizeof(XtPointer);
	avs_set_event(2, avs_get_event(2)+1);
	return True;
}


#define T_XtVaGetSubresources	1
char    *TestName = "XtVaGetSubresources";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

instance_variable_rec base;
Cardinal num_resources;
Arg setargs[2], getargs[2];
Cardinal num_args;
Pixel pixel;
char *string;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtVaGetSubresources-1.(A)");
	report_assertion("A successful call to void XtVaGetSubresources(w, base,");
	report_assertion("name, class, resources, num_resources,...) shall retrieve");
	report_assertion("the resource value for each resource specified in the");
	report_assertion("resource list resources from the resource values specified");
	report_assertion("in the varargs style argument list, or if no value for the");
	report_assertion("resource is found the variable argument list, from the");
	report_assertion("resource database associated with the widget w, matching the");
	report_assertion("resource identified by the calling application's name and");
	report_assertion("class, the names and classes of all ancestors of w, the name");
	report_assertion("and class of w, the subpart name name and class class, and");
	report_assertion("the resource name and class, or if no value is found in the");
	report_assertion("database, from the default_addr field of the resource list");
	report_assertion("and copy the resource value at an offset specified by the");
	report_assertion("corresponding resource_offset field from the address base.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvagtsres1", "XtVaGetSubresources");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources,2,
			 (ArgList)NULL, (Cardinal)0);
	tet_infoline("PREP: Update subpart resource list");
	XtVaGetSubresources(topLevel, &base, (String)NULL, (String)NULL,
			resources, 2, XtNbackground, 1,
			XtNlabel, "Hello World",(char *)NULL);
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtNbackground, &pixel,
		 XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, pixel , XtNbackground);
	check_str("Hello World", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365452 */
/* End of included file Mdefcode.tmc.365452 */

static void t002(){

instance_variable_rec base;
Cardinal num_resources;
Arg setargs[2], getargs[2];
Cardinal num_args;
Pixel pixel;
char *string;
pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtVaGetSubresources-2.(A)");
	report_assertion("On a call to void XtVaGetSubresources(w, base, name, class,");
	report_assertion("resources, num_resources,...) when a resource specified in");
	report_assertion("the resource database, the varargs list or a default");
	report_assertion("resource value is in a different representation from the");
	report_assertion("representation type specified in the resource_type field of");
	report_assertion("the resource list it shall call the appropriate type");
	report_assertion("converter to perform the conversion and store the converted");
	report_assertion("value in the subpart data structure.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvagtsres5", "XtVaGetSubresources");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppSetTypeConverter(app_ctext,
		 XtRInt,
		 XtRString,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheNone,
		 NULL);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources,2,
				(ArgList)NULL,(Cardinal)0);
	tet_infoline("PREP: Update subpart resource list");
	XtVaGetSubresources(topLevel, &base, (String)NULL, (String)NULL,
		 resources2, 2, XtNbackground, 1, NULL);
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources2, 2, XtNbackground, &pixel,
	XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, pixel , XtNbackground);
	check_str("2002", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: convertor was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "XtCVT_Proc invoked status");

	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365452 */
/* End of included file Mdefcode.tmc.365452 */

static void t003(){

instance_variable_rec base;
Cardinal num_resources;
Arg setargs[2], getargs[2];
Cardinal num_args;
Pixel pixel;
char *string;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtVaGetSubresources-3.(A)");
	report_assertion("On a call to void XtVaGetSubresources(w, base, name, class,");
	report_assertion("resources, num_resources,...) when the name XtVaTypedArg is");
	report_assertion("specified in place of a resource name in the variable");
	report_assertion("argument list it shall interpret the four arguments");
	report_assertion("following this argument as a name/type/value/size tuple.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvagtsres1", "XtVaGetSubresources");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources,2,
			 (ArgList)NULL, (Cardinal)0);
	tet_infoline("PREP: Update subpart resource list");
	XtVaGetSubresources(topLevel, &base, (String)NULL, (String)NULL,
			resources, 2, XtVaTypedArg, XtNbackground, XtRPixel, 0, sizeof(Pixel), XtNlabel, "Hello World",(char *)NULL);
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtNbackground, &pixel,
		 XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(0, base.background , XtNbackground);
	check_str("Hello World", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365452 */
/* End of included file Mdefcode.tmc.365452 */

static void t004(){

instance_variable_rec base;
Cardinal num_resources;
Arg setargs[2], getargs[2];
Cardinal num_args;
Pixel pixel;
char *string;
pid_t pid2;
XtVarArgsList sublist;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtVaGetSubresources-4.(A)");
	report_assertion("On a call to void XtVaGetSubresources(w, base, name, class,");
	report_assertion("resources, num_resources,...) when the name XtVaNestedList");
	report_assertion("is specified in place of a resource name in the variable");
	report_assertion("argument list it shall interpret the next argument as a");
	report_assertion("value specifying another varargs style variable argument");
	report_assertion("list and logically insert it in the original list at the");
	report_assertion("point of declaration.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvagtsres1", "XtVaGetSubresources");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources,2,
			 (ArgList)NULL, (Cardinal)0);
	tet_infoline("PREP: Update subpart resource list");
	XtVaGetSubresources(topLevel, &base, (String)NULL, (String)NULL,
			resources, 2, XtVaTypedArg, XtNbackground, XtRPixel, 0, sizeof(Pixel), XtNlabel, "Hello World",(char *)NULL);
	tet_infoline("PREP: Create nested list");
	sublist = XtVaCreateArgsList(NULL, XtNbackground, (XtArgVal)&pixel, NULL);
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtVaNestedList, sublist,
		 XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(0, base.background, XtNbackground);
	check_str("Hello World", string , XtNlabel);
	XtFree((char *)sublist);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365452 */
/* End of included file Mdefcode.tmc.365452 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
