/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtSetSubvalues()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


typedef struct _instance_variables {
	long foreground;
	String label;
} instance_variable_rec;
typedef struct _instance_variables2 {
	long l1;
	long l2;
} instance_variable_rec2;
static XtResource resources[] = {
	{
	XtNforeground,
	XtCForeground,
	XtRPixel, sizeof(Pixel),
	XtOffsetOf(instance_variable_rec, foreground),
	XtRString, "XtDefaultforeground"
	},
	{
	XtNlabel,
	XtCLabel,
	XtRString, sizeof(String),
	XtOffsetOf(instance_variable_rec, label),
	XtRString, "XtDefaultLabel"
	},
};


#define T_XtSetSubvalues	1
char    *TestName = "XtSetSubvalues";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

instance_variable_rec base;
Cardinal num_resources;
Arg setargs[2], getargs[2];
Cardinal num_args;
Pixel integer;
char *string;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtSetSubvalues-1.(A)");
	report_assertion("A call to void XtSetSubvalues(base, resources,");
	report_assertion("num_resources, args, num_args) shall copy the resource value");
	report_assertion("specified by the value field for the resource specified in");
	report_assertion("the name field of each member in the argument list args that");
	report_assertion("is present in the resource list specified by resources to");
	report_assertion("the structure pointed to by base.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstsvals1", "XtSetSubvalues");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources,2,NULL,0);
	tet_infoline("PREP: Set subvalues");
	setargs[0].name = XtNforeground;
	setargs[0].value = (XtArgVal)1;
	setargs[1].name = XtNlabel;
	setargs[1].value = (XtArgVal)"Hello World";
	XtSetSubvalues(&base, resources, 2, &setargs[0], 2 );
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtNforeground, &integer,
	XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, integer , XtNforeground);
	check_str("Hello World", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.363656 */
/* End of included file Mdefcode.tmc.363656 */

static void t002(){

instance_variable_rec2 base;
Cardinal num_resources;
Arg setargs[2], getargs[2];
Cardinal num_args;
Pixel integer;
char *string;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtSetSubvalues-2.(A)");
	report_assertion("A call to void XtSetSubvalues(base, resources,");
	report_assertion("num_resources, args, num_args) when a resource specified in");
	report_assertion("the argument list args is not present in the resource list");
	report_assertion("specified by resources shall not copy the resource value to");
	report_assertion("the structure base.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstsvals1", "XtSetSubvalues");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources,2,NULL,0);
	tet_infoline("PREP: Set subvalues");
	setargs[0].name = XtNforeground;
	setargs[0].value = (XtArgVal)1;
	setargs[1].name = "not real";
	setargs[1].value = (XtArgVal)2;
	base.l1 = (long)-1;
	base.l2 = (long)-1;
	XtSetSubvalues(&base, resources, 2, &setargs[0], 2 );
	tet_infoline("TEST: Only correct values are set");
	check_dec(1, base.l1 , XtNforeground);
	check_dec(-1, base.l2 , "missing long value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.363656 */
/* End of included file Mdefcode.tmc.363656 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
