/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtGetSubresources()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

typedef struct _instance_variables {
	long foreground;
	String label;
} instance_variable_rec;
static XtResource resources[] = {
	{
	XtNforeground,
	XtCForeground,
	XtRPixel, sizeof(Pixel),
	XtOffsetOf(instance_variable_rec, foreground),
	XtRString, "XtDefaultforeground"
	},
	{
	XtNlabel,
	XtCLabel,
	XtRString, sizeof(String),
	XtOffsetOf(instance_variable_rec, label),
	XtRString, "XtDefaultLabel"
	},
};
int def = 2002;

static XtResource resources2[] = {
        {
        XtNforeground,
        XtCForeground,
        XtRPixel, sizeof(Pixel),
        XtOffsetOf(instance_variable_rec, foreground),
        XtRString, "XtDefaultForeground"
        },
        {
        XtNlabel,
        XtCLabel,
        XtRString, sizeof(String),
        XtOffsetOf(instance_variable_rec, label),
        XtRInt, &def
        },
};

char whereitsat[64];

Boolean XtCVT_Proc(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
        sprintf(whereitsat, "%d", *(int *)from_val->addr);
        *(String*)to_val->addr = whereitsat;
        to_val->size = sizeof(XtPointer);
        avs_set_event(2, avs_get_event(2)+1);
        return True;
}


#define T_XtGetSubresources	1
char    *TestName = "XtGetSubresources";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

instance_variable_rec base;
Cardinal num_resources;
Arg setargs[2], getargs[2];
Cardinal num_args;
Pixel integer;
char *string;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetSubresources-1.(A)");
	report_assertion("A call to void XtGetSubresources(w, base, name, class,");
	report_assertion("resources, num_resources, args, num_args) shall retrieve the");
	report_assertion("resource value for each resource specified in the resource");
	report_assertion("list resources from the resource values specified in args,");
	report_assertion("or if no value for the resource is found in the argument");
	report_assertion("list, from the resource database associated with the widget");
	report_assertion("w, matching the resource identified by the calling");
	report_assertion("application's name and class, the names and classes of all");
	report_assertion("ancestors of w, the name and class of w, the subpart name");
	report_assertion("name and class class, and the resource name and class, or if");
	report_assertion("no value is found in the database, from the default_addr");
	report_assertion("field of the resource list and copy the resource at an");
	report_assertion("offset specified by the corresponding resource_offset field");
	report_assertion("from the address base.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	/*this test needs work LATER*/
	avs_xt_hier("Tgtsubres1", "XtGetSubresources");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources,2,
				(ArgList)NULL,(Cardinal)0);
	tet_infoline("PREP: Update subpart resource list");
	setargs[0].name = XtNforeground;
	setargs[0].value = (XtArgVal)1;
	setargs[1].name = XtNlabel;
	setargs[1].value = (XtArgVal)"Hello World";
	XtGetSubresources(topLevel, &base, (String)NULL, (String)NULL,
		 resources, 2, &setargs[0], 2 );
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtNforeground, &integer,
	XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, integer , XtNforeground);
	check_str("Hello World", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364704 */
/* End of included file Mdefcode.tmc.364704 */

static void t002(){

instance_variable_rec base;
Cardinal num_resources;
Arg setargs[2], getargs[2];
Cardinal num_args;
Pixel integer;
char *string;
pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetSubresources-2.(A)");
	report_assertion("On a call to void XtGetSubresources(w, base, name, class,");
	report_assertion("resources, num_resources, args, num_args) when a resource");
	report_assertion("specified in the resource database or a default resource");
	report_assertion("value is in a different representation from the");
	report_assertion("representation type specified in the resource_type field of");
	report_assertion("the resource list it shall call the appropriate type");
	report_assertion("converter to perform the conversion and store the converted");
	report_assertion("value in the subpart data structure.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtsubres1", "XtGetSubresources");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
        XtAppSetTypeConverter(app_ctext,
                 XtRInt,
                 XtRString,
                 XtCVT_Proc,
                 (XtConvertArgList)NULL,
                 (Cardinal)0,
                 XtCacheNone,
                 NULL);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources,2,
				(ArgList)NULL,(Cardinal)0);
	tet_infoline("PREP: Update subpart resource list");
	setargs[0].name = XtNforeground;
	setargs[0].value = (XtArgVal)1;
	XtGetSubresources(topLevel, &base, (String)NULL, (String)NULL,
		 resources2, 2, &setargs[0], 1 );
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources2, 2, XtNforeground, &integer,
	XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, integer , XtNforeground);
	check_str("2002", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: convertor was invoked");
        status = avs_get_event(2);
        check_dec(1, status, "XtCVT_Proc invoked status");

	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364704 */
/* End of included file Mdefcode.tmc.364704 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
