/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright 1989 by Sequent Computer Systems, Inc., Portland, Oregon
* 
* 			All Rights Reserved
* 
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted,
* provided that the above copyright notice appears in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of Sequent not be used
* in advertising or publicity pertaining to distribution or use of the
* software without specific, written prior permission.
* 
* SEQUENT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
* ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
* SEQUENT BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
* ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
* WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
* SOFTWARE.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"tet_api.h"
#ifdef INPUTEXTENSION
#include	"X11/extensions/XIproto.h"
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif


#define T_QueryTextExtents	1
char    *TestName = "QueryTextExtents";



/* Touch test for QueryTextExtents request */

#include "Xstlib.h"

#define CLIENT 0
static TestType test_type = SETUP;
Font Default_Font;
xQueryTextExtentsReq *req;
xQueryTextExtentsReply *rep;

static
void
tester()
{
	Set_Init_Timer();

	Create_Client(CLIENT);

	Default_Font = Create_Default_Font(CLIENT);

	Set_Test_Type(CLIENT, test_type);
	req = (xQueryTextExtentsReq *) Make_Req(CLIENT, X_QueryTextExtents);
	Send_Req(CLIENT, (xReq *) req);
	Set_Test_Type(CLIENT, GOOD);
	switch(test_type) {
	case GOOD:
		Log_Trace("client %d sent default QueryTextExtents request\n", CLIENT);
		if ((rep = (xQueryTextExtentsReply *) Expect_Reply(CLIENT, X_QueryTextExtents)) == NULL) {
			Log_Err("client %d failed to receive QueryTextExtents reply\n", CLIENT);
			Exit();
		}  else  {
			Log_Trace("client %d received QueryTextExtents reply\n", CLIENT);
			/* do any reply checking here */
			Free_Reply(rep);
		}
		Expect_Nothing(CLIENT);
		break;
	case BAD_LENGTH:
		Log_Trace("client %d sent QueryTextExtents request with bad length (%d)\n", CLIENT, req->length);
		Expect_BadLength(CLIENT);
		Expect_Nothing(CLIENT);
		break;
	case TOO_LONG:
	case JUST_TOO_LONG:
		Log_Trace("client %d sent overlong QueryTextExtents request (%d)\n", CLIENT, req->length);
		Expect_BadLength(CLIENT);
		Expect_Nothing(CLIENT);
		break;
	default:
		Log_Err("INTERNAL ERROR: test_type %d not one of GOOD(%d), BAD_LENGTH(%d), TOO_LONG(%d) or JUST_TOO_LONG(%d)\n",
			test_type, GOOD, BAD_LENGTH, TOO_LONG, JUST_TOO_LONG);
		Abort();
		/*NOTREACHED*/
		break;
	}
	Free_Req(req);
	Exit_OK();
}

int 	tet_thistest;

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion QueryTextExtents-1.(A)");
	report_assertion("When a client sends a valid QueryTextExtents protocol");
	report_assertion("request to the X server, then the X server sends back a");
	report_assertion("reply to the client with the minimum required length.");

	report_strategy("Call library function testfunc() to do the following:");
	report_strategy("Open a connection to the X server using native byte sex.");
	report_strategy("Send a valid QueryTextExtents protocol request to the X server.");
	report_strategy("Verify that the X server sends back a reply.");
	report_strategy("Open a connection to the X server using reversed byte sex.");
	report_strategy("Send a valid QueryTextExtents protocol request to the X server.");
	report_strategy("Verify that the X server sends back a reply.");

	tpfontstartup();
	test_type = GOOD;

	/* Call a library function to exercise the test code */
	testfunc(tester);

	tpfontcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion QueryTextExtents-2.(A)");
	report_assertion("When a client sends an invalid QueryTextExtents protocol");
	report_assertion("request to the X server, in which the length field of the");
	report_assertion("request is not the minimum length required to contain the");
	report_assertion("request, then the X server sends back a BadLength error to");
	report_assertion("the client.");

	report_strategy("Call library function testfunc() to do the following:");
	report_strategy("Open a connection to the X server using native byte sex.");
	report_strategy("Send an invalid QueryTextExtents protocol request to the X server with length ");
	report_strategy("  one less than the minimum length required to contain the request.");
	report_strategy("Verify that the X server sends back a BadLength error.");
	report_strategy("Open a connection to the X server using reversed byte sex.");
	report_strategy("Send an invalid QueryTextExtents protocol request to the X server with length ");
	report_strategy("  one less than the minimum length required to contain the request.");
	report_strategy("Verify that the X server sends back a BadLength error.");

	tpfontstartup();
	test_type = BAD_LENGTH; /* < minimum */

	/* Call a library function to exercise the test code */
	testfunc(tester);

	tpfontcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion QueryTextExtents-3.(B)");
	report_assertion("When a client sends an invalid QueryTextExtents protocol");
	report_assertion("request to the X server, in which the length field of the");
	report_assertion("request exceeds the maximum length accepted by the X server,");
	report_assertion("then the X server sends back a BadLength error to the");
	report_assertion("client.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Call library function testfunc() to do the following:");
	report_strategy("Open a connection to the X server using native byte sex.");
	report_strategy("Send an invalid QueryTextExtents protocol request to the X server with length ");
	report_strategy("  one greater than the maximum length accepted by the server.");
	report_strategy("Verify that the X server sends back a BadLength error.");
	report_strategy("Open a connection to the X server using reversed byte sex.");
	report_strategy("Send an invalid QueryTextExtents protocol request to the X server with length ");
	report_strategy("  one greater than the maximum length accepted by the server.");
	report_strategy("Verify that the X server sends back a BadLength error.");

	tpfontstartup();
	test_type = TOO_LONG;

	/* Call a library function to exercise the test code */
	testfunc(tester);
	tpfontcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = protostartup;
void	(*tet_cleanup)() = protocleanup;
