/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   char *
 *   XFetchBuffer(display, nbytes_return, buffer)
 *   Display	*display;
 *   int	*nbytes_return;
 *   int	buffer;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XFetchBuffer	1
char    *TestName = "XFetchBuffer";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XFetchBuffer function
 */
static Display	*display;
static int	*nbytes_return;
static int	buffer;


#include	"X11/Xatom.h"

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	nbytes_return = 0;
	buffer = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char	*bp;
char	*rbp;
int	nr;
int	len;
int 	i;
int 	j;
struct	bstrct {
	char	*data;
	int	len;
}	bfrs[8], *bptr;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XFetchBuffer-1.(A)");
	report_assertion("When the cut buffer specified by the buffer argument");
	report_assertion("contains data, then a call to XFetchBuffer returns in the");
	report_assertion("nbytes_return argument the number of bytes stored in the");
	report_assertion("buffer and returns a pointer to storage allocated for the");
	report_assertion("data, which can be freed with XFree.");

	report_strategy("For each cut buffer 0..7:");
	report_strategy("   Set the buffer to contain data using XStoreBuffer.");
	report_strategy("For each cut buffer 0..7:");
	report_strategy("   Obtain the contents of the buffer using XFetchBuffer.");
	report_strategy("   Verify that the data is correct.");
	report_strategy("   Free the returned data using XFree.");

	tpstartup();
	setargs();
	for(i=0, bptr=bfrs; i<8; i++, bptr++) {

		len = 1+i*123;
		bptr->len = len;

		if((bptr->data = (char*)malloc(len)) == (char *) NULL) {
			delete("malloc() returned NULL.");
			return;
		} else
			CHECK;

		for(j=len, bp=bptr->data; j>0; *bp++ = (j) %  (256 - i), j--)
			;

		XStoreBuffer(display, bptr->data, len, i);
	}

	for(i=0, bptr=bfrs; i<8; i++, bptr++) {
		
		buffer = i;
		nbytes_return = &nr;
		startcall(display);
		if (isdeleted())
			return;
		rbp = XFetchBuffer(display, nbytes_return, buffer);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(rbp == (char *) NULL) {
			report("%s() did not set buffer %d to contain any data.", TestName, i);
			FAIL;
		} else {
			CHECK;

			if(bptr->len != nr) {
				report("%s() set buffer %d to contain %d bytes instead of %d.", TestName, i, nr, bptr->len);
				FAIL;
			} else {
				CHECK;

				if(memcmp(rbp, bptr->data, nr) != 0) {
					report("%s() set buffer %d to contain the wrong data.", TestName, i);
					FAIL;
				} else
					CHECK;
			}

			free(bptr->data);
			XFree(rbp);
		}
	}


	CHECKPASS(8 + 8 * (3));

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

char	*rbp;
char	*tstr = "XTest Multi buffer string";
int	len = 1 + strlen(tstr);
int	nr;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XFetchBuffer-2.(A)");
	report_assertion("When the cut buffer specified by the buffer argument does");
	report_assertion("not contain any data, then a call to XFetchBuffer sets the");
	report_assertion("nbytes_return argument to zero, and returns NULL.");

	report_strategy("For each cut buffer 0..7:");
	report_strategy("   Set the buffer to contain data using XStoreBuffer.");
	report_strategy("For i in 0..7:");
	report_strategy("  Delete the property CUT_BUFFERi from screen 0 of the display using XDeletePropery.");
	report_strategy("For each cut buffer 0..7:");
	report_strategy("   Obtain the contents of the buffer using XFetchBuffer.");
	report_strategy("   Verify that the call returned NULL.");
	report_strategy("   Verify that the nbytes_return argument was set to zero.");

	tpstartup();
	setargs();
	for(i=0; i < 8; i++)
		XStoreBuffer(display, tstr, len, i);

	XDeleteProperty(display, RootWindow(display, 0), XA_CUT_BUFFER0);
	XDeleteProperty(display, RootWindow(display, 0), XA_CUT_BUFFER1);
	XDeleteProperty(display, RootWindow(display, 0), XA_CUT_BUFFER2);
	XDeleteProperty(display, RootWindow(display, 0), XA_CUT_BUFFER3);
	XDeleteProperty(display, RootWindow(display, 0), XA_CUT_BUFFER4);
	XDeleteProperty(display, RootWindow(display, 0), XA_CUT_BUFFER5);
	XDeleteProperty(display, RootWindow(display, 0), XA_CUT_BUFFER6);
	XDeleteProperty(display, RootWindow(display, 0), XA_CUT_BUFFER7);

	for(i=0; i < 8; i++) {
		
		buffer = i;
		nbytes_return = &nr;
		startcall(display);
		if (isdeleted())
			return;
		rbp = XFetchBuffer(display, nbytes_return, buffer);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(rbp != (char *) NULL) {
			report("%s() did not return NULL for buffer %d.", TestName, i);
			FAIL;
		} else
			CHECK;

		if(nr != 0) {
			report("%s() set nbytes_return to %d instead of 0 for buffer %d.", TestName, nr, i);
			FAIL;
		} else
			CHECK;

	}

	CHECKPASS(8 * 2);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
