/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2001 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int ((*)())()
 *   XSetIOErrorHandler(handler)
 *   int (*handler)();
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetIOErrorHandler	1
char    *TestName = "XSetIOErrorHandler";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XSetIOErrorHandler function
 */
static int (*handler)();


static int 	ValueReturn;

#include <signal.h>
#include <sys/wait.h>

#define	_xcall_(rvalue)		rvalue = XSetIOErrorHandler(handler)

static	Display	*client;
static	int	exit_status = -1;
static	int	counter = 0;

/*
 * various exit values are used because we do not know the exit status
 * used by the default handler
 */
static	int	exit_statuses[] = {
	2, 3, 4, 8, 16
};

static int
errorhandler(display)
Display *display;
{
	/* Handler exits with exit status of exit_status. */
	exit(exit_status);
}

static int
_errorhandler(display)
Display *display;
{
	/* Handler returns first time called. */
	/* Handler exits upon second and subsequent invocations */
	/* with exit status of exit_status. */
	if (counter++)
		exit(exit_status);
	return(0);
}

/*
 * Child exits with exit_status on success.
 * Child exits with exit_status+1 to indicate TET_DELETE.
 * Child exits with exit_status-1 to indicate failure.
 */
static	void
child_proc1()
{
	Window	w;
	int 	fail = 0;

	/* Child process closes connection number. */
	if (close(ConnectionNumber(client))) {
		report("Close failed on ConnectionNumber number.");
		exit(exit_status + 1);
	}
	/* Child process attempts to communicate to server, */
	/* causing handler to be invoked. */
	w = XCreateSimpleWindow(client, DefaultRootWindow(client), 1, 1, 50, 50, 1, 0, 0);
	XFlush(client);

	report("Handler not invoked or did not exit");
	FAIL;
	exit(exit_status - 1);
}



#include <stdio.h>
#define	MESSBUF	55


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	handler = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int	(*proc)();
int	child_exit;
int	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetIOErrorHandler-1.(A)");
	report_assertion("A call to XSetIOErrorHandler sets the fatal I/O error");
	report_assertion("handler to handler.");

	report_strategy("Call XSetIOErrorHandler to set the handler to errorhandler.");
	report_strategy("Open display.");
	report_strategy("Set exit_status.");
	report_strategy("Create child process.");
	report_strategy("Child process closes connection number.");
	report_strategy("Child process attempts to communicate to server,");
	report_strategy("causing handler to be invoked.");
	report_strategy("Handler exits with exit status of exit_status.");
	report_strategy("Verify that child's exit status was exit_status.");
	report_strategy("Repeat for various other exit_status values.");

	tpstartup();
	setargs();
/* The strategy uses ConnectionNumber, so can only be used on POSIX systems */
	if(config.posix_system != 1) {
		untested("The assertion can only be tested on a POSIX compliant system.");
		return;
	}

/* Call XSetIOErrorHandler to set the handler to errorhandler. */
	handler = errorhandler;
	_xcall_(proc);
	for (i=0; i<NELEM(exit_statuses); i++) {
/* Open display. */
		client = opendisplay();
		if (client == (Display *) NULL) {
			delete("Can not open display");
			return;
		}
		else
			CHECK;
/* Set exit_status. */
		exit_status = exit_statuses[i];
		XFlush(client);
/* Create child process. */
		child_exit = tet_fork(child_proc1, (void (*)()) NULL, 20, ~0);
/* Child process closes connection number. */
/* Child process attempts to communicate to server, */
/* causing handler to be invoked. */
/* Handler exits with exit status of exit_status. */
/* Verify that child's exit status was exit_status. */
		if (child_exit == (exit_statuses[i]+1)) {
			delete("Child process experienced unexpected problem.");
			return;
		}
		else
			CHECK;
		if (child_exit != exit_statuses[i]) {
			report("Handler not invoked (got %d exit status, expected %d.", child_exit, exit_statuses[i]);
			FAIL;
		}
		else
			CHECK;
/* Repeat for various other exit_status values. */
	}
	CHECKPASS(3*NELEM(exit_statuses));
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	(*proc)();
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetIOErrorHandler-2.(A)");
	report_assertion("A call to XSetIOErrorHandler returns the previous fatal I/O");
	report_assertion("error handler.");

	report_strategy("Call XSetIOErrorHandler to set error handler to errorhandler.");
	report_strategy("Call XSetIOErrorHandler to set error handler to _errorhandler.");
	report_strategy("Verify that errorhandler was returned.");
	report_strategy("Call XSetIOErrorHandler to set error handler to errorhandler.");
	report_strategy("Verify that _errorhandler was returned.");

	tpstartup();
	setargs();
/* Call XSetIOErrorHandler to set error handler to errorhandler. */
	handler = errorhandler;
	_xcall_(proc);
/* Call XSetIOErrorHandler to set error handler to _errorhandler. */
	handler = _errorhandler;
	_xcall_(proc);
/* Verify that errorhandler was returned. */
	if (proc != errorhandler) {
		report("Returned 0x%x, expected 0x%x", proc, errorhandler);
		FAIL;
	}
	else
		CHECK;
/* Call XSetIOErrorHandler to set error handler to errorhandler. */
	handler = errorhandler;
	_xcall_(proc);
/* Verify that _errorhandler was returned. */
	if (proc != _errorhandler) {
		report("Returned 0x%x, expected 0x%x", proc, _errorhandler);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.361772 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetIOErrorHandler-3.(B)");
	report_assertion("On a call to XSetIOErrorHandler with handler set to NULL");
	report_assertion("the fatal I/O error handler is set to the default fatal I/O");
	report_assertion("error handler.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.361772 */

static void t004(){

int	(*proc)();
pid_t	child;
int	stat_loc;
int	waitstatus;
int     p[2];
int     gotmessage = 0;
char    buf[MESSBUF];
FILE    *fp;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetIOErrorHandler-4.(A)");
	report_assertion("The default fatal I/O error handler prints a message and");
	report_assertion("exits.");

	report_strategy("Get default error handler.");
	report_strategy("Create child process.");
	report_strategy("Child calls default error handler and loops forever.");
	report_strategy("Parent sleeps for 10 seconds.");
	report_strategy("Parent verifies that child no longer exists.");

	tpstartup();
	setargs();
	client = Dsp;
/* Get default error handler. */
	handler = (int (*)()) NULL;
	_xcall_(proc);
	/* requires two calls! */
	_xcall_(proc);

	if (pipe(p) == -1) {
		delete("Could not create pipe");
		return;
	}

/* Create child process. */
	child = fork();
	if (!child) {

		close(p[0]);
		/*
		 * Capture both stdout and stderr into the pipe.
		 */
		dup2(p[1], 1);
		dup2(p[1], 2);

/* Child calls default error handler and loops forever. */
		(*proc)(client);
		/*
		 * Now close the pipe to make sure that the parent will not hang.
		 */
		close(p[1]);
		close(1);
		close(2);

		for (;;)
			continue;
	}
	else
		CHECK;

	close(p[1]);

/* Parent sleeps for 10 seconds. */
	sleep(10);
    /*
     * Read message in reasonable size chunks.
     */
    fp = fdopen(p[0], "r");
    if (fp == NULL) {
        delete("Could not fdopen pipe");
        return;
    }
    trace("The message produced by the default handler:");
    gotmessage = 0;
    while (fgets(buf, MESSBUF-1, fp)) {
        gotmessage = 1;
        buf[MESSBUF-1] = '\0';
        trace("Message: %s", buf);
    }

    if (!gotmessage) {
        report("No message was printed");
        FAIL;
    } else
        CHECK;

/* Parent verifies that child no longer exists. */
	waitstatus = waitpid(child, &stat_loc, WNOHANG);
	if (waitstatus != child) {
		report("Child did not exit.");
		FAIL;
		kill(child, SIGKILL);
		waitpid(child, &stat_loc, WNOHANG);
	}
	else
		CHECK;
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int	(*proc)();
int	i;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetIOErrorHandler-5.(B)");
	report_assertion("There is no limit to the number of times XSetIOErrorHandler");
	report_assertion("may be called.");
	report_assertion("Reason for omission: Testing the assertion would require an unreasonable amount of time or resources on most systems");

	report_strategy("Set handler to errorhandler.");
	report_strategy("Call XSetIOErrorHandler 1000 times.");
	report_strategy("Report untested.");

	tpstartup();
	setargs();
/* Set handler to errorhandler. */
	handler = errorhandler;
/* Call XSetIOErrorHandler 1000 times. */
	for (i=0; i<1000; i++) {
		if (i == 0)
			CHECK;
		startcall(Dsp);
		if (isdeleted())
			return;
		proc = XSetIOErrorHandler(handler);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	}
/* Report untested. */
	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){


 	report_purpose(6);

	report_assertion("Assertion XSetIOErrorHandler-6.(-)");
	report_assertion("When a system call error occurs, then Xlib calls handler.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t007(){

int	(*proc)();
int	child_exit;
char	*server;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetIOErrorHandler-7.(A)");
	report_assertion("When handler returns, then the client process exits.");

	report_strategy("Call XSetIOErrorHandler to set the handler to _errorhandler.");
	report_strategy("Open display.");
	report_strategy("Set exit_status.");
	report_strategy("Create child process.");
	report_strategy("Child process closes connection number.");
	report_strategy("Child process attempts to communicate to server,");
	report_strategy("causing handler to be invoked.");
	report_strategy("Handler returns first time called.");
	report_strategy("Verify that handler exited in the child proc.");

	tpstartup();
	setargs();
/* The strategy uses ConnectionNumber, so can only be used on POSIX systems */
	if(config.posix_system != 1) {
		untested("The assertion can only be tested on a POSIX compliant system.");
		return;
	}

	if ((server = config.display) == (char *) NULL) {
		delete("DISPLAY not set");
		return;
	}
	else
		CHECK;
/* Call XSetIOErrorHandler to set the handler to _errorhandler. */
	handler = _errorhandler;
	_xcall_(proc);
/* Open display. */

	client = XOpenDisplay(server);
	if (client == (Display *) NULL) {
		delete("Can not open display: %s", server);
		return;
	}
	else
		CHECK;

/* Set exit_status. */
	exit_status = exit_statuses[0];

	counter = 0;
/* Create child process. */
/* Child process closes connection number. */
/* Child process attempts to communicate to server, */
/* causing handler to be invoked. */
/* Handler returns first time called. */
	XFlush(client);
	child_exit = tet_fork(child_proc1, (void (*)()) NULL, 10, ~0);

	/*
	 * Since the exit status when the handler returns is not known, then
	 * no checks can be made on it.
	 * If the handler did not exit then this will have been reported in the
	 * child.  In this case the pass here will be spurious, however the
	 * TET will give precedence to the fail, so a false pass will not result.
	 */
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
