/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_ButtonPress	1
char    *TestName = "ButtonPress";



#define EVENT ButtonPress
#define EVENTMASK ButtonPressMask
#define PTRX 4
#define PTRY 3

int 	tet_thistest;

static void t001(){

Display			*display = Dsp;
Window			w;
XEvent			event_return;
XButtonPressedEvent	good;
PointerPlace		*ptr;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion ButtonPress-1.(B)");
	report_assertion("When any pointer button is pressed, then a ButtonPress");
	report_assertion("event is generated.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is enabled:");
	report_strategy("  Create window.");
	report_strategy("  Select for ButtonPress events.");
	report_strategy("  Generate ButtonPress event.");
	report_strategy("  Verify that a ButtonPress event was delivered.");
	report_strategy("  Verify that event member fields are correctly set.");

	tpstartup();
	if(noext(1))
		return;

/* Create window. */
	w = defwin(display);

/* Select for events. */
	XSelectInput(display, w, EVENTMASK);
	XSync(display, True);

/* Generate xname event. */
	XSync(display, True);
	ptr = warppointer(display, w, PTRX, PTRY);
	buttonpress(display, Button1);

/* Verify that event was delivered. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;

	good = event_return.xbutton;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.root = DRW(display);
	good.subwindow = None;
	good.x = PTRX;
	good.y = PTRY;
	good.x_root = ptr->nx;
	good.y_root = ptr->ny;
	good.state = 0L;
	good.button = Button1;
	good.same_screen = True;

	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event");
		FAIL;
	}
	else
		CHECK;

	
	CHECKPASS(2);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window			w;
Window			w1;
Window			w2;
XEvent			ev;
struct area		area;
char			*unexpstr = "Unexpected event on a child window.";
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion ButtonPress-2.(B)");
	report_assertion("When a ButtonPress event is generated and no active pointer");
	report_assertion("grab is in progress and at least one ancestor of the source");
	report_assertion("window has a matching passive grab on the pressed pointer");
	report_assertion("button, then the X server activates a passive grab for the");
	report_assertion("first ancestor of the source window, searching from the root");
	report_assertion("window down.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is enabled :");
	report_strategy("  Create a window.");
	report_strategy("  Create a child window.");
	report_strategy("  Create a child of the child.");
	report_strategy("  Select input on EnterNotify events for all of the windows.");
	report_strategy("  Select passive grabs for all the windows on Button1.");
	report_strategy("  Simulate a ButtonPress event.");
	report_strategy("  Verify that the child windows did not receive EnterNotify events.");
	report_strategy("  Verify that the oldest ancestor window received an EnterNotify with mode NotifyGrab.");
	report_strategy("  Simulate a ButtonRelease event.");
	report_strategy("  Release the passive grabs.");

	tpstartup();
	if (noext(1))
		return;

        w = defwin(Dsp);
	setarea(&area, 10, 10, 30, 30);
	w1 = crechild(Dsp, w, &area);
	w2 = crechild(Dsp, w1, &area);
	warppointer(Dsp, w2, 1,1);

	XSelectInput(Dsp, w, EnterWindowMask);
	XSelectInput(Dsp, w1, EnterWindowMask);
	XSelectInput(Dsp, w2, EnterWindowMask);

	XGrabButton(Dsp, Button1, AnyModifier, w, False,  0L, GrabModeAsync, GrabModeAsync, None, None);
	XGrabButton(Dsp, Button1, AnyModifier, w1, False, 0L, GrabModeAsync, GrabModeAsync, None, None);
	XGrabButton(Dsp, Button1, AnyModifier, w2, False, 0L, GrabModeAsync, GrabModeAsync, None, None);

	XSync(Dsp, True);
	buttonpress(Dsp, Button1);

	if(XCheckWindowEvent(Dsp, w1, EnterWindowMask, &ev) != False) {
		report(unexpstr);
		FAIL;
	} else
		CHECK;

	if(XCheckWindowEvent(Dsp, w2, EnterWindowMask, &ev) != False) {
		report(unexpstr);
		FAIL;
	} else
		CHECK;

	if(XCheckWindowEvent(Dsp, w, EnterWindowMask, &ev) == False) {
		report("No event was activated on the oldest ancestor window.");
		FAIL;
	} else {

		CHECK;
		if(ev.xcrossing.mode != NotifyGrab) {
			report("Passive grab was not activated on oldest ancestor window.");
			FAIL;
		} else
			CHECK;
	}

	buttonrel(Dsp, Button1);
	XUngrabButton(Dsp, Button1, AnyModifier, w);
	XUngrabButton(Dsp, Button1, AnyModifier, w1);
	XUngrabButton(Dsp, Button1, AnyModifier, w2);

	CHECKPASS(4);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.360832 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion ButtonPress-3.(B)");
	report_assertion("When a ButtonPress event is generated and no active pointer");
	report_assertion("grab is in progress and no ancestor of the source window has");
	report_assertion("a matching passive grab on the pressed pointer button, then");
	report_assertion("the X server automatically starts an active grab for the");
	report_assertion("client receiving the event and sets the last-pointer-grab");
	report_assertion("time to the current server time.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	UNTESTED;
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.360832 */

static void t004(){

Display			*display = Dsp;
Window			w;
int			count;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion ButtonPress-4.(B)");
	report_assertion("When a ButtonPress event is generated and no active pointer");
	report_assertion("grab is in progress and no ancestor of the source window has");
	report_assertion("a matching passive grab on the pressed pointer button and no");
	report_assertion("client has selected for button presses on the event window,");
	report_assertion("then the event is discarded.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is enabled:");
	report_strategy("  Create window.");
	report_strategy("  Select for all events except ButtonPress.");
	report_strategy("  Generate ButtonPress event.");
	report_strategy("  Verify that no event was delivered.");

	tpstartup();
	if(noext(1))
		return;

/* Create window. */
	w = defwin(display);

	warppointer(display, w, PTRX, PTRY);
	XSelectInput(display, w, ALLEVENTS & ~ButtonPressMask);
	XSync(display, True);
/* Generate xname event. */
	XSync(display, True);
	buttonpress(display, Button1);

/* Verify no events were delivered. */

	count = XPending(display);
	if (count != 0) {
		report("Got %d unexpected events.", count);
		FAIL;
	}
	else
		PASS;

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Display			*display = Dsp;
Window			w;
XEvent			event_return;
XButtonPressedEvent	good;
PointerPlace		*ptr;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion ButtonPress-5.(B)");
	report_assertion("When a ButtonPress event is generated, then all clients");
	report_assertion("having set ButtonPressMask event mask bits on the event");
	report_assertion("window are delivered a ButtonPress event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is enabled:");
	report_strategy("  Create window.");
	report_strategy("  Select for ButtonPress events.");
	report_strategy("  Generate ButtonPress event.");
	report_strategy("  Verify that a ButtonPress event was delivered.");
	report_strategy("  Verify that event member fields are correctly set.");
	report_strategy("Otherwise:");
	report_strategy("  Create window.");
	report_strategy("  Set ButtonPressMask event mask bits on window.");
	report_strategy("  Verify that no error occurred.");

	tpstartup();

	if(config.extensions) {

		if(noext(1))
			return;
	/* Create window. */
		w = defwin(display);

	/* Select for events. */
		XSelectInput(display, w, EVENTMASK);
		XSync(display, True);
	
	/* Generate xname event. */
		XSync(display, True);
		ptr = warppointer(display, w, PTRX, PTRY);
		buttonpress(display, Button1);
	
	/* Verify that event was delivered. */
	/* Verify that event member fields are correctly set. */
		if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
			report("Expected %s event, got none", eventname(EVENT));
			FAIL;
		} else
			CHECK;
	
		good = event_return.xbutton;
		good.type = EVENT;
		good.send_event = False;
		good.display = display;
		good.window = w;
		good.root = DRW(display);
		good.subwindow = None;
		good.x = PTRX;
		good.y = PTRY;
		good.x_root = ptr->nx;
		good.y_root = ptr->ny;
		good.state = 0L;
		good.button = Button1;
		good.same_screen = True;
	
		if (checkevent((XEvent *) &good, &event_return)) {
			report("Unexpected values in delivered event");
			FAIL;
		}
		else
			CHECK;
		
		CHECKPASS(2);

	} else {

	/* Create window. */
		w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
	/* Set ButtonPressMask event mask bits on window. */
		XSelectInput(display, w, ButtonPressMask);
		XSync(display, True);
	/* Verify that no error occurred. */
		if (geterr() != Success) {
			delete("Error setting up for test.");
			return;
		}
		else
			CHECK;
		CHECKUNTESTED(1);
	}

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display			*display = Dsp;
Display			*client2;
XEvent			ev;
Window			w;
int			count;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion ButtonPress-6.(B)");
	report_assertion("When a ButtonPress event is generated, then clients not");
	report_assertion("having set ButtonPressMask event mask bits on the event");
	report_assertion("window are not delivered a ButtonPress event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is enabled:");
	report_strategy("  Create window.");
	report_strategy("  Select for all events except ButtonPress.");
	report_strategy("  Create a second client.");
	report_strategy("  Select for ButtonPress events on the window");
	report_strategy("  Generate ButtonPress event.");
	report_strategy("  Verify that a ButtonPress event was delivered.");
	report_strategy("  Verify that no event was delivered to the other client.");

	tpstartup();
	if(noext(1))
		return;

	client2 = opendisplay();

/* Create window. */
	w = defwin(display);

	warppointer(display, w, PTRX, PTRY);
	XSelectInput(display, w, ALLEVENTS & ~ButtonPressMask);
	XSelectInput(client2, w, ButtonPressMask);
	XSync(display, True);
	XSync(client2, True);
/* Generate xname event. */
	buttonpress(display, Button1);

	XSync(client2, False);


/* Verify a ButtonPress was generated. */
	if(XCheckWindowEvent(client2, w, ButtonPressMask, &ev) == False) {
		report("No ButtonPress event was generated.");
		FAIL;
	} else
		CHECK;

/* Verify no events were delivered. */
	count = XPending(display);
	if (count != 0) {
		report("Got %d unexpected events.", count);
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XEvent			ev;
Window			w;
Window			w1;
Window			w2;
XSetWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion ButtonPress-7.(B)");
	report_assertion("When a ButtonPress event is generated and no client has");
	report_assertion("selected ButtonPressMask on the source window, then the");
	report_assertion("event propagates, with propagation stopping at the root");
	report_assertion("window of the screen or at the first window with");
	report_assertion("ButtonPressMask in its do-not-propagate mask, from the");
	report_assertion("source window to the first ancestor window for which some");
	report_assertion("client has selected for ButtonPress events.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a window.");
	report_strategy("  Create a child of that window.");
	report_strategy("  Create a child of the child.");
	report_strategy("  Select ButtonPress events on the root window.");
	report_strategy("  Simulate a ButtonPress event on the youngest child.");
	report_strategy("  Verify that a ButtonPress event was generated on the root.");
	report_strategy("  Select ButtonPress events on the oldest window.");
	report_strategy("  Set the do_not_propagate mask of its child to ButtonPress events.");
	report_strategy("  Simulate a ButtonPress event on the youngest child.");
	report_strategy("  Verify that no created window received a ButtonPress event.");
	report_strategy("  Clear the do_not_propagate mask on the oldest child.");
	report_strategy("  Set the do_not_propagate mask on the oldest window.");
	report_strategy("  Select for ButtonPress events on the oldest child.");
	report_strategy("  Simulate a ButtonPress on the youngest child.");
	report_strategy("  Verify that no ButtonPress event was sent to the oldest window.");
	report_strategy("  Verify that no ButtonPress event was sent to the youngest window.");
	report_strategy("  Verify that a ButtonPress event was sent to the oldest child.");
	report_strategy("");

	tpstartup();
	if(noext(1))
		return;

	w = defwin(Dsp);
	w1 = crechild(Dsp, w, (struct area *) NULL);
	w2 = crechild(Dsp, w1, (struct area *) NULL);
	XSelectInput(Dsp, DRW(Dsp), ButtonPressMask);	
	warppointer(Dsp, w2, 1,1);

	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	
	if (XCheckWindowEvent(Dsp, DRW(Dsp), ButtonPressMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(ButtonPress));
		FAIL;
	} else
		CHECK;

	XSelectInput(Dsp, DRW(Dsp), NoEventMask);	
	XSelectInput(Dsp, w, ButtonPressMask);	

	atts.do_not_propagate_mask = ButtonPressMask;
	XChangeWindowAttributes(Dsp, w1, CWDontPropagate, &atts);
	
	buttonrel(Dsp, Button1);	
	buttonpress(Dsp, Button1);

	if (XCheckWindowEvent(Dsp, w2, ButtonPressMask, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(ButtonPress));
		FAIL;
	} else
		CHECK;

	if (XCheckWindowEvent(Dsp, w1, ButtonPressMask, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(ButtonPress));
		FAIL;
	} else
		CHECK;

	if (XCheckWindowEvent(Dsp, w, ButtonPressMask, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(ButtonPress));
		FAIL;
	} else
		CHECK;

	XSelectInput(Dsp, w1, ButtonPressMask);	
	XChangeWindowAttributes(Dsp, w, CWDontPropagate, &atts);

	atts.do_not_propagate_mask = NoEventMask;
	XChangeWindowAttributes(Dsp, w1, CWDontPropagate, &atts);

	buttonrel(Dsp, Button1);	
	buttonpress(Dsp, Button1);

	if (XCheckWindowEvent(Dsp, w2, ButtonPressMask, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(ButtonPress));
		FAIL;
	} else
		CHECK;

	if (XCheckWindowEvent(Dsp, w, ButtonPressMask, &ev) != False) {
		report("Unexpected event (%s) received.", eventname(ButtonPress));
		FAIL;
	} else
		CHECK;

	if (XCheckWindowEvent(Dsp, w1, ButtonPressMask, &ev) == False) {
		report("ButtonPress event was not delivered to selecting child window.");
		FAIL;
	} else
		CHECK;

CHECKPASS(7);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

XEvent			ev;
Window			w;
Window			w1;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion ButtonPress-8.(B)");
	report_assertion("When a ButtonPress event is delivered and the source window");
	report_assertion("is an inferior of the event window and the source window is");
	report_assertion("a child of the event window, then subwindow is set to the");
	report_assertion("source window.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a window.");
	report_strategy("  Select ButtonPress events on that window.");
	report_strategy("  Create a child of that window.");
	report_strategy("  Simulate a ButtonPress event on the child.");
	report_strategy("  Verify that a ButtonPress event was delivered to the parent. ");
	report_strategy("  Verify that the subwindow component was the child of the event window.");

	tpstartup();
	if(noext(1))
		return;

	w = defwin(Dsp);
	w1 = crechild(Dsp, w, (struct area *) NULL);
	XSelectInput(Dsp, w, ButtonPressMask);	
	warppointer(Dsp, w1, 1,1);

	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	
	if (XCheckWindowEvent(Dsp, w, ButtonPressMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(ButtonPress));
		FAIL;
	} else {
		CHECK;
		if(ev.xbutton.subwindow != w1) {
			report("The subwindow component of the %s event was not set correctly.", eventname(ButtonPress));
			FAIL;
		} else 
			CHECK;
	}

	CHECKPASS(2);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Window			w;
Window			w1;
Window			w2;
XEvent			ev;
struct area		area;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion ButtonPress-9.(B)");
	report_assertion("When a ButtonPress event is delivered and the source window");
	report_assertion("is an inferior of the event window and the source window is");
	report_assertion("not a child of the event window, then subwindow is set to");
	report_assertion("the child of the event window that is an ancestor of the");
	report_assertion("source window.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a window.");
	report_strategy("  Select ButtonPress events on that window.");
	report_strategy("  Create a child of that window.");
	report_strategy("  Create a child of the child.");
	report_strategy("  Simulate a ButtonPress event on the youngest child.");
	report_strategy("  Verify that a ButtonPress event was generated on the oldest parent.  ");
	report_strategy("  Verify that the subwindow component was the child of the event window.");

	tpstartup();
	if (noext(1))
		return;

        w = defwin(Dsp);
	setarea(&area, 10, 10, 30, 30);
	w1 = crechild(Dsp, w, &area);
	w2 = crechild(Dsp, w1, &area);
	warppointer(Dsp, w2, 1,1);
	XSelectInput(Dsp, w, ButtonPressMask);

	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	
	if (XCheckWindowEvent(Dsp, w, ButtonPressMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(ButtonPress));
		FAIL;
	} else {
		CHECK;
		if(ev.xbutton.subwindow != w1) {
			report("The subwindow component of the %s event was not set correctly.", eventname(ButtonPress));
			FAIL;
		} else 
			CHECK;

	}

	CHECKPASS(2);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Window			w;
Window			w2;
XEvent			ev;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion ButtonPress-10.(B)");
	report_assertion("When a ButtonPress event is delivered and the source window");
	report_assertion("is not an inferior of the event window, then subwindow is");
	report_assertion("set to None.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a window.");
	report_strategy("  Select ButtonPress events on that window.");
	report_strategy("  Simulate a ButtonPress event on the window.");
	report_strategy("  Verify that a ButtonPress event was generated.");
	report_strategy("  Verify that the subwindow component was None.");
	report_strategy("  Create a window.");
	report_strategy("  Grab the pointer with owner_events set to False.");
	report_strategy("  Simulate a ButtonPress event on the window.");
	report_strategy("  Verify that a ButtonPress event was generated on the grabbing window.");
	report_strategy("  Verify that the subwindow component was None.");

	tpstartup();
	if (noext(1))
		return;

        w = defwin(Dsp);

	warppointer(Dsp, w, 1,1);
	XSelectInput(Dsp, w, ButtonPressMask);

	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	
	if (XCheckWindowEvent(Dsp, w, ButtonPressMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(ButtonPress));
		FAIL;
	} else {
		CHECK;
		if(ev.xbutton.subwindow != None) {
			report("The subwindow component of the %s event was not set correctly.", eventname(ButtonPress));
			FAIL;
		} else 
			CHECK;
	}

	w2 = defwin(Dsp);

	if( XGrabPointer(Dsp, w, False, ButtonPressMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime) != GrabSuccess) {
		delete("XGrabPointer() did not return GrabSuccess.");
		return;
	} else
		CHECK;

	warppointer(Dsp, w2, 1,1);
	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	
	if (XCheckWindowEvent(Dsp, w, ButtonPressMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(ButtonPress));
		FAIL;
	} else {
		CHECK;
		if(ev.xbutton.subwindow != None) {
			report("The subwindow component of the %s event was not set correctly.", eventname(ButtonPress));
			FAIL;
		} else 
			CHECK;
	}

	XUngrabPointer(Dsp, CurrentTime);

	CHECKPASS(5);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

Window			w;
Window			w2;
XEvent			ev;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion ButtonPress-11.(D)");
	report_assertion("If multiple screens are supported: When a ButtonPress event");
	report_assertion("is delivered and the event and root windows are not on the");
	report_assertion("same screen, then x and y are set to zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If multiple screens are supported:");
	report_strategy("  If extended testing is required:");
	report_strategy("    Create a window.");
	report_strategy("    Select ButtonPress events on that window.");
	report_strategy("    Create a window on the alternate screen.");
	report_strategy("    Grab the pointer with owner_events set to False.");
	report_strategy("    Simulate a ButtonPress event on the window.");
	report_strategy("    Verify that a ButtonPress event was generated on the grabbing window.");
	report_strategy("    Verify that the x and y  components are set to zero.");

	tpstartup();
/* Report unsupported if multiple screens are not supported. */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	} else
		CHECK;

	if(noext(1))
		return;

        w = defwin(Dsp);
	
	warppointer(Dsp, w, 1,1);
	XSelectInput(Dsp, w, ButtonPressMask);
	
	w2 = defdraw(Dsp, VI_ALT_WIN);
	
	if( XGrabPointer(Dsp, w, False, ButtonPressMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime) != GrabSuccess) {
		delete("XGrabPointer() did not return GrabSuccess.");
		return;
	} else
		CHECK;
	
	warppointer(Dsp, w2, 1,1);
	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	
	if (XCheckWindowEvent(Dsp, w, ButtonPressMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(ButtonPress));
		FAIL;
	} else {
		CHECK;
		if(ev.xbutton.x != 0 || ev.xbutton.y != 0) {
			report("The x and y components of the %s event were not set correctly.", eventname(ButtonPress));
			FAIL;
		} else 
			CHECK;
	}
	
	XUngrabPointer(Dsp, CurrentTime);
	
	CHECKPASS(4);

	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Window			w;
Window			w2;
XEvent			ev;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion ButtonPress-12.(D)");
	report_assertion("If multiple screens are supported: When a ButtonPress event");
	report_assertion("is delivered and the event and root windows are not on the");
	report_assertion("same screen, then same_screen is set to False.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If multiple screens are supported:");
	report_strategy("  If extended testing is required:");
	report_strategy("    Create a window.");
	report_strategy("    Select ButtonPress events on that window.");
	report_strategy("    Create a window on the alternate screen.");
	report_strategy("    Grab the pointer with owner_events set to False.");
	report_strategy("    Simulate a ButtonPress event on the window.");
	report_strategy("    Verify that a ButtonPress event was generated on the grabbing window.");
	report_strategy("    Verify that the same_screen component is set to zero.");

	tpstartup();
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	} else
		CHECK;

	if(noext(1))
		return;

        w = defwin(Dsp);
	
	warppointer(Dsp, w, 1,1);
	XSelectInput(Dsp, w, ButtonPressMask);
	
	w2 = defdraw(Dsp, VI_ALT_WIN);
	
	if( XGrabPointer(Dsp, w, False, ButtonPressMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime) != GrabSuccess) {
		delete("XGrabPointer() did not return GrabSuccess.");
		return;
	} else
		CHECK;
	
	warppointer(Dsp, w2, 1,1);
	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	
	if (XCheckWindowEvent(Dsp, w, ButtonPressMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(ButtonPress));
		FAIL;
	} else {
		CHECK;
		if(ev.xbutton.same_screen != False ) {
			report("The same_screen component of the %s event was not set correctly.", eventname(ButtonPress));
			FAIL;
		} else 
			CHECK;
	}
	
	XUngrabPointer(Dsp, CurrentTime);
	
	CHECKPASS(4);
	restoredevstate();
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
