/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XSendExtensionEvent(display, device, w, propagate, count, event_list, event_send)
 *   Display *display;
 *   XDevice *device;
 *   Window w;
 *   Bool propagate;
 *   int count;
 *   XEventClass *event_list;
 *   XEvent	*event_send;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSendExtensionEvent	1
char    *TestName = "XSendExtensionEvent";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XSendExtensionEvent function
 */
static Display *display;
static XDevice *device;
static Window w;
static Bool propagate;
static int count;
static XEventClass *event_list;
static XEvent	*event_send;


static int 	StatusReturn;

#define XInputNumEvents 15
extern ExtDeviceInfo Devs;
extern	int	nclass, nevent, event_types[];
extern XEventClass classes[];
extern XInputFirstEvent;
/*
 * Can not use "xcall" because it empties the event queue.
 */
#define	_xcall_(rvalue)	\
		_startcall(display);\
		((XAnyEvent *) event_send)->send_event = False;\
		rvalue = XSendExtensionEvent(display, device, w, propagate, count, event_list,event_send);\
		_endcall(display)
static XEvent _event;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	w = (Window) 0xffffffff;
	propagate = False;
	count = 1;
	event_list = 0;
	event_send = &_event;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int	i;
Window	w;
XAnyEvent *event;
XEvent	event_return;
int	return_value;
XEventClass noextensioneventclass;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSendExtensionEvent-1.(B)");
	report_assertion("A call to XSendExtensionEvent sends event_send to window w.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Discard all events in the event queue.");
	report_strategy("Call XSendExtensionEvent to send a KeyPress event to creator of window.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received.");
	report_strategy("Verify that send_event was not set to False.");
	report_strategy("Repeat for each event-type.");

	tpstartup();
	setargs();
/* Create window. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	NoExtensionEvent(device, unused, noextensioneventclass);
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
	propagate = False;
	event_list = &noextensioneventclass;
	event = (XAnyEvent *) &event_return;
	for (i = 0; i < nevent; i++) {

/* Discard all events in the event queue. */
		XSync(display, True);

/* Call XSendExtensionEvent to send a KeyPress event to creator of window. */
		event_send->type = event_types[i];
		_xcall_(return_value);

/* Verify that XSendExtensionEvent returned non-zero. */
		if (return_value == 0) {
			report("Returned zero, expected non-zero.");
			FAIL;
		}
		else
			CHECK;

/* Verify that event was received. */
		XSync(display, False);
		if (XCheckTypedEvent(display, event_send->type, &event_return) == False) {
			report("Expected event (%s) not received.", eventname(event_send->type));
			FAIL;
			continue;
		}
		else
			CHECK;

/* Verify that send_event was not set to False. */
		if (event->send_event == False) {
			report("send_event not set to True");
			FAIL;
		}
		else
			CHECK;

/* Repeat for each event-type. */
	}
	CHECKPASS(3*nevent);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
Window	ptrwin;
XAnyEvent *event;
XEvent	event_return;
int	return_value;
int root_x, root_y;	/* pointer location after XSendExtensionEvent */
int oroot_x, oroot_y;	/* pointer location before XSendExtensionEvent */
int sroot_x, sroot_y;	/* initial pointer location */
Window oldroot;		/* initial root window */
int itmp;		/* useless XQueryPointer return values */
unsigned int uitmp;	/* useless XQueryPointer return values */
Window wtmp;		/* useless XQueryPointer return values */
int dbp;
XEventClass dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSendExtensionEvent-2.(B)");
	report_assertion("When w is PointerWindow, then the destination window is");
	report_assertion("the window that contains the pointer.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Select KeyPress-type events on window.");
	report_strategy("Grab server.");
	report_strategy("Enable synchronization.");
	report_strategy("Save initial pointer location.");
	report_strategy("Warp pointer to window.");
	report_strategy("Get new pointer location.");
	report_strategy("Discard all events in the event queue.");
	report_strategy("Call XSendExtensionEvent to send a KeyPress event to window containing pointer.");
	report_strategy("Get current pointer location.");
	report_strategy("Check to see if pointer moved.");
	report_strategy("Warp pointer back to where it started.");
	report_strategy("Disable synchronization.");
	report_strategy("Ungrab server.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received.");
	report_strategy("Verify that send_event was not set to False.");

	tpstartup();
	setargs();
/* Create window. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(Devs.Button, dbp, dbpc);
	resetvinf(VI_WIN);
	nextvinf(&vp);
	ptrwin = makewin(display, vp);
/* Select KeyPress-type events on window. */
	XSelectExtensionEvent(display, ptrwin, &dbpc, 1);
/* Grab server. */
	XGrabServer(display);
/* Enable synchronization. */
	XSynchronize(display, True);
/* Save initial pointer location. */
	XQueryPointer(display, ptrwin, &oldroot, &wtmp, &sroot_x, &sroot_y, &itmp, &itmp, &uitmp);
/* Warp pointer to window. */
	XWarpPointer(display, None, ptrwin, 0, 0, 0, 0, 0, 0);
/* Get new pointer location. */
	if (XQueryPointer(display, ptrwin, &wtmp, &wtmp, &oroot_x, &oroot_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer on wrong root.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	} else
		CHECK;
/* Discard all events in the event queue. */
	XSync(display, True);
/* Call XSendExtensionEvent to send a KeyPress event to window containing pointer. */
	w = (Window) PointerWindow;
	propagate = False;
	event_list = &dbpc;
	event_send->type = dbp;
	_xcall_(return_value);
/* Get current pointer location. */
	if (XQueryPointer(display, ptrwin, &wtmp, &wtmp, &root_x, &root_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer moved.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	}
	else
		CHECK;
/* Check to see if pointer moved. */
	if (oroot_x != root_x || oroot_y != root_y) {
		delete("Pointer moved.");
		/*
		 * if this is ever changed to be a return, take care to
		 * also turn off synchronization and ungrab the server...
		 */
	}
	else
		CHECK;
/* Warp pointer back to where it started. */
	XWarpPointer(display, None, oldroot, 0, 0, 0, 0, sroot_x, sroot_y);
/* Disable synchronization. */
	XSynchronize(display, False);
/* Ungrab server. */
	XUngrabServer(display);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received. */
	XSync(display, False);
	if (XCheckTypedEvent(display, event_send->type, &event_return) == False) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display	*client2;
XVisualInfo *vp;
Window	parent;
Window	child;
XAnyEvent *event;
XEvent	event_return;
int	return_value;
int root_x, root_y;	/* pointer location after XSendExtensionEvent */
int oroot_x, oroot_y;	/* pointer location before XSendExtensionEvent */
int sroot_x, sroot_y;	/* initial pointer location */
Window oldroot;		/* initial root window */
int itmp;		/* useless XQueryPointer return values */
unsigned int uitmp;	/* useless XQueryPointer return values */
Window wtmp;		/* useless XQueryPointer return values */
unsigned int width;
unsigned int height;
struct area a;
int dbp;
XEventClass dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSendExtensionEvent-3.(B)");
	report_assertion("When w is InputFocus and an inferior of the focus window");
	report_assertion("contains the pointer, then the destination window is that");
	report_assertion("inferior.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create client2.");
	report_strategy("Create parent window.");
	report_strategy("Create inferior window.");
	report_strategy("Select KeyPress-type events on parent window with client2.");
	report_strategy("Flush client2 requests.");
	report_strategy("Select KeyPress-type events on child window.");
	report_strategy("Grab server.");
	report_strategy("Enable synchronization.");
	report_strategy("Set input focus to parent window.");
	report_strategy("Save initial pointer location.");
	report_strategy("Warp pointer to inferior of focus window.");
	report_strategy("Get new pointer location.");
	report_strategy("Discard all events in the event queue.");
	report_strategy("Call XSendExtensionEvent to send a KeyPress event to inferior of the focus window.");
	report_strategy("Get current pointer location.");
	report_strategy("Check to see if pointer moved.");
	report_strategy("Warp pointer back to where it started.");
	report_strategy("Disable synchronization.");
	report_strategy("Ungrab server.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received for inferior of focus window.");
	report_strategy("Verify that send_event was not set to False.");
	report_strategy("Verify that event was not received for focus window.");

	tpstartup();
	setargs();
/* Create client2. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(Devs.Button, dbp, dbpc);
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can't create new client.");
		return;
	}
	else
		CHECK;
/* Create parent window. */
	resetvinf(VI_WIN);
	nextvinf(&vp);
	parent = makewin(display, vp);
/* Create inferior window. */
	getsize(display, (Drawable) parent, &width, &height);
	a.x = 0;
	a.y = 0;
	a.width = width/2;
	a.height = height/2;
	child = crechild(display, parent, &a);
/* Select KeyPress-type events on parent window with client2. */
	XSelectExtensionEvent(client2, parent, &dbpc, 1);
/* Flush client2 requests. */
	XFlush(client2);
/* Select KeyPress-type events on child window. */
	XSelectExtensionEvent(display, child, &dbpc, 1);
/* Grab server. */
	XGrabServer(display);
/* Enable synchronization. */
	XSynchronize(display, True);
/* Set input focus to parent window. */
	XSetDeviceFocus(display, device, parent, RevertToPointerRoot, CurrentTime);
/* Save initial pointer location. */
	XQueryPointer(display, child, &oldroot, &wtmp, &sroot_x, &sroot_y, &itmp, &itmp, &uitmp);
/* Warp pointer to inferior of focus window. */
	XWarpPointer(display, None, child, 0, 0, 0, 0, 0, 0);

/* Get new pointer location. */
	if (XQueryPointer(display, child, &wtmp, &wtmp, &oroot_x, &oroot_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer on wrong root.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	} else
		CHECK;
/* Discard all events in the event queue. */
	XSync(display, True);
/* Call XSendExtensionEvent to send a KeyPress event to inferior of the focus window. */
	w = (Window) InputFocus;
	propagate = False;
	event_list = &dbpc;
	event_send->type = dbp;
	((XAnyEvent *) event_send)->window = child;
	_xcall_(return_value);
/* Get current pointer location. */
	if (XQueryPointer(display, child, &wtmp, &wtmp, &root_x, &root_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer moved.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	}
	else
		CHECK;
/* Check to see if pointer moved. */
	if (oroot_x != root_x || oroot_y != root_y) {
		delete("Pointer moved.");
		/*
		 * if this is ever changed to be a return, take care to
		 * also turn off synchronization and ungrab the server...
		 */
	}
	else
		CHECK;
/* Warp pointer back to where it started. */
	XWarpPointer(display, None, oldroot, 0, 0, 0, 0, sroot_x, sroot_y);
/* Disable synchronization. */
	XSynchronize(display, False);
/* Ungrab server. */
	XUngrabServer(display);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received for inferior of focus window. */
	XSync(display, False);
	if (XCheckTypedWindowEvent(display, child, event_send->type, &event_return) == False) {
		report("Expected event (%s) on inferior not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was not received for focus window. */
	XSync(client2, False);
	if (XCheckTypedWindowEvent(client2, child, event_send->type, &event_return) != False) {
		report("Focus window received event.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(8);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo *vp;
Window	nfocus;
XAnyEvent *event;
XEvent	event_return;
int	return_value;
int	dbp;
XEventClass dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSendExtensionEvent-4.(B)");
	report_assertion("When w is InputFocus and an inferior of the focus window");
	report_assertion("does not contain the pointer, then the destination window is");
	report_assertion("the focus window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Select KeyPress-type events on new focus window.");
	report_strategy("Set input focus to new focus window.");
	report_strategy("Discard all events in the event queue.");
	report_strategy("Call XSendExtensionEvent to send a KeyPress event to inferior of the focus window.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received for inferior of focus window.");
	report_strategy("Verify that send_event was not set to False.");

	tpstartup();
	setargs();
/* Create window. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(Devs.Button, dbp, dbpc);
	resetvinf(VI_WIN);
	nextvinf(&vp);
	nfocus = makewin(display, vp);
/* Select KeyPress-type events on new focus window. */
	XSelectExtensionEvent(display, nfocus, &dbpc, 1);
/* Set input focus to new focus window. */
	XSetDeviceFocus(display, device, nfocus, RevertToPointerRoot, CurrentTime);
/* Discard all events in the event queue. */
	XSync(display, True);
/* Call XSendExtensionEvent to send a KeyPress event to inferior of the focus window. */
	w = (Window) InputFocus;
	propagate = False;
	event_list = &dbpc;
	event_send->type = dbp;
	((XAnyEvent *) event_send)->window = nfocus;
	_xcall_(return_value);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received for inferior of focus window. */
	XSync(display, False);
	if (XCheckTypedWindowEvent(display, nfocus, event_send->type, &event_return) == False) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){


 	report_purpose(5);

	report_assertion("Assertion XSendExtensionEvent-5.(-)");
	report_assertion("When event_list is set to noextensioneventclass then a call");
	report_assertion("to XSendExtensionEvent results in event_send being sent to");
	report_assertion("the client that created the destination window.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t006(){

Display	*client2 = NULL;
int	return_value;
int dbp;
XEventClass dbpc, noextensioneventclass;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSendExtensionEvent-6.(B)");
	report_assertion("When event_list is set to noextensioneventclass and the");
	report_assertion("client that created the destination window w no longer");
	report_assertion("exists, then no event is sent.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create client2.");
	report_strategy("Call XSetCloseDownMode with RetainPermanent for client2.");
	report_strategy("Create window for client2.");
	report_strategy("Call XCloseDisplay for client2.");
	report_strategy("Select ALLEVENTS on window.");
	report_strategy("Call XSendExtensionEvent to send event to window.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that no events were received.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	NoExtensionEvent(device, unused, noextensioneventclass);
	DeviceButtonPress(Devs.Button, dbp, dbpc);
/* Create client2. */

	/* We must disable resource registration here to prevent attempted
	   deallocation of closed connections and deleted resources. */
	regdisable(); 

	if (config.display)
		client2 = XOpenDisplay(config.display);
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		regenable();
		return;
	}
	else
		CHECK;
/* Call XSetCloseDownMode with RetainPermanent for client2. */
	XSetCloseDownMode(client2, RetainPermanent);
/* Create window for client2. */
	w = mkwin(client2, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Call XCloseDisplay for client2. */
	XCloseDisplay(client2);

	/* re-enable resource registration */
	regenable();

/* Select ALLEVENTS on window. */
	XSelectExtensionEvent(display, w, classes, nclass);
/* Call XSendExtensionEvent to send event to window. */
	propagate = False;
	event_list = &noextensioneventclass;
	event_send->type = dbp;
	_xcall_(return_value);
/* Verify that XSendExtensionEvent returned non-zero. */
	XSync(display, False);
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were received. */
	if (XPending(display) > 0) {
		XEvent	event;

		XNextEvent(display, &event);
		report("Event(s) delivered unexpectedly (%s)", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XVisualInfo *vp;
XEvent	event_return;
int	return_value;
int dbp;
XEventClass dbpc, noextensioneventclass;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSendExtensionEvent-7.(B)");
	report_assertion("When event_list is not set to noextensioneventclass and no");
	report_assertion("clients have selected on the destination window and");
	report_assertion("propagate is False, then a call to XSendExtensionEvent");
	report_assertion("results in no event being sent.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Select no events on window.");
	report_strategy("Set propagate to False.");
	report_strategy("Set event_list to something other than noextensioneventclass.");
	report_strategy("Discard all events in the event queue.");
	report_strategy("Call XSendExtensionEvent.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that no events were received.");

	tpstartup();
	setargs();
/* Create window. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	NoExtensionEvent(device, unused, noextensioneventclass);
	DeviceButtonPress(device, dbp, dbpc);
	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select no events on window. */
	XSelectExtensionEvent(display, w, &noextensioneventclass, 1);
	XSync(display, True);
/* Set propagate to False. */
	propagate = False;
/* Set event_list to something other than NULL */
	count = 1;
	event_list = &dbpc;
/* Discard all events in the event queue. */
	XSync(display, True);
/* Call XSendExtensionEvent. */
	event_send->type = dbp;
	((XAnyEvent *) event_send)->window = w;
	_xcall_(return_value);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were received. */
	XSync(display, False);
	if (XCheckTypedWindowEvent(display, w, event_send->type, &event_return) != False) {
		report("Unexpected event (%s) received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Winh	*grandparent;
Winh	*parent;
Winh	*child;
XSetWindowAttributes attrs;
int	return_value;
int dbp;
XEventClass dbpc, noextensioneventclass;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSendExtensionEvent-8.(B)");
	report_assertion("When event_list is not set to noextensioneventclass and no");
	report_assertion("clients have selected on the destination w and propagate is");
	report_assertion("True and there is no matching ancestor of the destination w");
	report_assertion("for which no intervening window has that type in its");
	report_assertion("do-not-propagate-mask, then a call to XSendExtensionEvent");
	report_assertion("results in no event being sent.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create a window hierarchy.");
	report_strategy("Create a hierarchy member with KeyPressMask set in do_not_propagate_mask.");
	report_strategy("Create a child of this member without setting do_not_propagate_mask.");
	report_strategy("Create the hierarchy.");
	report_strategy("Select no events on the destination w.");
	report_strategy("Select for KeyPress on the grandparent window of this member.");
	report_strategy("Set w to the window corresponding to child node.");
	report_strategy("Set propagate to True.");
	report_strategy("Set event_list to KeyPressMask.");
	report_strategy("Set event type to KeyPress.");
	report_strategy("Call XSendExtensionEvent.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that no events were received.");
	report_strategy("Select for no events on the grandparent window of this member.");
	report_strategy("Call XSendExtensionEvent.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that no events were received.");
	report_strategy("Change the do_not_propagate_mask from KeyPressMask to noextensioneventclass.");
	report_strategy("Call XSendExtensionEvent.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that no events were received.");

	tpstartup();
	setargs();
/* Create a window hierarchy. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(Devs.Button, dbp, dbpc);
	NoExtensionEvent(device, unused, noextensioneventclass);
	grandparent = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (grandparent == (Winh *) NULL) {
		delete("Could not create grandparent");
		return;
	}
	else
		CHECK;
/* Create a hierarchy member with KeyPressMask set in do_not_propagate_mask. */
	attrs.do_not_propagate_mask = KeyPressMask;
	parent = winh_adopt(display, grandparent, CWDontPropagate, &attrs, (Winhg *) NULL, WINH_NOMASK);
	if (parent == (Winh *) NULL) {
		delete("Could not create parent");
		return;
	}
	else
		CHECK;
/* Create a child of this member without setting do_not_propagate_mask. */
	child = winh_adopt(display, parent, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (child == (Winh *) NULL) {
		delete("Could not create child");
		return;
	}
	else
		CHECK;
/* Create the hierarchy. */
	if (winh_create(display, (Winh *) NULL, WINH_NOMASK)) {
		return;
	}
	else
		CHECK;
	XSync(display, True);
/* Select no events on the destination w. */
	XChangeDeviceDontPropagateList (display, parent->window, 1, &dbpc, AddToList);
	if (XSelectExtensionEvent(display, child->window, &noextensioneventclass, 1))
		return;
	else
		CHECK;
/* Select no events on the parent of w. */
	if (XSelectExtensionEvent(display, parent->window, &noextensioneventclass, 1))
		return;
	else
		CHECK;
/* Select for devicebuttonPress on the grandparent window of this member. */
	if (XSelectExtensionEvent(display, grandparent->window, &dbpc, 1))
		return;
	else
		CHECK;
	XSync(display, True);
/* Set w to the window corresponding to child node. */
	w = child->window;
/* Set propagate to True. */
	propagate = True;
/* Set event_list to KeyPressMask. */
	event_list = &dbpc;
	count = 1;
/* Set event type to KeyPress. */
	event_send->type = dbp;
/* Call XSendExtensionEvent. */
	_xcall_(return_value);
	XSync(display, False);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were received. */
	if (XPending(display) > 0) {
		XEvent	event;

		XNextEvent(display, &event);
		report("Event(s) delivered unexpectedly (%s) through do_not_propagate_mask", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
/* Select for no events on the grandparent window of this member. */
	if (XSelectExtensionEvent(display, grandparent->window, &noextensioneventclass, 1))
		return;
	else
		CHECK;
	XSync(display, True);
/* Call XSendExtensionEvent. */
	_xcall_(return_value);
	XSync(display, False);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were received. */
	if (XPending(display) > 0) {
		XEvent	event;

		XNextEvent(display, &event);
		report("Event(s) delivered unexpectedly (%s) while none selected and do_not_propagate_mask on", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
/* Change the do_not_propagate_mask from KeyPressMask to noextensioneventclass.*/
	if (XChangeDeviceDontPropagateList (display, parent->window, 1, &dbpc, DeleteFromList))
		return;
	else
		CHECK;
	XSync(display, True);
/* Call XSendExtensionEvent. */
	_xcall_(return_value);
	XSync(display, False);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were received. */
	if (XPending(display) > 0) {
		XEvent	event;

		XNextEvent(display, &event);
		report("Event(s) delivered unexpectedly (%s) with none selected", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(15);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Display	*client2;
XVisualInfo *vp;
Window	parent;
Window	child;
int	return_value;
int root_x, root_y;	/* pointer location after XSendExtensionEvent */
int oroot_x, oroot_y;	/* pointer location before XSendExtensionEvent */
int sroot_x, sroot_y;	/* initial pointer location */
Window oldroot;		/* initial root window */
int itmp;		/* useless XQueryPointer return values */
unsigned int uitmp;	/* useless XQueryPointer return values */
Window wtmp;		/* useless XQueryPointer return values */
unsigned int width;
unsigned int height;
struct area a;
int dbp;
XEventClass noextensioneventclass, dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XSendExtensionEvent-9.(B)");
	report_assertion("When event_list is not set to noextensioneventclass and w");
	report_assertion("is set to InputFocus and an inferior of the focus window");
	report_assertion("contains the pointer and no clients have selected on that");
	report_assertion("inferior, then a call to XSendExtensionEvent results in no");
	report_assertion("event being sent.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create client2.");
	report_strategy("Create parent window.");
	report_strategy("Create inferior window.");
	report_strategy("Select KeyPress-type events on parent window with client2.");
	report_strategy("Flush client2 requests.");
	report_strategy("Select no events on child window.");
	report_strategy("Grab server.");
	report_strategy("Enable synchronization.");
	report_strategy("Set input focus to parent window.");
	report_strategy("Save initial pointer location.");
	report_strategy("Warp pointer to inferior of focus window.");
	report_strategy("Get new pointer location.");
	report_strategy("Discard all events in the event queue.");
	report_strategy("Call XSendExtensionEvent to send a KeyPress event to inferior of the focus window.");
	report_strategy("Get current pointer location.");
	report_strategy("Check to see if pointer moved.");
	report_strategy("Warp pointer back to where it started.");
	report_strategy("Disable synchronization.");
	report_strategy("Ungrab server.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that no event was received for focus window.");
	report_strategy("Verify that event was not received for client2.");

	tpstartup();
	setargs();
/* Create client2. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpc);
	NoExtensionEvent(device, unused, noextensioneventclass);
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can't create new client.");
		return;
	}
	else
		CHECK;
/* Create parent window. */
	resetvinf(VI_WIN);
	nextvinf(&vp);
	parent = makewin(display, vp);
/* Create inferior window. */
	getsize(display, (Drawable) parent, &width, &height);
	a.x = 0;
	a.y = 0;
	a.width = width/2;
	a.height = height/2;
	child = crechild(display, parent, &a);
/* Select KeyPress-type events on parent window with client2. */
	XSelectExtensionEvent(client2, parent, &noextensioneventclass, 1);
/* Flush client2 requests. */
	XFlush(client2);
/* Select no events on child window. */
	XSelectExtensionEvent(display, child, &noextensioneventclass, 1);
/* Grab server. */
	XGrabServer(display);
/* Enable synchronization. */
	XSynchronize(display, True);
/* Set input focus to parent window. */
	XSetDeviceFocus(display, Devs.Button, parent, RevertToPointerRoot, CurrentTime);
/* Save initial pointer location. */
	XQueryPointer(display, child, &oldroot, &wtmp, &sroot_x, &sroot_y, &itmp, &itmp, &uitmp);
/* Warp pointer to inferior of focus window. */
	XWarpPointer(display, None, child, 0, 0, 0, 0, 0, 0);

/* Get new pointer location. */
	if (XQueryPointer(display, child, &wtmp, &wtmp, &oroot_x, &oroot_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer on wrong root.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	} else
		CHECK;
/* Discard all events in the event queue. */
	XSync(display, True);
/* Call XSendExtensionEvent to send a KeyPress event to inferior of the focus window. */
	w = (Window) InputFocus;
	propagate = False;
	count = 1;
	event_list = &dbpc;
	event_send->type = dbp;
	((XAnyEvent *) event_send)->window = child;
	_xcall_(return_value);
/* Get current pointer location. */
	if (XQueryPointer(display, child, &wtmp, &wtmp, &root_x, &root_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer moved.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	}
	else
		CHECK;
/* Check to see if pointer moved. */
	if (oroot_x != root_x || oroot_y != root_y) {
		delete("Pointer moved.");
		/*
		 * if this is ever changed to be a return, take care to
		 * also turn off synchronization and ungrab the server...
		 */
	}
	else
		CHECK;
/* Warp pointer back to where it started. */
	XWarpPointer(display, None, oldroot, 0, 0, 0, 0, sroot_x, sroot_y);
/* Disable synchronization. */
	XSynchronize(display, False);
/* Ungrab server. */
	XUngrabServer(display);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
	XSync(display, False);
	XSync(client2, False);
/* Verify that no event was received for focus window. */
	if (XPending(display) > 0) {
		XEvent	event;

		XNextEvent(display, &event);
		report("Event(s) delivered unexpectedly (%s) to focus window", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
/* Verify that event was not received for client2. */
	if (XPending(client2) > 0) {
		XEvent	event;

		XNextEvent(client2, &event);
		report("Event(s) delivered unexpectedly (%s)", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

XVisualInfo *vp;
Window	nfocus;
int	return_value;
int root_x, root_y;	/* pointer location after XSendExtensionEvent */
int oroot_x, oroot_y;	/* pointer location before XSendExtensionEvent */
int sroot_x, sroot_y;	/* initial pointer location */
Window oldroot;		/* initial root window */
int itmp;		/* useless XQueryPointer return values */
unsigned int uitmp;	/* useless XQueryPointer return values */
Window wtmp;		/* useless XQueryPointer return values */
int dbp;
XEventClass noextensioneventclass, dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XSendExtensionEvent-10.(B)");
	report_assertion("When event_list is not set to noextensioneventclass and w");
	report_assertion("is set to InputFocus and an inferior of the focus window");
	report_assertion("does not contain the pointer and no clients have selected on");
	report_assertion("the focus window, then a call to XSendExtensionEvent results");
	report_assertion("in no event being sent.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Grab server.");
	report_strategy("Enable synchronization.");
	report_strategy("Set input focus to new focus window.");
	report_strategy("Save initial pointer location.");
	report_strategy("Warp pointer away from inferior of focus window; to root.");
	report_strategy("Get new pointer location.");
	report_strategy("Select no events on new focus window.");
	report_strategy("Discard all events in the event queue.");
	report_strategy("Call XSendExtensionEvent with propagate == False, w == InputFocus & event_list == ");
	report_strategy("devicebuttonpressclass.");
	report_strategy("Get current pointer location.");
	report_strategy("Check to see if pointer moved.");
	report_strategy("Warp pointer back to where it started.");
	report_strategy("Disable synchronization.");
	report_strategy("Ungrab server.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that no event was received.");
	report_strategy("Grab server.");
	report_strategy("Enable synchronization.");
	report_strategy("Set input focus to new focus window.");
	report_strategy("Save initial pointer location.");
	report_strategy("Warp pointer away from inferior of focus window; to root.");
	report_strategy("Get new pointer location.");
	report_strategy("Call XSendExtensionEvent again with propagate set to True.");
	report_strategy("Get current pointer location.");
	report_strategy("Check to see if pointer moved.");
	report_strategy("Warp pointer back to where it started.");
	report_strategy("Disable synchronization.");
	report_strategy("Ungrab server.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that no event was received.");

	tpstartup();
	setargs();
/* Create window. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpc);
	NoExtensionEvent(device, unused, noextensioneventclass);
	resetvinf(VI_WIN);
	nextvinf(&vp);
	nfocus = makewin(display, vp);
/* Grab server. */
	XGrabServer(display);
/* Enable synchronization. */
	XSynchronize(display, True);
/* Set input focus to new focus window. */
	XSetInputFocus(display, nfocus, RevertToPointerRoot, CurrentTime);
/* Save initial pointer location. */
	XQueryPointer(display, nfocus, &oldroot, &wtmp, &sroot_x, &sroot_y, &itmp, &itmp, &uitmp);
/* Warp pointer away from inferior of focus window; to root. */
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);

/* Get new pointer location. */
	if (XQueryPointer(display, nfocus, &wtmp, &wtmp, &oroot_x, &oroot_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer on wrong root.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	} else
		CHECK;
/* Select no events on new focus window. */
	XSelectExtensionEvent(display, nfocus, &noextensioneventclass, 1);
/* Discard all events in the event queue. */
	XSync(display, True);
	w = (Window) InputFocus;
	event_list = &dbpc;
	event_send->type = dbp;
	((XAnyEvent *) event_send)->window = nfocus;
	propagate = False;
/* Call xname with propagate == False, w == InputFocus & event_list == 
   devicebuttonpressclass. */
	_xcall_(return_value);
/* Get current pointer location. */
	if (XQueryPointer(display, nfocus, &wtmp, &wtmp, &root_x, &root_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer moved.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	}
	else
		CHECK;
/* Check to see if pointer moved. */
	if (oroot_x != root_x || oroot_y != root_y) {
		delete("Pointer moved.");
		/*
		 * if this is ever changed to be a return, take care to
		 * also turn off synchronization and ungrab the server...
		 */
	}
	else
		CHECK;
/* Warp pointer back to where it started. */
	XWarpPointer(display, None, oldroot, 0, 0, 0, 0, sroot_x, sroot_y);
/* Disable synchronization. */
	XSynchronize(display, False);
/* Ungrab server. */
	XUngrabServer(display);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
	XSync(display, False);
/* Verify that no event was received. */
	XSync(display, False);
	if (XPending(display) > 0) {
		XEvent	event;

		XNextEvent(display, &event);
		report("Event(s) delivered unexpectedly (%s)", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
/* Grab server. */
	XGrabServer(display);
/* Enable synchronization. */
	XSynchronize(display, True);
/* Set input focus to new focus window. */
	XSetInputFocus(display, nfocus, RevertToPointerRoot, CurrentTime);
/* Save initial pointer location. */
	XQueryPointer(display, nfocus, &oldroot, &wtmp, &sroot_x, &sroot_y, &itmp, &itmp, &uitmp);
/* Warp pointer away from inferior of focus window; to root. */
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);

/* Get new pointer location. */
	if (XQueryPointer(display, nfocus, &wtmp, &wtmp, &oroot_x, &oroot_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer on wrong root.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	} else
		CHECK;
/* Call XSendExtensionEvent again with propagate set to True. */
	propagate = True;
	_xcall_(return_value);
/* Get current pointer location. */
	if (XQueryPointer(display, nfocus, &wtmp, &wtmp, &root_x, &root_y, &itmp, &itmp, &uitmp) == False) {
		delete("Pointer moved.");
		XSynchronize(display, False);
		XUngrabServer(display);
		return;
	}
	else
		CHECK;
/* Check to see if pointer moved. */
	if (oroot_x != root_x || oroot_y != root_y) {
		delete("Pointer moved.");
		/*
		 * if this is ever changed to be a return, take care to
		 * also turn off synchronization and ungrab the server...
		 */
	}
	else
		CHECK;
/* Warp pointer back to where it started. */
	XWarpPointer(display, None, oldroot, 0, 0, 0, 0, sroot_x, sroot_y);
/* Disable synchronization. */
	XSynchronize(display, False);
/* Ungrab server. */
	XUngrabServer(display);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
	XSync(display, False);
/* Verify that no event was received. */
	XSync(display, False);
	if (XPending(display) > 0) {
		XEvent	event;

		XNextEvent(display, &event);
		report("Event(s) delivered unexpectedly (%s)", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

Display	*client2;
Winh	*grandparent;
Winh	*parent;
Winh	*child;
int	return_value;
XEvent	event_return;
XAnyEvent *event;
int dbp;
XEventClass noextensioneventclass, dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XSendExtensionEvent-11.(B)");
	report_assertion("When event_list is not set to noextensioneventclass and no");
	report_assertion("clients have selected on the destination w and propagate is");
	report_assertion("True and there is a matching ancestor of the destination w");
	report_assertion("for which no intervening window has that type in its");
	report_assertion("do-not-propagate-mask and that ancestor is an ancestor of");
	report_assertion("the focus window and InputFocus was not specified as the");
	report_assertion("destination, then a call to XSendExtensionEvent results in");
	report_assertion("the event being sent to all clients selecting a type in");
	report_assertion("event_list on the first matching ancestor.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set event_list to devicebuttonpressclass;");
	report_strategy("Set propagate to True.");
	report_strategy("Create window hierarchy with depth of three and with all windows");
	report_strategy("have no bits set in their do-not-propagate-mask.");
	report_strategy("Set focus window to window mid-level in window hierarchy.");
	report_strategy("Set w to window at bottom of window hierarchy.");
	report_strategy("Create client2.");
	report_strategy("Select no events on w.");
	report_strategy("Select no events on w with client2.");
	report_strategy("Select KeyPress events on top-level window in window hierarchy.");
	report_strategy("Select KeyPress events on top-level window in window hierarchy");
	report_strategy("with client2.");
	report_strategy("Call XSendExtensionEvent to send a KeyPress event to w.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received for top-level window in window hierarchy.");
	report_strategy("Verify that send_event was not set to False.");
	report_strategy("Verify that event was received for top-level window in window hierarchy");
	report_strategy("for client2.");
	report_strategy("Verify that send_event was not set to False for client2.");

	tpstartup();
	setargs();
/* Set event_list to devicebuttonpressclass. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpc);
	NoExtensionEvent(device, unused, noextensioneventclass);
	event_list = &dbpc;
/* Set propagate to True. */
	propagate = True;
/* Create window hierarchy with depth of three and with all windows */
/* have no bits set in their do-not-propagate-mask. */
	grandparent = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (grandparent == (Winh *) NULL) {
		delete("Could not create grandparent");
		return;
	}
	else
		CHECK;
	parent = winh_adopt(display, grandparent, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (parent == (Winh *) NULL) {
		delete("Could not create parent");
		return;
	}
	else
		CHECK;
	child = winh_adopt(display, parent, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (child == (Winh *) NULL) {
		delete("Could not create child");
		return;
	}
	else
		CHECK;
	if (winh_create(display, (Winh *) NULL, WINH_MAP)) {
		return;
	}
	else
		CHECK;
/* Set focus window to window mid-level in window hierarchy. */
	XSetInputFocus(display, parent->window, RevertToPointerRoot, CurrentTime);
/* Set w to window at bottom of window hierarchy. */
	w = child->window;
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can't create new client.");
		return;
	}
	else
		CHECK;
/* Select no events on w. */
	if(XSelectExtensionEvent(display, child->window, &noextensioneventclass, 1)){
		return;
	}
	else
		CHECK;
/* Select no events on w with client2. */
	if(XSelectExtensionEvent(client2, child->window, &noextensioneventclass, 1)){
		return;
	}
	else
		CHECK;
/* Select KeyPress events on top-level window in window hierarchy. */
	if(XSelectExtensionEvent(display, grandparent->window, &dbpc, 1)){
		return;
	}
	else
		CHECK;
/* Select KeyPress events on top-level window in window hierarchy */
/* with client2. */
	if(XSelectExtensionEvent(client2, grandparent->window, &dbpc, 1)){
		return;
	}
	else
		CHECK;
	XSync(display, True);
	XSync(client2, True);
/* Call XSendExtensionEvent to send a KeyPress event to w. */
	count = 1;
	event_list = &dbpc;
	event_send->type = dbp;
	((XAnyEvent *) event_send)->window = grandparent->window;
	_xcall_(return_value);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received for top-level window in window hierarchy. */
	XSync(display, False);
	if (XCheckTypedWindowEvent(display, grandparent->window, event_send->type, &event_return) != True) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received for top-level window in window hierarchy */
/* for client2. */
	XSync(client2, False);
	if (XCheckTypedWindowEvent(client2, grandparent->window, event_send->type, &event_return) != True) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False for client2. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(14);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Display	*client2;
Winh	*grandparent;
Winh	*parent;
Winh	*child;
int	return_value;
XEvent	event_return;
XAnyEvent *event;
int dbp;
XEventClass noextensioneventclass, dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XSendExtensionEvent-12.(B)");
	report_assertion("When event_list is not set to noextensioneventclass and no");
	report_assertion("clients have selected on the destination w and propagate is");
	report_assertion("True and there is a matching ancestor of the destination w");
	report_assertion("for which no intervening window has that type in its");
	report_assertion("do-not-propagate-mask and this ancestor is not an ancestor");
	report_assertion("of the focus window, then a call to XSendExtensionEvent");
	report_assertion("results in the event being sent to all clients selecting a");
	report_assertion("type in event_list on the first matching ancestor.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set event_list to devicebuttonpressclass.");
	report_strategy("Set propagate to True.");
	report_strategy("Create window hierarchy with depth of three and with all windows");
	report_strategy("have no bits set in their do-not-propagate-mask.");
	report_strategy("Set focus window to top window in window hierarchy.");
	report_strategy("Set w to window at bottom of window hierarchy.");
	report_strategy("Create client2.");
	report_strategy("Select no events on w.");
	report_strategy("Select no events on w with client2.");
	report_strategy("Select KeyPress events on mid-level window in window hierarchy.");
	report_strategy("Select KeyPress events on mid-level window in window hierarchy");
	report_strategy("with client2.");
	report_strategy("Call XSendExtensionEvent to send a KeyPress event to w.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received for mid-level window in window hierarchy.");
	report_strategy("Verify that send_event was not set to False.");
	report_strategy("Verify that event was received for mid-level window in window hierarchy");
	report_strategy("for client2.");
	report_strategy("Verify that send_event was not set to False for client2.");

	tpstartup();
	setargs();
/* Set event_list to devicebuttonpressclass.*/
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpc);
	NoExtensionEvent(device, unused, noextensioneventclass);
	count = 1;
	event_list = &dbpc;
/* Set propagate to True. */
	propagate = True;
/* Create window hierarchy with depth of three and with all windows */
/* have no bits set in their do-not-propagate-mask. */
	grandparent = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (grandparent == (Winh *) NULL) {
		delete("Could not create grandparent");
		return;
	}
	else
		CHECK;
	parent = winh_adopt(display, grandparent, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (parent == (Winh *) NULL) {
		delete("Could not create parent");
		return;
	}
	else
		CHECK;
	child = winh_adopt(display, parent, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (child == (Winh *) NULL) {
		delete("Could not create child");
		return;
	}
	else
		CHECK;
	if (winh_create(display, (Winh *) NULL, WINH_MAP)) {
		return;
	}
	else
		CHECK;
/* Set focus window to top window in window hierarchy. */
	XSetDeviceFocus(display, Devs.Button, grandparent->window, RevertToPointerRoot, CurrentTime);
/* Set w to window at bottom of window hierarchy. */
	w = child->window;
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can't create new client.");
		return;
	}
	else
		CHECK;
/* Select no events on w. */
	if(XSelectExtensionEvent(display, child->window, &noextensioneventclass, 1)){
		return;
	}
	else
		CHECK;
/* Select no events on w with client2. */
	if(XSelectExtensionEvent(client2, child->window, &noextensioneventclass, 1)){
		return;
	}
	else
		CHECK;
/* Select KeyPress events on mid-level window in window hierarchy. */
	if(XSelectExtensionEvent(display, parent->window, &dbpc, 1)){
		return;
	}
	else
		CHECK;
/* Select KeyPress events on mid-level window in window hierarchy */
/* with client2. */
	if(XSelectExtensionEvent(client2, parent->window, &dbpc, 1)){
		return;
	}
	else
		CHECK;
	XSync(display, True);
	XSync(client2, True);
/* Call XSendExtensionEvent to send a KeyPress event to w. */
	count = 1;
	event_list = &dbpc;
	event_send->type = dbp;
	((XAnyEvent *) event_send)->window = parent->window;
	_xcall_(return_value);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received for mid-level window in window hierarchy. */
	XSync(display, False);
	if (XCheckTypedWindowEvent(display, parent->window, event_send->type, &event_return) != True) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received for mid-level window in window hierarchy */
/* for client2. */
	XSync(client2, False);
	if (XCheckTypedWindowEvent(client2, parent->window, event_send->type, &event_return) != True) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False for client2. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(14);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

Display	*client2;
Window	w2;
int	status;
XAnyEvent *event;
XEvent	event_return;
int	return_value;
int devicemotionnotify, dbp;
XEventClass devicemotionnotifyclass, dbpc;
XEventClass classes[2];
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XSendExtensionEvent-13.(B)");
	report_assertion("A call to XSendExtensionEvent ignores active grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Select ALLEVENTS on this window.");
	report_strategy("Set propagate to False.");
	report_strategy("Create client2.");
	report_strategy("Create window with client2.");
	report_strategy("Grab the pointer with client2 using client2's window as the grab window,");
	report_strategy("owner_events set to False, event_list set to PointerMotionMask,");
	report_strategy("pointer_mode set to GrabModeSync, and keyboard_mode set to GrabModeSync.");
	report_strategy("Verify that XGrabPointer returned GrabSuccess.");
	report_strategy("Grab AnyButton with client2 using client2's window as the grab window,");
	report_strategy("owner_events set to False, event_list set to ButtonPressMask,");
	report_strategy("pointer_mode set to GrabModeSync, and keyboard_mode set to GrabModeSync.");
	report_strategy("Grab the keyboard with client2 using client2's window as the grab window,");
	report_strategy("owner_events set to False, pointer_mode set to GrabModeSync,");
	report_strategy("and keyboard_mode set to GrabModeSync.");
	report_strategy("Verify that XGrabKeyboard returned GrabSuccess.");
	report_strategy("Set event_list to PointerMotionMask.");
	report_strategy("Flush display, discarding events.");
	report_strategy("Flush client2, discarding events.");
	report_strategy("Call XSendExtensionEvent to send a MotionNotify event.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Flush display, not discarding events.");
	report_strategy("Flush client2, not discarding events.");
	report_strategy("Verify that event was received.");
	report_strategy("Verify that send_event was not set to False.");
	report_strategy("Verify that client2 received no events.");
	report_strategy("Set event_list to ButtonPressMask.");
	report_strategy("Flush display, discarding events.");
	report_strategy("Flush client2, discarding events.");
	report_strategy("Call XSendExtensionEvent to send a ButtonPress event.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Flush display, not discarding events.");
	report_strategy("Flush client2, not discarding events.");
	report_strategy("Verify that event was received.");
	report_strategy("Verify that send_event was not set to False.");
	report_strategy("Verify that client2 received no events.");
	report_strategy("Set event_list to KeyPressMask.");
	report_strategy("Flush display, discarding events.");
	report_strategy("Flush client2, discarding events.");
	report_strategy("Call XSendExtensionEvent to send a KeyPress event.");
	report_strategy("Flush display, not discarding events.");
	report_strategy("Flush client2, not discarding events.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received.");
	report_strategy("Verify that send_event was not set to False.");
	report_strategy("Verify that client2 received no events.");
	report_strategy("Ungrab the keyboard with client2.");
	report_strategy("Ungrab buttons with client2.");
	report_strategy("Ungrab the pointer with client2.");

	tpstartup();
	setargs();
/* Create window. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpc);
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
	((XAnyEvent *) event_send)->window = w;
/* Select ALLEVENTS on this window. */
	DeviceMotionNotify(device,devicemotionnotify, devicemotionnotifyclass);
	classes[0] = devicemotionnotifyclass;
	classes[1] = dbpc;
	XSelectExtensionEvent(display, w, classes, 2);
/* Set propagate to False. */
	propagate = False;
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can't create new client.");
		return;
	}
	else
		CHECK;
/* Create window with client2. */
	w2 = mkwin(client2, (XVisualInfo *) NULL, (struct area *) NULL, True);
/* Grab the pointer with client2 using */
/* client2's window as the grab window, */
/* owner_events set to False, */
/* event_list set to PointerMotionMask, */
/* pointer_mode set to GrabModeSync, */
/* and keyboard_mode set to GrabModeSync. */
	status = XGrabPointer(client2, w2, False, PointerMotionMask, GrabModeSync, GrabModeSync, None, None, CurrentTime);
/* Verify that XGrabPointer returned GrabSuccess. */
	if (status != GrabSuccess) {
		delete("Can't grab pointer (%d).", status);
		return;
	}
	else
		CHECK;
/* Grab AnyButton with client2 using */
/* client2's window as the grab window, */
/* owner_events set to False, */
/* event_list set to ButtonPressMask, */
/* pointer_mode set to GrabModeSync, */
/* and keyboard_mode set to GrabModeSync. */
	XGrabButton(client2, AnyButton, AnyModifier, w2, False, ButtonPressMask, GrabModeSync, GrabModeSync, None, None);
/* Grab the keyboard with client2 using */
/* client2's window as the grab window, */
/* owner_events set to False, */
/* pointer_mode set to GrabModeSync, */
/* and keyboard_mode set to GrabModeSync. */
	status = XGrabKeyboard(client2, w2, False, GrabModeSync, GrabModeSync, CurrentTime);
/* Verify that XGrabKeyboard returned GrabSuccess. */
	if (status != GrabSuccess) {
		delete("Can't grab keyboard (%d).", status);
		return;
	}
	else
		CHECK;
/* Set event_mask to PointerMotionMask. */
	event_list = &devicemotionnotifyclass;
	event_send->type = devicemotionnotify;
/* Flush display, discarding events. */
	XSync(display, True);
/* Flush client2, discarding events. */
	XSync(client2, True);
/* Call XSendExtensionEvent to send a MotionNotify event. */
	_xcall_(return_value);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Flush display, not discarding events. */
	XSync(display, False);
/* Flush client2, not discarding events. */
	XSync(client2, False);
/* Verify that event was received. */
	if (XCheckTypedWindowEvent(display, w, event_send->type, &event_return) == False) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received no events. */
	status = XPending(client2);
	if (status != 0) {
		report("Client2 received %d events, expected %d", status, 0);
		FAIL;
	}
	else
		CHECK;
/* Set event_mask to ButtonPressMask. */
	event_list = &dbpc;
	event_send->type = dbp;
/* Flush display, discarding events. */
	XSync(display, True);
/* Flush client2, discarding events. */
	XSync(client2, True);
/* Call XSendExtensionEvent to send a ButtonPress event. */
	_xcall_(return_value);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Flush display, not discarding events. */
	XSync(display, False);
/* Flush client2, not discarding events. */
	XSync(client2, False);
/* Verify that event was received. */
	if (XCheckTypedWindowEvent(display, w, event_send->type, &event_return) == False) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received no events. */
	status = XPending(client2);
	if (status != 0) {
		report("Client2 received %d events, expected %d", status, 0);
		FAIL;
	}
	else
		CHECK;
/* Set event_mask to KeyPressMask. */
	event_list = &dbpc;
	event_send->type = dbp;
/* Flush display, discarding events. */
	XSync(display, True);
/* Flush client2, discarding events. */
	XSync(client2, True);
/* Call XSendExtensionEvent to send a KeyPress event. */
	_xcall_(return_value);
/* Flush display, not discarding events. */
	XSync(display, False);
/* Flush client2, not discarding events. */
	XSync(client2, False);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received. */
	if (XCheckTypedWindowEvent(display, w, event_send->type, &event_return) == False) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
	}
	else
		CHECK;
/* Verify that send_event was not set to False. */
	event = (XAnyEvent *) &event_return;
	if (event->send_event == False) {
		report("send_event not set to True");
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received no events. */
	status = XPending(client2);
	if (status != 0) {
		report("Client2 received %d events, expected %d", status, 0);
		FAIL;
	}
	else
		CHECK;
/* Ungrab the keyboard with client2. */
	XUngrabKeyboard(client2, CurrentTime);
/* Ungrab buttons with client2. */
	XUngrabButton(client2, AnyButton, AnyModifier, w2);
/* Ungrab the pointer with client2. */
	XUngrabPointer(client2, CurrentTime);
	CHECKPASS(15);
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int	i;
XAnyEvent *event;
XEvent	event_return;
int	return_value;
int cdn, dmn, dsn;
XEventClass noextensioneventclass, cdnc, dmnc, dsnc;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XSendExtensionEvent-14.(B)");
	report_assertion("On a call to XSendExtensionEvent the only fields in the");
	report_assertion("forwarded event which are changed are the send_event and");
	report_assertion("serial fields.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Set type member of event to KeyPress.");
	report_strategy("Set serial member of event to 0.");
	report_strategy("Set send_event member of event to False.");
	report_strategy("Ignore display member of event, as it's filled in by Xlib.");
	report_strategy("Set window member of event to 0xffffffff.");
	report_strategy("Discard all events in the event queue.");
	report_strategy("Call XSendExtensionEvent to send event to creator of window.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received.");
	report_strategy("Verify that type was set to KeyPress.");
	report_strategy("Verify that serial was not set to 0.");
	report_strategy("Verify that send_event was not set to False.");
	report_strategy("Check display member of event was filled in by Xlib properly.");
	report_strategy("Verify that window was set to 0.");
	report_strategy("Repeat for each event-type.");

	tpstartup();
	setargs();
/* Create window. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	ChangeDeviceNotify(Devs.Button, cdn, cdnc);
	DeviceMappingNotify(Devs.Button, dmn, dmnc);
	DeviceStateNotify(Devs.Button, dsn, dsnc);
	NoExtensionEvent(device, unused, noextensioneventclass);
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
	propagate = False;
	count=1;
	event_list = &noextensioneventclass;
	event = (XAnyEvent *) &event_return;
	for (i = 0; i < nevent; i++) {
		char *en = eventname(event_types[i]);

/* Set type member of event to KeyPress. */
		event_send->type = event_types[i];

/* Set serial member of event to 0. */
		event_send->xany.serial = 0;

/* Set send_event member of event to False. */
		event_send->xany.send_event = False;

/* Ignore display member of event, as it's filled in by Xlib. */
		event_send->xany.display = (Display *) NULL;

/* Set window member of event to 0xffffffff. */
		event_send->xany.window = (Window) 0xffffffff;

/* Discard all events in the event queue. */
		XSync(display, True);

/* Call XSendExtensionEvent to send event to creator of window. */
		_xcall_(return_value);

/* Verify that XSendExtensionEvent returned non-zero. */
		if (return_value == 0) {
			report("%s: Returned zero, expected non-zero.",en);
			FAIL;
		}
		else
			CHECK;

/* Verify that event was received. */
		XSync(display, False);
		if (XPending(display) == 0) {
			report("%s: No events received.",en);
			FAIL;
			continue;
		}
		else
			CHECK;
		if (XCheckTypedEvent(display, event_send->type, &event_return) == False) {
			report("Expected event (%s) not received.", en);
			FAIL;
			continue;
		}
		else
			CHECK;

/* Verify that type was set to KeyPress. */
		if (event->type != event_types[i]) {
			report("type set to %s, expected %s", eventname(event->type), en);
			FAIL;
		}
		else
			CHECK;

/* Verify that serial was not set to 0. */
		if (event->serial == 0) {
			report("%s: serial set to zero, expected non-zero",en);
			FAIL;
		}
		else
			CHECK;

/* Verify that send_event was not set to False. */
		if (event->send_event == False) {
			report("%s: send_event not set to True", en);
			FAIL;
		}
		else
			CHECK;

/* Check display member of event was filled in by Xlib properly. */
		if (event->display != display) {
			report("%s: display not set to my display", en);
			FAIL;
		}
		else
			CHECK;

/* Verify that window was set to 0. */
		if (event->window != (Window) 0xffffffff &&
			 event->type != dmn &&
			 event->type != cdn &&
			 event->type != dsn) {
			report("%s: window set to 0x%x, expected 0x%x", en, event->window, (Window) 0xffffffff);
			FAIL;
		}
		else
			CHECK;

/* Repeat for each event-type. */
	}
	CHECKPASS(8*nevent);
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){


 	report_purpose(15);

	report_assertion("Assertion XSendExtensionEvent-15.(-)");
	report_assertion("On a call to XSendExtensionEvent the send_event field in");
	report_assertion("the forwarded event is set to True.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t016(){

int	correctserial;
XAnyEvent *event;
XEvent	event_return;
int	return_value;
int dbp;
XEventClass noextensioneventclass, dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XSendExtensionEvent-16.(B)");
	report_assertion("On a call to XSendExtensionEvent the serial field in the");
	report_assertion("forwarded event is set correctly.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Set serial to zero.");
	report_strategy("Call NextRequest to get correct serial.");
	report_strategy("Call XSendExtensionEvent.");
	report_strategy("Verify that XSendExtensionEvent returned non-zero.");
	report_strategy("Verify that event was received.");
	report_strategy("Verify that serial in delivered event is set correctly.");

	tpstartup();
	setargs();
/* Create window. */
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	/* Force the extension version to be initialized.  Otherwise, the call
	   to XSendExtensionEvent will result in two calls, one to 
	   XGetExtensionVersion and another to XSendExtensionEvent. */

	XGetExtensionVersion(display,"XInputExtension");
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpc);
	NoExtensionEvent(device, unused, noextensioneventclass);
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
	propagate = False;
	count = 1;
	event_list = &noextensioneventclass;
/* Set serial to zero. */
	event = (XAnyEvent *) event_send;
	event->serial = 0;
	event_send->type = dbp;
/* Call NextRequest to get correct serial. */
	XSync(display,0);
	correctserial = NextRequest(display);
/* Call XSendExtensionEvent. */
	_xcall_(return_value);
/* Verify that XSendExtensionEvent returned non-zero. */
	if (return_value == 0) {
		report("Returned zero, expected non-zero.");
		FAIL;
	}
	else
		CHECK;
/* Verify that event was received. */
	XFlush(display);
	XSync(display, False);
	if (XPending(display) == 0) {
		report("No events received.");
		FAIL;
		return;
	}
	else
		CHECK;
	if (XCheckTypedEvent(display, event_send->type, &event_return) == False) {
		report("Expected event (%s) not received.", eventname(event_send->type));
		FAIL;
		return;
	}
	else
		CHECK;
/* Verify that serial in delivered event is set correctly. */
	event = (XAnyEvent *) &event_return;
	if (event->serial != correctserial) {
		report("Serial set to %d, expected %d", event->serial, correctserial);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int	i;
int	n;
int	return_value;
int	good_event_types[XInputNumEvents];
long	bad_event_types[NM_LEN+2];
XEventClass noextensioneventclass;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XSendExtensionEvent-17.(B)");
	report_assertion("When the event in event_send is not one of the core events");
	report_assertion("or one of the events defined by an extension, then either");
	report_assertion("XSendExtensionEvent returns zero or a BadValue error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Use notmember() to get some bad event types.");
	report_strategy("Make sure this list also includes 0 and 1 which are specifically for errors and replies.");
	report_strategy("Call XSendExtensionEvent to send bad event type.");
	report_strategy("Verify that XSendExtensionEvent either returned zero and no error occurs,");
	report_strategy("	or returned non-zero and a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	NoExtensionEvent(device, unused, noextensioneventclass);
	propagate = False;
	event_list = &noextensioneventclass;

/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);

/* Use notmember() to get some bad event types. */
	for(i=0; i<XInputNumEvents; i++)
	    good_event_types[i]=XInputFirstEvent+i;
	n = notmember(good_event_types, XInputNumEvents, &bad_event_types[2]);

/* Make sure this list also includes 0 and 1 which are specifically for errors and replies. */
	n += 2;
	bad_event_types[0] = 0;
	bad_event_types[1] = 1;
	for (i = 0; i < n; i++) {

/* Call XSendExtensionEvent to send bad event type. */
		event_send->type = bad_event_types[i];
		trace("Using known bad event type %d.", event_send->type);
		startcall(display);
		if (isdeleted())
			return;
		return_value = XSendExtensionEvent(display, device, w, propagate, count, event_list, event_send);
		endcall(display);

/* Verify that XSendExtensionEvent either returned zero and no error occurs, */
/* 	or returned non-zero and a BadValue error occurs. */
		if (return_value == 0) {
			if(geterr() != Success) {
				FAIL;
				report("%s returned zero, but got %s when expecting no error.",
					TestName, errorname(geterr()));
			} else {
				trace("%s returned zero and no error", TestName);
				CHECK;
			}
		} else {
			if (geterr() != BadValue) {
				FAIL;
				report("%s returned non-zero, but got %s when expecting %s",
					TestName, errorname(geterr()), errorname(BadValue));
			} else {
				trace("%s returned non-zero and BadValue", TestName);
				CHECK;
			}
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

int	dbp, return_value;
XEventClass dbpc;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XSendExtensionEvent-18.(B)");
	report_assertion("When a window argument does not name a valid window, then a");
	report_assertion("BadWindow error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Initialise the event structure for the call.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpc);
	event_list = &dbpc;
	seterrdef();

/* Create a bad window by creating and destroying a window. */
	w = badwin(display);

/* Initialise the event structure for the call. */
	propagate = False;
	event_send->type = dbp;

/* Call xname using bad window as the window argument.*/
	startcall(display);
	if (isdeleted())
		return;
	return_value = XSendExtensionEvent(display, device, w, propagate, count, event_list, event_send);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (return_value == 0) {
		FAIL;
		report("%s returned zero, expecting a non-zero result.",
			TestName);
	} else
		CHECK;

/* Verify that a BadWindow error occurs. */
	if (geterr() == BadWindow)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

int baddevice;
int	 dbp;
XEventClass dbpc;
XDevice bogus;
int	return_value;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XSendExtensionEvent-19.(B)");
	report_assertion("When a device argument does not name a valid device, then a");
	report_assertion("baddevice error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify a bad device.");
	report_strategy("Initialise the event structure for the call.");
	report_strategy("Verify that a baddevice error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	DeviceButtonPress(Devs.Button, dbp, dbpc);
	event_list = &dbpc;
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
	BadDevice(display,baddevice);
	bogus.device_id = -1;
	device = &bogus;
	seterrdef();

/* Initialise the event structure for the call. */
	propagate = False;
	event_send->type = dbp;

	startcall(display);
	if (isdeleted())
		return;
	return_value = XSendExtensionEvent(display, device, w, propagate, count, event_list, event_send);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}
	if (return_value == 0) {
		FAIL;
		report("%s returned zero, expecting a non-zero result.",
			TestName);
	} else
		CHECK;

/* Verify that a baddevice error occurs. */
	if (geterr() == baddevice)
		CHECK;
	else
		FAIL;
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

int badclass;
int	dbp;
XEventClass bogus=-1, dbpc;
int	return_value;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XSendExtensionEvent-20.(B)");
	report_assertion("When an eventclass argument does not name a valid device,");
	report_assertion("then a badclass error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify a bad event class;");
	report_strategy("Initialise the event structure for the call.");
	report_strategy("Verify that a badclass error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	BadClass(display,badclass);
	device = Devs.Button;
	DeviceButtonPress(device, dbp, dbpc);
	seterrdef();
	event_list = &bogus;

/* Initialise the event structure for the call. */
	propagate = False;
	event_send->type = dbp;

/* Call xname using bad window as the window argument.*/
	startcall(display);
	if (isdeleted())
		return;
	return_value = XSendExtensionEvent(display, device, w, propagate, count, event_list, event_send);
	endcall(display);
	if (geterr() != badclass) {
		report("Got %s, Expecting badclass", errorname(geterr()));
		FAIL;
	}
	if (return_value == 0) {
		FAIL;
		report("%s returned zero, expecting a non-zero result.",
			TestName);
	} else
		CHECK;

/* Verify that a badclass error occurs. */
	if (geterr() == badclass)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = focusstartup;
void	(*tet_cleanup)() = focuscleanup;
