/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtWarning()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

int flag = 0;

/*
** Installed Warning handler
*/
void XtWMH_Proc(str)
String str;
{
	avs_set_event(1, avs_get_event(1)+1);
	tet_infoline("TEST: String passed to handler");
	if (strstr(str, "Hello World") == NULL) {
		sprintf(ebuf, "ERROR: Expected string passed to handler to contain \"Hello World\", is \"%s\"", str);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}


#define T_XtWarning	1
char    *TestName = "XtWarning";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char msg[1024];
char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;
int invoked;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtWarning-1.(A)");
	report_assertion("A call to void XtWarning(message) shall invoke the warning");
	report_assertion("handler installed for the calling process, passing message");
	report_assertion("as an argument to it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_xt_hier("Twarning1", "XtWarning");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register XtWMH_Proc as warning handler");
	XtSetWarningHandler(XtWMH_Proc);
	tet_infoline("TEST: Call XtWarning");
	XtWarning("Hello World");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler was invoked");
	invoked = avs_get_event(1);
        check_dec(1, invoked , "Warning handler invovocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3244 */
/* End of included file Mdefcode.tmc.3244 */

/* Including from file Mdefcode.tmc.3244 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtWarning-2.(B)");
	report_assertion("When a user warning handler has not been installed for the");
	report_assertion("calling process a call to void XtWarning(message) shall");
	report_assertion("invoke the default warning handler provided by the");
	report_assertion("Intrinsics.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3244 */

static void t003(){

char msg[1024];
char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtWarning-3.(C)");
	report_assertion("If the implementation is POSIX-based: The default warning");
	report_assertion("handler invoked by a call to void XtWarning(message) shall");
	report_assertion("print the message message to the standard error of the");
	report_assertion("calling process and return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

if (config.posix_system != 0) {
	FORK(pid2);
	avs_xt_hier("Twarning2", "XtWarning");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get the file name to store warning message");
	strcpy(msg, "/tmp/");
	strcat(msg, "outfile");
	sprintf(ebuf, "TEST: Call XtWarning");
	tet_infoline(ebuf);
	push_stderr("outfile", "w");
	XtWarning("Hello World");
	pop_stderr();
	tet_infoline("PREP: Open the temporary file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not written");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not written");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	tet_infoline("TEST: Message is correct");
	string = (char *)strstr(line, "Hello World");
	strncpy(buf, string, strlen("Hello World"));
	if (strncmp("Hello World", buf, strlen("Hello World")) != 0 ) {
		sprintf(ebuf, "ERROR: Expected \"Hello World\" Received \"%s\"", buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Unlink the file");
	fclose(stream);
	unlink(msg);
	LKROF(pid2, AVSXTTIMEOUT-2);
	unlink(msg);
	tet_result(TET_PASS);
} else {
	tet_infoline("INFO: Not configured as a POSIX system");
	tet_result(TET_UNSUPPORTED);
}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3244 */
/* End of included file Mdefcode.tmc.3244 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
