/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtProcessEvent()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
Widget labelw_msg;

extern char *event_names[];

XtInputId input_ret;
char *msg = "Hello World";
int acount = 0;
FILE *fid;
char *data = "data1";

/*
** Procedure XtIOP_Proc
*/
void XtIOP_Proc2(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	avs_set_event(3,1);
}
/*
** Procedure XtEVT_Proc
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	if (event->type == ButtonPress) {
		avs_set_event(1,1);
		exit(0);
	}
	else {
		sprintf(ebuf, "ERROR: Expected ButtonPress event Received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
void XtEVT_Proc2(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	if (event->type == ButtonPress) {
		avs_set_event(1,1);
	}
	else {
		sprintf(ebuf, "ERROR: Expected ButtonPress event Received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(outfile(data), "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register file as an input source");
	input_ret = XtAddInput(fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc2, (XtPointer)msg);
}
void XtEVT_Proc3(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
XKeyEvent *tevent;

	tevent = (XKeyEvent *)event;

	tet_infoline("TEST: Event timestamp returned by XtLastTimestampProcessed");
	if (tevent->time != XtLastTimestampProcessed(XtDisplay(w))) {
		sprintf(ebuf, "ERROR: event->time = %ld, XtLastTimestampProcessed returned %ld", (unsigned long)tevent->time, (unsigned long)XtLastTimestampProcessed(XtDisplay(w)));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (event->type == ButtonPress )
		avs_set_event(1, 1); 
	if (event->type == ButtonRelease )
		avs_set_event(2, 1); 
	if (event->type == KeyPress )
		avs_set_event(3, 1); 
	if (event->type == KeyRelease )
		avs_set_event(4, 1); 
}

void XtIOP_Proc(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	avs_set_event(3,avs_get_event(3)+1);
	exit(0);
}

void XtTMO2_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	avs_set_event(2,1);
	exit(0);
}
void XtTMO1_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}
void XtTMO_Proc5(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("PREP: Send events");
	send_event_time(labelw_msg, ButtonPress, ButtonPressMask, TRUE, 1);
	send_event_time(labelw_msg, ButtonRelease, ButtonReleaseMask, TRUE, 2);
	send_event_time(labelw_msg, KeyRelease, KeyReleaseMask, TRUE, 3);
	send_event_time(labelw_msg, KeyPress, KeyPressMask, TRUE, 4);
	send_event(rowcolw, ButtonRelease, ButtonReleaseMask, TRUE);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO1_Proc, topLevel);
}



#define T_XtProcessEvent	1
char    *TestName = "XtProcessEvent";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
#endif
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtProcessEvent-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to void XtProcessEvent(mask) when mask has only the");
	report_assertion("XtIMXEvent mask set, there is at least one pending X event");
	report_assertion("to be processed for the calling process, and the widget to");
	report_assertion("which the event is to be dispatched has no input method");
	report_assertion("registered for this event shall call the event handler for");
	report_assertion("this widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	FORK(pid2);
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event over wire to labelw_msg widget");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	display = XtDisplay(rowcolw);
	/*
	** ButtonRelease to call DestroyTree and cleanup
	*/
	send_event(rowcolw, ButtonRelease, ButtonReleaseMask, TRUE);
	for (i= 0; i == 0;) {
		XtProcessEvent(XtIMXEvent);
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Procedure XtEVT_Proc was invoked");
		invoked = avs_get_event(1);
		check_dec(1, invoked, "XtEVT_Proc invocation count");
		tet_result(TET_PASS);
	}
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

static void t002(){

#if XT_X_RELEASE == 4
char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
#endif
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtProcessEvent-2.(C)");
	report_assertion("If the implementation is X11R4: A successful call to void");
	report_assertion("XtProcessEvent(mask) when mask has only the XtIMXEvent mask");
	report_assertion("set and there is at least one pending X event to be");
	report_assertion("processed for the calling process shall call the event");
	report_assertion("handler for the widget to which the event is to be");
	report_assertion("dispatched.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE == 4
	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	FORK(pid2);
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event over wire to labelw_msg widget");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	display = XtDisplay(rowcolw);
	/*
	** ButtonRelease to call DestroyTree and cleanup
	*/
	send_event(rowcolw, ButtonRelease, ButtonReleaseMask, TRUE);
	for (i= 0; i == 0;) {
		XtProcessEvent(XtIMXEvent);
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Procedure XtEVT_Proc was invoked");
		invoked = avs_get_event(1);
		check_dec(1, invoked, "XtEVT_Proc invocation count");
		tet_result(TET_PASS);
	}
#else
	tet_infoline("INFO: Implementation is X11R4");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

static void t003(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtProcessEvent-3.(A)");
	report_assertion("A successful call to void XtProcessEvent(mask) when mask");
	report_assertion("has only the XtIMXEvent mask set, there is at least one");
	report_assertion("pending X event to be processed for the calling process, and");
	report_assertion("the widget to which the event is to be dispatched has no");
	report_assertion("event handler registered shall ignore the event.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	FORK(pid2);
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register XtEVT_Proc to handle ButtonPress to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Send KeyPress event over wire to labelw_msg widget");
	send_event(labelw_msg, KeyPress, KeyPressMask, TRUE);
	tet_infoline("PREP: Send ButtonPress event over wire to labelw_msg widget");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	send_event(rowcolw, ButtonRelease, ButtonReleaseMask, TRUE);
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO1_Proc, NULL);
	display = XtDisplay(rowcolw);
	for (i= 0; i == 0;) {
		XtProcessEvent(XtIMXEvent);
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Procedure XtEVT_Proc was invoked");
		invoked = avs_get_event(1);
		check_dec(1, invoked, "XtEVT_Proc invocation count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

static void t004(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtProcessEvent-4.(A)");
	report_assertion("A successful call to void XtProcessEvent(mask) when mask");
	report_assertion("has only the XtIMTimer mask set and there is at least one");
	report_assertion("pending timer to be processed for the calling process shall");
	report_assertion("call the callback procedure registered for the timer.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	FORK(pid2);
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO2_Proc, NULL);
	display = XtDisplay(rowcolw);
	XtProcessEvent(XtIMTimer);
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Timer procedure was invoked");
		invoked = avs_get_event(2);
		check_dec(1, invoked, "timeout procedure invocation count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

static void t005(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtProcessEvent-5.(A)");
	report_assertion("A successful call to void XtProcessEvent(mask) when mask");
	report_assertion("has only the XtIMAlternateInput mask set and there is at");
	report_assertion("least one pending input source to be processed for the");
	report_assertion("calling process shall call the callback procedure registered");
	report_assertion("for the input source.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(outfile(data), "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register file as an input source");
	input_ret = XtAddInput(fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	FORK(pid2);
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO1_Proc, NULL);
	display = XtDisplay(rowcolw);
	XtProcessEvent(XtIMAlternateInput);
	LKROF(pid2, AVSXTTIMEOUT-4);
	unlink(outfile(data));
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Input callback was invoked");
		invoked = avs_get_event(3);
		check_dec(1, invoked, "callback invocation count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

static void t006(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtProcessEvent-6.(A)");
	report_assertion("A successful call to void XtProcessEvent(mask) when mask is");
	report_assertion("the bitwise inclusive OR of any combination of XtIMXEvent,");
	report_assertion("XtIMTimer, and XtIMAlternateInput shall process any one");
	report_assertion("event or input of the specified types.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register XtEVT_Proc2 to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc2,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Send ButtonPress event over wire to labelw_msg widget");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("PREP: Register timeout procedure");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO2_Proc, NULL);
	FORK(pid2);
	for (i= 0; i == 0;) {
		XtProcessEvent(XtIMAlternateInput|XtIMXEvent|XtIMTimer);
	}
	LKROF(pid2, AVSXTTIMEOUT-4);
	unlink(outfile(data));
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Procedure XtEVT_Proc2 was invoked");
		invoked = avs_get_event(1);
		check_dec(1, invoked, "XtEVT_Proc2 invocation count");
		tet_infoline("TEST: Input callback was invoked");
		invoked = avs_get_event(3);
		check_dec(1, invoked, "callback invocation count");
		tet_infoline("TEST: Timer procedure was invoked");
		invoked = avs_get_event(2);
		check_dec(1, invoked, "timeout procedure invocation count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

static void t007(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtProcessEvent-7.(A)");
	report_assertion("A successful call to void XtProcessEvent(mask) when mask is");
	report_assertion("XtIMAll shall be equivalent to a call with mask set to a");
	report_assertion("bitwise inclusive OR of XtIMXEvent, XtIMTimer, and");
	report_assertion("XtIMAlternateInput.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register XtEVT_Proc2 to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc2,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Send ButtonPress event over wire to labelw_msg widget");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("PREP: Register timeout procedure");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO2_Proc, NULL);
	FORK(pid2);
	for (i= 0; i == 0;) {
		XtProcessEvent(XtIMAll);
	}
	LKROF(pid2, AVSXTTIMEOUT-4);
	unlink(outfile(data));
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Procedure XtEVT_Proc2 was invoked");
		invoked = avs_get_event(1);
		check_dec(1, invoked, "XtEVT_Proc2 invocation count");
		tet_infoline("TEST: Input callback was invoked");
		invoked = avs_get_event(3);
		check_dec(1, invoked, "callback invocation count");
		tet_infoline("TEST: Timer procedure was invoked");
		invoked = avs_get_event(2);
		check_dec(1, invoked, "timeout procedure invocation count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

static void t008(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtProcessEvent-8.(A)");
	report_assertion("A successful call to void XtProcessEvent(mask) when there");
	report_assertion("are no events or inputs of the specified types to be");
	report_assertion("processed shall block until an appropriate event or input is");
	report_assertion("available.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO2_Proc, NULL);
	FORK(pid2);
	for (i= 0; i == 0;) {
		XtProcessEvent(XtIMAll);
	}
	tet_infoline("ERROR: XtProcessEvent returned rqather than blocking");
	tet_result(TET_FAIL);
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Timeout procedure was invoked");
		invoked = avs_get_event(2);
		check_dec(1, invoked, "timeout procedure invocation count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

/* Including from file Mdefcode.tmc.3240 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtProcessEvent-9.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to void XtProcessEvent(mask) when mask has only the");
	report_assertion("XtIMXEvent mask set, there is at least one pending X event");
	report_assertion("to be processed for the calling process, and the widget to");
	report_assertion("which the event is to be dispatched has an input method for");
	report_assertion("this event shall not dispatch the event to the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3240 */

static void t010(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
Display *display;
XEvent loop_event;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtProcessEvent-10.(A)");
	report_assertion("When an event for a widget in the calling process is a");
	report_assertion("KeyPress, KeyRelease, ButtonPress, ButtonRelease,");
	report_assertion("MotionNotify, EnterNotify, LeaveNotify, PropertyNotify or a");
	report_assertion("SelectionClear event a call to void XtProcessEvent(mask)");
	report_assertion("shall record the timestamp from the event as the last");
	report_assertion("timestamp value that will be returned by the next call to");
	report_assertion("XtLastTimestampProcessed.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tprocevnt1", "XtProcessEvent");
	FORK(pid2);
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc3 to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask|ButtonReleaseMask|KeyPressMask|KeyReleaseMask,
		 False,
		 XtEVT_Proc3,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure which will cause event");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc5, topLevel);
	display = XtDisplay(rowcolw);
	for (i= 0; i == 0;) {
		XtProcessEvent(XtIMAll);
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Events were received");
		invoked = avs_get_event(1);
		check_dec(1, invoked, "Handler invocation for ButtonPress count");
		invoked = avs_get_event(2);
		check_dec(1, invoked, "Handler invocation for ButtonRelease count");
		invoked = avs_get_event(3);
		check_dec(1, invoked, "Handler invocation for KeyPress count");
		invoked = avs_get_event(4);
		check_dec(1, invoked, "Handler invocation for KeyRelease count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3240 */
/* End of included file Mdefcode.tmc.3240 */

/* Including from file Mdefcode.tmc.3240 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtProcessEvent-11.(D)");
	report_assertion("If the implementation is X11R5 or later: When an event in");
	report_assertion("the calling process is a remap event, a modal cascade exists");
	report_assertion("that has a widget with spring_loaded field set to True, and");
	report_assertion("no event input filter has been registered for the");
	report_assertion("spring-loaded widget window on the specified event a call to");
	report_assertion("void XtProcessEvent(mask) shall dispatch the event to the");
	report_assertion("spring-loaded widget after a dispatch to the widget to which");
	report_assertion("the event belonged.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3240 */

/* Including from file Mdefcode.tmc.3240 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtProcessEvent-12.(D)");
	report_assertion("If the implementation is X11R5 or later: When an event in");
	report_assertion("the calling process is a remap event, a modal cascade exists");
	report_assertion("that has a widget with spring_loaded field set to True, and");
	report_assertion("an event input filter has been registered for the");
	report_assertion("spring-loaded widget window on the specified event a call to");
	report_assertion("void XtProcessEvent(mask) shall not dispatch the event to");
	report_assertion("the spring-loaded widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3240 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
