/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtManageChild()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xaw/Label.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtWMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(1,1);
	exit(1);
}



#define T_XtManageChild	1
char    *TestName = "XtManageChild";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Boolean status;
Widget labelw_good;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtManageChild-1.(A)");
	report_assertion("A call to void XtManageChild(w) when widget w is not");
	report_assertion("realized and has the map_when_managed field set to True and");
	report_assertion("the parent of the widget is realized shall call the");
	report_assertion("change_managed procedure of the parent, realize the widget,");
	report_assertion("and map the widget window.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmngchild1", "XtManageChild");
	tet_infoline("PREP: Create a labelw_good widget");
	labelw_good = XtVaCreateWidget(
			"labelw_good",
			labelWidgetClass,
			boxw1,
			NULL
			);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Add widget labelw_good to parent's managed widget boxw1 list");
	XtManageChild(labelw_good);
	tet_infoline("TEST: labelw_good widget is managed shall return True");
	status = XtIsManaged(labelw_good);
	check_dec(True, status, "XtIsManaged return value");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2828 */
/* End of included file Mdefcode.tmc.2828 */

/* Including from file Mdefcode.tmc.2828 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtManageChild-2.(B)");
	report_assertion("On a successful call to void XtManageChild(w) when the");
	report_assertion("widget w has the map_when_managed field set to a value other");
	report_assertion("than True its window shall not be mapped.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2828 */

static void t003(){

Boolean status;
Widget labelw_good, labelw_good2;
pid_t pid2;
int invoked;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtManageChild-3.(A)");
	report_assertion("A call to void XtManageChild(w) when the parent of the");
	report_assertion("widget w does not belong to a subclass of");
	report_assertion("compositeWidgetClass shall issue an error.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmngchild3", "XtManageChild");
	XtAppSetErrorMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create test widgets");
	labelw_good = XtVaCreateWidget(
			"labelw_good",
			coreWidgetClass,
			boxw1,
			NULL
			);
	labelw_good2 = XtVaCreateWidget(
			"labelw_good2",
			coreWidgetClass,
			labelw_good,
			NULL
			);
	ConfigureDimension(topLevel, labelw_good);
	ConfigureDimension(topLevel, labelw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Manage a widget with non-composite parent");
	XtManageChild(labelw_good2);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Error handler was invoked");
	invoked = avs_get_event(1);
	if (!invoked) {
		sprintf(ebuf, "ERROR: Error handler was not invoked");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2828 */
/* End of included file Mdefcode.tmc.2828 */

/* Including from file Mdefcode.tmc.2828 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtManageChild-4.(B)");
	report_assertion("A call to void XtManageChild(w) when the parent of the");
	report_assertion("widget w is in the process of being destroyed shall return");
	report_assertion("immediately.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2828 */

/* Including from file Mdefcode.tmc.2828 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtManageChild-5.(B)");
	report_assertion("A call to void XtManageChild(w) when the widget w is in the");
	report_assertion("process of being destroyed shall return immediately.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2828 */

static void t006(){

Boolean status;
Widget labelw_good;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtManageChild-6.(A)");
	report_assertion("A call to void XtManageChild(w) when the widget w is");
	report_assertion("already managed shall return immediately.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tmngchild1", "XtManageChild");
	tet_infoline("PREP: Create a labelw_good widget");
	labelw_good = XtVaCreateWidget(
			"labelw_good",
			labelWidgetClass,
			boxw1,
			NULL
			);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add widget labelw_good to parent's managed widget boxw1 list");
	XtManageChild(labelw_good);
	tet_infoline("PREP: Call XtManageChild again for widget");
	XtManageChild(labelw_good);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2828 */
/* End of included file Mdefcode.tmc.2828 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
