/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtAppCreateShell()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xatom.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtAppCreateShell	1
char    *TestName = "XtAppCreateShell";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
String name_good;
XtAppContext app_ctext_good;
Widget topLevel_good;
Boolean status;
int argcount = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppCreateShell-1.(A)");
	report_assertion("A successful call to Widget XtAppCreateShell(name,");
	report_assertion("application_class, widget_class, display, args, num_args)");
	report_assertion("shall create a top-level shell widget that is the root of a");
	report_assertion("widget tree with name as the widget instance name, associate");
	report_assertion("it with the display specified by the argument display, and");
	report_assertion("return the shell widget instance.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	XtToolkitInitialize();
	tet_infoline("PREP: Create application context");
	app_ctext_good = XtCreateApplicationContext();
	tet_infoline("PREP: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext_good,	/* application context */
		(String)config.display,	 /* display name */
		"Hi there",	 /* application name use argv[0] */
		"World",	 /* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal) 0,	 /* command line options */
		&argcount,
		(String *)NULL	/* command line args */
	);
	if (display_good == NULL) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Create top level widget");
	topLevel_good = XtAppCreateShell("Hello", "World",
		 applicationShellWidgetClass, display_good,
		 (ArgList)NULL, (Cardinal)0);
	tet_infoline("TEST: Class is applicationShell");
	status = XtIsApplicationShell(topLevel_good);
	check_dec(True, status, "Return value");
	tet_infoline("TEST: Name");
	name_good = XtName(topLevel_good);
	check_str("Hello", name_good, "Name");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t002(){

Display *display_good;
String name_good, class_good;
char name[20], class[20];
XtAppContext app_ctext_good;
Widget widget_good;
Widget labelw_msg;
char *msg = "Property widget";
XTextProperty *text_prop;
Window window_good;
int argcount = 0;
int ret_value = 0;
Atom actual_type;
int actual_format;
unsigned long num_elements;
long bytes_after;
unsigned char *property_data_buff;
Arg args[2] = {
{ "XtNwidth", 100 },
{ "XtNheight", 100 }
};
pid_t	pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppCreateShell-2.(A)");
	report_assertion("On a successful call to Widget XtAppCreateShell(name,");
	report_assertion("application_class, widget_class, display, args, num_args)");
	report_assertion("when widget_class is ApplicationShell or a subclass thereof");
	report_assertion("the shell widget instance created shall have WM_COMMAND");
	report_assertion("property set from the values of the XtNargv and XtNargc");
	report_assertion("resources.");
	FORK(pid);
	initconfig();

	FORK(pid2);

	XtToolkitInitialize();
	tet_infoline("PREP: Create application context");
	app_ctext_good = XtCreateApplicationContext();
	tet_infoline("PREP: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext_good,	/* application context */
		(String)config.display,	 /* display name */
		"Hello",	 /* application name use argv[0] */
		"World",	 /* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal)0,		/* command line options */
		&argcount,
		(String *)NULL	 /* command line args */
	);
	if (display_good == NULL) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("PREP: Create top level widget");
	widget_good = XtAppCreateShell("Hello", "World",
		 applicationShellWidgetClass, display_good,
		 &args[0], 2);
	tet_infoline("PREP: Create label widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, widget_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(widget_good);
	tet_infoline("TEST: WM_COMMAND property is set");
	window_good = XtWindow(labelw_msg);
	ret_value = XGetWindowProperty(display_good, window_good,
		 XA_WM_COMMAND, (long)0,
		 128, False, AnyPropertyType,
		 &actual_type,
		 &actual_format,
		 &num_elements,
		 (unsigned long *)&bytes_after,
		 &property_data_buff);
	check_dec(Success, ret_value, "Return value");
	tet_infoline("TEST: WM_CLASS property is set");
	window_good = XtWindow(labelw_msg);
	ret_value = XGetWindowProperty(display_good, window_good,
		 XA_WM_CLASS, (long)0,
		 128, False, AnyPropertyType,
		 &actual_type,
		 &actual_format,
		 &num_elements,
		 (unsigned long *)&bytes_after,
		 &property_data_buff);
	check_dec(Success, ret_value, "Return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t003(){

Display *display_good;
String name_good;
XtAppContext app_ctext_good;
Widget topLevel_good;
Boolean status;
int argcount = 0;
pid_t	pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppCreateShell-3.(A)");
	report_assertion("A successful call to Widget XtAppCreateShell(name,");
	report_assertion("application_class, widget_class, display, args, num_args)");
	report_assertion("when name is NULL shall name the shell widget instance with");
	report_assertion("the application name passed to XtDisplayInitialize.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	XtToolkitInitialize();
	tet_infoline("PREP: Create application context");
	app_ctext_good = XtCreateApplicationContext();
	tet_infoline("PREP: Open display");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext_good,	/* application context */
		(String)config.display,	 /* display name */
		"Hi there",	 /* application name use argv[0] */
		"World",	 /* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal) 0,	 /* command line options */
		&argcount,
		(String *)NULL	/* command line args */
	 );
	if (display_good == NULL) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Create top level widget");
	topLevel_good = XtAppCreateShell(NULL, "World",
		 applicationShellWidgetClass, display_good,
		 (ArgList)NULL, (Cardinal)0);
	tet_infoline("TEST: Class is applicationShell");
	status = XtIsApplicationShell(topLevel_good);
	check_dec(True, status, "Return value");
	tet_infoline("TEST: Name");
	name_good = XtName(topLevel_good);
	check_str("Hi there", name_good, "Name");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

/* Including from file Mdefcode.tmc.3124 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppCreateShell-4.(B)");
	report_assertion("A successful call to Widget XtAppCreateShell(name,");
	report_assertion("application_class, widget_class, display, args, num_args)");
	report_assertion("when args specifies the XtNscreen argument shall create the");
	report_assertion("resource database for the shell widget using the resource");
	report_assertion("values specified in args and resource values from the");
	report_assertion("resource database of the screen specified by the XtNscreen");
	report_assertion("argument for those resources not specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3124 */

/* Including from file Mdefcode.tmc.3124 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppCreateShell-5.(B)");
	report_assertion("A successful call to Widget XtAppCreateShell(name,");
	report_assertion("application_class, widget_class, display, args, num_args)");
	report_assertion("when args does not specify the XtNscreen argument,");
	report_assertion("widget_class is applicationShellWidgetClass or a subclass");
	report_assertion("thereof, and the resource database of the default screen for");
	report_assertion("display specifies the resource name.screen, class");
	report_assertion("application_class.screen shall create the resource database");
	report_assertion("for the shell widget using the resource values specified in");
	report_assertion("args and resource values from the resource database of the");
	report_assertion("screen specified in the resource database of the default");
	report_assertion("screen for those resources not specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3124 */

/* Including from file Mdefcode.tmc.3124 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtAppCreateShell-6.(B)");
	report_assertion("A successful call to Widget XtAppCreateShell(name,");
	report_assertion("application_class, widget_class, display, args, num_args)");
	report_assertion("when args does not specify the XtNscreen argument,");
	report_assertion("widget_class is not applicationShellWidgetClass or a");
	report_assertion("subclass thereof, and the resource database of the default");
	report_assertion("screen for display specifies the resource name.screen, class");
	report_assertion("Class.screen, where Class is the class_name field from");
	report_assertion("CoreClassPart of widget_class, shall create the resource");
	report_assertion("database for the shell widget using the resource values");
	report_assertion("specified in args and resource values from the resource");
	report_assertion("database of the screen specified in the resource database of");
	report_assertion("the default screen for those resources not specified in");
	report_assertion("args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3124 */

/* Including from file Mdefcode.tmc.3124 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtAppCreateShell-7.(B)");
	report_assertion("A successful call to Widget XtAppCreateShell(name,");
	report_assertion("application_class, widget_class, display, args, num_args)");
	report_assertion("when args does not specify the XtNscreen argument and the");
	report_assertion("resource database of the default screen for display does not");
	report_assertion("specify the resource name.screen, class");
	report_assertion("application_class.screen shall create the resource database");
	report_assertion("for the shell widget using the resource values specified in");
	report_assertion("args and resource values from the resource database of the");
	report_assertion("default screen for those resources not specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.3124 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
