/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAppSetTypeConverter()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <AvsRectObj.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
#ifndef XavsRChar
#define XavsRChar "Char"
#endif

Boolean XtCVT_Proc(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	/*
	** Convert string to char
	*/
	avs_set_event(1, avs_get_event(1)+1);
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
	return True;
}
void XtDES_Proc(app_ctext, to_val, converter_data, args, num_args )
XtAppContext app_ctext;
XrmValue *to_val;
XtPointer converter_data;
XrmValuePtr args;
Cardinal *num_args;
{
	avs_set_event(2,1);
}
Boolean XtCVT_2StringToInt(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	char *str = (char *) (from_val->addr);
	static unsigned int i;
	sprintf(ebuf, "ERROR: Invoked converter XtCVT_2StringToInt");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
	to_val->size = sizeof (unsigned int);
	to_val->addr = (XtPointer) &i;
	i = *str;
	return True;
}
Boolean XtCVT_2StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	avs_set_event(1, avs_get_event(1)+1);
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
	return True;
}
void XtDES2_FreeInt(app_ctext, to_val, converter_data, args, num_args )
XtAppContext app_ctext;
XrmValue *to_val;
XtPointer converter_data;
XrmValuePtr args;
Cardinal *num_args;
{
	sprintf(ebuf, "ERROR: Invoked destructor XtDES2_FreeInt");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}
void XtDES2_FreeChar(app_ctext, to_val, converter_data, args, num_args )
XtAppContext app_ctext;
XrmValue *to_val;
XtPointer converter_data;
XrmValuePtr args;
Cardinal *num_args;
{
	avs_set_event(2, 1);
}

#define NUMARGS 8
XtConvertArgRec cargs[NUMARGS];
int argdata[NUMARGS] = {
	0,	/*don't care*/
	2002,
	0,	
	4004,
	0,	
	0,	
	0,	
	8008	
};

void xcap(w, size, value)
Widget w;
Cardinal *size;
XrmValue *value;
{
	avs_set_event(2, avs_get_event(2)+1);
	value->addr = (XtPointer)&argdata[7];
	value->size = sizeof(argdata[7]);
}

void init_args(checknum)
int checknum;
{
	cargs[0].address_mode = XtImmediate;
	cargs[0].address_id = (XtPointer)checknum;
	cargs[0].size = sizeof(XtPointer);

/*XtAddress*/
	cargs[1].address_mode = XtAddress;
	cargs[1].address_id = (XtPointer)&argdata[1];
	cargs[1].size = sizeof(XtPointer);

/*XtBaseOffset*/
	cargs[2].address_mode = XtBaseOffset;
	cargs[2].address_id = (XtPointer)XtOffset(Widget, core.screen);
	cargs[2].size = sizeof(Screen*);

/*XtImmediate*/
	cargs[3].address_mode = XtImmediate;
	cargs[3].address_id = (XtPointer)argdata[3];
	cargs[3].size = sizeof(XtPointer);

/*XtResourceString*/
	cargs[4].address_mode = XtImmediate;
	cargs[4].address_id = (XtPointer)argdata[4];
	cargs[4].size = sizeof(XtPointer);

/*XtResourceQuark*/
	cargs[5].address_mode = XtImmediate;
	cargs[5].address_id = (XtPointer)argdata[5];
	cargs[5].size = sizeof(XtPointer);

/*XtWidgetBaseOffset*/
	cargs[6].address_mode = XtWidgetBaseOffset;
	cargs[6].address_id = (XtPointer)XtOffset(Widget, core.self);
	cargs[6].size = sizeof(Widget);

/*XtProcedureArg*/
	cargs[7].address_mode = XtProcedureArg;
	cargs[7].address_id = (XtPointer)xcap;
	cargs[7].size = sizeof(XtPointer);
}

Boolean XtCVT_ProcA(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
int	checknum;

	char *str = (char *) (from_val->addr);
	static unsigned char i;

	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;

	avs_set_event(1, avs_get_event(1)+1);
	tet_infoline("TEST: Additional arguments passed to converter");
	if (*num_args != NUMARGS) {
		sprintf(ebuf, "ERROR: expected %d arguments, received %d", NUMARGS, *num_args);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return False;
	}

	checknum = (int)(*(XPointer *)args[0].addr);

	if (checknum == 0) {
		tet_infoline("ERROR: args[0].addr = 0");
		tet_result(TET_FAIL);
		return False;
	}
	if (checknum > NUMARGS) {
		sprintf(ebuf, "ERROR: args[0].addr = %d, should be < %d", checknum, NUMARGS);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return False;
	}

	if (args[checknum].addr == NULL) {
		sprintf(ebuf, "ERROR: args[%d].addr = NULL", checknum);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return False;
	}

	switch (checknum) {
	case 1:
	case 7:
		if (((int)*(int *)args[checknum].addr) != argdata[checknum]) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %d points to %d", checknum, argdata[checknum], ((int)*(int *)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return False;
		}
		break;
	case 2:
		if (((Screen*)*(Screen**)args[checknum].addr) != topLevel->core.screen) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %p points to %p", checknum, topLevel->core.screen, ((Screen*)*(Screen**)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return False;
		}
		break;
	case 3:
		if (((int)*(XPointer *)args[checknum].addr) != argdata[checknum]) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %d points to %d", checknum, argdata[checknum], ((int)*(XPointer *)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return False;
		}
		break;
	case 6:
		if (((Widget)*(Widget*)args[checknum].addr) != topLevel->core.self) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %p points to %p", checknum, topLevel->core.self, ((Widget)*(Widget*)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return False;
		}
		break;
	default:
		sprintf(ebuf, "ERROR: Unknown argument type %d", checknum);
		tet_infoline(ebuf);
		tet_result(TET_UNRESOLVED);
		return False;
	}

	return True;
}


#define T_XtAppSetTypeConverter	1
char    *TestName = "XtAppSetTypeConverter";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppSetTypeConverter-1.(A)");
	report_assertion("A successful call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("shall register converter as the procedure that will be");
	report_assertion("called by the Intrinsics to convert a resource value from");
	report_assertion("the representation type from_type to the type to_type in the");
	report_assertion("application context app_context of the calling process.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	tet_infoline("TEST: Procedure XtCVT_Proc was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "XtCVT_Proc invocation count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	XtCloseDisplay(display_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t002(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppSetTypeConverter-2.(A)");
	report_assertion("When destructor is not NULL a successful call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("shall register destructor as the procedure that shall be");
	report_assertion("called by the Intrinsics functions to deallocate the");
	report_assertion("resources produced by the corresponding converter.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	tet_infoline("TEST: Procedure XtCVT_Proc was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "XtCVT_Proc invocation count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Close display shall invoke destructor");
	XtCloseDisplay(display_good);
	status2 = avs_get_event(2);
	check_dec(1, status2, "destructor invocation count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t003(){

	Display *display_good;
	XrmValue from;
	XrmValue to_in_out;
	XtCacheRef cache_ref_return;
	int status1, status2;
	pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppSetTypeConverter-3.(A)");
	report_assertion("When more than one converter is registered for the same");
	report_assertion("from_type and to_type by multiple calls to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("the most recently registered converter shall override the");
	report_assertion("previous ones.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec2", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register converter XtCVT_2StringToInt");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_2StringToInt,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 XtDES2_FreeInt);
	tet_infoline("TEST: Register converter XtCVT_2StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_2StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 XtDES2_FreeChar);
	tet_infoline("TEST: Invoke recently added converter XtCVT_2StringToChar");
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(rowcolw,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Procedure XtCVT_2StringToChar was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "XtCVT_2StringToChar invocation count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t004(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppSetTypeConverter-4.(A)");
	report_assertion("On a call to void XtAppSetTypeConverter(app_context,");
	report_assertion("from_type, to_type, converter, convert_args, num_args,");
	report_assertion("cache_type, destructor) when cache_type is XtCacheNone the");
	report_assertion("converter procedure shall be registered such that the");
	report_assertion("results of a previous conversion will not be reused for");
	report_assertion("subsequent resource requests.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheNone,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	tet_infoline("TEST: Invoke it again");
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	tet_infoline("TEST: Procedure XtCVT_Proc was invoked twice");
	status1 = avs_get_event(1);
	check_dec(2, status1, "XtCVT_Proc invocations count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	XtCloseDisplay(display_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t005(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppSetTypeConverter-5.(A)");
	report_assertion("On a call to void XtAppSetTypeConverter(app_context,");
	report_assertion("from_type, to_type, converter, convert_args, num_args,");
	report_assertion("cache_type, destructor) when cache_type is XtCacheAll the");
	report_assertion("converter procedure shall be registered such that the");
	report_assertion("results of a a previous conversion will be reused for");
	report_assertion("subsequent resource requests with the same source value and");
	report_assertion("conversion arguments.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	tet_infoline("TEST: Invoke it again");
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	tet_infoline("TEST: Procedure XtCVT_Proc was invoked once");
	status1 = avs_get_event(1);
	check_dec(1, status1, "XtCVT_Proc invocations count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	XtCloseDisplay(display_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t006(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtAppSetTypeConverter-6.(A)");
	report_assertion("On a call to void XtAppSetTypeConverter(app_context,");
	report_assertion("from_type, to_type, converter, convert_args, num_args,");
	report_assertion("cache_type, destructor) when cache_type is XtCacheByDisplay");
	report_assertion("the converter procedure shall be registered such that the");
	report_assertion("results of a previous conversion will be reused for");
	report_assertion("subsequent resource requests with the same source value and");
	report_assertion("conversion arguments until the display connection associated");
	report_assertion("with the converted value is closed, at which time the values");
	report_assertion("stored in the cache shall be removed and the destructor");
	report_assertion("procedure shall be called.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	tet_infoline("TEST: Invoke it again");
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	tet_infoline("TEST: Procedure XtCVT_Proc was invoked once");
	status1 = avs_get_event(1);
	check_dec(1, status1, "XtCVT_Proc invocations count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Close display shall invoke destructor");
	XtCloseDisplay(display_good);
	status2 = avs_get_event(2);
	check_dec(1, status2, "destructor invocation count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

/* Including from file Mdefcode.tmc.3124 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtAppSetTypeConverter-7.(B)");
	report_assertion("On a call to void XtAppSetTypeConverter(app_context,");
	report_assertion("from_type, to_type, converter, convert_args, num_args,");
	report_assertion("cache_type, destructor) when XtCacheRefCount and XtCacheAll");
	report_assertion("are set in cache_type the converter procedure shall be");
	report_assertion("registered such that a count of every call to");
	report_assertion("XtCreateWidget, XtCreateManagedWidget,");
	report_assertion("XtGetApplicationResources and XtGetSubresources that use the");
	report_assertion("converted value will be made, the count decremented when a");
	report_assertion("widget using the converted value is destroyed, the");
	report_assertion("destructor procedure called when the count reaches zero, and");
	report_assertion("the converted value removed from the conversion cache.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3124 */

/* Including from file Mdefcode.tmc.3124 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtAppSetTypeConverter-8.(B)");
	report_assertion("On a call to void XtAppSetTypeConverter(app_context,");
	report_assertion("from_type, to_type, converter, convert_args, num_args,");
	report_assertion("cache_type, destructor) when XtCacheRefCount and");
	report_assertion("XtCacheByDisplay are set in cache_type the converter");
	report_assertion("procedure shall be registered such that a count of every");
	report_assertion("call to XtCreateWidget, XtCreateManagedWidget,");
	report_assertion("XtGetApplicationResources and XtGetSubresources that use the");
	report_assertion("converted value will be made, the count decremented when a");
	report_assertion("widget using the converted value is destroyed, the");
	report_assertion("destructor procedure called when the count reaches zero, and");
	report_assertion("the converted value removed from the conversion cache.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3124 */

static void t009(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtAppSetTypeConverter-9.(A)");
	report_assertion("When a coverter is registered by a call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("with the address_mode member of an XtConvertArgRec structure");
	report_assertion("in the list pointed to by convert_args set to XtAddress it");
	report_assertion("shall be called by the Intrinsics with the data pointed to");
	report_assertion("by the address_id field passed as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(1);
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_ProcA,
		 (XtConvertArgList)cargs,
		 (Cardinal)NUMARGS,
		 XtCacheByDisplay,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke conversion");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(display_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "converter invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t010(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtAppSetTypeConverter-10.(A)");
	report_assertion("When a coverter is registered by a call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("with the address_mode member of an XtConvertArgRec structure");
	report_assertion("pointed to by convert_args set to XtBaseOffset it shall be");
	report_assertion("called by the Intrinsics with the data at an offset of");
	report_assertion("address_id from the base of the widget for which the");
	report_assertion("converter is invoked passed as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(2);
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_ProcA,
		 (XtConvertArgList)cargs,
		 (Cardinal)NUMARGS,
		 XtCacheByDisplay,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke conversion");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(display_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "converter invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t011(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtAppSetTypeConverter-11.(A)");
	report_assertion("When a coverter is registered by a call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("with the address_mode member of an XtConvertArgRec structure");
	report_assertion("pointed to by convert_args set to XtImmediate it shall be");
	report_assertion("called by the Intrinsics with the data in the address_id");
	report_assertion("field passed as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(3);
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_ProcA,
		 (XtConvertArgList)cargs,
		 (Cardinal)NUMARGS,
		 XtCacheByDisplay,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke conversion");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(display_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "converter invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

/* Including from file Mdefcode.tmc.3124 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtAppSetTypeConverter-12.(B)");
	report_assertion("When a coverter is registered by a call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("with the address_mode member of an XtConvertArgRec structure");
	report_assertion("pointed to by convert_args set to XtResourceString it shall");
	report_assertion("be called by the Intrinsics with the offset of the resource");
	report_assertion("from the base of the widget, in whose context the converter");
	report_assertion("is invoked, for the resource string pointed to by address_id");
	report_assertion("passed as a conversion argument.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3124 */

/* Including from file Mdefcode.tmc.3124 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtAppSetTypeConverter-13.(B)");
	report_assertion("When a coverter is registered by a call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("with the address_mode member of an XtConvertArgRec structure");
	report_assertion("pointed to by convert_args set to XtResourceQuark it shall");
	report_assertion("be called by the Intrinsics with the offset of the resource");
	report_assertion("from the base of the widget, in whose context the converter");
	report_assertion("is invoked, for the resource string specified by the quark");
	report_assertion("value in the address_id field passed as a conversion");
	report_assertion("argument.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3124 */

static void t014(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
Widget test_widget;
pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtAppSetTypeConverter-14.(A)");
	report_assertion("When a coverter is registered by a call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("with the address_mode member of an XtConvertArgRec structure");
	report_assertion("pointed to by convert_args set to XtWidgetBaseOffset it");
	report_assertion("shall be called by the Intrinsics with the data at an offset");
	report_assertion("of address_id in the closest windowed ancestor of the widget");
	report_assertion("in whose context the converter is called, when the widget is");
	report_assertion("not of a subclass of Core, passed as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
        tet_infoline("PREP: Create AVS RectObj widget");
        test_widget = XtVaCreateManagedWidget("avsro", avsrectObjClass, topLevel, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(6);
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_ProcA,
		 (XtConvertArgList)cargs,
		 (Cardinal)NUMARGS,
		 XtCacheByDisplay,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke conversion");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		test_widget,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(display_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "converter invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

static void t015(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status1, status2;
int pid2;
pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtAppSetTypeConverter-15.(A)");
	report_assertion("When a coverter is registered by a call to void");
	report_assertion("XtAppSetTypeConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args, cache_type, destructor)");
	report_assertion("with the address_mode member of an XtConvertArgRec structure");
	report_assertion("pointed to by convert_args set to XtProcedureArg it shall be");
	report_assertion("called by the Intrinsics with the value returned by the");
	report_assertion("function pointed to by the address_id field passed as a");
	report_assertion("conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK( pid2 );
	avs_set_event(1,0);
	avs_set_event(2,0);
	avs_xt_hier("Tapsttpec1", "XtAppSetTypeConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(7);
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_ProcA,
		 (XtConvertArgList)cargs,
		 (Cardinal)NUMARGS,
		 XtCacheByDisplay,
		 XtDES_Proc);
	tet_infoline("TEST: Invoke conversion");
	display_good = XtDisplay(topLevel);
	from.addr = (XtPointer) "Hello";
	from.size = strlen(from.addr) + 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(display_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status1 = avs_get_event(1);
	check_dec(1, status1, "converter invocation count");
	tet_infoline("TEST: function was invoked");
	status1 = avs_get_event(2);
	check_dec(1, status1, "function invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3124 */
/* End of included file Mdefcode.tmc.3124 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
