/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight)
 *   Display *display;
 *   int class;
 *   Drawable which_screen;
 *   unsigned int width;
 *   unsigned int height;
 *   unsigned int *rwidth;
 *   unsigned int *rheight;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XQueryBestSize	1
char    *TestName = "XQueryBestSize";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_DRAWABLE which_screen


/*
 * Arguments to the XQueryBestSize function
 */
static Display *display;
static int class;
static Drawable which_screen;
static unsigned int width;
static unsigned int height;
static unsigned int *rwidth;
static unsigned int *rheight;


static int 	StatusReturn;

unsigned int cheight, cwidth;


/* Value list for use in test t007 */
static int 	classvallist[] = {
	TileShape,
	CursorShape,
	StippleShape,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	class = 0;
	which_screen = 0;
	width = 0;
	height = 0;
	rwidth = &cwidth;
	rheight = &cheight;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	which_screen = ErrdefDrawable;
}

static void t001(){

Status qstat;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XQueryBestSize-1.(A)");
	report_assertion("When the class argument is CursorShape, then a call to");
	report_assertion("XQueryBestSize returns the largest cursor height and width");
	report_assertion("that can be fully displayed on the specified screen.");

	report_strategy("Set class to CursorShape.");
	report_strategy("Call XQueryBestSize with width 10000 and height 10000.");
	report_strategy("Verify that XQueryBestSize returns non zero.");
	report_strategy("Call XQueryBestSize with returned values of width and height.");
	report_strategy("Verify that XQueryBestSize returns non zero.");
	report_strategy("Verify that XQueryBestSize returns the previously returned values");
	report_strategy("for width and height.");
	report_strategy("Repeat with initial width and height both set to zero.");

	tpstartup();
	setargs();
	which_screen = DRW(display);
	class = CursorShape;

	width = 10000;
	height = 10000;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	width = cwidth;
	height = cheight;

	cwidth = cheight = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	if(width != cwidth) {
		report("XQueryBestSize returned best width %d", cwidth);
		report("after previously returning best width %d", width);
		FAIL;
	} else
		CHECK;

	if(height != cheight) {
		report("XQueryBestSize returned best height %d", cheight);
		report("after previously returning best height %d", height);
		FAIL;
	} else
		CHECK;

	width = 0;
	height = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	width = cwidth;
	height = cheight;

	cwidth = cheight = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	if(width != cwidth) {
		report("XQueryBestSize returned best width %d", cwidth);
		report("after previously returning best width %d", width);
		FAIL;
	} else
		CHECK;

	if(height != cheight) {
		report("XQueryBestSize returned best height %d", cheight);
		report("after previously returning best height %d", height);
		FAIL;
	} else
		CHECK;

	CHECKPASS(8);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status qstat;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XQueryBestSize-2.(A)");
	report_assertion("When the class argument is TileShape, then a call to");
	report_assertion("XQueryBestSize returns the height and width of tile that are");
	report_assertion("closest to the arguments height and width that can be tiled");
	report_assertion("fastest on the specified screen.");

	report_strategy("Set class to TileShape.");
	report_strategy("Call XQueryBestSize with width 10000 and height 10000.");
	report_strategy("Verify that XQueryBestSize returns non zero.");
	report_strategy("Call XQueryBestSize with returned values of width and height.");
	report_strategy("Verify that XQueryBestSize returns non zero.");
	report_strategy("Verify that XQueryBestSize returns the previously returned values");
	report_strategy("for width and height.");
	report_strategy("Repeat with initial width and height both set to zero.");

	tpstartup();
	setargs();
	which_screen = DRW(display);
	class = TileShape;

	width = 10000;
	height = 10000;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	width = cwidth;
	height = cheight;

	cwidth = cheight = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	if(width != cwidth) {
		report("XQueryBestSize returned best width %d", cwidth);
		report("after previously returning best width %d", width);
		FAIL;
	} else
		CHECK;

	if(height != cheight) {
		report("XQueryBestSize returned best height %d", cheight);
		report("after previously returning best height %d", height);
		FAIL;
	} else
		CHECK;

	width = 0;
	height = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	width = cwidth;
	height = cheight;

	cwidth = cheight = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	if(width != cwidth) {
		report("XQueryBestSize returned best width %d", cwidth);
		report("after previously returning best width %d", width);
		FAIL;
	} else
		CHECK;

	if(height != cheight) {
		report("XQueryBestSize returned best height %d", cheight);
		report("after previously returning best height %d", height);
		FAIL;
	} else
		CHECK;

	CHECKPASS(8);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Status qstat;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XQueryBestSize-3.(A)");
	report_assertion("When the class argument is StippleShape, then a call to");
	report_assertion("XQueryBestSize returns the height and width of stipple that");
	report_assertion("are closest to the arguments height and width that can be");
	report_assertion("stippled fastest on the specified screen.");

	report_strategy("Set class to StippleShape.");
	report_strategy("Call XQueryBestSize with width 10000 and height 10000.");
	report_strategy("Verify that XQueryBestSize returns non zero.");
	report_strategy("Call XQueryBestSize with returned values of width and height.");
	report_strategy("Verify that XQueryBestSize returns non zero.");
	report_strategy("Verify that XQueryBestSize returns the previously returned values");
	report_strategy("for width and height.");
	report_strategy("Repeat with initial width and height both set to zero.");

	tpstartup();
	setargs();
	which_screen = DRW(display);
	class = StippleShape;

	width = 10000;
	height = 10000;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	width = cwidth;
	height = cheight;

	cwidth = cheight = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	if(width != cwidth) {
		report("XQueryBestSize returned best width %d", cwidth);
		report("after previously returning best width %d", width);
		FAIL;
	} else
		CHECK;

	if(height != cheight) {
		report("XQueryBestSize returned best height %d", cheight);
		report("after previously returning best height %d", height);
		FAIL;
	} else
		CHECK;

	width = 0;
	height = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	width = cwidth;
	height = cheight;

	cwidth = cheight = 0;

	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(qstat == 0) {
		report("XQueryBestSize returned wrong value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;

	trace("Status returned was %d", qstat);
	trace("Best height (for %d ) = %d", height, cheight);
	trace("Best width (for %d)  = %d", width, cwidth);

	if(width != cwidth) {
		report("XQueryBestSize returned best width %d", cwidth);
		report("after previously returning best width %d", width);
		FAIL;
	} else
		CHECK;

	if(height != cheight) {
		report("XQueryBestSize returned best height %d", cheight);
		report("after previously returning best height %d", height);
		FAIL;
	} else
		CHECK;

	CHECKPASS(8);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int qstat;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XQueryBestSize-4.(A)");
	report_assertion("When the class argument is TileShape, and the which_screen");
	report_assertion("argument specifies an InputOnly window, then a BadMatch");
	report_assertion("error occurs.");

	report_strategy("Set class to TileShape.");
	report_strategy("Set which_screen to an InputOnly window.");
	report_strategy("Call XQueryBestSize.");
	report_strategy("Verify that XQueryBestSize returns zero.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	which_screen = iponlywin(display);
	class = TileShape;
	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	trace("Status returned is %d", qstat);

	if(qstat == 0)
		CHECK;
	else
		FAIL;

	if(geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int qstat;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XQueryBestSize-5.(A)");
	report_assertion("When the class argument is StippleShape, and the");
	report_assertion("which_screen argument specifies an InputOnly window, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Set class to StippleShape.");
	report_strategy("Set which_screen to an InputOnly window.");
	report_strategy("Call XQueryBestSize.");
	report_strategy("Verify that XQueryBestSize returns zero.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	which_screen = iponlywin(display);
	class = StippleShape;
	startcall(display);
	if (isdeleted())
		return;
	qstat = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	trace("Status returned is %d", qstat);

	if(qstat == 0)
		CHECK;
	else
		FAIL;

	if(geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EDra.mc */
/* End of included file error/EDra.mc */

/* Including from file error/EDra.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XQueryBestSize-6.(A)");
	report_assertion("When a drawable argument does not name a valid Drawable,");
	report_assertion("then a BadDrawable error occurs.");

	report_strategy("Create a bad drawable by creating and destroying a window.");
	report_strategy("Call test function using bad drawable as the drawable argument.");
	report_strategy("Verify that a BadDrawable error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_DRAWABLE = (Drawable)badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadDrawable) {
		report("Got %s, Expecting BadDrawable", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadDrawable)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EDra.mc */

/* Including from file Mval.tmc.3356 */
/* End of included file Mval.tmc.3356 */

/* Including from file error/EVal.mc */
static void t007(){

#undef	VALUE_ARG
#define	VALUE_ARG class
#undef	VALUE_LIST
#define	VALUE_LIST classvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XQueryBestSize-7.(A)");
	report_assertion("When the value of class is other than TileShape,");
	report_assertion("CursorShape or StippleShape, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		StatusReturn = XQueryBestSize(display, class, which_screen, width, height, rwidth, rheight);
		endcall(display);
		if (StatusReturn != 0) {
			report("Status returned was %d", StatusReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
