/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XCreatePixmap(display, d, width, height, depth)
 *   Display *display;
 *   Drawable d;
 *   unsigned int width;
 *   unsigned int height;
 *   unsigned int depth;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreatePixmap	1
char    *TestName = "XCreatePixmap";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_DRAWABLE d


/*
 * Arguments to the XCreatePixmap function
 */
static Display *display;
static Drawable d;
static unsigned int width;
static unsigned int height;
static unsigned int depth;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	d = DRW(display);
	width = 13;
	height = 17;
	depth = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo	*vp;
Status 		gstat;
Window		root_ret;
int		x_ret, y_ret;
unsigned int	w_ret, h_ret, bw_ret, dep_ret;
Pixmap		pmap;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreatePixmap-1.(A)");
	report_assertion("A call to XCreatePixmap creates a pixmap of width width,");
	report_assertion("height height, and depth depth on the same screen as the");
	report_assertion("drawable argument d, and returns a pixmap ID.");

	report_strategy("For each supported pixmap depth:");
	report_strategy("  Create a pixmap of height 13, width 17.");
	report_strategy("  Verify the depth, height and width with XGetGeometry.");

	tpstartup();
	setargs();

	for(resetvinf(VI_PIX); nextvinf(&vp); ) {
		depth = vp->depth;
		d = DRW(display);
		startcall(display);
		if (isdeleted())
			return;
		pmap = XCreatePixmap(display, d, width, height, depth);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		gstat = XGetGeometry(display, pmap, &root_ret, &x_ret, &y_ret, &w_ret, &h_ret, &bw_ret, &dep_ret);

		if(gstat != True) {
			delete("XGetGeometry did not return True for pixmap ID 0x%x",pmap);
			return;
		} else
			CHECK;

		if(w_ret != width) {
			report("XGetGeometry returned width of %u instead of %u for pixmap of depth %u", w_ret, width, depth);
			FAIL;
		} else 
			CHECK;

		if(h_ret != height) {
			report("XGetGeometry returned height of %u instead of %u for pixmap of depth %u", h_ret, height, depth);
			FAIL;
		} else 
			CHECK;

		if(dep_ret != depth) {
			report("XGetGeometry returned depth of %u instead of depth %u", dep_ret, depth);
			FAIL;
		} else 
			CHECK;

 	}

	CHECKPASS(4 * nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreatePixmap-2.(A)");
	report_assertion("When the drawable argument d is an InputOnly window, then");
	report_assertion("no error occurs.");

	report_strategy("For each supported pixmap depth:");
	report_strategy("  Create an InputOnly window.");
	report_strategy("  Call XCreatePixmap with the window as the drawable argument.");
	report_strategy("  Verify that no error occurred.");

	tpstartup();
	setargs();
	for(resetvinf(VI_PIX); nextvinf(&vp); ) {
		d = iponlywin(display);
		depth = vp->depth;
		startcall(display);
		if (isdeleted())
			return;
		XCreatePixmap(display, d, width, height, depth);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(geterr() != Success) {
			report("XCreatePixmap() produced error %s with an InputOnly Window as the drawable",errorname(geterr()));
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo	*vp;
unsigned int	depth;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreatePixmap-3.(A)");
	report_assertion("When either the width argument or height argument is zero,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("For each supported pixmap depth:");
	report_strategy("  Create a pixmap with height = 17 and width = 0 with XCreatePixmap.");
	report_strategy("  Verify that a BadValue error occurred.");
	report_strategy("  Create a pixmap with height = 0 and width = 19 with XCreatePixmap.");
	report_strategy("  Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	for(resetvinf(VI_PIX); nextvinf(&vp); ) {
		depth = vp->depth;

		d = DRW(display); 
		height = 17;
		width = 0;
		startcall(display);
		if (isdeleted())
			return;
		XCreatePixmap(display, d, width, height, depth);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() != BadValue) {
			report("When XCreatePixmap called with zero width");
			report("Got %s, Expecting BadValue error", 
							errorname(geterr()));
			FAIL;
		} else
			CHECK;

		width = 19;
		height = 0;
		startcall(display);
		if (isdeleted())
			return;
		XCreatePixmap(display, d, width, height, depth);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() != BadValue) {
			report("When XCreatePixmap called with zero height");
			report("Got %s, Expecting BadValue error", 
							errorname(geterr()));
			FAIL;
		} else
			CHECK;
	}	

	CHECKPASS(nvinf() * 2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo	*vp;
unsigned int	depth, nondepth;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreatePixmap-4.(A)");
	report_assertion("When the depth depth is not supported by the screen of the");
	report_assertion("drawable d, then a BadValue error occurs.");

	report_strategy("Call XCreatePixmap with depth argument set to the ");
	report_strategy("	sum of all supported pixmap depths plus 1.");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	nondepth = 1;
	for(resetvinf(VI_PIX); nextvinf(&vp); )
		nondepth += vp->depth;	

	trace("Selected unsupported depth is %u", nondepth);
	d = DRW(display);
	depth = nondepth;
	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmap(display, d, width, height, depth);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	if(geterr() != BadValue) {
		report("When XCreatePixmap called with unsupported depth %d",
								depth);
		report("Got %s, Expecting BadValue error", errorname(geterr()));
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreatePixmap-5.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file error/EDra.mc */
/* End of included file error/EDra.mc */

/* Including from file error/EDra.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCreatePixmap-6.(A)");
	report_assertion("When a drawable argument does not name a valid Drawable,");
	report_assertion("then a BadDrawable error occurs.");

	report_strategy("Create a bad drawable by creating and destroying a window.");
	report_strategy("Call test function using bad drawable as the drawable argument.");
	report_strategy("Verify that a BadDrawable error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_DRAWABLE = (Drawable)badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmap(display, d, width, height, depth);
	endcall(display);
	if (geterr() != BadDrawable) {
		report("Got %s, Expecting BadDrawable", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadDrawable)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EDra.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
