/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XRebindKeysym(display, keysym, list, mod_count, string, bytes_string)
 *   Display		*display;
 *   KeySym		keysym;
 *   KeySym		*list;
 *   int		mod_count;
 *   unsigned char	*string;
 *   int		bytes_string;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XRebindKeysym	1
char    *TestName = "XRebindKeysym";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XRebindKeysym function
 */
static Display		*display;
static KeySym		keysym;
static KeySym		*list;
static int		mod_count;
static unsigned char	*string;
static int		bytes_string;



/* Arbitary keysyms for use as modifiers */
#define	MODKS1	0x12
#define	MODKS2	0x45

#define XK_LATIN1
#include    "X11/keysymdef.h"
#undef XK_LATIN1

#define	MAXRES	256	/* Maximum length of bound string */


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	keysym = 0;
	list = 0;
	mod_count = 0;
	string = 0;
	bytes_string = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XKeyEvent	ev;
char	*astring = "Bound String";
char	*modstring = "String to bind to modified key";
static char	rstring[MAXRES] = "UninitializedBoundString."; 
KeySym	ksr;
KeySym	modlist[5];
KeySym	keylist[6];
XModifierKeymap	*origmap;
XModifierKeymap	*modmap;
KeySym	*origkeymap;
int 	minkc, maxkc;
int 	kpk;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XRebindKeysym-1.(B)");
	report_assertion("A call to XRebindKeysym rebinds the meaning of the keysym");
	report_assertion("argument for use in XLookupString to the bytes_string length");
	report_assertion("string and to use the mod_count modifiers specified by the");
	report_assertion("list argument.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set map between keysyms that will be used and keycodes.");
	report_strategy("Open new connection to get refreshed mappings.");
	report_strategy("Bind the keysym XK_A to a string using XRebindKeysym.");
	report_strategy("Bind the keysym XK_A with modifiers to a second string using XRebindKeysym.");
	report_strategy("Obtain the keycode bound to the XK_A keysym using XKeysymToKeycode.");
	report_strategy("Obtain the binding for the keycode without modifiers using XLookupString.");
	report_strategy("Verify that the keysym is correctly bound to the string astring.");
	report_strategy("Obtain the binding for the keycode with modifiers using XLookupString.");
	report_strategy("Verify that the keysym is correctly bound to the string modstring.");

	tpstartup();
	setargs();
	/*
	 * Save old keyboard map.  Map the keysyms that we want to use
	 * to the first available keycodes.
	 */
	XDisplayKeycodes(display, &minkc, &maxkc);
	origkeymap = XGetKeyboardMapping(display, minkc, maxkc-minkc+1, &kpk);
	keylist[0] = MODKS1;
	keylist[1] = MODKS1;
	keylist[2] = MODKS2;
	keylist[3] = MODKS2;
	keylist[4] = XK_A;
	keylist[5] = XK_A;
	XChangeKeyboardMapping(display, minkc, 2, keylist, 3);

	origmap = XGetModifierMapping(display);

	/*
	 * Set up a modifier mapping to use the modifier keysyms that we are
	 * going to use.
	 */
	modmap = XNewModifiermap(0);
	modmap = XInsertModifiermapEntry(modmap, minkc, ShiftMapIndex);
	modmap = XInsertModifiermapEntry(modmap, minkc+1, Mod1MapIndex);
	if( XSetModifierMapping(display, modmap) != MappingSuccess) {
		report("XSetModifierMapping did not return MappingSuccess");
		UNTESTED;
		/*
		 * Attempt to reset the state of the keyboard.
		 */
		XSetModifierMapping(display, origmap);
		XChangeKeyboardMapping(display, minkc, kpk, origkeymap,
			maxkc-minkc+1);
		return;
	} else
		CHECK;

	/*
	 * Need to refresh the display structure mappings, we just open a new
	 * connection and use that.
	 */
	display = opendisplay();

	/*
	 * Set up a rebinding for A (unshifted)
	 */
	keysym = XK_A;
	list = (KeySym *) NULL;
	mod_count = 0;
	string = (unsigned char *)astring;
	bytes_string = strlen((char *)string)+1;
	startcall(display);
	if (isdeleted())
		return;
	XRebindKeysym(display, keysym, list, mod_count, string, bytes_string);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Set up a rebinding for Shift Mod1 A.
	 */
	modlist[0] = MODKS1;
	modlist[1] = MODKS2;

	keysym = XK_A;
	list = modlist;
	mod_count = 2;
	string = (unsigned char *)modstring;
	bytes_string = strlen((char *)string)+1;
	startcall(display);
	if (isdeleted())
		return;
	XRebindKeysym(display, keysym, list, mod_count, string, bytes_string);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Check the unmodified case.
	 */
	ev.display = display;
	ev.keycode = XKeysymToKeycode(display, XK_A);
	debug(1, "code=%d", ev.keycode);
	ev.state = 0;
	XLookupString(&ev, rstring, MAXRES, &ksr, (XComposeStatus *) NULL);
	trace("String returned >%s<", rstring);

	if (strcmp(astring,  rstring) != 0) {
		report("%s() bound XK_A to \"%s\" instead of \"%s\".", TestName, rstring, astring);
		FAIL;
	} else
		CHECK;


	/*
	 * Now check the modified case.
	 */
	ev.display = display;
	ev.state = ShiftMask|Mod1Mask;
	XLookupString(&ev, rstring, MAXRES, &ksr, (XComposeStatus *) NULL);
	trace("String returned >%s<", rstring);

	if (strcmp(modstring,  rstring) != 0) {
		report("%s() bound XK_A to \"%s\" instead of \"%s\".", TestName, rstring, modstring);
		FAIL;
	} else
		CHECK;

	/*
	 * Attempt to reset the state of the keyboard.
	 */
	XSetModifierMapping(display, origmap);
	XChangeKeyboardMapping(display, minkc, kpk, origkeymap, maxkc-minkc+1);

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.1332 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XRebindKeysym-2.(B)");
	report_assertion("When keysym does not exist, then a call to XRebindKeysym");
	report_assertion("rebinds the meaning of the keysym argument.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.1332 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
