/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Pixmap
 *   XCreatePixmapFromBitmapData(display, d, data, width, height, fg, bg, depth)
 *   Display *display;
 *   Drawable d;
 *   char *data;
 *   unsigned int width;
 *   unsigned int height;
 *   unsigned long fg;
 *   unsigned long bg;
 *   unsigned int depth;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreatePixmapFromBitmapData	1
char    *TestName = "XCreatePixmapFromBitmapData";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_DRAWABLE d


/*
 * Arguments to the XCreatePixmapFromBitmapData function
 */
static Display *display;
static Drawable d;
static char *data;
static unsigned int width;
static unsigned int height;
static unsigned long fg;
static unsigned long bg;
static unsigned int depth;


/* Data for a "checkerboard" pixmap. */
static unsigned char cpfbd_one[] = {
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff};
	

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	d = 0;
	data = (char*)cpfbd_one;
	width = 16;
	height = 8;
	fg = W_BG;
	bg = W_FG;
	depth = 1;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	d = ErrdefDrawable;
}

static void t001(){

XVisualInfo *vp;
Pixmap ret;
Window wr_r;
int it_r;
unsigned int width_ret, height_ret;
unsigned int uit_r;
unsigned int depth_ret;
struct area ar;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreatePixmapFromBitmapData-1.(A)");
	report_assertion("A call to XCreatePixmapFromBitmapData returns a pixmap");
	report_assertion("containing the bitmap-format XPutImage of the data of depth");
	report_assertion("depth, width width, and height height, and with");
	report_assertion("foreground and background pixel values of fg and bg.");

	report_strategy("Create a drawable for the pixmap.");
	report_strategy("Call XCreatePixmapFromBitmapData to create the pixmap from the data.");
	report_strategy("Call XGetGeometry to check the pixmap.");
	report_strategy("Verify the pixmap was as expected.");

	tpstartup();
	setargs();
/* Create a drawable for the pixmap. */
	resetvinf(VI_WIN); nextvinf(&vp);
	d = makewin(display, vp);
	depth = vp->depth;

/* Call xname to create the pixmap from the data. */
	startcall(display);
	if (isdeleted())
		return;
	ret=XCreatePixmapFromBitmapData(display, d, data, width, height, fg, bg, depth);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call XGetGeometry to check the pixmap. */
	if(!XGetGeometry(display, ret, &wr_r, &it_r, &it_r,
		&width_ret, &height_ret, &uit_r, &depth_ret)) {
		delete("XGetGeometry failed.");
		return;
	} else
		CHECK;

	if(width_ret!=width || height_ret!=height) {
		FAIL;
		report("%s created a pixmap of unexpected geometry",
			TestName);
		report("Expected width, height: %d,%d", width, height);
		report("Returned width, height: %d,%d", width_ret, height_ret);
	} else
		CHECK;

	if(depth_ret != depth) {
		FAIL;
		report("%s created a pixmap of unexpected depth.",
			TestName);
		report("Expected depth: %u", depth);
		report("Returned depth: %u", depth_ret);
	} else
		CHECK;

/* Verify the pixmap was as expected. */
	setarea(&ar,0,0,8,4);
	if (!checkarea(display, ret, &ar, fg, 0, CHECK_IN)) {
		FAIL;
		report("%s did not return the expected pixmap.", TestName);
		trace("Top left quarter was incorrect");
	} else
		CHECK;

	setarea(&ar,8,0,8,4);
	if (!checkarea(display, ret, &ar, bg, 0, CHECK_IN)) {
		FAIL;
		report("%s did not return the expected pixmap.", TestName);
		trace("Top right quarter was incorrect");
	} else
		CHECK;

	setarea(&ar,0,4,8,4);
	if (!checkarea(display, ret, &ar, bg, 0, CHECK_IN)) {
		FAIL;
		report("%s did not return the expected pixmap.", TestName);
		trace("Bottom left quarter was incorrect");
	} else
		CHECK;

	setarea(&ar,8,4,8,4);
	if (!checkarea(display, ret, &ar, fg, 0, CHECK_IN)) {
		FAIL;
		report("%s did not return the expected pixmap.", TestName);
		trace("Bottom right quarter was incorrect");
	} else
		CHECK;

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
int baddepth;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreatePixmapFromBitmapData-2.(A)");
	report_assertion("When the depth is not supported by the screen of the");
	report_assertion("specified drawable d, then on a call to");
	report_assertion("XCreatePixmapFromBitmapData a BadValue error occurs.");

	report_strategy("Calculate a bad depth.");
	report_strategy("Call XCreatePixmapFromBitmapData with a bad depth");
	report_strategy("Verify that a bad value error occurred.");

	tpstartup();
	setargs();

/* Calculate a bad depth. */
	baddepth=1;
	resetvinf(VI_PIX);
	for(baddepth=1; nextvinf(&vp); )
		if(baddepth < vp->depth)
			baddepth=vp->depth;
	baddepth *= 2;

/* Call xname with a bad depth */
	depth=baddepth;
	d = defwin(display);
	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmapFromBitmapData(display, d, data, width, height, fg, bg, depth);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

/* Verify that a bad value error occurred. */
	if (geterr() != BadValue) {
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.2160 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreatePixmapFromBitmapData-3.(B)");
	report_assertion("When sufficient temporary storage cannot be allocated, then");
	report_assertion("a call to XCreatePixmapFromBitmapData returns NULL.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.2160 */

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreatePixmapFromBitmapData-4.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreatePixmapFromBitmapData-5.(A)");
	report_assertion("When a drawable argument does not name a valid drawable,");
	report_assertion("then one or more BadDrawable errors, one or more BadGC");
	report_assertion("errors or both types of error occur.");

	report_strategy("Create a bad drawable by creating and destroying a window.");
	report_strategy("Call test function using bad drawable as the drawable argument.");
	report_strategy("Verify that a BadDrawable and BadGC error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_DRAWABLE = (Drawable)badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmapFromBitmapData(display, d, data, width, height, fg, bg, depth);
	endcall(display);

	if (geterr() == BadDrawable || geterr() == BadGC)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
