/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   char *
 *   XSetLocaleModifiers(modifier_list)
 *   char *modifier_list;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;

#include <locale.h>
#include <ximtest.h>



#define T_XSetLocaleModifiers	1
char    *TestName = "XSetLocaleModifiers";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XSetLocaleModifiers function
 */
static char *modifier_list;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	modifier_list = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
char *plocale,*plclmod;
char *modstr;
Bool supported;
#endif
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetLocaleModifiers-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XSetLocaleModifiers modifier_list");

	report_strategy("For every Locale specified by the user in the configuration file, call ");
	report_strategy("XSetLocaleModifiers for every locale modifier set specified by the user ");
	report_strategy("in the configuration file.");

	tpstartup();
	setargs();
#if XT_X_RELEASE > 4

	resetlocale();
	while(nextlocale(&plocale))
	{
		setlocale(LC_CTYPE,plocale);
		resetlclmod();
		supported = XSupportsLocale();
		while(nextlclmod(&plclmod))
		{
			if(supported)
			{
				modifier_list = plclmod;
				startcall(Dsp);
				if (isdeleted())
					return;
				modstr = XSetLocaleModifiers(modifier_list);
				endcall(Dsp);
				if (geterr() != Success) {
					report("Got %s, Expecting Success", errorname(geterr()));
					FAIL;
				}
				if((modstr != NULL) && (strcmp(modstr,modifier_list) == 0))
				{
					trace("Modifier %s found for locale %s",
						modifier_list,plocale);;
					CHECK;
				}
				else
				{
					report("Modifiers, %s, not supported for %s locale",
						plclmod,plocale);
					FAIL;
				}
			}
			else
			{
				report("Locale %s not supported for modifier, %s",
					plocale,plclmod);
				FAIL;
			}
		}
	}
	
	CHECKPASS(nlocales() * nlclmod());
#else

	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = localestartup;
void	(*tet_cleanup)() = localecleanup;
