/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XSetModifierMapping(display, modmap)
 *   Display	*display;
 *   XModifierKeymap	*modmap;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetModifierMapping	1
char    *TestName = "XSetModifierMapping";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSetModifierMapping function
 */
static Display	*display;
static XModifierKeymap	*modmap;


static int 	ValueReturn;


static	XModifierKeymap	*origmap;

static	int	Minkc, Maxkc;

static void
savemap()
{
	startup();
	if(Dsp) {
		origmap = XGetModifierMapping(Dsp);
		XDisplayKeycodes(Dsp, &Minkc, &Maxkc);
	}
}

static void
cleanmap()
{
	if(Dsp)
		XSetModifierMapping(Dsp, origmap);
	cleanup();
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	modmap = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	i;
int 	kpm;
XModifierKeymap	*newmap;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetModifierMapping-1.(A)");
	report_assertion("A succesful call to XSetModifierMapping specifies the");
	report_assertion("KeyCodes of the keys that are to be used as modifiers and");
	report_assertion("returns MappingSuccess.");

	report_strategy("Set up a modifier map.");
	report_strategy("Call XSetModifierMapping to set servers map.");
	report_strategy("Verify that MappingSuccess is returned.");
	report_strategy("Get current map with XGetModifierMapping.");
	report_strategy("Verify that the mapping has been set correctly.");

	tpstartup();
	setargs();
	/*
	 * Because some keycodes may not be usable as modifiers in a server
	 * dependent fashion, then we must take steps to avoid this.
	 * Therefore: get current modifiers and rearrange them.
	 */
	kpm = origmap->max_keypermod;
	modmap = XNewModifiermap(kpm);
	if (modmap == 0) {
		delete("Could not create new map");
		return;
	}

	for (i = 0; i < kpm*8; i++)
		modmap->modifiermap[i] = origmap->modifiermap[kpm*8-1 - i];

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetModifierMapping(display, modmap);
	endcall(display);
	if (ValueReturn != MappingSuccess) {
		report("Returned value was %d, expecting MappingSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	newmap = XGetModifierMapping(display);

	if (newmap->max_keypermod == modmap->max_keypermod)
		CHECK;
	else {
		report("max_keypermod was %d, expecting %d", newmap->max_keypermod,
			modmap->max_keypermod);
		FAIL;
	}

	for (i = 0; i < kpm*8; i += kpm) {
            int j, k;

            /*
             * "The order of keycodes within each set is chosen arbitrarily by
             * the server," so loop over all of the keycodes in both lists to
             * see if any match because the server might have reordered them.
             */
            for (j = i; j < i + kpm; j++) {
                int found = 0;

                for (k = i; !found && k < i + kpm; k++) {
                    if (modmap->modifiermap[j] == newmap->modifiermap[k]) {
                        CHECK;
                        found = 1;
                    }
                }

                if (!found) {
			report("Modifier map was not set correctly");
			FAIL;
			break;
                }
            }
        }

	CHECKPASS(1+kpm*8);

	XFreeModifiermap(newmap);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	n;
XEvent	ev;
XMappingEvent	good;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetModifierMapping-2.(A)");
	report_assertion("When a call to XSetModifierMapping succeeds, then a");
	report_assertion("MappingNotify event is generated.");

	report_strategy("Call XSetModifierMapping to set mapping.");
	report_strategy("Verify that a MappingNotify event is generated.");

	tpstartup();
	setargs();
	modmap = origmap;

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetModifierMapping(display, modmap);
	endcall(display);
	if (ValueReturn != MappingSuccess) {
		report("Returned value was %d, expecting MappingSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	defsetevent(good, display, MappingNotify);
	good.window = None;	/* unused */
	good.request = MappingModifier;
	/* rest not used */

	n = getevent(display, &ev);
	if (n == 0 || ev.type != MappingNotify) {
		report("Expecting a MappingNotify event");
		FAIL;
		return;
	} else
		CHECK;

	if (checkevent((XEvent*)&good, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion XSetModifierMapping-3.(-)");
	report_assertion("The modifiermap member of the XModifierKeymap structure");
	report_assertion("contains eight sets of max_keypermod KeyCodes, one for each");
	report_assertion("modifier in the order Shift, Lock, Control, Mod1, Mod2,");
	report_assertion("Mod3, Mod4, and Mod5.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t004(){

XModifierKeymap	*oldmap;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetModifierMapping-4.(A)");
	report_assertion("When a zero KeyCode occurs in a set, then it is ignored.");

	report_strategy("Set up a mapping with all keycodes zero.");
	report_strategy("Set mapping with XSetModifierMapping.");
	report_strategy("Verify no BadValue error.");

	tpstartup();
	setargs();
	oldmap = XGetModifierMapping(display);
	if (oldmap == 0) {
		delete("Could not get the old map");
		return;
	}

	modmap = XNewModifiermap(1);
	for (i = 0; i < 8; i++)
		modmap->modifiermap[i] = 0;

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetModifierMapping(display, modmap);
	endcall(display);
	if (ValueReturn != MappingSuccess) {
		report("Returned value was %d, expecting MappingSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (geterr() == Success)
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	i;
int 	ret;
int 	found;
XModifierKeymap *newmap;
unsigned int	kc;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetModifierMapping-5.(C)");
	report_assertion("When an implementation restriction on which keys can be");
	report_assertion("used as modifiers is violated, then a call to");
	report_assertion("XSetModifierMapping returns MappingFailed and none of the");
	report_assertion("modifiers are changed.");

	report_strategy("Try in turn all possible keycodes.");
	report_strategy("If all return MappingSuccess:");
	report_strategy("  Report unsupported.");
	report_strategy("else");
	report_strategy("  Verify that MappingFailed is returned.");
	report_strategy("  Verify that modifier has not been set to this keycode.");

	tpstartup();
	setargs();
	if ((modmap = XNewModifiermap(1)) == 0) {
		delete("Failed to create new modifier map");
		return;
	}

	for (i = 0; i < 8; i++)
		modmap->modifiermap[i] = 0;

	found = 0;
	for (kc = Minkc; kc <= Maxkc; kc++) {
		modmap->modifiermap[0] = (KeyCode)kc;

		startcall(display);
		if (isdeleted())
			return;
		ret = XSetModifierMapping(display, modmap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (ret != MappingSuccess) {

			found = True;

			if (ret != MappingFailed) {
				report("Return value was %d, expecting MappingFailure", ret);
				FAIL;
				break;
			}
			newmap = XGetModifierMapping(display);

			if (newmap->modifiermap[0] == (KeyCode)kc) {
				report("An invalid keycode (%u) was set into the map", kc);
				FAIL;
				break;
			} else
				CHECK;
		} else
			CHECK;
	}

	if (!found)
		unsupported("All keycodes are acceptable as modifiers for this server");
	else
		CHECKPASS(Maxkc-Minkc+1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	i;
int 	kpm;
int	modkc;
XModifierKeymap	*newmap;
XModifierKeymap	*oldmap;
int	ret;
KeyCode *kcp;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetModifierMapping-6.(B)");
	report_assertion("When the new KeyCodes specified for a modifier differ from");
	report_assertion("those currently defined and any of the current or new keys");
	report_assertion("for that modifier are in the logically down state, then a");
	report_assertion("call to XSetModifierMapping returns MappingBusy and none of");
	report_assertion("the modifiers are changed.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Get current modifier mapping (other tests may have changed it from origmap).");
	report_strategy("  Make a new modifier map by permuting the old.");
	report_strategy("  Check there is at least one non-zero keycode in it.");
	report_strategy("  Simulate pressing this key using extension.");
	report_strategy("  Call XSetModifierMapping to set the new mod. map.");
	report_strategy("  Expect MappingBusy");
	report_strategy("  Release all keys.");
	report_strategy("  Get current mapping with XGetModifierMapping.");
	report_strategy("  Compare with that got at first.");
	report_strategy("  Remove key from map.");
	report_strategy("  Simulate pressing key not in the map.");
	report_strategy("  Call XSetModifierMapping.");
	report_strategy("  Expect MappingBusy as one of current (at time of XSetModifierMapping call) mod keys pressed.");
	report_strategy("  Release all keys.");
	report_strategy("  Call XSetModifierMapping to set up map to not include this key.");
	report_strategy("  Expect MappingSuccess.");
	report_strategy("  Simulate pressing key not in the map.");
	report_strategy("  Call XSetModifierMapping.");
	report_strategy("  Expect !MappingBusy as key not in current or new maps (at time of XSetModifierMapping call).");
	report_strategy("  Release all keys.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(0))
		return;
	else
		CHECK;

	oldmap = XGetModifierMapping(display);

	/*
	 * Because some keycodes may not be usable as modifiers in a server
	 * dependent fashion, then we must take steps to avoid this.
	 * Therefore: get current modifiers and rearrange them.
	 */
	kpm = oldmap->max_keypermod;
	modmap = XNewModifiermap(kpm);
	if (modmap == 0) {
		delete("Could not create new map");
		XFreeModifiermap(oldmap);
		return;
	}

	modkc = 0;
	for (i = 0; i < kpm*8; i++) {
		KeyCode kc = modmap->modifiermap[i] = oldmap->modifiermap[kpm*8-1 - i];

		if (!modkc && kc) {
			modkc = kc;
			kcp = &(modmap->modifiermap[i]);
		}
	}

	if (!modkc) {
		delete("Can't find a usable modifier key code.");
		XFreeModifiermap(oldmap);
		XFreeModifiermap(modmap);
		return;
	} else
		CHECK;

	keypress(display, modkc);

	startcall(display);
	if (isdeleted())
		return;
	ret = XSetModifierMapping(display, modmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	relalldev();

	if (ret == MappingBusy)
		CHECK;
	else {
		report("Key %d did not cause MappingBusy when pressed.", modkc);
		FAIL;
	}
	/* now check no change occurred */
	newmap = XGetModifierMapping(display);

	if (newmap->max_keypermod == oldmap->max_keypermod)
		CHECK;
	else {
		report("max_keypermod was %d, expecting %d", newmap->max_keypermod,
			oldmap->max_keypermod);
		FAIL;
	}
	for (i = 0; i < kpm*8; i++) {
		if (oldmap->modifiermap[i] == newmap->modifiermap[i])
			CHECK;
		else {
			report("Modifier map was not set correctly");
			FAIL;
			break;
		}
	}

	/* use a key not in new map, but in current, and expect MappingBusy */
	*kcp = 0; /* remove modkc from map */
	keypress(display, modkc);
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetModifierMapping(display, modmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	relalldev();

	if (ret == MappingBusy)
		CHECK;
	else {
		report("Pressing key %d caused %s, not MappingBusy, though in old map.",
			modkc, (ret==MappingSuccess)?"MappingSuccess":"MappingFailed");
		FAIL;
	}
	/* make sure that key is not in map, now */
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetModifierMapping(display, modmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret != MappingSuccess) {
		delete("Can't install new mod. map not including key %d.", modkc);
		XFreeModifiermap(modmap);
		XFreeModifiermap(oldmap);
		XFreeModifiermap(newmap);
		return;
	} else
		CHECK;
	/* use a key not in the new or current map and expect other than MappingBusy */
	keypress(display, modkc);
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetModifierMapping(display, modmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	relalldev();

	if (ret != MappingBusy)
		CHECK;
	else {
		report("Pressing key %d caused MappingBusy though not in new or old map.", modkc);
		FAIL;
	}

	XFreeModifiermap(modmap);
	XFreeModifiermap(oldmap);
	XFreeModifiermap(newmap);

	CHECKPASS(7 + kpm*8);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetModifierMapping-7.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

static void t008(){

int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSetModifierMapping-8.(A)");
	report_assertion("When a KeyCode is not in the range returned by");
	report_assertion("XDisplayKeycodes, then a BadValue error occurs.");

	report_strategy("Call XDisplayKeycodes to get range of valid keycodes.");
	report_strategy("Set up map with keycode less than the minimum value.");
	report_strategy("Call XSetModifierMapping.");
	report_strategy("Verify that a BadValue error occurs.");
	report_strategy("");
	report_strategy("Set up map with keycode greater than the maximum value (if possible).");
	report_strategy("Call XSetModifierMapping.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	modmap = XNewModifiermap(1);
	for (i = 0; i < 8*modmap->max_keypermod; i++)
		modmap->modifiermap[i] = 0;

	modmap->modifiermap[0] = Minkc-1;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetModifierMapping(display, modmap);
	endcall(display);
	if (ValueReturn != MappingFailed) {
		report("Returned value was %d, expecting MappingFailed", ValueReturn);
		FAIL;
	}
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		CHECK;
	else
		FAIL;

	if (Maxkc+1 < 0xff) {
		modmap->modifiermap[0] = Maxkc+1;
		startcall(display);
		if (isdeleted())
			return;
		ValueReturn = XSetModifierMapping(display, modmap);
		endcall(display);
		if (ValueReturn != MappingFailed) {
			report("Returned value was %d, expecting MappingFailed", ValueReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else
			FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = savemap;
void	(*tet_cleanup)() = cleanmap;
