/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime)
 *   Display	*display;
 *   Window	grab_window;
 *   Bool	owner_events;
 *   unsigned int 	event_mask;
 *   int 	pointer_mode;
 *   int 	keyboard_mode;
 *   Window	confine_to;
 *   Cursor	cursor;
 *   Time	thetime;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGrabPointer	1
char    *TestName = "XGrabPointer";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW grab_window
#define A_DRAWABLE grab_window
#define A_WINDOW2 confine_to
#define A_DRAWABLE2 confine_to
#define A_CURSOR cursor


/*
 * Arguments to the XGrabPointer function
 */
static Display	*display;
static Window	grab_window;
static Bool	owner_events;
static unsigned int 	event_mask;
static int 	pointer_mode;
static int 	keyboard_mode;
static Window	confine_to;
static Cursor	cursor;
static Time	thetime;


static int 	ValueReturn;


/*
 * For all these tests note that the grab_window is automatically destroyed
 * at the end of the test, and therefore the grab is released.
 */

/*
 * Get the window that the pointer is currently in, if the pointer
 * is in a child of the given window. Otherwise it returns None.
 */
static Window
getpointerwin(disp, win)
Display	*disp;
Window	win;
{
Window	child;
Window	wtmp;
int 	itmp;
unsigned uitmp;
Bool 	s;

	s = XQueryPointer(disp, win, &wtmp, &child, &itmp, &itmp, &itmp, &itmp
		, &uitmp);

	if (!s)
		delete("Could not get pointer window");

	return(child);
}



/*
 * Returns True if the keyboard is frozen.
 */
static int
iskfrozen()
{
XEvent	ev;
int 	res;
static int 	key;

	XSelectInput(display, grab_window, KeyPressMask);
	XSync(display, True); /* Flush previous events */
	key = getkeycode(display);

	/*
	 * Try to provoke a keypress on grab_window.
	 */
	warppointer(display, grab_window, 1, 1);
	keypress(display, key);
	if (XCheckMaskEvent(display, KeyPressMask, &ev))
		res = False;
	else
		res = True;
	keyrel(display, key);

	return(res);
}



static char	*WindowTree[]= {
	".",
		"child1 . (10,10) 30x30",
		"child2 . (50,50) 30x30",
			"grandchild child2 (2,2) 20x20",
};

static int NWindowTree = NELEM(WindowTree);



/*
 * Returns True if the pointer is grabbed.  This is not a general purpose
 * routine since it knows about the Grab Pointer args.
 * When the pointer is grabbed then pointer events are not reported to
 * non grabbing clients.
 */
static
pgrabbed()
{
Window	win;
Display	*client2;
XEvent	ev;

	if (confine_to != None)
		win = confine_to;
	else
		win = grab_window;

	client2 = opendisplay();
	
	XSelectInput(client2, win, PointerMotionMask|EnterWindowMask);
	/* Flush events for client2 */
	XSync(client2, True);

	/*
	 * Ensure that pointer either enters or moves within win.
	 */
	warppointer(display, win, 1, 1);
	warppointer(display, win, 1, 2);

	XSync(client2, False);
	if (getevent(client2, &ev)) {
		/*
		 * An event was reported - pointer isn't grabbed, do a sanity
		 * check on the type of event.
		 */
		if (ev.type != MotionNotify && ev.type != EnterNotify) {
			delete("Unexpected event received in pgrabbed()");
			delete("  event type %s", eventname(ev.type));
		}
		return(False);
	} else {
		return(True);
	}
}



/* Value list for use in test t030 */
static unsigned long	event_maskvallist[] = {
	ButtonPressMask,
	ButtonReleaseMask,
	EnterWindowMask,
	LeaveWindowMask,
	PointerMotionMask,
	PointerMotionHintMask,
	Button1MotionMask,
	Button2MotionMask,
	Button3MotionMask,
	Button4MotionMask,
	Button5MotionMask,
	ButtonMotionMask,
	KeymapStateMask,
};



/* Value list for use in test t031 */
static int 	pointer_modevallist[] = {
	GrabModeSync,
	GrabModeAsync,
};



/* Value list for use in test t032 */
static int 	keyboard_modevallist[] = {
	GrabModeSync,
	GrabModeAsync,
};



/* Value list for use in test t033 */
static int 	owner_eventsvallist[] = {
	True,
	False,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	grab_window = defwin(display);
	owner_events = True;
	event_mask = 0;
	pointer_mode = GrabModeAsync;
	keyboard_mode = GrabModeAsync;
	confine_to = None;
	cursor = None;
	thetime = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGrabPointer-1.(A)");
	report_assertion("A successful call to XGrabPointer actively grabs control of");
	report_assertion("the pointer and returns GrabSuccess.");

	report_strategy("Call XGrabPointer.");
	report_strategy("Verify that it returns GrabSuccess.");

	tpstartup();
	setargs();
	grab_window = defwin(display);
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret != GrabSuccess) {
		report("GrabSuccess was not returned");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*client2;
XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGrabPointer-2.(A)");
	report_assertion("After a call to XGrabPointer is made by a client, pointer");
	report_assertion("events are reported only to that client.");

	report_strategy("Create second client.");
	report_strategy("Create grab window.");
	report_strategy("Select pointer events for both clients.");
	report_strategy("Grab the pointer.");
	report_strategy("Warp pointer.");
	report_strategy("Verify that the event is only reported to grabbing client.");

	tpstartup();
	setargs();
	client2 = opendisplay();

	grab_window = defwin(display);
	warppointer(display, grab_window, 0, 0);

	XSelectInput(display, grab_window, PointerMotionMask);
	XSelectInput(client2, grab_window, PointerMotionMask);
	XSync(client2, False);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, grab_window, 1, 1);

	if (getevent(display, &ev) == 0 || ev.type != MotionNotify) {
		report("No pointer event occurred on the grabbing client");
		FAIL;
	} else
		CHECK;
	if (getevent(client2, &ev) != 0) {
		report("Event was reported on the non-grabbing client");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window	w1, w2;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGrabPointer-3.(A)");
	report_assertion("A call to XGrabPointer overrides any active pointer grab by");
	report_assertion("this client.");

	report_strategy("Create two windows.");
	report_strategy("Call XGrabPointer with confine_to as one of the windows.");
	report_strategy("Check that pointer is within that window.");
	report_strategy("Call XGrabPointer with confine_to as the other window.");
	report_strategy("Verify that pointer is within the other window.");

	tpstartup();
	setargs();
	/* Move pointer, mainly so that its position will be restored */
	warppointer(display, DRW(display), 0, 0);

	w1 = defwin(display);
	w2 = defwin(display);

	grab_window = w1;
	confine_to = w1;

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (getpointerwin(display, DRW(display)) == confine_to)
		CHECK;
	else {
		delete("Could not set up first grab properly");
		return;
	}

	confine_to = w2;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (getpointerwin(display, DRW(display)) == confine_to)
		CHECK;
	else {
		report("A second grab did not override the first");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Window	win;
XEvent	ev;
XMotionEvent	*mp;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGrabPointer-4.(A)");
	report_assertion("When owner_events is False, then all generated pointer");
	report_assertion("events that are selected by the event_mask are reported with");
	report_assertion("respect to the grab_window.");

	report_strategy("Set owner_events to False.");
	report_strategy("Create grab window.");
	report_strategy("Create other window.");
	report_strategy("Set event-mask to select pointer events.");
	report_strategy("Grab pointer.");
	report_strategy("Warp pointer to other window.");
	report_strategy("Verify that events are reported with respect to the grab window.");

	tpstartup();
	setargs();
	owner_events = False;
	grab_window = defwin(display);
	event_mask = PointerMotionMask;

	win = defwin(display);
	warppointer(display, DRW(display), 0, 0);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	warppointer(display, win, 0, 0);
	warppointer(display, win, 1, 1);

	if (!XCheckMaskEvent(display, (long)event_mask, &ev)) {
		delete("No pointer event was received");
		return;
	} else
		CHECK;

	mp = (XMotionEvent*)&ev;
	if (mp->window == grab_window)
		CHECK;
	else if (mp->window == win) {
		report("Event was unexpectedly received on the pointer window");
		FAIL;
	} else {
		report("Event was not received on the grab_window");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window	window2;
XEvent	ev;
XMotionEvent	*mp;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGrabPointer-5.(A)");
	report_assertion("When owner_events is True, and a pointer event is");
	report_assertion("generated that would normally be reported to the client,");
	report_assertion("then it is reported on the window that it would normally be");
	report_assertion("reported on.");

	report_strategy("Create window for grab window.");
	report_strategy("Create window2.");
	report_strategy("Set owner_events to True.");
	report_strategy("Select pointer events on window2.");
	report_strategy("Grab pointer.");
	report_strategy("Warp pointer in window2.");
	report_strategy("Verify that pointer events are generated on window2.");

	tpstartup();
	setargs();
	grab_window = defwin(display);
	window2 = defwin(display);

	owner_events = True;
	XSelectInput(display, window2, PointerMotionMask);
	warppointer(display, window2, 0, 0);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, window2, 1, 0);

	if (!XCheckMaskEvent(display, PointerMotionMask, &ev)) {
		delete("No pointer event was received");
		return;
	} else
		CHECK;

	mp = (XMotionEvent*)&ev;
	if (mp->window == window2)
		CHECK;
	else if (mp->window == grab_window) {
		report("Event was unexpectedly received on the grab window");
		FAIL;
	} else {
		report("Event was not received on the normal window");
		FAIL;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Window	window2;
XEvent	ev;
XMotionEvent	*mp;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGrabPointer-6.(A)");
	report_assertion("When owner_events is True, and a pointer event is");
	report_assertion("generated that would not normally be reported to the client,");
	report_assertion("and it is selected by event_mask, then it is reported on");
	report_assertion("the grab_window.");

	report_strategy("Create window for grab window.");
	report_strategy("Create window2.");
	report_strategy("Set owner_events to True.");
	report_strategy("Select pointer events in event_mask.");
	report_strategy("Do not select pointer events on window2.");
	report_strategy("Grab pointer.");
	report_strategy("Warp pointer in window2.");
	report_strategy("Verify that pointer events are generated on the grab window.");

	tpstartup();
	setargs();
	grab_window = defwin(display);
	window2 = defwin(display);

	owner_events = True;
	event_mask = PointerMotionMask;
	warppointer(display, window2, 0, 0);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, window2, 1, 0);

	if (!XCheckMaskEvent(display, (long)event_mask, &ev)) {
		delete("No pointer event was received");
		return;
	} else
		CHECK;

	mp = (XMotionEvent*)&ev;
	if (mp->window == grab_window)
		CHECK;
	else if (mp->window == window2) {
		report("Event was unexpectedly received on the source window");
		FAIL;
	} else {
		report("Event was not received on the grab window");
		FAIL;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XGrabPointer-7.(A)");
	report_assertion("When pointer_mode is GrabModeAsync, then pointer event");
	report_assertion("processing continues normally.");

	report_strategy("Grab pointer with pointer_mode GrabModeAsync.");
	report_strategy("Warp pointer.");
	report_strategy("Verify that pointer events are received.");

	tpstartup();
	setargs();
	owner_events = False;
	grab_window = defwin(display);
	event_mask = PointerMotionMask;
	pointer_mode = GrabModeAsync;
	warppointer(display, grab_window, 0, 0);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, grab_window, 1, 1);

	if (!XCheckMaskEvent(display, (long)event_mask, &ev)) {
		delete("No pointer event was received");
		return;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XGrabPointer-8.(A)");
	report_assertion("When pointer_mode is GrabModeAsync and the pointer is");
	report_assertion("currently frozen by this client, then the processing of");
	report_assertion("events for the pointer is resumed.");

	report_strategy("Freeze pointer by grabbing keyboard with pointer_mode GrabModeSync.");
	report_strategy("Warp pointer.");
	report_strategy("Verify that no pointer events received yet.");
	report_strategy("Grab pointer with GrabModeAsync.");
	report_strategy("Verify that the pointer event is now released.");

	tpstartup();
	setargs();
	owner_events = False;
	grab_window = defwin(display);
	event_mask = PointerMotionMask;
	pointer_mode = GrabModeAsync;
	warppointer(display, grab_window, 0, 0);

	/*
	 * Freeze the pointer by grabbing the keyboard.
	 */
	XGrabKeyboard(display, grab_window, False, GrabModeSync, GrabModeAsync, thetime);
	warppointer(display, grab_window, 1, 1);
	if (XCheckMaskEvent(display, (long)event_mask, &ev)) {
		delete("Pointer event was received while frozen");
		return;
	} else
		CHECK;

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (!XCheckMaskEvent(display, (long)event_mask, &ev)) {
		report("Normal pointer processing was not restored");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XGrabPointer-9.(A)");
	report_assertion("When pointer_mode is GrabModeSync, then the state of the");
	report_assertion("pointer, as seen by client applications, appears to freeze,");
	report_assertion("and no further pointer events are generated until the");
	report_assertion("grabbing client calls XAllowEvents or until the pointer grab");
	report_assertion("is released.");

	report_strategy("Grab pointer with GrabModeSync.");
	report_strategy("Warp pointer.");
	report_strategy("Verify that no pointer events are received.");

	tpstartup();
	setargs();
	owner_events = False;
	grab_window = defwin(display);
	event_mask = PointerMotionMask;
	pointer_mode = GrabModeSync;
	warppointer(display, grab_window, 0, 0);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, grab_window, 1, 1);
	if (XCheckMaskEvent(display, (long)event_mask, &ev)) {
		delete("Pointer event was received while frozen");
		return;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XGrabPointer-10.(A)");
	report_assertion("When the pointer is frozen, then the actual pointer changes");
	report_assertion("are not lost and are processed after the grab is released or");
	report_assertion("the client calls XAllowEvents.");

	report_strategy("Grab pointer with GrabModeSync.");
	report_strategy("Warp pointer.");
	report_strategy("Verify that no pointer events are received.");
	report_strategy("Release pointer.");
	report_strategy("Verify that pointer events are now received.");

	tpstartup();
	setargs();
	owner_events = False;
	grab_window = defwin(display);
	event_mask = PointerMotionMask;
	pointer_mode = GrabModeSync;
	warppointer(display, grab_window, 0, 0);
	XSelectInput(display, grab_window, PointerMotionMask);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, grab_window, 1, 1);
	if (XCheckMaskEvent(display, (long)event_mask, &ev)) {
		delete("Pointer event was received while frozen");
		return;
	} else
		CHECK;

	XUngrabPointer(display, CurrentTime);
	XSync(display, False);

	if (XCheckMaskEvent(display, (long)event_mask, &ev) && ev.type == MotionNotify)
		CHECK;
	else {
		report("Pointer event was not saved while pointer was frozen");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XGrabPointer-11.(B)");
	report_assertion("When keyboard_mode is GrabModeAsync, then keyboard event");
	report_assertion("processing is unaffected by activation of the grab.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Grab pointer with keyboard_mode = GrabModeAsync.");
	report_strategy("  Check keyboard not frozen.");
	report_strategy("else");
	report_strategy("  Report untested.");
	report_strategy("");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	keyboard_mode = GrabModeAsync;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (iskfrozen()) {
		report("Keyboard was frozen by GrabModeAsync");
		FAIL;
	} else
		CHECK;

	relalldev();
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XGrabPointer-12.(B)");
	report_assertion("When keyboard_mode is GrabModeSync, then the state of the");
	report_assertion("keyboard, as seen by client applications, appears to freeze,");
	report_assertion("and no further keyboard events are generated until the");
	report_assertion("grabbing client calls XAllowEvents or until the pointer grab");
	report_assertion("is released.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Call XGrabPointer with keyboard_mode GrabModeSync.");
	report_strategy("  Verify that keyboard is frozen.");
	report_strategy("  Release grab.");
	report_strategy("  Verify that keyboard is not frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	keyboard_mode = GrabModeSync;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (iskfrozen())
		CHECK;
	else {
		report("Keyboard was not frozen with keyboard_mode GrabModeSync");
		FAIL;
	}

	XUngrabKeyboard(display, thetime);
	XAllowEvents(display, AsyncKeyboard, thetime);
	if (!iskfrozen())
		CHECK;
	else {
		report("Could not unfreeze keyboard from keyboard_mode GrabModeSync");
		FAIL;
	}

	relalldev();
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	key;
int 	n;
int 	first;
XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XGrabPointer-13.(B)");
	report_assertion("When the keyboard is frozen, then the actual keyboard");
	report_assertion("changes are not lost and are processed after the grab is");
	report_assertion("released or the client calls XAllowEvents.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Enable key events on grab_window.");
	report_strategy("  Call XGrabPointer with keyboard_mode GrabModeSync.");
	report_strategy("  Press and release key.");
	report_strategy("  Check no events arrived yet.");
	report_strategy("  Release grab.");
	report_strategy("  Verify that KeyPress and KeyRelease events are now received.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	key = getkeycode(display);
	XSelectInput(display, grab_window, KeyPressMask|KeyReleaseMask);

	keyboard_mode = GrabModeSync;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, grab_window, 10, 10);
	keypress(display, key);
	keyrel(display, key);

	if (XCheckMaskEvent(display, KeyPressMask|KeyReleaseMask, &ev)) {
		delete("Events received while keyboard supposed to be frozen");
		return;
	} else
		CHECK;

	XUngrabKeyboard(display, thetime);
	XAllowEvents(display, AsyncKeyboard, thetime);
	if (isdeleted())
		return;

	n = getevent(display, &ev);
	if (n != 2) {
		report("Expecting two events to be released after grab");
		report("  got %d", n);
		FAIL;
	} else {
		first = ev.type;
		getevent(display, &ev);

		if (ev.type != KeyPress && first != KeyPress) {
			report("Did not get KeyPress event after releasing grab");
			FAIL;
		} else
			CHECK;
		if (ev.type != KeyRelease && first != KeyRelease) {
			report("Did not get KeyRelease event after releasing grab");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

Cursor	goodcur;
Window	parent,curwin;
Window	windows[7]; /* root + 5 above + None stopper */
Window	root;
Window	*wp;
struct buildtree *tree;
char	*wname;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XGrabPointer-14.(B)");
	report_assertion("When cursor is a valid cursor, then it is displayed");
	report_assertion("regardless of which window the pointer is in.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Make a tree of windows rooted at grab_window, all with default cursor.");
	report_strategy("  Make a non-overlapping sibling of grab_window, the cursor window.");
	report_strategy("  Set that window's cursor to be a good, non default, cursor.");
	report_strategy("  Call XGrabPointer with cursor = the good cursor.");
	report_strategy("  Warp pointer to all windows in the tree, root and cursor window, and");
	report_strategy("    validate that current cursor is equal to that of cursor window");
	report_strategy("    using extension.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (!noext(1)) {

		goodcur = makecur(display);
		wp = windows;
		*wp++ = root = DRW(display);
		*wp++ = parent = grab_window;
		tree = buildtree(display, parent, WindowTree, NWindowTree);
		*wp++ = btntow(tree, "child1");
		*wp++ = btntow(tree, "child2");
		*wp++ = btntow(tree, "grandchild");
		*wp++ = curwin = defwin(display);
		*wp = None;
		XDefineCursor(display, curwin, goodcur);
		(void)warppointer(display, curwin, 2, 2);
		if (spriteiswin(display, parent)) {
			delete("Require XT_FONTCURSOR_GOOD to be other than default.");
			return;
		} else
			CHECK;
	
		cursor = goodcur;
		startcall(display);
		if (isdeleted())
			return;
		ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
		endcall(display);
		if (ValueReturn != GrabSuccess) {
			report("Returned value was %d, expecting GrabSuccess", ValueReturn);
			FAIL;
		}
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	
		for(wp=windows; *wp != None; wp++) { /* around 6 times */
			(void)warppointer(display, *wp, 0,0);
			/* use 0,0 as window making stuff keeps away from there on
			 * root. All of our tree windows are not at 0,0 either
			 */
			if (spriteiswin(display, curwin)) /* true at least once! */
				CHECK;
			else {
				report("Window %s did not have specified cursor as displayed cursor.",
					(wname=btwton(tree,*wp)) ? wname :
						( *wp == root ? "ROOT" : "<Unknown>" ));
				FAIL;
			}
		}
	
		CHECKPASS(1+6);

	} else {

		cursor = makecur(display);

		startcall(display);
		if (isdeleted())
			return;
		ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
		endcall(display);
		if (ValueReturn != GrabSuccess) {
			report("Returned value was %d, expecting GrabSuccess", ValueReturn);
			FAIL;
		}
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		CHECK;

		CHECKUNTESTED(1);
	}

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

Cursor	goodcur1, goodcur2;
Window	parent,gchild;
Window	windows[6]; /* root + 4 above + None stopper */
Window	root;
Window	*wp;
struct buildtree *tree;
char	*wname;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XGrabPointer-15.(B)");
	report_assertion("When cursor is None, then the normal cursor is displayed");
	report_assertion("when the pointer position is in the grab_window and its");
	report_assertion("subwindows, and the grab_window cursor is displayed when the");
	report_assertion("pointer is in any other window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Make a tree of windows rooted at grab_window (parent), all with default cursor.");
	report_strategy("  Set grab_window to be one of its own children (child2), which has its own");
	report_strategy("    child (grandchild).");
	report_strategy("  Set grab_window's cursor to be a good, non default, cursor.");
	report_strategy("  Set grab_window's child's (grandchild) cursor to be yet another good,");
	report_strategy("    non default, cursor.");
	report_strategy("  Call XGrabPointer with cursor = None.");
	report_strategy("  Warp pointer to all windows in the tree, plus root, and");
	report_strategy("    validate that current cursor is equal to that of grab_window & grandchild,");
	report_strategy("    respectively, when in the corresponding windows, but equal to that of");
	report_strategy("    grab_window otherwise, using extension.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(0))
		return;
	goodcur1 = makecur(display);
	goodcur2 = makecur2(display);
	if (isdeleted()) {
		report("Could not make cursors. Check that XT_FONTCURSOR_GOOD");
		report("and XT_FONTCURSOR_GOOD+2 both are good glyphs in cursor font.");
		return;
	}
	wp = windows;
	*wp++ = root = DRW(display);
	*wp++ = parent = grab_window;
	tree = buildtree(display, parent, WindowTree, NWindowTree);
	*wp++ = btntow(tree, "child1");
	*wp++ = grab_window = btntow(tree, "child2");
	*wp++ = gchild = btntow(tree, "grandchild");
	*wp = None;
	XDefineCursor(display, grab_window, goodcur1);
	XDefineCursor(display, gchild, goodcur2);

	(void)warppointer(display, gchild, 2, 2);
	if (spriteiswin(display, grab_window)) {
		delete("Require glyphs XT_FONTCURSOR_GOOD and XT_FONTCURSOR_GOOD+2 to differ in cursor font.");
		return;
	} else
		CHECK;

	cursor = None;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for(wp=windows; *wp != None; wp++) { /* around 5 times */
		(void)warppointer(display, *wp, 0,0);
		/* use 0,0 as window making stuff keeps away from there on
		 * root. All of our tree windows are not at 0,0 either
		 */
		if (!(wname = btwton(tree,*wp)))
			wname = (*wp == root) ? "ROOT" : "<Unknown>";
		if (*wp == grab_window || *wp == gchild) {
			if (spriteiswin(display, *wp))
				CHECK;
			else {
				report("Window %s did not have cursor as its normal cursor", wname);
				report("\twhen in grab_window or descendent.");
				FAIL;
			}
		} else {
			if (spriteiswin(display, grab_window))
				CHECK;
			else {
				report("Window %s did not have cursor as grab_window's cursor", wname);
				report("\twhen not in grab_window or descendent.");
				FAIL;
			}
		}
	}

	CHECKPASS(1+5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XGrabPointer-16.(A)");
	report_assertion("When confine_to is not None, then the pointer is confined");
	report_assertion("to that window.");

	report_strategy("Create grab_window.");
	report_strategy("Create window as the confine_to window.");
	report_strategy("Grab pointer.");
	report_strategy("Verify that pointer is now in the confine_to window.");
	report_strategy("Warp pointer outside confine_to window.");
	report_strategy("Verify that pointer is still within the confine_to window.");

	tpstartup();
	setargs();
	warppointer(display, DRW(display), 0, 0);

	grab_window = defwin(display);
	confine_to = defwin(display);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (getpointerwin(display, DRW(display)) != confine_to) {
		report("Pointer was not warped to confine_to window");
		FAIL;
	} else
		CHECK;

	/* It is known that no window gets created at (0,0) */
	warppointer(display, DRW(display), 0, 0);

	if (getpointerwin(display, DRW(display)) != confine_to) {
		report("Pointer moved out of confine_to window after warp");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

Window	win;
XEvent	ev;
XCrossingEvent	*cp;
XEnterWindowEvent	entergood;
XLeaveWindowEvent	leavegood;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XGrabPointer-17.(A)");
	report_assertion("When the pointer is not initially in the confine_to window,");
	report_assertion("then it is warped automatically to the closest edge just");
	report_assertion("before the grab activates and enter and leave events are");
	report_assertion("generated.");

	report_strategy("Create confine_to window.");
	report_strategy("Create grab_window.");
	report_strategy("Create spare window 'win'.");
	report_strategy("Warp pointer to win.");
	report_strategy("Enable events on win and grab and confine_to windows.");
	report_strategy("Grab pointer.");
	report_strategy("Verify that a leave event is generated on win.");
	report_strategy("Verify that an enter event is generated on the confine_to window.");

	tpstartup();
	setargs();
	warppointer(Dsp, DRW(Dsp), 0, 0);

	grab_window = defwin(display);
	confine_to = defwin(display);
	win = defwin(display);

	warppointer(display, win, 0, 0);

	XSelectInput(display, win, EnterWindowMask|LeaveWindowMask);
	XSelectInput(display, grab_window, EnterWindowMask|LeaveWindowMask);
	XSelectInput(display, confine_to, EnterWindowMask|LeaveWindowMask);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	defsetevent(entergood, display, EnterNotify);
	entergood.window = confine_to;
	entergood.root = DRW(display);
	entergood.subwindow = None;
	entergood.time = 0;
	entergood.mode = NotifyNormal;
	entergood.detail = NotifyNonlinear;
	entergood.same_screen = True;
	entergood.focus = False;
	entergood.state = 0;

	defsetevent(leavegood, display, LeaveNotify);
	leavegood.window = win;
	leavegood.root = DRW(display);
	leavegood.subwindow = None;
	leavegood.time = 0;
	leavegood.mode = NotifyNormal;
	leavegood.detail = NotifyNonlinear;
	leavegood.same_screen = True;
	leavegood.focus = False;
	leavegood.state = 0;

	/*
	 * The first two events are the pointer leaving win and warping to
	 * confine_to.  These are normal mode events.
	 */
	if (getevent(display, &ev) == 0 || ev.type != LeaveNotify) {
		report("No leave notify event for win received");
		FAIL;
	} else
		CHECK;

	cp = (XCrossingEvent*)&ev;
	/* Set the fields that we can't conveniently check */
	leavegood.time = cp->time;
	leavegood.x = cp->x;
	leavegood.y = cp->y;
	leavegood.x_root = cp->x_root;
	leavegood.y_root = cp->y_root;
	leavegood.focus = cp->focus;
	if (checkevent((XEvent*)&leavegood, &ev))
		FAIL;
	else
		CHECK;

	if (getevent(display, &ev) == 0 || ev.type != EnterNotify) {
		report("No enter notify event for confine_to received");
		FAIL;
	} else
		CHECK;

	cp = (XCrossingEvent*)&ev;
	/* Set the fields that we can't conveniently check */
	entergood.time = cp->time;
	entergood.x = cp->x;
	entergood.y = cp->y;
	entergood.x_root = cp->x_root;
	entergood.y_root = cp->y_root;
	entergood.focus = cp->focus;
	if (checkevent((XEvent*)&entergood, &ev))
		FAIL;
	else
		CHECK;

	/*
	 * There are then grab mode enter and leave events to the grab window.
	 */
	leavegood.window = win;
	leavegood.mode = NotifyGrab;
	entergood.window = grab_window;
	entergood.mode = NotifyGrab;

	if (getevent(display, &ev) == 0 || ev.type != LeaveNotify) {
		report("No grab-mode leave notify event for win received");
		FAIL;
	} else
		CHECK;

	cp = (XCrossingEvent*)&ev;
	/* Set the fields that we can't conveniently check */
	leavegood.time = cp->time;
	leavegood.x = cp->x;
	leavegood.y = cp->y;
	leavegood.x_root = cp->x_root;
	leavegood.y_root = cp->y_root;
	leavegood.focus = cp->focus;
	if (checkevent((XEvent*)&leavegood, &ev))
		FAIL;
	else
		CHECK;

	if (getevent(display, &ev) == 0 || ev.type != EnterNotify) {
		report("No grab-mode enter notify event for grab_window received");
		FAIL;
	} else
		CHECK;

	cp = (XCrossingEvent*)&ev;
	/* Set the fields that we can't conveniently check */
	entergood.time = cp->time;
	entergood.x = cp->x;
	entergood.y = cp->y;
	entergood.x_root = cp->x_root;
	entergood.y_root = cp->y_root;
	entergood.focus = cp->focus;
	if (checkevent((XEvent*)&entergood, &ev))
		FAIL;
	else
		CHECK;
	
	CHECKPASS(8);
	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

struct	area	area;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XGrabPointer-18.(A)");
	report_assertion("When the confine_to window is subsequently reconfigured,");
	report_assertion("then the pointer is warped automatically to keep it within");
	report_assertion("the window.");

	report_strategy("Create grab_window and confine_to window.");
	report_strategy("Grab pointer.");
	report_strategy("Move window so that it does not overlap it's previous position.");
	report_strategy("Verify that pointer has been warped to the new position.");

	tpstartup();
	setargs();
	warppointer(display, DRW(display), 0, 0);

	grab_window = defwin(display);

	/*
	 * This time make confine_to a child of grab_window, also make it small
	 * so that moving it will force the pointer to move.
	 */
	setarea(&area, 1, 1, 2, 2);
	confine_to = crechild(display, grab_window, &area);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XMoveWindow(display, confine_to, 20, 20);
	if (isdeleted())
		return;

	if (getpointerwin(display, grab_window) == confine_to)
		CHECK;
	else {
		report("Pointer was not kept within confine_to when confine_to was moved");
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

Window	root;
Window	wtmp;
int 	itmp;
unsigned uitmp;
Bool 	s;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XGrabPointer-19.(C)");
	report_assertion("If multiple screens are supported: When the confine_to");
	report_assertion("window and the grab_window are not on the same screen, then");
	report_assertion("the pointer is warped to the screen containing the");
	report_assertion("confine_to window.");

	report_strategy("If only one screen");
	report_strategy("  UNSUPPORTED.");
	report_strategy("Create grab_window on default screen.");
	report_strategy("Create confine_to window on alternate screen.");
	report_strategy("Grab pointer.");
	report_strategy("Verify that pointer is warped to other screen.");

	tpstartup();
	setargs();
	if (config.alt_screen < 0) {
		unsupported("Only one screen supported");
		return;
	}

	warppointer(display, DRW(display), 0, 0);

	grab_window = defwin(display);
	confine_to = defdraw(display, VI_ALT_WIN);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Query Pointer returns false if the pointer is not the same screen as
	 * the given window.  Check with both windows, mainly as a sanity check
	 * against them being on the same screen.
	 */
	s = XQueryPointer(display, confine_to, &root, &wtmp, &itmp, &itmp,
		&itmp, &itmp , &uitmp);
	if (s)
		CHECK;
	else {
		report("Pointer was not warped to confine_to window on other screen");
		FAIL;
	}

	s = XQueryPointer(display, grab_window, &root, &wtmp, &itmp, &itmp,
		&itmp, &itmp , &uitmp);
	if (s) {
		report("Pointer was not warped to confine_to window on other screen");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

Time	t1,t2;
int	rc;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XGrabPointer-20.(B)");
	report_assertion("When a successful call to XGrabPointer is made, then the");
	report_assertion("last-pointer-grab time is set to the specified time with");
	report_assertion("CurrentTime replaced by the current X server time.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Call XGrabPointer with time = gettime(display).");
	report_strategy("  Check result and that pointer is grabbed.");
	report_strategy("  Attempt XUngrabPointer at time just before time.");
	report_strategy("  Check still grabbed.");
	report_strategy("  Attempt XUngrabPointer at time equal to time.");
	report_strategy("  Check no longer grabbed.");
	report_strategy("");
	report_strategy("  Get time before with gettime(display).");
	report_strategy("  Call XGrabPointer with time = CurrentTime.");
	report_strategy("  Check result and that pointer is grabbed.");
	report_strategy("  Attempt XUngrabPointer at time before.");
	report_strategy("  Check still grabbed.");
	report_strategy("  Attempt XUngrabPointer at CurrentTime.");
	report_strategy("  Check no longer grabbed.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(0))
		return;
	else
		CHECK;
	XSync(display, True);
	t1 = gettime(display);
	if (t1 == CurrentTime) {
		delete("Could not get server time.");
		return;
	} else
		CHECK;

	thetime = t1;
	startcall(display);
	if (isdeleted())
		return;
	rc = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (!pgrabbed()) {
		delete("Failed to grab and result was %s.", grabreplyname(rc));
		return;
	} else if (rc != GrabSuccess) {
		report("Grab succeeded but result was %s.", grabreplyname(rc));
		FAIL;
	} else
		CHECK;
	/* now set up OK */
	trace("Grabbed at time 0x%lx.",(unsigned long)thetime);
	XUngrabPointer(display, thetime - 1);
	if (!pgrabbed()) {
		report("Last pointer grab time set earlier than specified time.");
		FAIL;
	} else
		CHECK;
	XUngrabPointer(display, thetime);
	if (pgrabbed()) {
		report("Last pointer grab time set later than specified time.");
		FAIL;
	} else
		CHECK;

	XUngrabPointer(display, CurrentTime); /* last despairing attempt */
	if (pgrabbed()) {
		delete("Cannot release pointer grab to perform CurrentTime tests.");
		return;
	} else
		CHECK;

	XSync(display, True);
	t1 = gettime(display);
	if (t1 == CurrentTime) {
		delete("Could not get earlier server time.");
		return;
	} else
		CHECK;

	thetime = CurrentTime;
	startcall(display);
	if (isdeleted())
		return;
	rc = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (!pgrabbed()) {
		delete("Failed to grab at CurrentTime and result was %s.", grabreplyname(rc));
		return;
	} else if (rc != GrabSuccess) {
		report("Grab succeeded at CurrentTime but result was %s.", grabreplyname(rc));
		FAIL;
	} else
		CHECK;
	/* now set up OK */
	t2 = gettime(display);
	if (t2 == CurrentTime) {
		delete("Could not get later server time.");
		return;
	} else
		CHECK;

	trace("Grabbed at time between 0x%lx and 0x%lx (diff = %d).",t1,t2,t2-t1);
	XUngrabPointer(display, t1);
	if (!pgrabbed()) {
		report("Last pointer grab time set earlier than 0x%lx.",t1);
		FAIL;
	} else
		CHECK;
	XUngrabPointer(display, t2);
	if (pgrabbed()) {
		report("Last pointer grab time set later than 0x%lx.", t2);
		FAIL;
	} else
		CHECK;

	CHECKPASS(11);
	
	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

Display	*client2;
Window	win;
XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XGrabPointer-21.(A)");
	report_assertion("When the grab_window or confine_to window becomes not");
	report_assertion("viewable during an active pointer grab, then the grab is");
	report_assertion("released.");

	report_strategy("Create new client, client2.");
	report_strategy("Create grab and confine_to windows.");
	report_strategy("Create spare window 'win' that does not overlap with the other two.");
	report_strategy("Enable events on win for client2.");
	report_strategy("Grab pointer.");
	report_strategy("Unmap grab_window.");
	report_strategy("Verify that grab is released by provoking pointer events for client2.");
	report_strategy("");
	report_strategy("Re-map grab_window.");
	report_strategy("Grab pointer.");
	report_strategy("Unmap confine_to window.");
	report_strategy("Verify that grab is released by provoking pointer events for client2.");

	tpstartup();
	setargs();
	warppointer(display, DRW(display), 0, 0);

	client2 = opendisplay();

	grab_window = defwin(display);
	confine_to = defwin(display);
	win = defwin(display);

	XSelectInput(client2, win, PointerMotionMask|EnterWindowMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XUnmapWindow(display, grab_window);

	/*
	 * Warp into win and force all events to be received.
	 * If the grab has been released then this will generate
	 * an event for client2.
	 */
	warppointer(display, win, 0, 0);
	XSync(client2, False);

	if (XCheckWindowEvent(client2, win, PointerMotionMask|EnterWindowMask, &ev))
		CHECK;
	else {
		report("Grab was not released when grab_window was unmapped");
		FAIL;
	}

	/* Clear any extra events */
	XSync(client2, True);

	/* Now repeat for confine_to window. */
	XMapWindow(display, grab_window);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XUnmapWindow(display, confine_to);

	/* Warp to win and check for events on client2 */
	warppointer(display, win, 0, 0);
	XSync(client2, False);

	if (XCheckWindowEvent(client2, win, PointerMotionMask|EnterWindowMask, &ev))
		CHECK;
	else {
		report("Grab was not released when confine_to window was unmapped");
		FAIL;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t022(){

Display	*client2;
Window	win;
XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XGrabPointer-22.(A)");
	report_assertion("When window reconfiguration causes the confine_to window to");
	report_assertion("lie completely outside the boundaries of the root window");
	report_assertion("during an active pointer grab, then the grab is released.");

	report_strategy("Create second client.");
	report_strategy("Create grab and confine_to windows.");
	report_strategy("Create window, win.");
	report_strategy("Select events on win for second client.");
	report_strategy("Grab pointer.");
	report_strategy("Move confine_to window off the root window.");
	report_strategy("Verify that grab is released by provoking an event for second client.");

	tpstartup();
	setargs();
	warppointer(display, DRW(display), 0, 0);

	client2 = opendisplay();

	grab_window = defwin(display);
	confine_to = defwin(display);
	win = defwin(display);

	XSelectInput(client2, win, PointerMotionMask|EnterWindowMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XMoveWindow(display, confine_to, -9000, -9000);
	warppointer(display, win, 0, 0);
	XSync(client2, False);

	if (isdeleted())
		return;

	if (XCheckWindowEvent(client2, win, PointerMotionMask|EnterWindowMask, &ev))
		CHECK;
	else {
		report("Grab was not released when the confine_to window was placed beyond root window");
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t023(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion XGrabPointer-23.(A)");
	report_assertion("When the grab_window is not viewable, then a call to");
	report_assertion("XGrabPointer fails and returns GrabNotViewable.");

	report_strategy("Create unmapped grab window.");
	report_strategy("Attempt to grab pointer.");
	report_strategy("Verify that XGrabPointer fails and returns GrabNotViewable.");

	tpstartup();
	setargs();
	grab_window = defwin(display);
	XUnmapWindow(display, grab_window);

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabNotViewable)
		PASS;
	else {
		report("Return value was %s, expecting GrabNotViewable", grabreplyname(ret));
		FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t024(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion XGrabPointer-24.(A)");
	report_assertion("When the confine_to window is not viewable, then a call to");
	report_assertion("XGrabPointer fails and returns GrabNotViewable.");

	report_strategy("Create unmapped confine_to window.");
	report_strategy("Attempt to grab pointer.");
	report_strategy("Verify that XGrabPointer fails and returns GrabNotViewable.");

	tpstartup();
	setargs();
	warppointer(Dsp, DRW(Dsp), 0, 0);

	grab_window = defwin(display);
	confine_to = defwin(display);
	XUnmapWindow(display, confine_to);

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabNotViewable)
		PASS;
	else {
		report("Return value was %s, expecting GrabNotViewable", grabreplyname(ret));
		FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t025(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(25);

	report_assertion("Assertion XGrabPointer-25.(A)");
	report_assertion("When the confine_to window lies completely outside the");
	report_assertion("boundaries of the root window, then a call to XGrabPointer");
	report_assertion("fails and returns GrabNotViewable.");

	report_strategy("Create confine_to window.");
	report_strategy("Move outside root window.");
	report_strategy("Attempt to grab pointer.");
	report_strategy("Verify that XGrabPointer fails and returns GrabNotViewable.");

	tpstartup();
	setargs();
	warppointer(Dsp, DRW(Dsp), 0, 0);

	grab_window = defwin(display);
	confine_to = defwin(display);
	XMoveWindow(display, confine_to, -9000, -9000);

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabNotViewable)
		PASS;
	else {
		report("Return value was %s, expecting GrabNotViewable", grabreplyname(ret));
		FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t026(){

Display	*client2;
int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(26);

	report_assertion("Assertion XGrabPointer-26.(A)");
	report_assertion("When the pointer is actively grabbed by some other client,");
	report_assertion("then a call to XGrabPointer fails and returns AlreadyGrabbed.");

	report_strategy("Create client2.");
	report_strategy("Grab pointer with client2.");
	report_strategy("Attempt to grab pointer with default client.");
	report_strategy("Verify that XGrabPointer fails and returns AlreadyGrabbed.");

	tpstartup();
	setargs();
	if ((client2 = opendisplay()) == 0)
		return;

	grab_window = defwin(Dsp);
	if (isdeleted())
		return;

	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	display = Dsp;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == AlreadyGrabbed)
		CHECK;
	else {
		report("Return value was %s, expecting AlreadyGrabbed", grabreplyname(ret));
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t027(){

Display	*client2;
int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(27);

	report_assertion("Assertion XGrabPointer-27.(A)");
	report_assertion("When the pointer is frozen by an active grab of another");
	report_assertion("client, then a call to XGrabPointer fails and returns");
	report_assertion("GrabFrozen.");

	report_strategy("Create client2.");
	report_strategy("Grab keyboard and freeze pointer with client2.");
	report_strategy("Attempt to grab pointer with default client.");
	report_strategy("Verify that XGrabPointer fails and returns GrabFrozen.");

	tpstartup();
	setargs();
	if ((client2 = opendisplay()) == 0)
		return;

	grab_window = defwin(display);

	if (XGrabKeyboard(client2, grab_window, True, GrabModeSync, GrabModeAsync, CurrentTime) != GrabSuccess) {
		delete("Could not freeze pointer by grabbing keyboard");
		return;
	}
	
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabFrozen)
		CHECK;
	else {
		report("Return value was %s, expecting GrabFrozen", grabreplyname(ret));
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t028(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(28);

	report_assertion("Assertion XGrabPointer-28.(A)");
	report_assertion("When the specified time is earlier than the");
	report_assertion("last-pointer-grab time or later than the current X server");
	report_assertion("time, then a call to XGrabPointer fails and returns");
	report_assertion("GrabInvalidTime.");

	report_strategy("Grab pointer with a given time.");
	report_strategy("Release grab.");
	report_strategy("Grab pointer with earlier time.");
	report_strategy("Verify that XGrabPointer fails and returns GrabInvalidTime.");
	report_strategy("Get current server time.");
	report_strategy("Grab pointer with later time.");
	report_strategy("Verify that XGrabPointer fails and returns GrabInvalidTime.");

	tpstartup();
	setargs();
	grab_window = defwin(display);

	/* get time from the server */
	thetime = gettime(display);

	/* This sets the last-pointer-grab time */
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XUngrabPointer(display, thetime);

	thetime -= 100;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabInvalidTime)
		CHECK;
	else {
		report("Return value was %s, expecting GrabInvalidTime",
			grabreplyname(ret));
		FAIL;
	}
	XUngrabPointer(display, thetime);

	/*
	 * Get current time again and add several minutes to get a time in the
	 * future.
	 */
	thetime = gettime(display);
	thetime += ((config.speedfactor+1) * 1000000);

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabInvalidTime)
		CHECK;
	else {
		 report("Returned valued was %s, expecting GrabInvalidTime", grabreplyname(ret));
		 FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECur.mc */
/* End of included file error/ECur.mc */

/* Including from file error/ECur.mc */
static void t029(){

unsigned int shape;
int 	pass = 0, fail = 0;

 	report_purpose(29);

	report_assertion("Assertion XGrabPointer-29.(A)");
	report_assertion("When a cursor argument does not name a valid Cursor, then a");
	report_assertion("BadCursor error occurs.");

	report_strategy("Create cursor with shape XT_FONTCURSOR_GOOD in font cursor.");
	report_strategy("Free cursor.");
	report_strategy("Call test function using bad cursor as the cursor argument.");
	report_strategy("Verify that a BadCursor error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	/* UNSUPPORTED is not allowed */
	shape = config.fontcursor_good;
	if (config.fontcursor_good == -1) {
		delete("A value of UNSUPPORTED is not allowed for XT_FONTCURSOR_GOOD");
		return;
	}

	A_CURSOR = XCreateFontCursor(A_DISPLAY, shape);
	XFreeCursor(A_DISPLAY, A_CURSOR);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != BadCursor) {
		report("Got %s, Expecting BadCursor", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadCursor)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECur.mc */

/* Including from file Mval.tmc.3576 */
/* End of included file Mval.tmc.3576 */

/* Including from file error/EVal.mc */
static void t030(){

#undef	VALUE_ARG
#define	VALUE_ARG event_mask
#undef	VALUE_LIST
#define	VALUE_LIST event_maskvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE unsigned
#undef	NOTMEMBER
#define	NOTMEMBER notmaskmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(30);

	report_assertion("Assertion XGrabPointer-30.(A)");
	report_assertion("When the value of event_mask is not a bitwise combination");
	report_assertion("of ButtonPressMask, ButtonReleaseMask, EnterWindowMask,");
	report_assertion("LeaveWindowMask, PointerMotionMask, PointerMotionHintMask,");
	report_assertion("Button1MotionMask, Button2MotionMask, Button3MotionMask,");
	report_assertion("Button4MotionMask, Button5MotionMask, ButtonMotionMask or");
	report_assertion("KeymapStateMask, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
		endcall(display);
		if (ValueReturn != GrabSuccess) {
			report("Returned value was %d, expecting GrabSuccess", ValueReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file Mval.tmc.3576 */
/* End of included file Mval.tmc.3576 */

/* Including from file error/EVal.mc */
static void t031(){

#undef	VALUE_ARG
#define	VALUE_ARG pointer_mode
#undef	VALUE_LIST
#define	VALUE_LIST pointer_modevallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(31);

	report_assertion("Assertion XGrabPointer-31.(A)");
	report_assertion("When the value of pointer_mode is other than GrabModeSync");
	report_assertion("or GrabModeAsync, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
		endcall(display);
		if (ValueReturn != GrabSuccess) {
			report("Returned value was %d, expecting GrabSuccess", ValueReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file Mval.tmc.3576 */
/* End of included file Mval.tmc.3576 */

/* Including from file error/EVal.mc */
static void t032(){

#undef	VALUE_ARG
#define	VALUE_ARG keyboard_mode
#undef	VALUE_LIST
#define	VALUE_LIST keyboard_modevallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(32);

	report_assertion("Assertion XGrabPointer-32.(A)");
	report_assertion("When the value of keyboard_mode is other than GrabModeSync");
	report_assertion("or GrabModeAsync, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
		endcall(display);
		if (ValueReturn != GrabSuccess) {
			report("Returned value was %d, expecting GrabSuccess", ValueReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file Mval.tmc.3576 */
/* End of included file Mval.tmc.3576 */

/* Including from file error/EVal.mc */
static void t033(){

#undef	VALUE_ARG
#define	VALUE_ARG owner_events
#undef	VALUE_LIST
#define	VALUE_LIST owner_eventsvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(33);

	report_assertion("Assertion XGrabPointer-33.(A)");
	report_assertion("When the value of owner_events is other than True or False,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
		endcall(display);
		if (ValueReturn != GrabSuccess) {
			report("Returned value was %d, expecting GrabSuccess", ValueReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t034(){

int 	pass = 0, fail = 0;

 	report_purpose(34);

	report_assertion("Assertion XGrabPointer-34.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	seterrdef();
	A_WINDOW2 = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, thetime);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ t029, 29 },
	{ t030, 30 },
	{ t031, 31 },
	{ t032, 32 },
	{ t033, 33 },
	{ t034, 34 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
