/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_Expose	1
char    *TestName = "Expose";



#define	EVENT		Expose
#define	MASK		ExposureMask

int 	tet_thistest;

static void t001(){

Display	*display = Dsp;
Window	w;
XEvent	event_return;
int	events;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion Expose-1.(A)");
	report_assertion("The server does not generate Expose events on windows whose");
	report_assertion("class is specified as InputOnly.");

	report_strategy("Create InputOnly window.");
	report_strategy("Select for Expose and MapNotify events on window.");
	report_strategy("Map window.");
	report_strategy("Verify that a MapNotify event was received.");
	report_strategy("Verify that no Expose events were received.");

	tpstartup();
#ifdef	OTHERMASK
#undef	OTHERMASK
#endif
#define	OTHERMASK	StructureNotifyMask
#ifdef	OTHEREVENT
#undef	OTHEREVENT
#endif
#define	OTHEREVENT	MapNotify

/* Create InputOnly window. */
	w = iponlywin(display);
/* Select for Expose and MapNotify events on window. */
	XSelectInput(display, w, MASK|OTHERMASK);
/* Map window. */
	XSync(display, True);
	XMapWindow(display, w);
	XSync(display, False);
/* Verify that a MapNotify event was received. */
	if (!XCheckTypedWindowEvent(display, w, OTHEREVENT, &event_return)) {
		delete("Expected %s event, got none", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
/* Verify that no Expose events were received. */
	if (XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		delete("Got %s event, expected none", eventname(EVENT));
		return;
	}
	else
		CHECK;
	events = XPending(display);
	if (events > 0) {
		delete("Received %d more events than expected", events);
		return;
	}
	else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion Expose-2.(-)");
	report_assertion("When no valid contents are available for regions of a");
	report_assertion("window and the regions are visible, then an Expose event is");
	report_assertion("generated.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

/* Including from file Mdefcode.tmc.312 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion Expose-3.(B)");
	report_assertion("When no valid contents are available for regions of a");
	report_assertion("window and the regions are viewable but not visible and the");
	report_assertion("server is maintaining backing store on the window, then an");
	report_assertion("Expose event is generated.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.312 */

/* Including from file Mdefcode.tmc.312 */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion Expose-4.(B)");
	report_assertion("When no valid contents are available for regions of a");
	report_assertion("window and the window is not viewable but the server is");
	report_assertion("honoring the window's backing-store attribute of Always or");
	report_assertion("WhenMapped, then an Expose event is generated.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.312 */

static void t005(){

Display	*display;
Winh	*eventw;
Winhe	*winhe;
int	expected;
int	lastcount;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion Expose-5.(A)");
	report_assertion("When an Expose events are generated, then they are");
	report_assertion("contiguously delivered by the server.");

	report_strategy("Create client.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Choose event window.");
	report_strategy("Select for Visibility events on all windows.");
	report_strategy("Select for Expose events on event window.");
	report_strategy("Unmap and remap event window to generate Expose events.");
	report_strategy("Verify that Expose events are contiguously delivered.");

	tpstartup();
/* Create client. */
	/*
	 * Do not use Dsp because we are selecting on root window.
	 * We could instead de-select on root window prior to returning,
	 * but this is actually easier.
	 */
	display = opendisplay();
	if (display == (Display *) NULL) {
		delete("Could not open display.");
		return;
	}
	else
		CHECK;
/* Build and create window hierarchy. */
	if (winh(display, 2, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Choose event window. */
	eventw = guardian->firstchild;
/* Select for Visibility events on all windows. */
	if (winh_selectinput(display, (Winh *)NULL, VisibilityChangeMask))
		return;
	else
		CHECK;
/* Select for Expose events on event window. */
	if (winh_selectinput(display, eventw, VisibilityChangeMask|MASK))
		return;
	else
		CHECK;
/* Unmap and remap event window to generate Expose events. */
	XUnmapWindow(display, eventw->window);
	XSync(display, True);
	XMapWindow(display, eventw->window);
	XSync(display, False);
/* Verify that events are contiguously delivered. */
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_qdel == (Winhe *) NULL) {
		delete("No events delivered.");
		return;
	}
	else
		CHECK;
	winhe = winh_qdel;
	while (winhe && winhe->event->type == VisibilityNotify)
		winhe = winhe->next;
	expected = -1;
	for ( ; winhe && expected; winhe = winhe->next) {
		if (expected == -1)
			CHECK;
		if (winhe->event->type != EVENT) {
			report("Received %s event while only expecting %s types",
				eventname(winhe->event->type), eventname(EVENT));
			delete("Unexpected event received.");
			return;
		}
		if (winhe->event->xexpose.window != eventw->window) {
			report("Received event on wrong window, got %d expecting %d",
				winhe->event->xexpose.window, eventw->window);
			delete("Unexpected event received.");
			return;
		}
		lastcount = winhe->event->xexpose.count;
		if (lastcount < expected)
			expected--;
		else
			expected = lastcount;
	}
	if (lastcount != 0) {
		report("Last %s had count set to %d, not zero",
			eventname(EVENT), lastcount);
		FAIL;
	}
	else
		CHECK;
	while (winhe && winhe->event->type == VisibilityNotify)
		winhe = winhe->next;
	if (winhe) {
		report("Received %s event while only expecting %s types",
			eventname(winhe->event->type), eventname(VisibilityNotify));
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(9);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display	*display = Dsp;
Display	*client2, *client3;
Winh	*eventw;
Window	w;
XEvent	event_return;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion Expose-6.(A)");
	report_assertion("When an Expose event is generated, then all clients having");
	report_assertion("set ExposureMask event mask bits on the event window are");
	report_assertion("delivered an Expose event.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Choose event window.");
	report_strategy("Select for Expose events on event window.");
	report_strategy("Select for Expose events on event window with client2.");
	report_strategy("Select for no events on event window with client3.");
	report_strategy("Unmap and remap event window to generate Expose events.");
	report_strategy("Verify that events are delivered to selecting clients.");
	report_strategy("Verify that no Expose events are received for client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Build and create window hierarchy. */
	if (winh(display, 2, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Choose event window. */
	eventw = guardian->firstchild;
	w = eventw->window;
/* Select for Expose events on event window. */
	XSelectInput(display, w, MASK);
/* Select for Expose events on event window with client2. */
	XSelectInput(client2, w, MASK);
/* Select for no events on event window with client3. */
	XSelectInput(client3, w, NoEventMask);
/* Unmap and remap event window to generate Expose events. */
	XUnmapWindow(display, eventw->window);
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XMapWindow(display, eventw->window);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Verify that events are delivered to selecting clients. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		delete("Expected %s event, got none", eventname(EVENT));
		return;
	}
	else
		CHECK;
	if (!XCheckTypedWindowEvent(client2, w, EVENT, &event_return)) {
		delete("Expected %s event, got none with client2", eventname(EVENT));
		return;
	}
	else
		CHECK;
/* Verify that no Expose events are received for client3. */
	if (XCheckTypedWindowEvent(client3, w, EVENT, &event_return)) {
		delete("Got %s event, expected none", eventname(EVENT));
		return;
	}
	else
		CHECK;

	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){


 	report_purpose(7);

	report_assertion("Assertion Expose-7.(-)");
	report_assertion("When an Expose event is generated, then clients not having");
	report_assertion("set ExposureMask event mask bits on the event window are not");
	report_assertion("delivered an Expose event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
