/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XHostAdress *
 *   XListHosts(display, nhosts_return, state_return)
 *   Display	*display;
 *   int 	*nhosts_return;
 *   Bool	*state_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XListHosts	1
char    *TestName = "XListHosts";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XListHosts function
 */
static Display	*display;
static int 	*nhosts_return;
static Bool	*state_return;



#include	"xthost.h"

static	int 	Nhosts;
static	Bool	State;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	nhosts_return = &Nhosts;
	state_return = &State;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XHostAddress	*list;
int 	couldadd = 0;
int 	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XListHosts-1.(A)");
	report_assertion("A call to XListHosts returns a pointer to a list of host");
	report_assertion("structures, that can be freed with XFree, for hosts that");
	report_assertion("are in the current access control list and returns the size");
	report_assertion("of the list in nhosts_return.");

	report_strategy("Attempt to add some hosts to the access list.");
	report_strategy("If BadAccess error:");
	report_strategy("  Note that the known address will not necessarily be in list.");
	report_strategy("Call XListHosts.");
	report_strategy("If hosts were added to the access list:");
	report_strategy("  Verify that nhosts_return is greater than or equal to number of known names.");
	report_strategy("  Verify that each known name is in the list.");
	report_strategy("Verify that nhosts_return addresses can be accessed in the return value.");
	report_strategy("Free returned value with XFree.");

	tpstartup();
	setargs();
	CATCH_ERROR(display);
	XAddHosts(display, xthosts, nxthosts);
	RESTORE_ERROR(display);

	if (GET_ERROR(display) == BadAccess) {
		couldadd = False;
		debug(1, "Could not add hosts");
	} else {
		couldadd = True;
	}

	startcall(display);
	if (isdeleted())
		return;
	list = XListHosts(display, nhosts_return, state_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (couldadd) {
		if (*nhosts_return >= nxthosts)
			CHECK;
		else {
			report("nhosts was %d, expecting at least %d",
				*nhosts_return, nxthosts);
			FAIL;
		}

		for (i = 0; i < nxthosts; i++) {
			for (j = 0; j < *nhosts_return; j++) {
				if (samehost(&xthosts[i], &list[j]))
					break;
			}
			if (j == *nhosts_return) {
				report("Host list did not include xthosts[%d]", i);
				FAIL;
			} else if (i == 0)
				CHECK;
		}
	} else {
		CHECK; CHECK;	/* For balance */
	}

	for (j = 0; j < *nhosts_return; j++) {
		/* Do something to access addresses */
		trace("family=%d, length=%d", list[j].family, list[j].length);
	}
	XFree((char*)list);

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XHostAddress	*list;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XListHosts-2.(A)");
	report_assertion("A call to XListHosts returns a boolean to state_return that");
	report_assertion("is True to mean that the use of the list is enabled for");
	report_assertion("restricting the hosts that are allowed to make connections");
	report_assertion("and is False to mean that the use of the list is disabled");
	report_assertion("and that any host can connect.");

	report_strategy("Call XListHosts.");
	report_strategy("Verify that state_return is either True or False.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	list = XListHosts(display, nhosts_return, state_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (*state_return == True || *state_return == False)
		CHECK;
	else {
		report("State return was neither True or False");
		FAIL;
	}

	CHECKPASS(1);

	XFree((char*)list);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
