/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XAllowDeviceEvents(display, device, event_mode, time1)
 *   Display	*display;
 *   XDevice *device;
 *   int	event_mode;
 *   Time	time1 ;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XAllowDeviceEvents	1
char    *TestName = "XAllowDeviceEvents";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XAllowDeviceEvents function
 */
static Display	*display;
static XDevice *device;
static int	event_mode;
static Time	time1 ;


#include <stdio.h>
extern ExtDeviceInfo Devs;

/*
 * A window for use as a grab window in the freeze and freezecheck
 * routines.
 */
static	Window	grabwin;
static	int dmn, dbp, dbr;
static	XEventClass class[3];

/*
 * Verify devices and create grab window.
 */

static int
grabstartup()
{

	if (Dsp==NULL)
		return;

	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("Required extension device not available for %s.\n", TestName);
	    return(0);
	    }
	grabwin = defwin(Dsp);
	device = Devs.Button;
	DeviceMotionNotify(Devs.Button, dmn, class[0]);
	DeviceButtonPress(device, dbp, class[1]);
	DeviceButtonRelease(device, dbr, class[2]);
	XSelectExtensionEvent(Dsp, grabwin, class, 3);
	warppointer(Dsp, grabwin, 1, 1);
	XSync(Dsp,0);
	return (1);
}
/*
 * Destroy the grab window.
 */

static void
grabcleanup()
{
	if (Dsp)
	    XDestroyWindow(Dsp, grabwin);
}

/*
 * Grab and freeze the device.
 */
static void
grabfreezedevice(disp, time)
Display	*disp;
Time	time;
{

	device = Devs.Button;
	XGrabDevice(disp, device, grabwin, True, 3, 
	    class, GrabModeSync, GrabModeAsync, time);
}

/*
 * Return True if the device is frozen.  We generate a motion event on the
 * device and check to see if we can receive it.  If we receive it,
 * then the device is not frozen.
 */
static	Bool
ispfrozen(disp)
Display	*disp;
{
int axisval=0, ret=True;
XEvent ev;

	 XSync(display, True); /* Flush previous events */
	SimulateDeviceMotionEvent(display, Devs.Button, False, 1, &axisval, 0);
	XSync(display,0);
	while (XPending(display))
	    {
	    XNextEvent(display, &ev);
	    if (ev.type == dmn)
		ret = False;
	    }
	return(ret);
}



/*
 * Returns True if the keyboard is frozen.
 */
static
iskfrozen(display)
Display	*display;
{
XEvent	ev;
Window	win;
int 	res;
int 	key;

	XSync(display, True); /* Flush previous events */
	key = getkeycode(display);

	/*
	 * Try to provoke a keypress on win.
	 */
	win = defwin(display);
	XSelectInput(display, win, KeyPressMask);
	warppointer(display, win, 1, 1);
	keypress(display, key);
	if (XCheckMaskEvent(display, (long)KeyPressMask, &ev))
		res = False;
	else
		res = True;

	return(res);
}

/*
 * Set up for SyncAll tests grab and freeze both device and keyboard.
 */
bothset()
{

	device = Devs.Button;
	XUngrabDevice(display, device, CurrentTime);
	XUngrabKeyboard(display, CurrentTime);

	warppointer(display, grabwin, 5, 5);

	XGrabDevice(display, device, grabwin, False, 3, 
		class, GrabModeSync, GrabModeAsync, CurrentTime);

	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
		    CurrentTime);

	if (!ispfrozen(display)) {
	    delete("Could not freeze device");
	    return;
	    }
	/*
	 * Can't check for the keyboard being frozen here since that requires
	 * pressing a key - and that would release the grab.
	 */
    }


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	event_mode = AsyncThisDevice;
	time1 = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XAllowDeviceEvents-1.(B)");
	report_assertion("When the specified time is earlier than the last-grab time");
	report_assertion("of the most recent active grab for the client or later than");
	report_assertion("the current X server time, then a call to XAllowDeviceEvents");
	report_assertion("has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab and freeze device with a given time.");
	report_strategy("Call XAllowDeviceEvents with earlier time and AsyncThisDevice.");
	report_strategy("Verify that the device is still frozen.");
	report_strategy("Get current server time.");
	report_strategy("Call XAllowDeviceEvents with a later time.");
	report_strategy("Verify that the device is still frozen.");

	tpstartup();
	setargs();
	/* get time from the server */
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }

	if (noext(0))
	    return;
	device = Devs.Button;
	time1 = gettime(display);
	grabfreezedevice(display, time1);

	time1 -= 100;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display))
		CHECK;
	else {
		report("Events allowed when time was earlier than last-grab time");
		FAIL;
	}

	/*
	 * Get current time again and add several minutes to get a time in the
	 * future.
	 */
	time1 = gettime(display);
	time1 += ((config.speedfactor+1) * 1000000);
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display))
		CHECK;
	else {
		report("Events allowed when time was later than current server time");
		FAIL;
	}

	XUngrabDevice(display, device, CurrentTime);
	XSync(display,0);
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XAllowDeviceEvents-2.(B)");
	report_assertion("When the event_mode argument is AsyncThisDevice and the");
	report_assertion("device is frozen by the client, then device event processing");
	report_assertion("is resumed.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Freeze device.");
	report_strategy("Call XAllowDeviceEvents with event_mode AsyncThisDevice.");
	report_strategy("Verify that device is not frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Button;
	grabfreezedevice(display, time1);

	event_mode = AsyncThisDevice;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (ispfrozen(display)) {
		report("Device was not released after AsyncThisDevice");
		FAIL;
	} else
		CHECK;

	XUngrabDevice(display, device, CurrentTime);
	XSync(display,0);
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XAllowDeviceEvents-3.(B)");
	report_assertion("When the event_mode argument is AsyncThisDevice and the");
	report_assertion("device is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowDeviceEvents thaws for");
	report_assertion("both grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Freeze device with XGrabPointer.");
	report_strategy("Freeze device with XGrabKeyboard.");
	report_strategy("Call XAllowDeviceEvents with event_mode AsyncThisDevice.");
	report_strategy("Verify that device is not frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Button;
	XGrabPointer(display, grabwin, False, NoEventMask, GrabModeSync, 
		GrabModeSync, None, None, CurrentTime);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
		CurrentTime);

	if (isdeleted())
		return;

	event_mode = AsyncThisDevice;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Device was not released from double grab after AsyncThisDevice");
		FAIL;
	} else
		CHECK;

        XUngrabPointer(display, CurrentTime);
        XUngrabKeyboard(display, CurrentTime);
        XSync(display,0);
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XAllowDeviceEvents-4.(B)");
	report_assertion("When the event_mode argument is AsyncThisDevice and the");
	report_assertion("device is not frozen by the client, then a call to");
	report_assertion("XAllowDeviceEvents has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XAllowDeviceEvents with event_mode AsyncThisDevice.");
	report_strategy("Verify device is not frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Button;
	event_mode = AsyncThisDevice;

	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (!ispfrozen(display))
		PASS;
	else {
		report("device was frozen after AsyncThisDevice");
		FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XAllowDeviceEvents-5.(B)");
	report_assertion("When the event_mode argument is SyncThisDevice and the");
	report_assertion("device is frozen and actively grabbed by the client, then");
	report_assertion("device event processing is resumed normally until the next");
	report_assertion("DeviceButtonPress or DeviceButtonRelease event is reported");
	report_assertion("to the client, at which time the device again appears to");
	report_assertion("freeze, unless the reported event causes the device grab to");
	report_assertion("be released.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab and freeze the device.");
	report_strategy("Call XAllowDeviceEvents with event_mode SyncThisDevice.");
	report_strategy("Verify that device is not frozen.");
	report_strategy("If test extension available:");
	report_strategy("  Press a button.");
	report_strategy("  Verify that the device is frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Button;
	grabfreezedevice(display, time1);
	if (ispfrozen(display))
		CHECK;
	else {
		delete("Could not freeze device");
		return;
	}

	event_mode = SyncThisDevice;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("Device was not released after SyncThisDevice");
		FAIL;
	} else
		CHECK;

	if (noext(1) || nbuttons() <= 1) {
		CHECKUNTESTED(2);
		return;
	}

	/* If extension we can go on */
	devicebuttonpress(display, Devs.Button, Button1);
	if (ispfrozen(display))
		CHECK;
	else {
		report("Device was not re-frozen by a button press");
		FAIL;
	}

	devicebuttonrel(display, Devs.Button, Button1);
	devicerelbuttons(Devs.Button);
	XUngrabDevice(display, device, CurrentTime);
	XSync(display,0);
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XAllowDeviceEvents-6.(B)");
	report_assertion("When the event_mode argument is SyncThisDevice and the");
	report_assertion("device is not frozen by the client or the device is not");
	report_assertion("grabbed by the client, then a call to XAllowDeviceEvents has");
	report_assertion("no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XAllowDeviceEvents with event_mode SyncThisDevice.");
	report_strategy("Verify device is not frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Button;
	event_mode = SyncThisDevice;

	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (!ispfrozen(display))
		PASS;
	else {
		report("device was frozen after SyncThisDevice with no initial freeze");
		FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XAllowDeviceEvents-7.(B)");
	report_assertion("When the event_mode argument is SyncThisDevice and the");
	report_assertion("device is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowDeviceEvents thaws for");
	report_assertion("both grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Freeze device with XGrabDevice.");
	report_strategy("Freeze device with XGrabKeyboard.");
	report_strategy("Call XAllowDeviceEvents with event_mode SyncThisDevice.");
	report_strategy("Verify that device is not frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Button;
	XGrabDevice(display, device, grabwin, True, 3, 
	    class, GrabModeSync, GrabModeAsync, time1);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
		CurrentTime);

	if (isdeleted())
		return;

	event_mode = SyncThisDevice;
	startcall(display);
	if (isdeleted())
		return;
	ret = XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("device was not released after SyncThisDevice");
		FAIL;
	} else
		CHECK;

        XUngrabKeyboard(display, CurrentTime);
        XUngrabDevice(display, device, CurrentTime);
        XSync(display, 0);
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int ret;
XEvent  ev;
XButtonPressedEvent    *bpp;
Window  chwin;
struct  area    area;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XAllowDeviceEvents-8.(B)");
	report_assertion("When the event_mode argument is ReplayThisDevice and the");
	report_assertion("device is actively grabbed by the client and is frozen as");
	report_assertion("the result of an event having been sent to the client, then");
	report_assertion("the device grab is released and the event is completely");
	report_assertion("reprocessed as though any passive grabs at or above the grab");
	report_assertion("window of the grab just released were not present.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for replay device.");
	report_strategy("If extensions are available:");
	report_strategy("  Create window.");
	report_strategy("  Create child of this window.");
	report_strategy("  Set passive grabs on both these windows.");
	report_strategy("  Warp device into child window.");
	report_strategy("  Press button to activate the grab.");
	report_strategy("  Check that parent window has the grab.");
	report_strategy("  Set event_mode to ReplayThisDevice.");
	report_strategy("  Call XAllowDeviceEvents.");
	report_strategy("  Verify that the child window now has the grab.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	event_mode = ReplayThisDevice;
	if (noext(1)) {
		startcall(display);
		if (isdeleted())
			return;
		XAllowDeviceEvents(display, device, event_mode, time1);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	/*
	 * Set up a device freeze as a result of a button press.
	 */
	warppointer(display, grabwin, 1, 1);
	setarea(&area, 50, 50, 5, 5);
	chwin = crechild(display, grabwin, &area);

	XSelectExtensionEvent(display, grabwin, class, 3);
	XGrabDeviceButton(display, Devs.Button, Button1, AnyModifier,
		NULL, grabwin,
		False, 3, class, GrabModeSync, GrabModeAsync);
	XGrabDeviceButton(display, Devs.Button, Button1, AnyModifier,
		NULL, chwin,
		False, 3, class, GrabModeSync, GrabModeAsync);

	/*
	 * Activate the grab.
	 */
	XSync(display, True);	/* Discard any events */
	warppointer(display, chwin, 1, 1);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,False);

	/*
	 * Check that the grab was activated and that it occurs on the parent
	 * window.
	 */
	ret = XPending(display);
	if (XPending(display)) {
	        XNextEvent(display, &ev);
	/*
	if (XCheckTypedEvent(display, devicebuttonpress, &ev)) {
	*/
		bpp = (XButtonPressedEvent*)&ev;
		if (bpp->window == grabwin)
			CHECK;
		else if (bpp->window == chwin) {
			delete("Child window had the grab");
			return;
		} else {
			delete("Could not get grab on parent window");
			return;
		}
	} else {
		report("Did not get a button event when trying to activate grab");
		FAIL;
		return;
	}

	/* Do the ReplayThisDevice */
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * The effect should be as if the button were pressed again
	 * but without the passive grab on the parent window.  So this
	 * time the child should pick up the grab.
	 */
	ret = XPending(display);
	if (XPending(display)) {
	        XNextEvent(display, &ev);
		bpp = (XButtonPressedEvent*)&ev;
		if (bpp->window == chwin)
			CHECK;
		else if (bpp->window == grabwin) {
			report("Parent window had the grab after a ReplayThisDevice");
			FAIL;
		} else {
			report("After ReplayThisDevice the grab on the child did not activate");
			FAIL;
		}
	} else {
		report("Did not get a button event when trying to activate grab");
		FAIL;
	}

	devicebuttonrel(display, Devs.Button, Button1);
	devicerelbuttons(Devs.Button);
	XUngrabDeviceButton(display, Devs.Button, Button1, AnyModifier,
		NULL, grabwin);
	XUngrabDeviceButton(display, Devs.Button, Button1, AnyModifier,
		NULL, chwin);
        XSync(display, 0);
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XAllowDeviceEvents-9.(B)");
	report_assertion("When the event_mode argument is ReplayThisDevice and the");
	report_assertion("device is not frozen as a result of an event or the device");
	report_assertion("is not grabbed by the client, then a call to");
	report_assertion("XAllowDeviceEvents has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XAllowDeviceEvents with event_mode ReplayThisDevice.");
	report_strategy("Verify device is not frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Button;
	event_mode = ReplayThisDevice;
	warppointer(display, grabwin, 1, 1);

	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (!ispfrozen(display))
		PASS;
	else {
		report("device was frozen after ReplayThisDevice");
		FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	key;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XAllowDeviceEvents-10.(B)");
	report_assertion("When the event_mode argument is ReplayThisDevice and the");
	report_assertion("device is frozen twice by the client on behalf of two");
	report_assertion("separate grabs, then a call to XAllowDeviceEvents thaws for");
	report_assertion("both grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Freeze device with XGrabKeyboard.");
	report_strategy("  Set up passive grab.");
	report_strategy("  Freeze device by activating grab with a button press.");
	report_strategy("  Call XAllowDeviceEvents with event_mode of ReplayThisDevice.");
	report_strategy("  Verify that device was released.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	if (noext(1))
		return;

	warppointer(display, grabwin, 1, 1);
	XSync(display,0);

	key = getkeycode(display);
	XGrabKey(display, key, 0, grabwin, False, GrabModeSync, GrabModeAsync);
	XGrabDeviceButton(display, device, Button1, AnyModifier, NULL,  grabwin,
		False, 0, NULL, GrabModeSync, GrabModeAsync);
	devicebuttonpress(display, Devs.Button, Button1);
	keypress(display, key);
	XSync(display,0);

	event_mode = ReplayThisDevice;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("device was not released after ReplayThisDevice");
		report("  and the device was frozen by two grabs.");
		FAIL;
	} else
		CHECK;

	keyrel(display, key);
	devicebuttonrel(display, Devs.Button, Button1);
        XUngrabKey(display, key, AnyModifier, grabwin);
        XUngrabDeviceButton(display, Devs.Button, Button1, AnyModifier,
                NULL, grabwin);
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	key;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XAllowDeviceEvents-11.(B)");
	report_assertion("When the event_mode argument is SyncAll and both the");
	report_assertion("grabbed device and the other devices are frozen by the");
	report_assertion("client, then event processing for both devices continues");
	report_assertion("normally until the next DeviceButtonPress,");
	report_assertion("DeviceButtonRelease, DeviceKeyPress, or DeviceKeyRelease");
	report_assertion("event is reported to the client for a grabbed device at");
	report_assertion("which time all devices again appear to freeze, unless the");
	report_assertion("reported event causes the grab to be released.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If no extensions:");
	report_strategy("  Touch test for SyncAll.");
	report_strategy("else");
	report_strategy("  Create grabwindow.");
	report_strategy("  Select events on grab window.");
	report_strategy("  Freeze and grab device by calling XGrabDevice.");
	report_strategy("  Freeze and grab keyboard by calling XGrabKeyboard.");
	report_strategy("  Check that device is frozen.");
	report_strategy("");
	report_strategy("  Call XAllowDeviceEvents with event_mode of SyncAll.");
	report_strategy("  Verify that device has been released.");
	report_strategy("");
	report_strategy("  Press button.");
	report_strategy("  Verify that device is frozen.");
	report_strategy("  Verify that keyboard is frozen.");
	report_strategy("");
	report_strategy("  Call XAllowDeviceEvents with event_mode of SyncAll.");
	report_strategy("  Check device released.");
	report_strategy("  Release button.");
	report_strategy("  Verify that device is frozen.");
	report_strategy("  Verify that keyboard is frozen.");
	report_strategy("");
	report_strategy("  Call XAllowDeviceEvents with event_mode of SyncAll.");
	report_strategy("  Check device released.");
	report_strategy("  Press key.");
	report_strategy("  Verify that device is frozen.");
	report_strategy("  Verify that keyboard is frozen.");
	report_strategy("");
	report_strategy("  Call XAllowDeviceEvents with event_mode of SyncAll.");
	report_strategy("  Check device released.");
	report_strategy("  Release key.");
	report_strategy("  Verify that device is frozen.");
	report_strategy("  Verify that keyboard is frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	event_mode = SyncAll;

	if (noext(1)) {
	    startcall(display);
	    if (isdeleted())
	    	return;
	    XAllowDeviceEvents(display, device, event_mode, time1);
	    endcall(display);
	    if (geterr() != Success) {
	    	report("Got %s, Expecting Success", errorname(geterr()));
	    	FAIL;
	    }

	untested("There is no reliable test method, but a touch test was performed");
	    return;
	} else
	    CHECK;


	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
	    report("SyncAll did not release device and keyboard");
	    FAIL;
	} else
	    CHECK;

	/* 1. Button press */
	devicebuttonpress(display, Devs.Button, Button1);
	if (ispfrozen(display))
	    CHECK;
	else {
	    report("device was not re-frozen by a button press after SyncAll");
	    FAIL;
	}
	if (iskfrozen(display))
	    CHECK;
	else {
	    report("Keyboard was not re-frozen by a button press after SyncAll");
	    FAIL;
	}

	/* Allow events again for next part */
	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ispfrozen(display)) {
	    report("SyncAll did not release device and keyboard");
	    FAIL;
	} else
	    CHECK;

	/* 2. Button release */
	devicebuttonrel(display, Devs.Button, Button1);
	if (ispfrozen(display))
	    CHECK;
	else {
	    report("device was not re-frozen by a button release after SyncAll");
	    FAIL;
	}
	if (iskfrozen(display))
	    CHECK;
	else {
	    report("Keyboard was not re-frozen by a button release after SyncAll");
	    FAIL;
	}

	/* Allow events again for next part */
	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ispfrozen(display)) {
	    report("SyncAll did not release device and keyboard");
	    FAIL;
	} else
	    CHECK;

	/* 3. Press key. */
	key = getkeycode(display);
	keypress(display, key);
	if (ispfrozen(display))
	    CHECK;
	else {
	    report("device was not re-frozen by a key press after SyncAll");
	    FAIL;
	}
	if (iskfrozen(display))
	    CHECK;
	else {
	    report("Keyboard was not re-frozen by a key press after SyncAll");
	    FAIL;
	}

	/* Allow events again for next part */
	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ispfrozen(display)) {
	    report("SyncAll did not release device and keyboard");
	    FAIL;
	} else
	    CHECK;

	/* 4. Key release. */
	keyrel(display, key);
	if (ispfrozen(display))
	    CHECK;
	else {
	    report("device was not re-frozen by a key release after SyncAll");
	    FAIL;
	}
	if (iskfrozen(display))
	    CHECK;
	else {
	    report("Keyboard was not re-frozen by a key release after SyncAll");
	    FAIL;
	}

	devicerelbuttons(Devs.Button);
	relalldev();
        XUngrabDevice(display, device, CurrentTime);
        XUngrabKeyboard(display, CurrentTime);
        XSync(display, 0);
	CHECKPASS(13);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	key;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XAllowDeviceEvents-12.(B)");
	report_assertion("When the event_mode argument is SyncAll and an event has");
	report_assertion("caused the grab on one device to be released and a");
	report_assertion("subsequent event is reported for another device that does");
	report_assertion("not cause the grab to be released, then all devices are");
	report_assertion("again frozen.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Grab and freeze Keyboard with XGrabKeyboard.");
	report_strategy("  Set passive grab on button with device_mode GrabModeSync.");
	report_strategy("  Activate device grab.");
	report_strategy("");
	report_strategy("  Call XAllowDeviceEvents with event_mode SyncAll.");
	report_strategy("  Release button to release device grab.");
	report_strategy("  Check device not frozen.");
	report_strategy("");
	report_strategy("  Press key.");
	report_strategy("  Verify that device and keyboard are frozen.");

	tpstartup();
	setargs();
	if (noext(1))
	    return;

	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
	    CurrentTime);
	XGrabButton(display, Button1, 0, grabwin,
	    False, PointerMotionMask, GrabModeSync, GrabModeSync,
	    None, None);

	warppointer(display, grabwin, 1, 1);
	devicebuttonpress(display, Devs.Button, Button1);

	if (ispfrozen(display))
	    CHECK;
	else {
	    delete("Could not freeze device and keyboard");
	    return;
	}

	event_mode = SyncAll;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Release device grab.
	 */
	devicebuttonrel(display, Devs.Button, Button1);
	if (ispfrozen(display)) {
	    report("device remained frozen after releasing button");
	    FAIL;
	} else
	    CHECK;

	key = getkeycode(display);
	keypress(display, key);
	if (ispfrozen(display))
	    CHECK;
	else {
		report("device was not re-frozen by an event from the keyboard after the device grab was released.");
		FAIL;
	}
	if (iskfrozen(display))
		CHECK;
	else {
		report("Keyboard was not re-frozen by an event from the keyboard after the device grab was released");
		FAIL;
	}

	relalldev();
	devicerelbuttons(Devs.Button);
        XUngrabKeyboard(display, CurrentTime);
        XUngrabButton(display, Button1, AnyModifier, grabwin);
        XSync(display,0);
	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XAllowDeviceEvents-13.(B)");
	report_assertion("When the event_mode argument is SyncAll and the grabbed");
	report_assertion("device or the other devices are frozen twice by the client");
	report_assertion("on behalf of two separate grabs, then a call to");
	report_assertion("XAllowDeviceEvents thaws for both grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Grab and freeze device.");
	report_strategy("  Grab keyboard and freeze device.");
	report_strategy("");
	report_strategy("  Call XAllowDeviceEvents with event_mode of SyncAll.");
	report_strategy("  Verify that device and keyboard are thawed.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	XGrabDevice(display, device, grabwin, True, 3, 
	    class, GrabModeSync, GrabModeAsync, CurrentTime);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
		CurrentTime);

	event_mode = SyncAll;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("device was not thawed by SyncAll when device was frozen");
		report("  on behalf of two grabs");
		FAIL;
	} else
		CHECK;
	if (iskfrozen(display)) {
		report("Keyboard was not thawed by SyncAll when device was frozen");
		report("  on behalf of two grabs");
		FAIL;
	} else
		CHECK;

        XUngrabKeyboard(display, CurrentTime);
        XUngrabDevice(display, device, CurrentTime);
        XSync(display,0);
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XAllowDeviceEvents-14.(B)");
	report_assertion("When the event_mode argument is SyncAll and neither the");
	report_assertion("grabbed device or the other devices are frozen by the client");
	report_assertion("or none are grabbed by the client, then a call to");
	report_assertion("XAllowDeviceEvents has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Call XAllowDeviceEvents with SyncAll.");
	report_strategy("  Press button.");
	report_strategy("  Verify that device and keyboard are not frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	event_mode = SyncAll;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	devicebuttonpress(display, Devs.Button, Button1);
	if (ispfrozen(display)) {
		report("device was frozen by button press after SyncAll");
		report("  even though there were no grabs active");
		FAIL;
	} else
		CHECK;
	if (iskfrozen(display)) {
		report("Keyboard was frozen by button press after SyncAll");
		report("  even though there were no grabs active");
		FAIL;
	} else
		CHECK;

	devicerelbuttons(Devs.Button);
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XAllowDeviceEvents-15.(B)");
	report_assertion("When the event_mode argument is AsyncAll and the grabbed");
	report_assertion("device and the other devices are frozen by the client, then");
	report_assertion("event processing for all devices is resumed normally.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If no extensions:");
	report_strategy("  Touch test for AsyncAll.");
	report_strategy("else");
	report_strategy("  Grab and freeze keyboard and device.");
	report_strategy("  Call XAllowDeviceEvents with AsyncAll.");
	report_strategy("  Verify that device is released.");
	report_strategy("  Verify that keyboard is released.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	event_mode = AsyncAll;
	device = Devs.Button;
	if (noext(0)) {
		startcall(display);
		if (isdeleted())
			return;
		XAllowDeviceEvents(display, device, event_mode, time1);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	bothset();
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("device remained frozen after AsyncAll");
		FAIL;
	} else
		CHECK;
	if (iskfrozen(display)) {
		report("Keyboard remained frozen after AsyncAll");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XAllowDeviceEvents-16.(B)");
	report_assertion("When the event_mode argument is AsyncAll and either the");
	report_assertion("grabbed device or another device is not frozen by the");
	report_assertion("client, then a call to XAllowDeviceEvents has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Grab and freeze device.");
	report_strategy("  Call XAllowDeviceEvents with AsyncAll.");
	report_strategy("  Verify that device is not released.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	grabfreezedevice(display, CurrentTime);

	event_mode = AsyncAll;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display))
		CHECK;
	else {
		report("device was released by AsyncAll, although keyboard was not frozen");
		FAIL;
	}
	XUngrabDevice(display, device, CurrentTime);
	XSync(display,0);
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XAllowDeviceEvents-17.(B)");
	report_assertion("When the event_mode argument is AsyncAll and the grabbed");
	report_assertion("device or other devices is frozen twice by the client on");
	report_assertion("behalf of two separate grabs, then a call to");
	report_assertion("XAllowDeviceEvents thaws for both grabs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions available:");
	report_strategy("  Freeze device and keyboard by calling XGrabPointer.");
	report_strategy("  Freeze device and keyboard again by calling XGrabKeyboard.");
	report_strategy("");
	report_strategy("  Call XAllowDeviceEvents with AsyncAll.");
	report_strategy("  Verify that device and keyboard are not frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	XGrabDevice(display, device, grabwin, True, 3, 
	    class, GrabModeSync, GrabModeAsync, CurrentTime);
	XGrabKeyboard(display, grabwin, False, GrabModeSync, GrabModeSync,
		CurrentTime);

	event_mode = AsyncAll;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen(display)) {
		report("device remained frozen after AsyncAll");
		report("  when it was frozen twice");
		FAIL;
	} else
		CHECK;
	if (iskfrozen(display)) {
		report("Keyboard remained frozen after AsyncAll");
		report("  when it was frozen twice");
		FAIL;
	} else
		CHECK;

        XUngrabKeyboard(display, CurrentTime);
        XUngrabDevice(display, device, CurrentTime);
        XSync(display,0);
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

static	int 	modes[] = {
	AsyncThisDevice, SyncThisDevice, ReplayThisDevice};
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XAllowDeviceEvents-18.(B)");
	report_assertion("When the event_mode argument is AsyncThisDevice,");
	report_assertion("SyncThisDevice, or ReplayThisDevice, then a call to");
	report_assertion("XAllowDeviceEvents has no effect on the processing of");
	report_assertion("keyboard events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Grab and freeze the keyboard.");
	report_strategy("  For each event_mode AsyncThisDevice SyncThisDevice ReplayThisDevice");
	report_strategy("    Call XAllowDeviceEvents.");
	report_strategy("    Verify that keyboard is still frozen.");

	tpstartup();
	setargs();
	if (noext(0))
		return;

	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	XGrabKeyboard(display, grabwin, False, GrabModeAsync, GrabModeSync,
		CurrentTime);

	for (i = 0; i < NELEM(modes); i++) {
		event_mode = modes[i];
		startcall(display);
		if (isdeleted())
			return;
		XAllowDeviceEvents(display, device, event_mode, time1);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (iskfrozen(display))
			CHECK;
		else {
			report("Keyboard was released when event_mode was %s",
				alloweventmodename(modes[i]));
			FAIL;
		}
	}

        XUngrabKeyboard(display, CurrentTime);
        XSync(display,0);
	CHECKPASS(NELEM(modes));
	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XAllowDeviceEvents-19.(B)");
	report_assertion("When the event_mode argument is AsyncOtherDevices then a");
	report_assertion("call to XAllowDeviceEvents has no effect on the processing");
	report_assertion("of device events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab and freeze device.");
	report_strategy("  Call XAllowDeviceEvents with mode AsyncOtherDevices.");
	report_strategy("  Verify that device is still frozen.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	if (noext(0))
	    return;
	device = Devs.Button;
	grabfreezedevice(display, time1);

	event_mode = AsyncOtherDevices;
	startcall(display);
	if (isdeleted())
		return;
	XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ispfrozen(display))
		PASS;
	else {
		report("device was released when event_mode was AsyncOtherDevices");
		FAIL;
	}
	XUngrabDevice(display, device, CurrentTime);
	XSync(display,0);

	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

XDevice nodevice;
int baddevice;
int ret;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XAllowDeviceEvents-20.(B)");
	report_assertion("A call to XAllowDeviceEvents will fail with a BadDevice");
	report_assertion("error if an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	ret = XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XAllowDeviceEvents-21.(B)");
	report_assertion("A call to XAllowDeviceEvents will fail with a BadValue");
	report_assertion("error if the specified mode is invalid.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Invoke XAllowDeviceEvents with an invalid mode.");
	report_strategy("Verify BadValue");

	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	event_mode = -1;

	startcall(display);
	if (isdeleted())
		return;
	ret = XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t022(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XAllowDeviceEvents-22.(B)");
	report_assertion("Touch test for SyncAll mode.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");


	tpstartup();
	setargs();
	if (!grabstartup())
	    {
	    UNTESTED;
	    return;
	    }
	device = Devs.Button;
	event_mode = SyncAll;

	startcall(display);
	if (isdeleted())
		return;
	ret = XAllowDeviceEvents(display, device, event_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (geterr() == Success)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
