#ifndef __ASM_SH64_PAGE_H
#define __ASM_SH64_PAGE_H

/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * include/asm-sh64/page.h
 *
 * Copyright (C) 2000, 2001  Paolo Alberelli
 * Copyright (C) 2003, 2004  Paul Mundt
 *
 * benedict.gaster@superh.com 19th, 24th July 2002.
 *
 * Modified to take account of enabling for D-CACHE support.
 *
 */

#include <unistd.h>

#define PAGE_SIZE ((unsigned long)getpagesize())
#define PAGE_SHIFT ((PAGE_SIZE > 65536) ? -1 : ((unsigned long[]){12,13,14,-1,15,-1,-1,-1,16}[PAGE_SIZE>>13]))
#define PAGE_MASK    (~(PAGE_SIZE-1))

#endif /* __ASM_SH64_PAGE_H */
