#!/bin/python3
'''
    SPDX-FileCopyrightText: 2025 Agata Cacko <cacko.azh@gmail.com>

    This file is part of Fast Sketch Cleanup Plugin for Krita

    SPDX-License-Identifier: GPL-3.0-or-later
'''

from PyQt5.QtCore import QTimer, pyqtSignal


class SignalThrottler:
	

	signal = pyqtSignal()
	timer = None

	signalsCaught = 0
	timeInMs = 0



	def __init__(self, timeInMs: int):
		self.timeInMs = timeInMs


	def slot(self) -> None:
		if self.timer == None:
			self.signal.emit()
			self.timer = QTimer()
			self.timer.setSingleShot(True)
			self.timer.start(self.timeInMs)
		else:
			self.signalsCaught += 1
		


	def timerSlot(self) -> None:
		if self.signalsCaught > 0:
			self.signalsCaught = 0
			self.signal.emit()
		self.timer = None