/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mso.generator.ParserGeneratorRunner;
import mso.generator.utils.Choice;
import mso.generator.utils.Lim;
import mso.generator.utils.Limitation;
import mso.generator.utils.MSO;
import mso.generator.utils.Member;
import mso.generator.utils.Option;
import mso.generator.utils.Stream;
import mso.generator.utils.Struct;
import mso.generator.utils.Type;
import mso.generator.utils.TypeRegistry;
import org.eclipse.jdt.annotation.Nullable;

public class QtParserGenerator {
    public final QtParserConfiguration config;
    private final String generatedWarning = "/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */";

    private static String version() {
        return "/* version " + ParserGeneratorRunner.version + " */";
    }

    public QtParserGenerator(@Nullable String string, String string2, String string3) {
        this.config = new QtParserConfiguration(string, string2, string3);
    }

    void generate(MSO mSO) throws IOException {
        FileWriter fileWriter = this.config.createHeader ? new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".h") : new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".cpp");
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
        printWriter.println(QtParserGenerator.version());
        if (this.config.createHeader) {
            printWriter.println("#ifndef " + this.config.basename.toUpperCase() + "_H");
            printWriter.println("#define " + this.config.basename.toUpperCase() + "_H");
        }
        printWriter.println("#include <QString>");
        printWriter.println("#include <QByteArray>");
        printWriter.println("#include <QVector>");
        printWriter.println("#include <QSharedPointer>// replace with QScopedPointer when switching to Qt 4.6");
        if (this.config.enableXml) {
            printWriter.println("#include <QXmlStreamReader>");
        }
        if (this.config.enableWriting) {
            printWriter.println("#include \"leoutputstream.h\"");
        }
        if (this.config.enableIntrospection) {
            printWriter.println("#include \"introspection.h\"");
        }
        printWriter.println("class LEInputStream;");
        printWriter.println("namespace " + this.config.namespace + "{");
        if (this.config.enableXml) {
            printWriter.println("void skipToStartElement(QXmlStreamReader& in) {");
            printWriter.println("    do {");
            printWriter.println("        in.readNext();");
            printWriter.println("    } while (!in.atEnd() && !in.isStartElement());");
            printWriter.println("}");
        }
        if (!this.config.enableIntrospection) {
            printWriter.println("class StreamOffset {");
            printWriter.println("public:");
            printWriter.println("    virtual ~StreamOffset() {}");
            printWriter.println("    quint32 streamOffset;");
            printWriter.println("};");
        }
        for (Struct iterator : mSO.structs) {
            printWriter.println("class " + iterator.name + ";");
            printWriter.println("void parse" + iterator.name + "(LEInputStream& in, " + iterator.name + "& _s);");
            if (this.config.enableXml) {
                printWriter.println("void parse" + iterator.name + "(QXmlStreamReader& in, " + iterator.name + "& _s);");
            }
            if (!this.config.enableWriting) continue;
            printWriter.println("void write(const " + iterator.name + "& v, LEOutputStream& out);");
        }
        for (Struct struct : mSO.structs) {
            this.printStructureClassDeclaration(printWriter, struct);
        }
        if (this.config.createHeader) {
            printWriter.println("} // close namespace");
            printWriter.println("#endif");
            printWriter.close();
            fileWriter = new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".cpp");
            printWriter = new PrintWriter(fileWriter);
            printWriter.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
            printWriter.println(QtParserGenerator.version());
            printWriter.println("#include \"" + this.config.basename + ".h\"");
            printWriter.println("using namespace " + this.config.namespace + ";");
        }
        printWriter.println("#include \"leinputstream.h\"");
        if (this.config.enableIntrospection) {
            for (Struct struct : mSO.structs) {
                this.printStructureClassImplementation(printWriter, struct);
            }
        }
        for (Struct struct : mSO.structs) {
            this.printStructureParser(printWriter, struct);
            if (this.config.enableWriting) {
                this.printStructureWriter(printWriter, struct);
            }
            if (!this.config.enableXml) continue;
            QtParserGenerator.printStructureXmlParser(printWriter, struct);
        }
        if (!this.config.createHeader) {
            printWriter.println("}");
        }
        if (this.config.enableIntrospection) {
            printWriter.println("const Introspectable* parse(const QString& key, LEInputStream& in) {");
            printWriter.println("    const Introspectable* i = 0;");
            boolean bl = true;
            for (Stream stream : mSO.streams) {
                printWriter.print("    ");
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print("} else ");
                }
                printWriter.println("if (\"" + stream.key + "\" == key) {");
                printWriter.println("        " + stream.type + " *_t = new " + stream.type + "(0);");
                printWriter.println("        parse" + stream.type + "(in, *_t);");
                printWriter.println("        i = _t;");
            }
            printWriter.println("    } else {");
            printWriter.println("        TODOS* _t = new TODOS(0);");
            printWriter.println("        parseTODOS(in, *_t);");
            printWriter.println("        i = _t;");
            printWriter.println("    }");
            printWriter.println("    return i;");
            printWriter.println("}");
        }
        if (this.config.enableXml) {
            printWriter.println("const QMap<QString,QSharedPointer<const Introspectable> > parse(QXmlStreamReader& in) {");
            printWriter.println("    QMap<QString,QSharedPointer<const Introspectable> > streams;");
            printWriter.println("    // skip until first element");
            printWriter.println("    while (!in.atEnd() && !in.isStartElement()) {");
            printWriter.println("        in.readNext();");
            printWriter.println("    }");
            printWriter.println("    if (!in.isStartElement()) {");
            printWriter.println("        return streams;");
            printWriter.println("    }");
            printWriter.println("    do {");
            printWriter.println("        in.readNext();");
            printWriter.println("    } while (!in.atEnd() && !in.isStartElement());");
            printWriter.println("    if (!in.isStartElement()) {");
            printWriter.println("        return streams;");
            printWriter.println("    }");
            printWriter.println("    do {");
            printWriter.println("        QString name = in.name().toString();");
            printWriter.println("        if (streams.contains(name)) {");
            printWriter.println("            streams.clear();");
            printWriter.println("            return streams;");
            printWriter.println("        }");
            boolean bl = true;
            for (Stream stream : mSO.streams) {
                printWriter.print("        ");
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print("} else ");
                }
                printWriter.println("if (\"" + stream.key + "\" == name) {");
                printWriter.println("            QSharedPointer<Introspectable> _t(new " + stream.type + "(0));");
                printWriter.println("            parse" + stream.type + "(in, *static_cast<" + stream.type + "*>(_t.data()));");
                printWriter.println("            streams[name] = _t;");
            }
            printWriter.println("        } else { // unknown stream should be binary");
            printWriter.println("            QSharedPointer<Introspectable> _t(new TODOS(0));");
            printWriter.println("            parseTODOS(in, *static_cast<TODOS*>(_t.data()));");
            printWriter.println("            streams[name] = _t;");
            printWriter.println("        }");
            printWriter.println("        do {");
            printWriter.println("            in.readNext();");
            printWriter.println("        } while (in.isWhitespace());");
            printWriter.println("    } while (in.isStartElement());");
            printWriter.println("    qDebug() << in.tokenType();");
            printWriter.println("    if (!in.isEndElement()) {");
            printWriter.println("        qDebug() << \"parsing error: not at end of an element\";");
            printWriter.println("        streams.clear();");
            printWriter.println("    }");
            printWriter.println("    in.readNext();");
            printWriter.println("    if (!in.isEndDocument()) {");
            printWriter.println("        qDebug() << \"parsing error: not at end of xml\";");
            printWriter.println("        streams.clear();");
            printWriter.println("    }");
            printWriter.println("    return streams;");
            printWriter.println("}");
            printWriter.println("void serialize(const Introspectable* i, const QString& key, LEOutputStream& out)  {");
            bl = true;
            for (Stream stream : mSO.streams) {
                printWriter.print("    ");
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print("} else ");
                }
                printWriter.println("if (\"" + stream.key + "\" == key) {");
                printWriter.println("        write(*static_cast<const " + stream.type + "*>(i), out);");
            }
            printWriter.println("    } else {");
            printWriter.println("        write(*static_cast<const TODOS*>(i), out);");
            printWriter.println("    }");
            printWriter.println("}");
        }
        printWriter.close();
        fileWriter.close();
    }

    private void printStructureParser(PrintWriter printWriter, Struct struct) {
        printWriter.print("void ");
        if (this.config.namespace != null && this.config.namespace.length() > 0) {
            printWriter.print(this.config.namespace + "::");
        }
        printWriter.println("parse" + struct.name + "(LEInputStream& in, " + struct.name + "& _s) {");
        printWriter.println("    _s.streamOffset = in.getPosition();");
        if (struct.containsKnownLengthArrayMember) {
            printWriter.println("    int _c;");
        }
        if (struct.containsArrayMember || struct.containsOptionalMember || struct.containsChoice) {
            printWriter.println("    LEInputStream::Mark _m;");
        }
        if (struct.containsOptionalMember) {
            printWriter.println("    bool _possiblyPresent;");
        }
        if (struct.containsUnknownLengthArrayMember) {
            printWriter.println("    bool _atend;");
        }
        for (Member member : struct.members) {
            if (this.config.enableStyleTextPropAtomFix && struct.name.equals("StyleTextPropAtom") && member.name.equals("todo")) break;
            this.printStructureMemberParser(printWriter, struct.name, member);
            if (member.type().name.contains("RecordHeader")) {
                // empty if block
            }
            if (!this.config.enableStyleTextPropAtomFix || !struct.name.equals("TextContainer") || !member.name.equals("style")) continue;
            QtParserGenerator.styleTextPropAtomFix2(printWriter);
        }
        printWriter.println("}");
    }

    private static void printStructureXmlParser(PrintWriter printWriter, Struct struct) {
        printWriter.println("void parse" + struct.name + "(QXmlStreamReader& in, " + struct.name + "& _s) {");
        printWriter.println("    in.readNext();");
        for (Member member : struct.members) {
            QtParserGenerator.printStructureMemberXmlParser(printWriter, member);
        }
        printWriter.println("}");
    }

    private static String prependStructureToExpression(String string, String string2) {
        if (string.length() > 0) {
            Pattern pattern = Pattern.compile("([^.\\w])([.a-zA-Z])");
            Matcher matcher = pattern.matcher(string);
            string = matcher.replaceAll("$1" + string2 + ".$2");
            pattern = Pattern.compile("^([a-zA-Z])");
            matcher = pattern.matcher(string);
            string = matcher.replaceAll(string2 + ".$1");
        }
        return string;
    }

    private void printStructureMemberParser(PrintWriter printWriter, String string, Member member) {
        String string2;
        Object object;
        String string3;
        Object object2 = "    ";
        String string4 = string3 = member.count == null ? "" : "[_i]";
        if (member.condition != null) {
            object = QtParserGenerator.prependStructureToExpression(member.condition, "_s");
            if (!member.isStruct) {
                printWriter.println((String)object2 + "_s._has_" + member.name + " = " + (String)object + ";");
                printWriter.println((String)object2 + "if (_s._has_" + member.name + ") {");
            } else {
                printWriter.println((String)object2 + "if (" + (String)object + ") {");
            }
            object2 = (String)object2 + "    ";
            if (member.isStruct) {
                printWriter.println((String)object2 + "_s." + member.name + " = QSharedPointer<" + member.type().name + ">(new " + member.type().name + "(&_s));");
                string3 = ".data()";
            }
        }
        if (member.isStruct) {
            string2 = member.condition == null ? "" : "*";
            object = "parse" + member.type().name + "(in, " + string2 + "_s." + member.name + string3 + ");";
        } else {
            object = "_s." + member.name + string3 + " = in.read" + member.type().name + "();";
        }
        if (member.isChoice) {
            this.printChoiceParser(printWriter, (String)object2, string, member);
            return;
        }
        if (member.isArray && member.count == null) {
            if (member.size != null) {
                QtParserGenerator.printFixedSizeArrayParser(printWriter, (String)object2, member, member.size);
            } else {
                QtParserGenerator.printVariableArrayParser(printWriter, (String)object2, member);
            }
            return;
        }
        if (member.isOptional) {
            this.printOptionalMemberParser(printWriter, (String)object2, member);
            return;
        }
        if (member.count != null) {
            string2 = QtParserGenerator.prependStructureToExpression(member.count, "_s");
            printWriter.println((String)object2 + "_c = " + string2 + ";");
        }
        if (member.count != null) {
            if (!member.isStruct) {
                printWriter.println((String)object2 + "_s." + member.name + ".resize(_c);");
            }
            if (member.type() == member.registry.uint8) {
                printWriter.println((String)object2 + "in.readBytes(_s." + member.name + ");");
            } else {
                printWriter.println((String)object2 + "for (int _i=0; _i<_c; ++_i) {");
                if (member.isStruct) {
                    printWriter.println((String)object2 + "    _s." + member.name + ".append(" + member.type().name + "(&_s));");
                }
                printWriter.println((String)object2 + "    " + (String)object);
                this.printLimitationCheck(printWriter, "        ", "_s." + member.name + "[_i]", member);
                printWriter.println((String)object2 + "}");
            }
        } else {
            printWriter.println((String)object2 + (String)object);
            this.printLimitationCheck(printWriter, (String)object2, "_s." + member.name, member);
        }
        if (member.condition != null) {
            printWriter.println("    }");
        }
    }

    private static void printStructureMemberXmlParser(PrintWriter printWriter, Member member) {
        Object object = "    ";
        printWriter.println((String)object + "if (!in.isStartElement()) {");
        printWriter.println((String)object + "    qDebug() << \"not startelement in " + member.type().name + " \" << in.lineNumber();");
        printWriter.println((String)object + "    return;");
        printWriter.println((String)object + "}");
        if (!member.isOptional && !member.isArray) {
            printWriter.println((String)object + "if (in.name() != \"" + member.name + "\") {");
            printWriter.println((String)object + "    qDebug() << \"not startelement in " + member.name + " \" << in.lineNumber();");
            printWriter.println((String)object + "    return;");
            printWriter.println((String)object + "}");
        }
        if (member.isOptional) {
            printWriter.println((String)object + "if (in.name() == \"" + member.name + "\") {");
            object = (String)object + "    ";
        }
        if (!member.isStruct) {
            printWriter.println((String)object + "in.readElementText();");
        } else {
            printWriter.println((String)object + "skipToStartElement(in);");
        }
        if (member.isOptional) {
            printWriter.println("    }");
        }
    }

    private void printStructureWriter(PrintWriter printWriter, Struct struct) {
        printWriter.println("void write(const " + struct.name + "& _s, LEOutputStream& out) {");
        for (Member member : struct.members) {
            this.printStructureMemberWriter(printWriter, member);
        }
        printWriter.println("}");
    }

    private void printStructureMemberWriter(PrintWriter printWriter, Member member) {
        Object object = "    ";
        if (member.condition != null) {
            printWriter.println("    if (" + QtParserGenerator.getExpression("_s", member.condition) + ") {");
            object = (String)object + "    ";
        }
        if (member.isChoice) {
            boolean bl = true;
            for (String string : ((Choice)member.type()).getChoiceNames()) {
                printWriter.print((String)object);
                if (!bl) {
                    printWriter.print("} else ");
                }
                bl = false;
                printWriter.println("if (_s." + member.name + ".is<" + string + ">()) {");
                printWriter.println((String)object + "    write(*_s." + member.name + ".get<" + string + ">(), out);");
            }
            printWriter.println((String)object + "}");
        } else if (member.isArray) {
            if (member.type() == member.registry.uint8) {
                printWriter.println((String)object + "out.writeBytes(_s." + member.name + ");");
            } else {
                String string = this.getTypeName(member.type());
                printWriter.println((String)object + "foreach (" + string + " _i, _s." + member.name + ") {");
                if (member.isStruct) {
                    printWriter.println((String)object + "    write(_i, out);");
                } else {
                    printWriter.println((String)object + "    out.write" + member.type().name + "(_i);");
                }
                printWriter.println((String)object + "}");
            }
        } else if (member.isStruct) {
            printWriter.print((String)object);
            if (member.isOptional || member.condition != null) {
                printWriter.print("if (_s." + member.name + ") write(*");
            } else {
                printWriter.print("write(");
            }
            printWriter.println("_s." + member.name + ", out);");
        } else {
            printWriter.println((String)object + "out.write" + member.type().name + "(_s." + member.name + ");");
        }
        if (member.condition != null) {
            printWriter.println("    }");
        }
    }

    private String getTypeName(Type type) {
        TypeRegistry typeRegistry = type.registry;
        if (type instanceof Choice) {
            return this.createChoiceClass(type.name, (Choice)type);
        }
        if (type == typeRegistry.bit) {
            return "bool";
        }
        if (type == typeRegistry.uint2 || type == typeRegistry.uint3 || type == typeRegistry.uint4 || type == typeRegistry.uint5 || type == typeRegistry.uint6 || type == typeRegistry.uint7 || type == typeRegistry.uint8) {
            return "quint8";
        }
        if (type == typeRegistry.uint9 || type == typeRegistry.uint12 || type == typeRegistry.uint13 || type == typeRegistry.uint14 || type == typeRegistry.uint15 || type == typeRegistry.uint16) {
            return "quint16";
        }
        if (type == typeRegistry.uint20 || type == typeRegistry.uint30 || type == typeRegistry.uint32) {
            return "quint32";
        }
        if (type == typeRegistry.int16) {
            return "qint16";
        }
        if (type == typeRegistry.int32) {
            return "qint32";
        }
        return type.name;
    }

    private String createChoiceClass(String string, Choice choice) {
        String string2 = "StreamOffset";
        if (this.config.enableIntrospection) {
            string2 = "Introspectable";
        }
        String string3 = "class " + string + " : public QSharedPointer<" + string2 + "> {\n";
        string3 = string3 + "    public:\n";
        string3 = string3 + "        " + string + "() {}\n";
        for (String string4 : choice.getChoiceNames()) {
            string3 = string3 + "        explicit " + string + "(" + string4 + "* a) :QSharedPointer<" + string2 + ">(a) {}\n";
        }
        string3 = string3 + "        template <typename T> T*get() { return dynamic_cast<T*>(this->data()); }\n";
        string3 = string3 + "        template <typename T> const T*get() const { return dynamic_cast<const T*>(this->data()); }\n";
        string3 = string3 + "        template <typename T> bool is() const { return get<T>(); }\n";
        string3 = string3 + "    };\n";
        string3 = string3 + "    " + string;
        return string3;
    }

    private String getMemberDeclaration(Member member) {
        String string = this.getTypeName(member.type());
        if (member.isArray) {
            if (member.isStruct) {
                return "QList<" + member.type().name + "> " + member.name;
            }
            if ("quint8".equals(string)) {
                return "QByteArray " + member.name;
            }
            return "QVector<" + string + "> " + member.name;
        }
        if (member.isStruct && (member.isOptional || member.condition != null)) {
            return "QSharedPointer<" + string + "> " + member.name;
        }
        return string + " " + member.name;
    }

    private static String memberToString(Member member, String string) {
        String string2 = string + member.name;
        Object object = member.isArray ? "\"[array of " + string2 + "]\"" : (member.isInteger ? "QString::number(" + string2 + ") + \"(\" + QString::number(" + string2 + ",16).toUpper() + \")\"" : (member.type() == member.type().registry.bit ? "QString::number(" + string2 + ")" : (member.isChoice ? "\"<choice>\"" : (member.isOptional || member.condition != null ? "((" + string2 + ")?" + string2 + "->toString() :\"null\")" : string2 + ".toString()"))));
        return object;
    }

    private static void styleTextPropAtomFix(PrintWriter printWriter) {
        printWriter.println("    RecordHeader rh;");
        printWriter.println("    QList<TextPFRun> rgTextPFRun;");
        printWriter.println("    QList<TextCFRun> rgTextCFRun;");
    }

    private static void styleTextPropAtomFix2(PrintWriter printWriter) {
        printWriter.println("    if (_s.style) {");
        printWriter.println("        quint32 count = 0;");
        printWriter.println("        if (_s.text.is<TextCharsAtom>()) {");
        printWriter.println("            count = _s.text.get<TextCharsAtom>()->textChars.size();");
        printWriter.println("        }");
        printWriter.println("        if (_s.text.is<TextBytesAtom>()) {");
        printWriter.println("            count = _s.text.get<TextBytesAtom>()->textChars.size();");
        printWriter.println("        }");
        printWriter.println("        quint32 sum = 0;");
        printWriter.println("        do {");
        printWriter.println("        _s.style->rgTextPFRun.append(TextPFRun(_s.style.data()));");
        printWriter.println("            parseTextPFRun(in, _s.style->rgTextPFRun.last());");
        printWriter.println("            sum += _s.style->rgTextPFRun.last().count;");
        printWriter.println("        } while (sum <= count);");
        printWriter.println("        sum = 0;");
        printWriter.println("        do {");
        printWriter.println("            _s.style->rgTextCFRun.append(TextCFRun(_s.style.data()));");
        printWriter.println("            parseTextCFRun(in, _s.style->rgTextCFRun.last());");
        printWriter.println("            sum += _s.style->rgTextCFRun.last().count;");
        printWriter.println("        } while (sum <= count);");
        printWriter.println("    }");
    }

    private void printStructureClassDeclaration(PrintWriter printWriter, Struct struct) {
        printWriter.print("class " + struct.name);
        if (this.config.enableIntrospection) {
            printWriter.println(" : public Introspectable {");
            printWriter.println("private:");
            printWriter.println("    class _Introspection;");
        } else {
            printWriter.println(" : public StreamOffset {");
        }
        printWriter.println("public:");
        if (this.config.enableIntrospection) {
            printWriter.println("    static const Introspection _introspection;");
        }
        for (Member iterator : struct.members) {
            if (iterator.isStruct || iterator.condition == null) continue;
            printWriter.println("    bool _has_" + iterator.name + ";");
        }
        if (this.config.enableStyleTextPropAtomFix && struct.name.equals("StyleTextPropAtom")) {
            QtParserGenerator.styleTextPropAtomFix(printWriter);
        } else {
            for (Member member : struct.members) {
                String string = this.getMemberDeclaration(member);
                printWriter.println("    " + string + ";");
            }
        }
        boolean bl = true;
        if (this.config.enableIntrospection) {
            printWriter.print("    explicit " + struct.name + "(const Introspectable* parent)");
            printWriter.print("\n       :Introspectable(parent)");
            bl = false;
            for (Member member : struct.members) {
                if (!member.isStruct || member.isArray || member.isOptional || member.isChoice || member.condition != null) continue;
                if (bl) {
                    printWriter.print("\n       :");
                    bl = false;
                } else {
                    printWriter.print(",\n        ");
                }
                printWriter.print(member.name + "(this)");
            }
            printWriter.println(" {}");
        } else {
            printWriter.println("    " + struct.name + "(void* /*dummy*/ = 0) {}");
        }
        if (this.config.enableToString) {
            printWriter.println("    QString toString() {");
            printWriter.println("        QString _s = \"" + struct.name + ":\";");
            for (Member member : struct.members) {
                printWriter.print("        _s = _s + \"" + member.name + ": \" + ");
                printWriter.print(QtParserGenerator.memberToString(member, ""));
                printWriter.println(" + \", \";");
            }
            printWriter.println("        return _s;");
            printWriter.println("    }");
        }
        if (this.config.enableIntrospection) {
            printWriter.println("    const Introspection* getIntrospection() const { return &_introspection; }");
        }
        printWriter.println("};");
    }

    private void printStructureClassImplementation(PrintWriter printWriter, Struct struct) {
        int n = struct.members.size();
        String string = struct.name + "::_Introspection";
        printWriter.println("class " + string + " {");
        printWriter.println("public:");
        printWriter.println("    static const QString name;");
        printWriter.println("    static const int numberOfMembers;");
        printWriter.println("    static const QString names[" + n + "];");
        printWriter.println("    static int (* const numberOfInstances[" + n + "])(const Introspectable*);");
        printWriter.println("    static QVariant (* const value[" + n + "])(const Introspectable*, int position);");
        printWriter.println("    static const Introspectable* (* const introspectable[" + n + "])(const Introspectable*, int position);");
        for (Member member : struct.members) {
            if (struct.name.equals("StyleTextPropAtom") && this.config.enableStyleTextPropAtomFix && member.name.equals("todo")) break;
            if (!member.isStruct && !member.isChoice) {
                if (member.condition != null) {
                    printWriter.println("    static int count_" + member.name + "(const Introspectable* i) {");
                    printWriter.println("        return static_cast<const " + struct.name + "*>(i)->_has_" + member.name + " ?1 :0;");
                    printWriter.println("    }");
                }
            } else if (member.isOptional || member.condition != null) {
                printWriter.println("    static int count_" + member.name + "(const Introspectable* i) {");
                printWriter.println("        return get_" + member.name + "(i, 0) ?1 :0;");
                printWriter.println("    }");
            } else if (member.isArray) {
                printWriter.println("    static int count_" + member.name + "(const Introspectable* i) {");
                printWriter.println("        return static_cast<const " + struct.name + "*>(i)->" + member.name + ".size();");
                printWriter.println("    }");
            }
            if (member.isStruct || member.isChoice) {
                printWriter.println("    static const Introspectable* get_" + member.name + "(const Introspectable* i, int j) {");
            } else {
                printWriter.println("    static QVariant get_" + member.name + "(const Introspectable* i, int j) {");
            }
            String string2 = "static_cast<const " + struct.name + "*>(i)->" + member.name;
            if (!member.isChoice) {
                printWriter.print("        ");
                if (!member.isStruct) {
                    if (member.isArray && member.type() != member.type().registry.uint8) {
                        printWriter.println("return qVariantFromValue(" + string2 + ");");
                    } else {
                        printWriter.println("return " + string2 + ";");
                    }
                } else if (member.isArray) {
                    printWriter.println("return &(" + string2 + "[j]);");
                } else if (member.isOptional || member.condition != null) {
                    printWriter.println("return " + string2 + ".data();");
                } else {
                    printWriter.println("return &(" + string2 + ");");
                }
            } else {
                printWriter.println("        return static_cast<const " + struct.name + "*>(i)->" + member.name + ".data();");
            }
            printWriter.println("    }");
        }
        printWriter.println("};");
        printWriter.println("const QString " + string + "::name(\"" + struct.name + "\");");
        printWriter.println("const int " + string + "::numberOfMembers(" + n + ");");
        printWriter.println("const QString " + string + "::names[" + n + "] = {");
        for (Member member : struct.members) {
            printWriter.println("    \"" + member.name + "\",");
        }
        printWriter.println("};");
        printWriter.println("int (* const " + string + "::numberOfInstances[" + n + "])(const Introspectable*) = {");
        for (Member member : struct.members) {
            if (member.condition != null || (member.isStruct || member.isChoice) && (member.isOptional || member.isArray)) {
                printWriter.println("    _Introspection::count_" + member.name + ",");
                continue;
            }
            printWriter.println("    Introspection::one,");
        }
        printWriter.println("};");
        printWriter.println("QVariant (* const " + string + "::value[" + n + "])(const Introspectable*, int position) = {");
        for (Member member : struct.members) {
            if (struct.name.equals("StyleTextPropAtom") && this.config.enableStyleTextPropAtomFix && member.name.equals("todo")) break;
            if (member.isStruct || member.isChoice) {
                printWriter.println("    Introspection::nullValue,");
                continue;
            }
            printWriter.println("    _Introspection::get_" + member.name + ",");
        }
        printWriter.println("};");
        printWriter.println("const Introspectable* (* const " + string + "::introspectable[" + n + "])(const Introspectable*, int position) = {");
        for (Member member : struct.members) {
            if (member.isStruct || member.isChoice) {
                printWriter.println("    _Introspection::get_" + member.name + ",");
                continue;
            }
            printWriter.println("    Introspection::null,");
        }
        printWriter.println("};");
        printWriter.println("const Introspection " + struct.name + "::_introspection(");
        printWriter.println("    \"" + struct.name + "\", " + struct.members.size() + ", _Introspection::names, _Introspection::numberOfInstances, _Introspection::value, _Introspection::introspectable);");
    }

    private void printChoiceParser(PrintWriter printWriter, String string, String string2, Member member) {
        Choice choice = (Choice)member.type();
        Type type = choice.commonType;
        if (type == null) {
            QtParserGenerator.printUnsureChoiceParser(printWriter, string, string2, member);
        } else {
            this.printSureChoiceParser(printWriter, string, string2, member, type);
        }
    }

    private static String getClause(String string, Type type, Lim lim) {
        Object object;
        block6: {
            Lim[] limArray;
            block5: {
                object = "";
                Limitation[] limitationArray = lim.limitations;
                limArray = lim.lims;
                if (limitationArray == null || limitationArray.length <= 0) break block5;
                for (int i = 0; i < limitationArray.length; ++i) {
                    Limitation limitation = limitationArray[i];
                    Object object2 = string;
                    if (type instanceof Struct) {
                        object2 = (String)object2 + "." + limitation.name;
                    }
                    String string2 = QtParserGenerator.getLimit((String)object2, limitation);
                    if (((String)object).length() > 0) {
                        object = (String)object + "&&";
                    }
                    object = (String)object + "(" + string2 + ")";
                }
                break block6;
            }
            if (limArray == null || limArray.length <= 0) break block6;
            for (int i = 0; i < limArray.length; ++i) {
                Lim lim2 = limArray[i];
                String string3 = QtParserGenerator.getClause(string, type, lim2);
                if (((String)object).length() > 0) {
                    object = (String)object + "||";
                }
                object = (String)object + "(" + string3 + ")";
            }
        }
        return ((String)object).replace("..", ".");
    }

    private void printSureChoiceParser(PrintWriter printWriter, String string, String string2, Member member, Type type) {
        printWriter.println(string + "_m = in.setMark();");
        Choice choice = (Choice)member.type();
        String string3 = this.getTypeName(type);
        if (choice.commonType instanceof Struct) {
            printWriter.println(string + string3 + " _choice(&_s);");
            printWriter.println(string + "parse" + string3 + "(in, _choice);");
        } else {
            printWriter.println(string + string3 + " _choice = in.read" + type.name + "();");
        }
        printWriter.println(string + "in.rewind(_m);");
        printWriter.println(string + "qint64 startPos = in.getPosition();");
        for (int i = 0; i < choice.options.size(); ++i) {
            printWriter.print(string);
            Option option = choice.options.get(i);
            String string4 = QtParserGenerator.getClause("_choice", option.limitsType, option.lim);
            printWriter.print("if (startPos == in.getPosition()");
            if (!member.isOptional && i == choice.options.size() - 1) {
                printWriter.println(") {");
            } else {
                printWriter.println(" && (" + string4 + ")) {");
            }
            printWriter.println(string + "    _s." + member.name + " = " + string2 + "::" + member.type().name + "(new " + option.type.name + "(&_s));");
            printWriter.println(string + "    parse" + option.type.name + "(in, *(" + option.type.name + "*)_s." + member.name + ".data());");
            printWriter.println(string + "}");
        }
    }

    private static void printUnsureChoiceParser(PrintWriter printWriter, String string, String string2, Member member) {
        String string3;
        Object object = "";
        Object object2 = "_x";
        printWriter.println(string + "_m = in.setMark();");
        Choice choice = (Choice)member.type();
        String[] stringArray = choice.getChoiceNames();
        int n = member.isOptional ? stringArray.length : stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            string3 = stringArray[i];
            printWriter.println(string + "try {");
            printWriter.println(string + "    _s." + member.name + " = " + string2 + "::" + choice.name + "(new " + string3 + "(&_s));");
            printWriter.println(string + "    parse" + string3 + "(in, *(" + string3 + "*)_s." + member.name + ".data());");
            printWriter.println(string + "} catch (IncorrectValueException " + (String)object2 + ") {");
            printWriter.println(string + "    _s." + member.name + ".clear();");
            printWriter.println(string + "    in.rewind(_m);");
            object2 = (String)object2 + "x";
            object = (String)object + "}";
        }
        if (!member.isOptional) {
            string3 = stringArray[stringArray.length - 1];
            printWriter.println(string + "    _s." + member.name + " = " + string2 + "::" + choice.name + "(new " + string3 + "(&_s));");
            printWriter.println(string + "    parse" + string3 + "(in, *(" + string3 + "*)_s." + member.name + ".data());");
        }
        printWriter.println(string + (String)object);
    }

    private static void printFixedSizeArrayParser(PrintWriter printWriter, String string, Member member, String string2) {
        printWriter.println(string + "qint64 _startPos = in.getPosition();");
        printWriter.println(string + "int _totalSize = qMin(" + QtParserGenerator.getExpression("_s", string2) + ", quint32(in.getSize() - _startPos));");
        printWriter.println(string + "_atend = in.getPosition() - _startPos >= _totalSize;");
        printWriter.println(string + "while (!_atend) {");
        printWriter.println(string + "    _s." + member.name + ".append(" + member.type().name + "(&_s));");
        printWriter.println(string + "    parse" + member.type().name + "(in, _s." + member.name + ".last());");
        printWriter.println(string + "    _atend = in.getPosition() - _startPos >= _totalSize;");
        printWriter.println(string + "}");
    }

    private static void printVariableArrayParser(PrintWriter printWriter, String string, Member member) {
        printWriter.println(string + "_atend = false;");
        printWriter.println(string + "while (!_atend) {");
        printWriter.println(string + "    _m = in.setMark();");
        printWriter.println(string + "    try {");
        printWriter.println(string + "        _s." + member.name + ".append(" + member.type().name + "(&_s));");
        printWriter.println(string + "        parse" + member.type().name + "(in, _s." + member.name + ".last());");
        printWriter.println(string + "    } catch(IncorrectValueException _e) {");
        printWriter.println(string + "        _s." + member.name + ".removeLast();");
        printWriter.println(string + "        _atend = true;");
        printWriter.println(string + "        in.rewind(_m);");
        printWriter.println(string + "    } catch(EOFException _e) {");
        printWriter.println(string + "        _s." + member.name + ".removeLast();");
        printWriter.println(string + "        _atend = true;");
        printWriter.println(string + "        in.rewind(_m);");
        printWriter.println(string + "    }");
        printWriter.println(string + "}");
    }

    private void printOptionalMemberParser(PrintWriter printWriter, String string, Member member) {
        printWriter.println(string + "_m = in.setMark();");
        Option option = Option.parseOption((Struct)member.type(), null);
        String string2 = this.getTypeName(option.limitsType);
        printWriter.println(string + "try {");
        printWriter.println(string + "    " + string2 + " _optionCheck(&_s);");
        printWriter.println(string + "    parse" + string2 + "(in, _optionCheck);");
        printWriter.println(string + "    _possiblyPresent = " + QtParserGenerator.getClause("_optionCheck", option.limitsType, option.lim) + ";");
        printWriter.println(string + "} catch(EOFException _e) {");
        printWriter.println(string + "    _possiblyPresent = false;");
        printWriter.println(string + "}");
        printWriter.println(string + "in.rewind(_m);");
        printWriter.println(string + "_m = in.setMark();");
        printWriter.println(string + "if (_possiblyPresent) {");
        printWriter.println(string + "    try {");
        printWriter.println(string + "        _s." + member.name + " = QSharedPointer<" + member.type().name + ">(new " + member.type().name + "(&_s));");
        printWriter.println(string + "        parse" + member.type().name + "(in, *_s." + member.name + ".data());");
        printWriter.println(string + "    } catch(IncorrectValueException _e) {");
        printWriter.println(string + "        _s." + member.name + ".clear();");
        printWriter.println(string + "        in.rewind(_m);");
        printWriter.println(string + "    } catch(EOFException _e) {");
        printWriter.println(string + "        _s." + member.name + ".clear();");
        printWriter.println(string + "        in.rewind(_m);");
        printWriter.println(string + "    }");
        printWriter.println(string + "}");
    }

    private void printLimitationCheck(PrintWriter printWriter, String string, String string2, Member member) {
        for (Limitation limitation : member.limitations) {
            Object object = limitation.name;
            object = !"".equals(object) ? string2 + "." + (String)object : string2;
            if (!member.isStruct) {
                object = "((" + this.getTypeName(member.type()) + ")" + (String)object + ")";
            }
            String string3 = limitation.value;
            String string4 = limitation.expression;
            if (string3 != null) {
                string4 = QtParserGenerator.getCondition((String)object, string3);
            } else if (string4 != null) {
                string4 = QtParserGenerator.getExpression((String)object, string4);
            }
            printWriter.println(string + "if (!(" + string4 + ")) {");
            String string5 = "IncorrectValueException";
            printWriter.println(string + "    throw " + string5 + "(in.getPosition(), \"" + string4 + "\");");
            printWriter.println(string + "}");
        }
    }

    static String getLimit(String string, Limitation limitation) {
        String string2 = limitation.value;
        String string3 = limitation.expression;
        if (string2 != null) {
            return QtParserGenerator.getCondition(string, string2);
        }
        if (string3 != null) {
            return QtParserGenerator.getExpression(string, string3);
        }
        throw new Error("value and condition cannot both be null for " + string);
    }

    private static String getExpression(String string, String string2) {
        if (Pattern.matches(".*[A-Za-z].*", string2)) {
            return QtParserGenerator.prependStructureToExpression(string2, string);
        }
        return string + string2;
    }

    private static String getCondition(String string, String string2) {
        String string3 = " == ";
        String string4 = " || ";
        if (string2.startsWith("!")) {
            string2 = string2.substring(1);
            string3 = " != ";
            string4 = " && ";
        }
        if (string2.contains("|")) {
            String[] stringArray = string2.split("\\|");
            String string5 = string + string3 + stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string5 = string5 + string4 + string + string3 + stringArray[i];
            }
            return string5;
        }
        if (!"".equals(string2)) {
            return string + string3 + string2;
        }
        return string2;
    }

    public class QtParserConfiguration {
        public final @Nullable String namespace;
        public final String basename;
        public final String outputdir;
        public boolean createHeader;
        public boolean enableXml;
        public boolean enableWriting;
        public boolean enableIntrospection;
        public boolean enableToString;
        public boolean enableStyleTextPropAtomFix;

        QtParserConfiguration(String string, String string2, String string3) {
            this.namespace = string;
            this.basename = string2;
            this.outputdir = string3;
        }
    }
}

