;; Copyright (C) 2002-2013 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.
;;
;; DFA-based pipeline description for 5500
(define_automaton "vr55")
(define_cpu_unit "vr55_dp0"     "vr55")
(define_cpu_unit "vr55_dp1"     "vr55")
(define_cpu_unit "vr55_mem"     "vr55")
(define_cpu_unit "vr55_mac"     "vr55")
(define_cpu_unit "vr55_fp"      "vr55")
(define_cpu_unit "vr55_bru"     "vr55")

;;
;; The ordering of the instruction-execution-path/resource-usage
;; descriptions (also known as reservation RTL) is roughly ordered
;; based on the define attribute RTL for the "type" classification.
;; When modifying, remember that the first test that matches is the
;; reservation used!
;;

(define_insn_reservation "ir_vr55_unknown" 1
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "unknown,atomic,syncloop"))
  "vr55_dp0+vr55_dp1+vr55_mem+vr55_mac+vr55_fp+vr55_bru")

;; Assume prediction fails.
(define_insn_reservation "ir_vr55_branch" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "branch,jump,call"))
  "vr55_bru")

(define_insn_reservation "ir_vr55_load" 3
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "load,fpload,fpidxload"))
  "vr55_mem")

(define_bypass 4
  "ir_vr55_load"
  "ir_vr55_mthilo,ir_vr55_imul_si,ir_vr55_imul_di,ir_vr55_imadd,
   ir_vr55_idiv_si,ir_vr55_idiv_di")

(define_insn_reservation "ir_vr55_store" 0
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "store,fpstore,fpidxstore"))
  "vr55_mem")

;; This reservation is for conditional move based on integer
;; or floating point CC.
(define_insn_reservation "ir_vr55_condmove" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "condmove"))
  "vr55_dp0|vr55_dp1")

;; Move to/from FPU registers
(define_insn_reservation "ir_vr55_xfer" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "mfc,mtc"))
  "vr55_dp0|vr55_dp1")

(define_insn_reservation "ir_vr55_arith" 1
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "arith,shift,signext,slt,clz,const,logical,move,nop,trap"))
  "vr55_dp0|vr55_dp1")

(define_bypass 2
  "ir_vr55_arith"
  "ir_vr55_mthilo,ir_vr55_imul_si,ir_vr55_imul_di,ir_vr55_imadd,
   ir_vr55_idiv_si,ir_vr55_idiv_di")

(define_insn_reservation "ir_vr55_mthilo" 1
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "mthi,mtlo"))
  "vr55_mac")

(define_insn_reservation "ir_vr55_mfhilo" 5
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "mfhi,mflo"))
  "vr55_mac")

;; The default latency is for the GPR result of a mul.  Bypasses handle the
;; latency of {mul,mult}->{mfhi,mflo}.
(define_insn_reservation "ir_vr55_imul_si" 5
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "imul,imul3")
            (eq_attr "mode" "SI")))
  "vr55_mac")

;; The default latency is for pre-reload scheduling and handles the case
;; where a pseudo destination will be stored in a GPR (as it usually is).
;; The delay includes the latency of the dmult itself and the anticipated
;; mflo or mfhi.
;;
;; Once the mflo or mfhi has been created, bypasses handle the latency
;; between it and the dmult.
(define_insn_reservation "ir_vr55_imul_di" 9
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "imul,imul3")
            (eq_attr "mode" "DI")))
  "vr55_mac*4")

;; The default latency is as for ir_vr55_imul_si.
(define_insn_reservation "ir_vr55_imadd" 5
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "imadd"))
  "vr55_mac")

(define_bypass 1
  "ir_vr55_imul_si,ir_vr55_imadd"
  "ir_vr55_imadd"
  "mips_linked_madd_p")

(define_bypass 2
  "ir_vr55_imul_si,ir_vr55_imadd"
  "ir_vr55_mfhilo")

(define_bypass 4
  "ir_vr55_imul_di"
  "ir_vr55_mfhilo")

;; Divide algorithm is early out with best latency of 7 pcycles.
;; Use worst case for scheduling purposes.
(define_insn_reservation "ir_vr55_idiv_si" 42
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "idiv")
            (eq_attr "mode" "SI")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_idiv_di" 74
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "idiv")
            (eq_attr "mode" "DI")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fadd" 4
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "fadd"))
  "vr55_fp")

(define_insn_reservation "ir_vr55_fmul_sf" 5
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fmul")
            (eq_attr "mode" "SF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fmul_df" 6
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fmul")
            (eq_attr "mode" "DF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fmadd_sf" 9
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fmadd")
            (eq_attr "mode" "SF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fmadd_df" 10
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fmadd")
            (eq_attr "mode" "DF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fdiv_sf" 30
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt")
            (eq_attr "mode" "SF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fdiv_df" 59
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt")
            (eq_attr "mode" "DF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fabs" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "fabs,fneg,fmove"))
  "vr55_fp")

(define_insn_reservation "ir_vr55_fcmp" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "fcmp"))
  "vr55_fp")

(define_insn_reservation "ir_vr55_fcvt_sf" 4
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fcvt")
            (eq_attr "mode" "SF")))
  "vr55_fp")

(define_insn_reservation "ir_vr55_fcvt_df" 6
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fcvt")
            (eq_attr "mode" "DF")))
  "vr55_fp")

(define_insn_reservation "ir_vr55_frsqrt_sf" 60
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "frsqrt")
            (eq_attr "mode" "SF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_frsqrt_df" 118
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "frsqrt")
            (eq_attr "mode" "DF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_multi" 1
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "multi"))
  "vr55_dp0+vr55_dp1+vr55_mem+vr55_mac+vr55_fp+vr55_bru")
