/* Generated by re2c 0.15.3 on Tue Oct 24 10:49:45 2017 */
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Derick Rethans
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/* $Id$ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
           **ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 60) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			if ((res = tz_wrapper(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 33) YYFILL(33);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1465;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych >= 'a') goto yy145;
		} else {
			if (yych <= 'e') goto yy1474;
			if (yych <= 'z') goto yy145;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1465;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy1465;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1436;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1437;
				if (yych <= 'N') goto yy140;
				goto yy1435;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1452;
				goto yy145;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1453;
				goto yy145;
			} else {
				if (yych <= 'o') goto yy1451;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1436;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1437;
				if (yych <= 'N') goto yy140;
				goto yy1435;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1436;
				goto yy140;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1437;
				goto yy140;
			} else {
				if (yych <= 'o') goto yy1435;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy1405;
		} else {
			if (yych == 'I') goto yy1406;
			if (yych <= 'N') goto yy140;
			goto yy1407;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1420;
			goto yy145;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1421;
				goto yy145;
			} else {
				if (yych <= 'o') goto yy1422;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy1405;
		} else {
			if (yych == 'I') goto yy1406;
			if (yych <= 'N') goto yy140;
			goto yy1407;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1405;
			goto yy140;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1406;
				goto yy140;
			} else {
				if (yych <= 'o') goto yy1407;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy139;
	case '0':
	case '1':	goto yy1335;
	case '2':	goto yy1336;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1337;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy140;
	case 'E':	goto yy1330;
	case 'H':	goto yy1331;
	case 'O':	goto yy1332;
	case 'U':	goto yy1333;
	case 'W':	goto yy1334;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'e':	goto yy1373;
	case 'h':	goto yy1374;
	case 'o':	goto yy1375;
	case 'u':	goto yy1376;
	case 'w':	goto yy1377;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy139;
	case '0':
	case '1':	goto yy1335;
	case '2':	goto yy1336;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1337;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy140;
	case 'E':
	case 'e':	goto yy1330;
	case 'H':
	case 'h':	goto yy1331;
	case 'O':
	case 'o':	goto yy1332;
	case 'U':
	case 'u':	goto yy1333;
	case 'W':
	case 'w':	goto yy1334;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1326;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1327;
yy12:
	YYDEBUG(12, *YYCURSOR);
	{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy140;
				goto yy1261;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1262;
				goto yy140;
			} else {
				if (yych <= 'O') goto yy1263;
				if (yych <= 'Q') goto yy140;
				goto yy1264;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy145;
			} else {
				if (yych <= 'e') goto yy1303;
				if (yych <= 'h') goto yy145;
				goto yy1304;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1305;
				goto yy145;
			} else {
				if (yych <= 'r') goto yy1306;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy140;
				goto yy1261;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1262;
				goto yy140;
			} else {
				if (yych <= 'O') goto yy1263;
				if (yych <= 'Q') goto yy140;
				goto yy1264;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy140;
			} else {
				if (yych <= 'e') goto yy1261;
				if (yych <= 'h') goto yy140;
				goto yy1262;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1263;
				goto yy140;
			} else {
				if (yych <= 'r') goto yy1264;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1247;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1258;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1247;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1247;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1226;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1244;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1226;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1226;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1169;
				goto yy140;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1168;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1170;
				if (yych <= 'T') goto yy140;
				goto yy1171;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1198;
				if (yych <= 'd') goto yy145;
				goto yy1197;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1199;
				goto yy145;
			} else {
				if (yych <= 'u') goto yy1200;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1169;
				goto yy140;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1168;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1170;
				if (yych <= 'T') goto yy140;
				goto yy1171;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1169;
				if (yych <= 'd') goto yy140;
				goto yy1168;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1170;
				goto yy140;
			} else {
				if (yych <= 'u') goto yy1171;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1138;
			if (yych <= 'K') goto yy140;
			goto yy1139;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy145;
			goto yy1156;
		} else {
			if (yych == 'l') goto yy1157;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1138;
			if (yych <= 'K') goto yy140;
			goto yy1139;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy140;
			goto yy1138;
		} else {
			if (yych == 'l') goto yy1139;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1037;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'r') goto yy1131;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1037;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'r') goto yy1037;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy991;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy993;
	case '-':	goto yy412;
	case '.':	goto yy1003;
	case '/':	goto yy411;
	case '0':	goto yy1036;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1035;
	case ':':	goto yy1004;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy399;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy401;
	case '-':	goto yy412;
	case '.':	goto yy413;
	case '/':	goto yy411;
	case '0':
	case '1':
	case '2':	goto yy1035;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1002;
	case ':':	goto yy422;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy399;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy401;
	case '-':	goto yy412;
	case '.':	goto yy413;
	case '/':	goto yy411;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1002;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy989;
	case ':':	goto yy422;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy399;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy401;
	case '-':	goto yy412;
	case '.':	goto yy413;
	case '/':	goto yy411;
	case '0':
	case '1':	goto yy989;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy408;
	case ':':	goto yy422;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy399;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy401;
	case '-':	goto yy412;
	case '.':	goto yy413;
	case '/':	goto yy411;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy408;
	case ':':	goto yy422;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy379;
	case '0':
	case '1':	goto yy376;
	case '2':	goto yy377;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy378;
	default:	goto yy12;
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy375;
				if (yych <= 'U') goto yy140;
				goto yy374;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy374;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy371;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy369;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy352;
			if (yych <= 'T') goto yy140;
			goto yy351;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy361;
		} else {
			if (yych == 'u') goto yy360;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy352;
			if (yych <= 'T') goto yy140;
			goto yy351;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy352;
		} else {
			if (yych == 'u') goto yy351;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy330;
				goto yy140;
			} else {
				if (yych <= 'P') goto yy329;
				if (yych <= 'T') goto yy140;
				goto yy328;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'g') goto yy342;
				goto yy145;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy341;
				goto yy145;
			} else {
				if (yych <= 'u') goto yy340;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy330;
				goto yy140;
			} else {
				if (yych <= 'P') goto yy329;
				if (yych <= 'T') goto yy140;
				goto yy328;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'g') goto yy330;
				goto yy140;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy329;
				goto yy140;
			} else {
				if (yych <= 'u') goto yy328;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy140;
			goto yy318;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'c') goto yy323;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy140;
			goto yy318;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'c') goto yy318;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy309;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy191;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy164;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy178;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy164;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy164;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy140;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy156;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy155;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy155;
	goto yy12;
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy145;
		goto yy3;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy140;
		goto yy3;
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	YYDEBUG(49, *YYCURSOR);
	{
		goto std;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych >= 'F') goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych >= 'M') goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy61;
				} else {
					if (yych <= 'T') goto yy68;
					if (yych >= 'W') goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych >= 'd') goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy65;
				} else {
					if (yych == 'h') goto yy63;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy56;
				if (yych <= 's') goto yy61;
				goto yy68;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy67;
				} else {
					if (yych == 'y') goto yy66;
				}
			}
		}
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept == 3) {
						goto yy72;
					} else {
						goto yy166;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy193;
					} else {
						goto yy207;
					}
				} else {
					if (yyaccept == 7) {
						goto yy221;
					} else {
						goto yy332;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy415;
					} else {
						goto yy430;
					}
				} else {
					if (yyaccept == 11) {
						goto yy551;
					} else {
						goto yy596;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy606;
					} else {
						goto yy703;
					}
				} else {
					if (yyaccept == 15) {
						goto yy723;
					} else {
						goto yy754;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 24) {
			if (yyaccept <= 20) {
				if (yyaccept <= 18) {
					if (yyaccept == 17) {
						goto yy761;
					} else {
						goto yy788;
					}
				} else {
					if (yyaccept == 19) {
						goto yy733;
					} else {
						goto yy394;
					}
				}
			} else {
				if (yyaccept <= 22) {
					if (yyaccept == 21) {
						goto yy913;
					} else {
						goto yy782;
					}
				} else {
					if (yyaccept == 23) {
						goto yy1007;
					} else {
						goto yy1015;
					}
				}
			}
		} else {
			if (yyaccept <= 28) {
				if (yyaccept <= 26) {
					if (yyaccept == 25) {
						goto yy1057;
					} else {
						goto yy1081;
					}
				} else {
					if (yyaccept == 27) {
						goto yy1234;
					} else {
						goto yy1359;
					}
				}
			} else {
				if (yyaccept <= 30) {
					if (yyaccept == 29) {
						goto yy1362;
					} else {
						goto yy1442;
					}
				} else {
					if (yyaccept == 31) {
						goto yy1450;
					} else {
						goto yy1473;
					}
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(58, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy54;
	goto yy56;
yy59:
	YYDEBUG(59, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy60:
	YYDEBUG(60, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy56;
				goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych <= 'E') goto yy56;
				goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych <= 'L') goto yy56;
				goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
				} else {
					if (yych <= 'T') goto yy68;
					if (yych <= 'V') goto yy56;
					goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych <= 'c') goto yy56;
				goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy65;
				} else {
					if (yych == 'h') goto yy63;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy56;
				if (yych >= 't') goto yy68;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
					goto yy67;
				} else {
					if (yych == 'y') goto yy66;
					goto yy56;
				}
			}
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy127;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy127;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy117;
		if (yych <= 'N') goto yy56;
		goto yy116;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy56;
			goto yy117;
		} else {
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy114;
	if (yych == 'o') goto yy114;
	goto yy56;
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy113;
	if (yych == 'a') goto yy113;
	goto yy56;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy98;
		if (yych <= 'Q') goto yy56;
		goto yy97;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy98;
		} else {
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy94;
	if (yych == 'e') goto yy94;
	goto yy56;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy82;
	if (yych == 'e') goto yy82;
	goto yy56;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy69;
		if (yych <= 'T') goto yy56;
		goto yy70;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy77;
	if (yych == 'u') goto yy77;
	goto yy56;
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy71;
	if (yych != 'e') goto yy56;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
yy72:
	YYDEBUG(72, *YYCURSOR);
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy74;
	if (yych != 'd') goto yy56;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy75;
	if (yych != 'a') goto yy56;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych != 'y') goto yy56;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy72;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy78;
	if (yych != 'r') goto yy72;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy79;
	if (yych != 's') goto yy56;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy80;
	if (yych != 'd') goto yy56;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy81;
	if (yych != 'a') goto yy56;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy84;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy84;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy90;
	if (yych == 'k') goto yy90;
	goto yy56;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy85;
	if (yych != 'n') goto yy72;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy86;
	if (yych != 'e') goto yy56;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy87;
	if (yych != 's') goto yy56;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy88;
	if (yych != 'd') goto yy56;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy89;
	if (yych != 'a') goto yy56;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy91;
		if (yych <= 'R') goto yy72;
		goto yy76;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy72;
		} else {
			if (yych == 's') goto yy76;
			goto yy72;
		}
	}
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy92;
	if (yych != 'a') goto yy56;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy93;
	if (yych != 'y') goto yy56;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych == 's') goto yy76;
	goto yy72;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy95;
	if (yych != 'a') goto yy56;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy96;
	if (yych != 'r') goto yy56;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych == 's') goto yy76;
	goto yy72;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy110;
	if (yych == 'i') goto yy110;
	goto yy56;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy99;
	if (yych != 'r') goto yy56;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy100;
	if (yych != 't') goto yy56;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy102;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy102;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy107;
	if (yych == 'i') goto yy107;
	goto yy56;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy103;
	if (yych != 'n') goto yy56;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy104;
	if (yych != 'i') goto yy56;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy105;
	if (yych != 'g') goto yy56;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy106;
	if (yych != 'h') goto yy56;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy96;
	if (yych == 't') goto yy96;
	goto yy56;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy108;
	if (yych != 'g') goto yy56;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy109;
	if (yych != 'h') goto yy56;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy96;
	if (yych == 't') goto yy96;
	goto yy56;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy111;
	if (yych != 'd') goto yy72;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy112;
	if (yych != 'a') goto yy56;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy96;
	if (yych == 'y') goto yy96;
	goto yy56;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy115;
	if (yych != 'u') goto yy56;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy96;
	if (yych == 'r') goto yy96;
	goto yy56;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy121;
	if (yych == 'n') goto yy121;
	goto yy56;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy118;
	if (yych != 'n') goto yy56;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy76;
		if (yych <= 'T') goto yy72;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy72;
			goto yy76;
		} else {
			if (yych != 'u') goto yy72;
		}
	}
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy120;
	if (yych != 't') goto yy56;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy96;
	if (yych == 'e') goto yy96;
	goto yy56;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy122;
		if (yych <= 'S') goto yy72;
		goto yy123;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy72;
		} else {
			if (yych == 't') goto yy123;
			goto yy72;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy124;
	if (yych == 'a') goto yy124;
	goto yy56;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy96;
	if (yych == 'h') goto yy96;
	goto yy56;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy136;
	if (yych == 'n') goto yy136;
	goto yy56;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy131;
	if (yych == 't') goto yy131;
	goto yy56;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy128;
	if (yych != 'c') goto yy56;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy129;
		if (yych <= 'R') goto yy72;
		goto yy76;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy72;
		} else {
			if (yych == 's') goto yy76;
			goto yy72;
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy130;
	if (yych != 'n') goto yy56;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy96;
	if (yych == 'd') goto yy96;
	goto yy56;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy132;
	if (yych != 'u') goto yy72;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy133;
	if (yych != 'r') goto yy56;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy134;
	if (yych != 'd') goto yy56;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy135;
	if (yych != 'a') goto yy56;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy137;
	if (yych != 'd') goto yy72;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy138;
	if (yych != 'a') goto yy56;
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy139;
	goto yy3;
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy142;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	goto yy56;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(149, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy3;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy3;
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy139;
		if (yych <= ',') goto yy3;
		goto yy147;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy3;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy154:
	YYDEBUG(154, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy56;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy56;
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy140;
		goto yy3;
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy141;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy141;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
	YYDEBUG(157, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy158;
			if (yych <= '@') goto yy3;
			goto yy142;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy159;
	if (yych <= '2') goto yy160;
	if (yych <= '9') goto yy161;
	goto yy56;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy161;
	if (yych <= ':') goto yy162;
	goto yy3;
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych >= '5') goto yy163;
	} else {
		if (yych <= '9') goto yy139;
		if (yych <= ':') goto yy162;
		goto yy3;
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy163;
	if (yych <= '9') goto yy139;
	if (yych >= ';') goto yy3;
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy163;
	if (yych <= '9') goto yy139;
	goto yy3;
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy139;
	goto yy3;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy141;
			if (yych >= 'E') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy165;
			if (yych <= 'e') goto yy167;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'M') goto yy142;
			goto yy173;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych >= 'a') goto yy142;
		} else {
			if (yych <= 'n') goto yy173;
			if (yych <= 'z') goto yy142;
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy142;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'k') goto yy168;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy169;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy170;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy171;
		if (yych != 'y') goto yy3;
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy172;
	if (yych != 's') goto yy166;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy166;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy174;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy144;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') goto yy175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy176;
		if (yych != 'd') goto yy3;
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy56;
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy147;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy141;
				goto yy165;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy167;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy146;
			} else {
				if (yych <= 'e') goto yy180;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy173;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy186;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy168;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'k') goto yy181;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy169;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy182;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy170;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy183;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy171;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy184;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy147;
			goto yy166;
		} else {
			if (yych <= '/') goto yy147;
			if (yych <= 'R') goto yy166;
			goto yy172;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy147;
			goto yy166;
		} else {
			if (yych == 's') goto yy185;
			if (yych <= 'z') goto yy153;
			goto yy166;
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy166;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy166;
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy174;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy187;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 's') goto yy188;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy176;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'd') goto yy189;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy154;
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy141;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy192;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy195;
			} else {
				if (yych == ' ') goto yy195;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
			} else {
				if (yych == 'E') goto yy200;
				goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy142;
			} else {
				if (yych <= 'e') goto yy200;
				if (yych <= 'z') goto yy142;
			}
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy194:
	YYDEBUG(194, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 23) YYFILL(23);
	yych = *YYCURSOR;
yy195:
	YYDEBUG(195, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy194;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy197;
	if (yych <= '3') goto yy198;
	if (yych <= '9') goto yy199;
	goto yy56;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy195;
	if (yych <= '0') goto yy299;
	if (yych <= '2') goto yy300;
	if (yych <= '3') goto yy301;
	goto yy195;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy298;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy298;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy205;
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy205;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy143;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'm') goto yy201;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy202;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy203;
		if (yych != 'e') goto yy3;
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych != 'r') goto yy56;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy195;
		if (yych <= 0x1F) goto yy193;
		goto yy195;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy193;
			goto yy195;
		} else {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		}
	}
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy295;
	goto yy56;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy294;
	goto yy212;
yy207:
	YYDEBUG(207, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy208:
	YYDEBUG(208, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy294;
	goto yy212;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy294;
	goto yy212;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy294;
	goto yy212;
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy212:
	YYDEBUG(212, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy211;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy207;
		if (yych <= '0') goto yy285;
		if (yych <= '1') goto yy286;
		goto yy287;
	} else {
		if (yych <= '9') goto yy288;
		if (yych == 'T') goto yy214;
		goto yy207;
	}
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych <= '/') goto yy207;
			goto yy215;
		} else {
			if (yych <= '1') goto yy216;
			if (yych <= '2') goto yy217;
			goto yy218;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy207;
		} else {
			if (yych != 't') goto yy207;
		}
	}
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy283;
	if (yych <= '2') goto yy284;
	if (yych <= '9') goto yy273;
	goto yy56;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy56;
	} else {
		if (yych <= '0') goto yy273;
		if (yych <= '9') goto yy218;
		if (yych <= ':') goto yy274;
		goto yy56;
	}
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy56;
	} else {
		if (yych <= '2') goto yy218;
		if (yych <= '9') goto yy273;
		if (yych <= ':') goto yy219;
		goto yy56;
	}
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy56;
	} else {
		if (yych <= '4') goto yy273;
		if (yych == ':') goto yy219;
		goto yy56;
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy219;
	if (yych != ':') goto yy56;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy220;
	if (yych <= '9') goto yy222;
	goto yy56;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy223;
	} else {
		if (yych <= '9') goto yy266;
		if (yych <= ':') goto yy223;
	}
yy221:
	YYDEBUG(221, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy222:
	YYDEBUG(222, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy223;
	if (yych != ':') goto yy221;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy224;
	if (yych <= '6') goto yy225;
	if (yych <= '9') goto yy226;
	goto yy56;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '9') goto yy227;
	goto yy221;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy227;
	goto yy221;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy221;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy229;
			goto yy221;
		} else {
			if (yych <= ' ') goto yy229;
			if (yych == '(') goto yy229;
			goto yy221;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy221;
			if (yych <= '-') goto yy229;
			goto yy221;
		} else {
			if (yych <= 'Z') goto yy229;
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy229;
			goto yy221;
		}
	}
yy228:
	YYDEBUG(228, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy229:
	YYDEBUG(229, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy228;
			} else {
				if (yych == ' ') goto yy228;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy232;
				if (yych <= '*') goto yy56;
				goto yy231;
			} else {
				if (yych == '-') goto yy231;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy233;
				if (yych <= 'F') goto yy234;
			} else {
				if (yych == 'P') goto yy233;
				goto yy234;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy235;
				goto yy236;
			} else {
				if (yych <= 'p') goto yy235;
				if (yych <= 'z') goto yy236;
				goto yy56;
			}
		}
	}
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy226;
		if (yych <= '@') goto yy221;
		goto yy237;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy264;
			goto yy237;
		} else {
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy248;
			goto yy221;
		}
	}
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy259;
	if (yych <= '2') goto yy260;
	if (yych <= '9') goto yy261;
	goto yy56;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy236;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy236;
	goto yy56;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych <= '.') goto yy242;
			if (yych <= '@') goto yy221;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy243;
			if (yych <= 'Z') goto yy237;
			goto yy221;
		} else {
			if (yych == 'm') goto yy258;
			if (yych <= 'z') goto yy248;
			goto yy221;
		}
	}
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy237;
		if (yych <= '`') goto yy221;
		if (yych <= 'z') goto yy248;
		goto yy221;
	}
yy235:
	YYDEBUG(235, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych <= '.') goto yy242;
			if (yych <= '@') goto yy221;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy243;
			if (yych <= 'Z') goto yy237;
			goto yy221;
		} else {
			if (yych == 'm') goto yy243;
			if (yych <= 'z') goto yy237;
			goto yy221;
		}
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy237;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy238;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy239;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy240;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy241;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy226;
	goto yy221;
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy247;
	if (yych == 'm') goto yy247;
	goto yy56;
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy245;
			if (yych <= 0x08) goto yy221;
			goto yy245;
		} else {
			if (yych == ' ') goto yy245;
			if (yych <= '(') goto yy221;
			goto yy226;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy221;
		} else {
			if (yych <= 'Z') goto yy238;
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy238;
			goto yy221;
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy245;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy245:
	YYDEBUG(245, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(246, *YYCURSOR);
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy245;
		if (yych == '\t') goto yy245;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy245;
		if (yych == '.') goto yy244;
		goto yy56;
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych == '.') goto yy221;
			goto yy250;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy221;
			if (yych <= 'Z') goto yy238;
			goto yy221;
		} else {
			if (yych <= '_') goto yy250;
			if (yych <= '`') goto yy221;
			if (yych >= '{') goto yy221;
		}
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych == '.') goto yy221;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy221;
			if (yych <= 'Z') goto yy239;
			goto yy221;
		} else {
			if (yych <= '_') goto yy250;
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy253;
			goto yy221;
		}
	}
yy250:
	YYDEBUG(250, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy251;
	if (yych <= '`') goto yy56;
	if (yych >= '{') goto yy56;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(252, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy221;
			goto yy250;
		} else {
			if (yych == '/') goto yy250;
			goto yy221;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy251;
			if (yych <= '^') goto yy221;
			goto yy250;
		} else {
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy251;
			goto yy221;
		}
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych == '.') goto yy221;
			goto yy250;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy221;
			if (yych <= 'Z') goto yy240;
			goto yy221;
		} else {
			if (yych <= '_') goto yy250;
			if (yych <= '`') goto yy221;
			if (yych >= '{') goto yy221;
		}
	}
	YYDEBUG(254, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych == '.') goto yy221;
			goto yy250;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy221;
			if (yych <= 'Z') goto yy241;
			goto yy221;
		} else {
			if (yych <= '_') goto yy250;
			if (yych <= '`') goto yy221;
			if (yych >= '{') goto yy221;
		}
	}
	YYDEBUG(255, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy221;
			goto yy226;
		} else {
			if (yych == '-') goto yy250;
			goto yy221;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy250;
			if (yych <= '^') goto yy221;
			goto yy250;
		} else {
			if (yych <= '`') goto yy221;
			if (yych >= '{') goto yy221;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(257, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy250;
		if (yych <= '.') goto yy56;
		goto yy250;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy250;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy256;
			goto yy56;
		}
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy245;
			if (yych == '\t') goto yy245;
			goto yy221;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy245;
				goto yy221;
			} else {
				if (yych <= ')') goto yy226;
				if (yych <= ',') goto yy221;
				goto yy250;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy244;
			if (yych <= '/') goto yy250;
			if (yych <= '@') goto yy221;
			goto yy238;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy221;
				goto yy250;
			} else {
				if (yych <= '`') goto yy221;
				if (yych <= 'z') goto yy249;
				goto yy221;
			}
		}
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '9') goto yy261;
	if (yych <= ':') goto yy262;
	goto yy221;
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy221;
		if (yych >= '5') goto yy263;
	} else {
		if (yych <= '9') goto yy226;
		if (yych <= ':') goto yy262;
		goto yy221;
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '5') goto yy263;
	if (yych <= '9') goto yy226;
	if (yych >= ';') goto yy221;
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '5') goto yy263;
	if (yych <= '9') goto yy226;
	goto yy221;
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '9') goto yy226;
	goto yy221;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy226;
		if (yych <= '@') goto yy221;
		goto yy238;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy238;
		} else {
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy238;
			goto yy221;
		}
	}
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy221;
			goto yy226;
		} else {
			if (yych == '+') goto yy231;
			goto yy221;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy231;
			if (yych <= '@') goto yy221;
			goto yy239;
		} else {
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy239;
			goto yy221;
		}
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy267;
			if (yych <= 0x1F) goto yy221;
		} else {
			if (yych == '.') goto yy223;
			if (yych <= '9') goto yy221;
			goto yy223;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy269;
			if (yych <= 'O') goto yy221;
			goto yy269;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy221;
				goto yy269;
			} else {
				if (yych == 'p') goto yy269;
				goto yy221;
			}
		}
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(268, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy267;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy267;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy269;
			if (yych != 'p') goto yy56;
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy271;
		if (yych == 'm') goto yy271;
		goto yy56;
	}
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy271;
	if (yych != 'm') goto yy56;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy245;
		if (yych == '\t') goto yy245;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy245;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy245;
		if (yych <= 0x08) goto yy56;
		goto yy245;
	} else {
		if (yych == ' ') goto yy245;
		goto yy56;
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy274;
	if (yych != ':') goto yy56;
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy275;
	if (yych <= '9') goto yy276;
	goto yy56;
yy275:
	YYDEBUG(275, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy277;
		goto yy221;
	} else {
		if (yych <= '9') goto yy276;
		if (yych <= ':') goto yy277;
		goto yy221;
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy277;
	if (yych != ':') goto yy221;
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy278;
	if (yych <= '6') goto yy279;
	if (yych <= '9') goto yy226;
	goto yy56;
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '9') goto yy280;
	goto yy221;
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy221;
yy280:
	YYDEBUG(280, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy282;
			goto yy221;
		} else {
			if (yych <= ' ') goto yy282;
			if (yych == '(') goto yy282;
			goto yy221;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy221;
			if (yych <= '-') goto yy282;
			goto yy221;
		} else {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy282;
			goto yy221;
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy282:
	YYDEBUG(282, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy281;
			if (yych <= 0x1F) goto yy56;
			goto yy281;
		} else {
			if (yych == '(') goto yy232;
			if (yych <= '*') goto yy56;
			goto yy231;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy231;
			if (yych <= '@') goto yy56;
			goto yy234;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy230;
				goto yy234;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy236;
				goto yy56;
			}
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy56;
	} else {
		if (yych <= '9') goto yy273;
		if (yych <= ':') goto yy274;
		goto yy56;
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy56;
	} else {
		if (yych <= '4') goto yy273;
		if (yych == ':') goto yy274;
		goto yy56;
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy207;
	} else {
		if (yych <= '0') goto yy292;
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy274;
		goto yy207;
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy207;
	} else {
		if (yych <= '2') goto yy293;
		if (yych <= '9') goto yy292;
		if (yych <= ':') goto yy219;
		goto yy207;
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy207;
	} else {
		if (yych <= '4') goto yy292;
		if (yych <= '9') goto yy289;
		if (yych <= ':') goto yy219;
		goto yy207;
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy207;
	} else {
		if (yych <= '9') goto yy289;
		if (yych <= ':') goto yy219;
		goto yy207;
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy207;
	if (yych >= ':') goto yy207;
yy290:
	YYDEBUG(290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy207;
	if (yych >= ':') goto yy207;
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy207;
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy207;
	} else {
		if (yych <= '9') goto yy290;
		if (yych <= ':') goto yy274;
		goto yy207;
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy207;
	} else {
		if (yych <= '9') goto yy290;
		if (yych <= ':') goto yy219;
		goto yy207;
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy213;
	goto yy212;
yy295:
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(296, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(297, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy302;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy302;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy205;
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy56;
				if (yych <= ',') goto yy211;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
	YYDEBUG(303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(304, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy305;
	if (yych <= '9') goto yy306;
yy305:
	YYDEBUG(305, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy305;
	if (yych >= ':') goto yy305;
	YYDEBUG(307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy305;
	if (yych >= ':') goto yy305;
	YYDEBUG(308, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy305;
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy192;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'c') goto yy310;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy200;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy312;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	if (yych <= '/') goto yy195;
	if (yych <= '0') goto yy299;
	if (yych <= '2') goto yy300;
	if (yych <= '3') goto yy301;
	goto yy195;
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy201;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'm') goto yy313;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy202;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy314;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy203;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'e') goto yy315;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych != 'r') goto yy154;
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych <= ',') goto yy193;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy147;
			goto yy195;
		} else {
			if (yych == '_') goto yy147;
			goto yy193;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	goto yy195;
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy319;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'O') goto yy142;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'o') goto yy320;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy143;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'b') goto yy321;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy144;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'e') goto yy322;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy204;
		if (yych == 'r') goto yy204;
		goto yy3;
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy319;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 't') goto yy324;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'O') goto yy320;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy325;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy321;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'b') goto yy326;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy322;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'e') goto yy327;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy204;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'r') goto yy316;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy336;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy336;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
			goto yy333;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy333;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'o') goto yy331;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy332;
		if (yych <= 'z') goto yy142;
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'I') goto yy142;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'i') goto yy334;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy143;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'l') goto yy335;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy144;
			goto yy193;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'U') goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy337;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 's') goto yy338;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy339;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy193;
			goto yy195;
		} else {
			if (yych == ' ') goto yy195;
			goto yy193;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy139;
			if (yych <= ',') goto yy193;
			goto yy195;
		} else {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy336;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'g') goto yy347;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy333;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy344;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy331;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy343;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy332;
		} else {
			if (yych == '.') goto yy332;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy332;
			if (yych <= 'Z') goto yy142;
			goto yy332;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy150;
			goto yy332;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'I') goto yy334;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'i') goto yy345;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy335;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'l') goto yy346;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy317;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy152;
				goto yy193;
			}
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'U') goto yy337;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy348;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy338;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 's') goto yy349;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy339;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy350;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy317;
			if (yych <= '.') goto yy195;
			goto yy147;
		} else {
			if (yych <= '9') goto yy195;
			if (yych == '_') goto yy147;
			goto yy193;
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'L') goto yy358;
			if (yych <= 'M') goto yy141;
			goto yy357;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy141;
			goto yy358;
		} else {
			if (yych == 'n') goto yy357;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy353;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'U') goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy354;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy355;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy356;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy204;
		if (yych == 'y') goto yy204;
		goto yy3;
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych == 'E') goto yy359;
				goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy359;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'Y') goto yy142;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'y') goto yy359;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy143;
			goto yy193;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'L') goto yy358;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy357;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy367;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy366;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy353;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy362;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'U') goto yy354;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy363;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy355;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy364;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy356;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy365;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy204;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy316;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy359;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy368;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'Y') goto yy359;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'y') goto yy368;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy317;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy151;
				goto yy193;
			}
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
	YYDEBUG(372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy142;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy370;
				goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy396;
				} else {
					if (yych <= ':') goto yy162;
					if (yych <= 'C') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '4') {
					if (yych <= '/') goto yy3;
					goto yy396;
				} else {
					if (yych <= '5') goto yy381;
					if (yych <= '9') goto yy382;
					goto yy162;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy3;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy381;
				} else {
					if (yych <= '9') goto yy382;
					if (yych <= ':') goto yy162;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(380, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy379;
		goto yy56;
	} else {
		if (yych <= '-') goto yy379;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
		goto yy56;
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy395;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy383;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych != '-') goto yy60;
yy385:
	YYDEBUG(385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy386;
	if (yych <= '1') goto yy387;
	goto yy56;
yy386:
	YYDEBUG(386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy388;
	goto yy56;
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy390;
	if (yych <= '2') goto yy391;
	if (yych <= '3') goto yy392;
	goto yy56;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy393;
	goto yy56;
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy393;
	goto yy56;
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy393:
	YYDEBUG(393, *YYCURSOR);
	++YYCURSOR;
yy394:
	YYDEBUG(394, *YYCURSOR);
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy384;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy395;
					if (yych <= ':') goto yy162;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(397, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy398;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych == '-') goto yy385;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy401;
	if (yych <= '0') goto yy675;
	if (yych <= '1') goto yy676;
	if (yych <= '9') goto yy677;
	goto yy401;
yy400:
	YYDEBUG(400, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy401:
	YYDEBUG(401, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy400;
	case '-':
	case '.':	goto yy516;
	case 'A':
	case 'a':	goto yy419;
	case 'D':
	case 'd':	goto yy405;
	case 'F':
	case 'f':	goto yy406;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy414;
	case 'J':
	case 'j':	goto yy418;
	case 'M':
	case 'm':	goto yy404;
	case 'N':
	case 'n':	goto yy421;
	case 'O':
	case 'o':	goto yy420;
	case 'P':
	case 'p':	goto yy423;
	case 'S':
	case 's':	goto yy402;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy416;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy417;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy988;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy988;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy988;
			if (yych == 'U') goto yy125;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy126;
			if (yych <= 'd') goto yy56;
			goto yy988;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy668;
			if (yych <= 'u') goto yy125;
			goto yy56;
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy531;
			goto yy56;
		} else {
			if (yych <= 'I') goto yy117;
			if (yych <= 'N') goto yy56;
			goto yy116;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy531;
			goto yy56;
		} else {
			if (yych <= 'i') goto yy117;
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy113;
		if (yych <= 'D') goto yy56;
		goto yy518;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy113;
		} else {
			if (yych == 'e') goto yy518;
			goto yy56;
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy534;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy98;
			if (yych <= 'Q') goto yy56;
			goto yy97;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy534;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy98;
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy69;
		if (yych <= 'T') goto yy56;
		goto yy70;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy987;
		} else {
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy681;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy680;
	goto yy60;
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy469;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy668;
		if (yych == 'o') goto yy469;
		goto yy56;
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy668;
	goto yy56;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy605;
	case '3':	goto yy607;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy608;
	case 'A':
	case 'a':	goto yy612;
	case 'D':
	case 'd':	goto yy616;
	case 'F':
	case 'f':	goto yy610;
	case 'J':
	case 'j':	goto yy609;
	case 'M':
	case 'm':	goto yy611;
	case 'N':
	case 'n':	goto yy615;
	case 'O':
	case 'o':	goto yy614;
	case 'S':
	case 's':	goto yy613;
	default:	goto yy56;
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy555;
	case '1':	goto yy556;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy557;
	case 'A':
	case 'a':	goto yy561;
	case 'D':
	case 'd':	goto yy565;
	case 'F':
	case 'f':	goto yy559;
	case 'J':
	case 'j':	goto yy558;
	case 'M':
	case 'm':	goto yy560;
	case 'N':
	case 'n':	goto yy564;
	case 'O':
	case 'o':	goto yy563;
	case 'S':
	case 's':	goto yy562;
	default:	goto yy517;
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy517;
		if (yych <= '0') goto yy507;
		goto yy508;
	} else {
		if (yych <= '5') goto yy509;
		if (yych <= '9') goto yy510;
		goto yy517;
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '.') goto yy471;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy473;
			if (yych == 'I') goto yy506;
		} else {
			if (yych == 'W') goto yy415;
			if (yych <= 'X') goto yy479;
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy504;
			goto yy415;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy503;
			goto yy415;
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy496;
		if (yych <= 'T') goto yy56;
		goto yy495;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy496;
		} else {
			if (yych == 'u') goto yy495;
			goto yy56;
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy424;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy425;
			if (yych == 'P') goto yy489;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy488;
			if (yych == 'm') goto yy425;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy489;
			if (yych == 'u') goto yy488;
			goto yy56;
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy483;
	if (yych == 'c') goto yy483;
	goto yy56;
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy469;
	if (yych == 'o') goto yy469;
	goto yy56;
yy422:
	YYDEBUG(422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy429;
	if (yych <= '9') goto yy431;
	goto yy56;
yy423:
	YYDEBUG(423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy425;
		if (yych == 'm') goto yy425;
		goto yy56;
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy425;
	if (yych != 'm') goto yy56;
yy425:
	YYDEBUG(425, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy427;
		if (yych == '\t') goto yy427;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy427;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy427;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(428, *YYCURSOR);
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy432;
	} else {
		if (yych <= '9') goto yy446;
		if (yych <= ':') goto yy432;
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy432;
	if (yych != ':') goto yy430;
yy432:
	YYDEBUG(432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy433;
	if (yych <= '6') goto yy434;
	if (yych <= '9') goto yy435;
	goto yy56;
yy433:
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy439;
	goto yy430;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych == '0') goto yy439;
	goto yy430;
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy430;
yy436:
	YYDEBUG(436, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy437:
	YYDEBUG(437, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(438, *YYCURSOR);
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy437;
	goto yy430;
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy430;
		} else {
			if (yych <= ' ') goto yy440;
			if (yych == '.') goto yy436;
			goto yy430;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy442;
			if (yych == 'P') goto yy442;
			goto yy430;
		} else {
			if (yych <= 'a') goto yy442;
			if (yych == 'p') goto yy442;
			goto yy430;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(441, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy440;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy440;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy442;
			if (yych != 'p') goto yy56;
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy444;
		if (yych == 'm') goto yy444;
		goto yy56;
	}
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy444;
	if (yych != 'm') goto yy56;
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy427;
		if (yych == '\t') goto yy427;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy427;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy427;
		if (yych <= 0x08) goto yy56;
		goto yy427;
	} else {
		if (yych == ' ') goto yy427;
		goto yy56;
	}
yy446:
	YYDEBUG(446, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy447;
			if (yych <= 0x1F) goto yy430;
		} else {
			if (yych == '.') goto yy432;
			if (yych <= '9') goto yy430;
			goto yy450;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy449;
			if (yych <= 'O') goto yy430;
			goto yy449;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy449;
			} else {
				if (yych == 'p') goto yy449;
				goto yy430;
			}
		}
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(448, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy447;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy447;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy449;
			if (yych != 'p') goto yy56;
		}
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy466;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy467;
		if (yych == 'm') goto yy467;
		goto yy56;
	}
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy451;
	if (yych <= '6') goto yy452;
	if (yych <= '9') goto yy435;
	goto yy56;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy453;
	goto yy430;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych != '0') goto yy430;
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy440;
			if (yych <= 0x1F) goto yy430;
			goto yy440;
		} else {
			if (yych == '.') goto yy454;
			if (yych <= '9') goto yy430;
			goto yy455;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy442;
			if (yych <= 'O') goto yy430;
			goto yy442;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy442;
			} else {
				if (yych == 'p') goto yy442;
				goto yy430;
			}
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy464;
	goto yy56;
yy455:
	YYDEBUG(455, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy456:
	YYDEBUG(456, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(457, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy456;
		} else {
			if (yych != 'A') goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy458;
			if (yych <= '`') goto yy56;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy460;
		if (yych == 'm') goto yy460;
		goto yy56;
	}
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy460;
	if (yych != 'm') goto yy56;
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy462;
		if (yych == '\t') goto yy462;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy462;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy462;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(463, *YYCURSOR);
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(465, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy430;
			goto yy464;
		} else {
			if (yych == 'A') goto yy458;
			goto yy430;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy458;
			if (yych <= '`') goto yy430;
			goto yy458;
		} else {
			if (yych == 'p') goto yy458;
			goto yy430;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy467;
	if (yych != 'm') goto yy56;
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy427;
		if (yych == '\t') goto yy427;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy427;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy427;
		if (yych <= 0x08) goto yy56;
		goto yy427;
	} else {
		if (yych == ' ') goto yy427;
		goto yy56;
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy470;
	if (yych != 'v') goto yy56;
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy475;
			if (yych == 'e') goto yy475;
			goto yy415;
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy472:
	YYDEBUG(472, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy471;
		if (yych <= 0x1F) goto yy56;
		goto yy471;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy471;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy474;
	if (yych <= '9') goto yy480;
yy474:
	YYDEBUG(474, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy476;
	if (yych != 'm') goto yy56;
yy476:
	YYDEBUG(476, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy477;
	if (yych != 'b') goto yy56;
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy478;
	if (yych != 'e') goto yy56;
yy478:
	YYDEBUG(478, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych != 'r') goto yy56;
yy479:
	YYDEBUG(479, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy471;
		if (yych <= 0x1F) goto yy415;
		goto yy471;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy415;
			goto yy471;
		} else {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych >= ':') goto yy474;
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych >= ':') goto yy474;
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy474;
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy484;
	if (yych != 't') goto yy56;
yy484:
	YYDEBUG(484, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'O') goto yy485;
			if (yych != 'o') goto yy415;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy486;
	if (yych != 'b') goto yy56;
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy487;
	if (yych != 'e') goto yy56;
yy487:
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych == 'r') goto yy479;
	goto yy56;
yy488:
	YYDEBUG(488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy492;
	if (yych == 'g') goto yy492;
	goto yy56;
yy489:
	YYDEBUG(489, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy490;
	if (yych != 'r') goto yy56;
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'I') goto yy491;
			if (yych != 'i') goto yy415;
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy479;
	if (yych == 'l') goto yy479;
	goto yy56;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'U') goto yy493;
			if (yych != 'u') goto yy415;
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy494;
	if (yych != 's') goto yy56;
yy494:
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy479;
	if (yych == 't') goto yy479;
	goto yy56;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy502;
		if (yych <= 'M') goto yy56;
		goto yy501;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy502;
		} else {
			if (yych == 'n') goto yy501;
			goto yy56;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy497;
	if (yych != 'n') goto yy56;
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'U') goto yy498;
			if (yych != 'u') goto yy415;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy499;
	if (yych != 'a') goto yy56;
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy500;
	if (yych != 'r') goto yy56;
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy479;
	if (yych == 'y') goto yy479;
	goto yy56;
yy501:
	YYDEBUG(501, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy479;
			if (yych == 'e') goto yy479;
			goto yy415;
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'Y') goto yy479;
			if (yych == 'y') goto yy479;
			goto yy415;
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy479;
			goto yy415;
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych != 'I') goto yy415;
		}
	}
	YYDEBUG(505, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy479;
			goto yy415;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy479;
			goto yy415;
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy540;
	} else {
		if (yych <= '/') goto yy430;
		if (yych <= '9') goto yy554;
		if (yych <= ':') goto yy432;
		goto yy430;
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		if (yych <= '.') goto yy540;
		goto yy430;
	} else {
		if (yych <= '2') goto yy554;
		if (yych <= '9') goto yy553;
		if (yych <= ':') goto yy432;
		goto yy430;
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy540;
	} else {
		if (yych <= '/') goto yy430;
		if (yych <= '9') goto yy553;
		if (yych <= ':') goto yy432;
		goto yy430;
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy540;
	} else {
		if (yych == ':') goto yy432;
		goto yy430;
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy534;
	if (yych == 'e') goto yy534;
	goto yy56;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy531;
	if (yych == 'a') goto yy531;
	goto yy56;
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy489;
		if (yych <= 'T') goto yy56;
		goto yy488;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy489;
		} else {
			if (yych == 'u') goto yy488;
			goto yy56;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy524;
	if (yych == 'e') goto yy524;
	goto yy56;
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy518;
	if (yych == 'e') goto yy518;
	goto yy56;
yy516:
	YYDEBUG(516, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy517:
	YYDEBUG(517, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy516;
	case 'A':
	case 'a':	goto yy513;
	case 'D':
	case 'd':	goto yy515;
	case 'F':
	case 'f':	goto yy511;
	case 'I':	goto yy414;
	case 'J':
	case 'j':	goto yy418;
	case 'M':
	case 'm':	goto yy512;
	case 'N':
	case 'n':	goto yy421;
	case 'O':
	case 'o':	goto yy420;
	case 'S':
	case 's':	goto yy514;
	case 'V':	goto yy416;
	case 'X':	goto yy417;
	default:	goto yy56;
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy519;
	if (yych != 'c') goto yy56;
yy519:
	YYDEBUG(519, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy520;
			if (yych != 'e') goto yy415;
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy521;
	if (yych != 'm') goto yy56;
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy522;
	if (yych != 'b') goto yy56;
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy523;
	if (yych != 'e') goto yy56;
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych == 'r') goto yy479;
	goto yy56;
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy525;
	if (yych != 'p') goto yy56;
yy525:
	YYDEBUG(525, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'T') goto yy526;
			if (yych != 't') goto yy415;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy527;
			if (yych != 'e') goto yy415;
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy528;
	if (yych != 'm') goto yy56;
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy529;
	if (yych != 'b') goto yy56;
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy530;
	if (yych != 'e') goto yy56;
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych == 'r') goto yy479;
	goto yy56;
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy532;
		if (yych <= 'X') goto yy56;
		goto yy479;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy479;
			goto yy56;
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'C') goto yy533;
			if (yych != 'c') goto yy415;
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy479;
	if (yych == 'h') goto yy479;
	goto yy56;
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy535;
	if (yych != 'b') goto yy56;
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'R') goto yy536;
			if (yych != 'r') goto yy415;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy537;
	if (yych != 'u') goto yy56;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy538;
	if (yych != 'a') goto yy56;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych != 'r') goto yy56;
yy539:
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy479;
	if (yych == 'y') goto yy479;
	goto yy56;
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy547;
	if (yych <= '6') goto yy548;
	if (yych <= '9') goto yy549;
	goto yy56;
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(545, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(546, *YYCURSOR);
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy552;
	goto yy430;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy436;
		goto yy430;
	} else {
		if (yych <= '0') goto yy552;
		if (yych <= '9') goto yy550;
		goto yy430;
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych >= ':') goto yy430;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy551;
	if (yych <= '9') goto yy544;
yy551:
	YYDEBUG(551, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy440;
			if (yych <= 0x1F) goto yy430;
			goto yy440;
		} else {
			if (yych == '.') goto yy436;
			if (yych <= '/') goto yy430;
			goto yy544;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy442;
			if (yych <= 'O') goto yy430;
			goto yy442;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy442;
			} else {
				if (yych == 'p') goto yy442;
				goto yy430;
			}
		}
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy447;
			if (yych <= 0x1F) goto yy430;
			goto yy447;
		} else {
			if (yych == '.') goto yy432;
			if (yych <= '9') goto yy430;
			goto yy432;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy449;
			if (yych <= 'O') goto yy430;
			goto yy449;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy449;
			} else {
				if (yych == 'p') goto yy449;
				goto yy430;
			}
		}
	}
yy554:
	YYDEBUG(554, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy447;
			if (yych <= 0x1F) goto yy430;
			goto yy447;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy430;
				goto yy541;
			} else {
				if (yych <= '.') goto yy540;
				if (yych <= '9') goto yy430;
				goto yy432;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy449;
			if (yych <= 'O') goto yy430;
			goto yy449;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy449;
			} else {
				if (yych == 'p') goto yy449;
				goto yy430;
			}
		}
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy594;
		goto yy541;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy557;
		goto yy56;
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy594;
		goto yy541;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy594;
	if (yych <= '.') goto yy541;
	goto yy56;
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy590;
		if (yych <= 'T') goto yy56;
		goto yy589;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy590;
		} else {
			if (yych == 'u') goto yy589;
			goto yy56;
		}
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy587;
	if (yych == 'e') goto yy587;
	goto yy56;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy584;
	if (yych == 'a') goto yy584;
	goto yy56;
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy581;
		if (yych <= 'T') goto yy56;
		goto yy580;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy581;
		} else {
			if (yych == 'u') goto yy580;
			goto yy56;
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy577;
	if (yych == 'e') goto yy577;
	goto yy56;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy575;
	if (yych == 'c') goto yy575;
	goto yy56;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy573;
	if (yych == 'o') goto yy573;
	goto yy56;
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy566;
	if (yych != 'e') goto yy56;
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy567;
	if (yych != 'c') goto yy56;
yy567:
	YYDEBUG(567, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych >= '.') goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy520;
			if (yych == 'e') goto yy520;
			goto yy415;
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy472;
	if (yych <= '0') goto yy569;
	if (yych <= '2') goto yy570;
	if (yych <= '3') goto yy571;
	goto yy472;
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych <= '9') goto yy572;
	goto yy474;
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych <= '9') goto yy572;
	goto yy474;
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych <= '1') goto yy572;
	if (yych <= '9') goto yy480;
	goto yy474;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych <= '9') goto yy481;
	goto yy474;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy574;
	if (yych != 'v') goto yy56;
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy475;
			if (yych == 'e') goto yy475;
			goto yy415;
		}
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy576;
	if (yych != 't') goto yy56;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'O') goto yy485;
			if (yych == 'o') goto yy485;
			goto yy415;
		}
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy578;
	if (yych != 'p') goto yy56;
yy578:
	YYDEBUG(578, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'T') goto yy579;
			if (yych != 't') goto yy415;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy527;
			if (yych == 'e') goto yy527;
			goto yy415;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy583;
	if (yych == 'g') goto yy583;
	goto yy56;
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy582;
	if (yych != 'r') goto yy56;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'I') goto yy491;
			if (yych == 'i') goto yy491;
			goto yy415;
		}
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'U') goto yy493;
			if (yych == 'u') goto yy493;
			goto yy415;
		}
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy585;
		if (yych <= 'X') goto yy56;
		goto yy586;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy586;
			goto yy56;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'C') goto yy533;
			if (yych == 'c') goto yy533;
			goto yy415;
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy568;
			goto yy471;
		} else {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy588;
	if (yych != 'b') goto yy56;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'R') goto yy536;
			if (yych == 'r') goto yy536;
			goto yy415;
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy593;
		if (yych <= 'M') goto yy56;
		goto yy592;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy593;
		} else {
			if (yych == 'n') goto yy592;
			goto yy56;
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy591;
	if (yych != 'n') goto yy56;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'U') goto yy498;
			if (yych == 'u') goto yy498;
			goto yy415;
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy479;
			if (yych == 'e') goto yy479;
			goto yy415;
		}
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'Y') goto yy479;
			if (yych == 'y') goto yy479;
			goto yy415;
		}
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy595;
	if (yych <= '3') goto yy597;
	if (yych <= '9') goto yy598;
	goto yy56;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy604;
		if (yych >= 'n') goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy596;
			goto yy604;
		} else {
			if (yych <= '9') goto yy543;
			if (yych <= 'm') goto yy596;
			goto yy600;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy543;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy603;
	goto yy56;
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy603;
	goto yy56;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy603;
	goto yy56;
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy56;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy596;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy544;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy662;
		} else {
			if (yych <= '9') goto yy608;
			if (yych >= 'n') goto yy659;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy660;
		} else {
			if (yych <= 's') goto yy658;
			if (yych <= 't') goto yy661;
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy606;
			goto yy662;
		} else {
			if (yych <= '1') goto yy608;
			if (yych <= 'm') goto yy606;
			goto yy659;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy606;
			goto yy660;
		} else {
			if (yych <= 's') goto yy658;
			if (yych <= 't') goto yy661;
			goto yy606;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy662;
		if (yych <= 'm') goto yy606;
		goto yy659;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy606;
			goto yy660;
		} else {
			if (yych <= 's') goto yy658;
			if (yych <= 't') goto yy661;
			goto yy606;
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy657;
		if (yych <= 'T') goto yy56;
		goto yy656;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy657;
		} else {
			if (yych == 'u') goto yy656;
			goto yy56;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy655;
	if (yych == 'e') goto yy655;
	goto yy56;
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy654;
	if (yych == 'a') goto yy654;
	goto yy56;
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy653;
		if (yych <= 'T') goto yy56;
		goto yy652;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy653;
		} else {
			if (yych == 'u') goto yy652;
			goto yy56;
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy650;
	if (yych == 'e') goto yy650;
	goto yy56;
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy649;
	if (yych == 'c') goto yy649;
	goto yy56;
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy648;
	if (yych == 'o') goto yy648;
	goto yy56;
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy617;
	if (yych != 'e') goto yy56;
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy618;
	if (yych != 'c') goto yy56;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy625;
	if (yych <= '2') goto yy626;
	goto yy56;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy627;
	goto yy56;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy632;
	if (yych <= '6') goto yy633;
	goto yy56;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy634;
	goto yy56;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy635;
	if (yych != ' ') goto yy56;
yy635:
	YYDEBUG(635, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(636, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy635;
		} else {
			if (yych == ' ') goto yy635;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy638;
		} else {
			if (yych != 'G') goto yy56;
		}
	}
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy646;
	goto yy56;
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy639;
	if (yych <= '2') goto yy641;
	if (yych <= '9') goto yy642;
	goto yy56;
yy639:
	YYDEBUG(639, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy640;
	if (yych <= '9') goto yy642;
	if (yych <= ':') goto yy643;
yy640:
	YYDEBUG(640, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy640;
		if (yych >= '5') goto yy644;
	} else {
		if (yych <= '9') goto yy645;
		if (yych <= ':') goto yy643;
		goto yy640;
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy640;
	if (yych <= '5') goto yy644;
	if (yych <= '9') goto yy645;
	if (yych >= ';') goto yy640;
yy643:
	YYDEBUG(643, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy640;
	if (yych <= '5') goto yy644;
	if (yych <= '9') goto yy645;
	goto yy640;
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy640;
	if (yych >= ':') goto yy640;
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy640;
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy638;
	if (yych == '-') goto yy638;
	goto yy56;
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy618;
	if (yych == 'v') goto yy618;
	goto yy56;
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy618;
	if (yych == 't') goto yy618;
	goto yy56;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy651;
	if (yych != 'p') goto yy56;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy619;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy618;
		if (yych == 't') goto yy618;
		goto yy56;
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy618;
	if (yych == 'g') goto yy618;
	goto yy56;
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy618;
	if (yych == 'r') goto yy618;
	goto yy56;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy618;
		if (yych <= 'X') goto yy56;
		goto yy618;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy618;
		} else {
			if (yych == 'y') goto yy618;
			goto yy56;
		}
	}
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy618;
	if (yych == 'b') goto yy618;
	goto yy56;
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy618;
		if (yych <= 'M') goto yy56;
		goto yy618;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy618;
		} else {
			if (yych == 'n') goto yy618;
			goto yy56;
		}
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy618;
	if (yych == 'n') goto yy618;
	goto yy56;
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy667;
	goto yy56;
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy667;
	goto yy56;
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy667;
	goto yy56;
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy667;
	goto yy56;
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy606;
	if (yych >= ':') goto yy606;
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy606;
	if (yych >= ':') goto yy606;
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy606;
	if (yych >= ':') goto yy606;
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy606;
yy667:
	YYDEBUG(667, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy662;
	goto yy606;
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy670;
		goto yy517;
	} else {
		if (yych <= '-') goto yy671;
		if (yych <= '.') goto yy670;
		if (yych >= '0') goto yy517;
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy612;
	case 'D':
	case 'd':	goto yy616;
	case 'F':
	case 'f':	goto yy610;
	case 'J':
	case 'j':	goto yy609;
	case 'M':
	case 'm':	goto yy611;
	case 'N':
	case 'n':	goto yy615;
	case 'O':
	case 'o':	goto yy614;
	case 'S':
	case 's':	goto yy613;
	default:	goto yy56;
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy517;
	if (yych <= '0') goto yy675;
	if (yych <= '1') goto yy676;
	if (yych <= '9') goto yy677;
	goto yy517;
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy517;
	if (yych <= '0') goto yy672;
	if (yych <= '1') goto yy673;
	if (yych <= '9') goto yy674;
	goto yy517;
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy541;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy674;
	goto yy56;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy541;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy541;
	goto yy56;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy541;
		goto yy678;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy677;
		goto yy56;
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy541;
		goto yy678;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy541;
	if (yych >= '/') goto yy56;
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy550;
	goto yy56;
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy724;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy722;
	goto yy60;
yy681:
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy690;
	case '1':	goto yy691;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy692;
	case 'A':
	case 'a':	goto yy685;
	case 'D':
	case 'd':	goto yy689;
	case 'F':
	case 'f':	goto yy683;
	case 'J':
	case 'j':	goto yy682;
	case 'M':
	case 'm':	goto yy684;
	case 'N':
	case 'n':	goto yy688;
	case 'O':
	case 'o':	goto yy687;
	case 'S':
	case 's':	goto yy686;
	default:	goto yy56;
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy721;
		if (yych <= 'T') goto yy56;
		goto yy720;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy721;
		} else {
			if (yych == 'u') goto yy720;
			goto yy56;
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy719;
	if (yych == 'e') goto yy719;
	goto yy56;
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy718;
	if (yych == 'a') goto yy718;
	goto yy56;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy717;
		if (yych <= 'T') goto yy56;
		goto yy716;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy717;
		} else {
			if (yych == 'u') goto yy716;
			goto yy56;
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy714;
	if (yych == 'e') goto yy714;
	goto yy56;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy713;
	if (yych == 'c') goto yy713;
	goto yy56;
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy712;
	if (yych == 'o') goto yy712;
	goto yy56;
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy704;
	if (yych == 'e') goto yy704;
	goto yy56;
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy693;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy697;
	goto yy56;
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy693;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy697;
	goto yy56;
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy694;
	if (yych <= '3') goto yy695;
	if (yych <= '9') goto yy696;
	goto yy56;
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy696;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '1') goto yy696;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy696:
	YYDEBUG(696, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy600;
		goto yy596;
	} else {
		if (yych <= 'r') goto yy601;
		if (yych <= 's') goto yy599;
		if (yych <= 't') goto yy602;
		goto yy596;
	}
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy700;
	} else {
		if (yych <= '3') goto yy701;
		if (yych <= '9') goto yy696;
		goto yy56;
	}
	YYDEBUG(699, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy702;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy702;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy701:
	YYDEBUG(701, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '1') goto yy702;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy600;
	} else {
		if (yych <= 'r') goto yy601;
		if (yych <= 's') goto yy599;
		if (yych <= 't') goto yy602;
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy705;
	if (yych != 'c') goto yy56;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy707;
	if (yych <= '2') goto yy708;
	if (yych <= '3') goto yy709;
	goto yy56;
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy710;
	goto yy56;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy710;
	goto yy56;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy710:
	YYDEBUG(710, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(711, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy705;
	if (yych == 'v') goto yy705;
	goto yy56;
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy705;
	if (yych == 't') goto yy705;
	goto yy56;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy715;
	if (yych != 'p') goto yy56;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy706;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy705;
		if (yych == 't') goto yy705;
		goto yy56;
	}
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy705;
	if (yych == 'g') goto yy705;
	goto yy56;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy705;
	if (yych == 'r') goto yy705;
	goto yy56;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy705;
		if (yych <= 'X') goto yy56;
		goto yy705;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy705;
		} else {
			if (yych == 'y') goto yy705;
			goto yy56;
		}
	}
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy705;
	if (yych == 'b') goto yy705;
	goto yy56;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy705;
		if (yych <= 'M') goto yy56;
		goto yy705;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy705;
		} else {
			if (yych == 'n') goto yy705;
			goto yy56;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy705;
	if (yych == 'n') goto yy705;
	goto yy56;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy730;
	case '-':	goto yy727;
	case '.':	goto yy731;
	case '/':	goto yy728;
	case '0':	goto yy744;
	case '1':	goto yy745;
	case '2':	goto yy747;
	case '3':	goto yy748;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy746;
	case 'W':	goto yy749;
	default:	goto yy723;
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy725;
	case '1':	goto yy726;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy692;
	case 'A':
	case 'a':	goto yy685;
	case 'D':
	case 'd':	goto yy689;
	case 'F':
	case 'f':	goto yy683;
	case 'J':
	case 'j':	goto yy682;
	case 'M':
	case 'm':	goto yy684;
	case 'N':
	case 'n':	goto yy688;
	case 'O':
	case 'o':	goto yy687;
	case 'S':
	case 's':	goto yy686;
	default:	goto yy56;
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy693;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy692;
	goto yy56;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy693;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy692;
	goto yy56;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy912;
	case '1':	goto yy914;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	case 'A':
	case 'a':	goto yy906;
	case 'D':
	case 'd':	goto yy910;
	case 'F':
	case 'f':	goto yy904;
	case 'J':
	case 'j':	goto yy903;
	case 'M':
	case 'm':	goto yy905;
	case 'N':
	case 'n':	goto yy909;
	case 'O':
	case 'o':	goto yy908;
	case 'S':
	case 's':	goto yy907;
	case 'W':	goto yy911;
	default:	goto yy878;
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy886;
	if (yych <= '1') goto yy887;
	if (yych <= '9') goto yy888;
	goto yy56;
yy729:
	YYDEBUG(729, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy730:
	YYDEBUG(730, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy729;
	case '-':
	case '.':	goto yy877;
	case 'A':
	case 'a':	goto yy739;
	case 'D':
	case 'd':	goto yy743;
	case 'F':
	case 'f':	goto yy737;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy732;
	case 'J':
	case 'j':	goto yy736;
	case 'M':
	case 'm':	goto yy738;
	case 'N':
	case 'n':	goto yy742;
	case 'O':
	case 'o':	goto yy741;
	case 'S':
	case 's':	goto yy740;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy734;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy735;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy878;
	if (yych <= '0') goto yy870;
	if (yych <= '2') goto yy871;
	if (yych <= '3') goto yy872;
	goto yy878;
yy732:
	YYDEBUG(732, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy869;
	} else {
		if (yych == 'W') goto yy733;
		if (yych <= 'X') goto yy823;
	}
yy733:
	YYDEBUG(733, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy867;
	goto yy733;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy866;
	goto yy733;
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy859;
		if (yych <= 'T') goto yy56;
		goto yy858;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy859;
		} else {
			if (yych == 'u') goto yy858;
			goto yy56;
		}
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy852;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy98;
			if (yych <= 'Q') goto yy56;
			goto yy97;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy852;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy98;
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy849;
			goto yy56;
		} else {
			if (yych <= 'I') goto yy117;
			if (yych <= 'N') goto yy56;
			goto yy116;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy849;
			goto yy56;
		} else {
			if (yych <= 'i') goto yy117;
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy843;
		if (yych <= 'T') goto yy56;
		goto yy842;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy843;
		} else {
			if (yych == 'u') goto yy842;
			goto yy56;
		}
	}
yy740:
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy835;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy835;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy830;
	if (yych == 'c') goto yy830;
	goto yy56;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy824;
	if (yych == 'o') goto yy824;
	goto yy56;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy113;
		if (yych <= 'D') goto yy56;
		goto yy817;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy113;
		} else {
			if (yych == 'e') goto yy817;
			goto yy56;
		}
	}
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy814;
	if (yych <= '9') goto yy815;
	goto yy60;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy783;
	if (yych <= '9') goto yy762;
	goto yy60;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy763;
	if (yych <= '1') goto yy764;
	goto yy56;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy762;
	goto yy60;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy758;
	if (yych <= '6') goto yy759;
	if (yych <= '9') goto yy54;
	goto yy60;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy750;
		if (yych <= '4') goto yy751;
		goto yy752;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy82;
		} else {
			if (yych == 'e') goto yy82;
			goto yy56;
		}
	}
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy753;
	goto yy56;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy753;
	goto yy56;
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '4') goto yy56;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy755;
	if (yych <= '/') goto yy754;
	if (yych <= '7') goto yy756;
yy754:
	YYDEBUG(754, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy756:
	YYDEBUG(756, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(757, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy760;
	goto yy60;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '6') goto yy760;
	if (yych <= '9') goto yy54;
	goto yy60;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'R') goto yy761;
				if (yych <= 'T') goto yy60;
				if (yych >= 'W') goto yy60;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych >= 'd') goto yy60;
			} else {
				if (yych == 'f') goto yy60;
				if (yych >= 'h') goto yy60;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych >= 's') goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy60;
				} else {
					if (yych == 'y') goto yy60;
				}
			}
		}
	}
yy761:
	YYDEBUG(761, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy760;
	goto yy60;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy765;
	goto yy56;
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy767;
	if (yych <= '2') goto yy768;
	if (yych <= '3') goto yy769;
	goto yy56;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy770;
	goto yy56;
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy770;
	goto yy56;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy772;
	if (yych <= '2') goto yy773;
	goto yy56;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy774;
	goto yy56;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy779;
	if (yych <= '6') goto yy780;
	goto yy56;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy781;
	goto yy56;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy781:
	YYDEBUG(781, *YYCURSOR);
	++YYCURSOR;
yy782:
	YYDEBUG(782, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych >= '1') goto yy785;
	} else {
		if (yych <= '3') goto yy786;
		if (yych <= '9') goto yy760;
		goto yy60;
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy761;
				goto yy60;
			} else {
				if (yych <= '/') goto yy761;
				if (yych <= '9') goto yy787;
				if (yych <= 'C') goto yy761;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy761;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy761;
					if (yych <= 'T') goto yy60;
					goto yy761;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy761;
				if (yych <= 'Y') goto yy60;
				goto yy761;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy761;
				} else {
					if (yych == 'g') goto yy761;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy761;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy761;
				}
			}
		}
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy761;
				goto yy60;
			} else {
				if (yych <= '/') goto yy761;
				if (yych <= '9') goto yy787;
				if (yych <= 'C') goto yy761;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy761;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy761;
					if (yych <= 'T') goto yy60;
					goto yy761;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy761;
				if (yych <= 'Y') goto yy60;
				goto yy761;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy761;
				} else {
					if (yych == 'g') goto yy761;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy761;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy761;
				}
			}
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy761;
				goto yy60;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy761;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy761;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy761;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy761;
					if (yych <= 'T') goto yy60;
					goto yy761;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy761;
				if (yych <= 'Y') goto yy60;
				goto yy761;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy761;
				} else {
					if (yych == 'g') goto yy761;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy761;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy761;
				}
			}
		}
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych >= 'F') goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych >= 'M') goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy61;
				} else {
					if (yych <= 'T') goto yy789;
					if (yych >= 'W') goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych >= 'd') goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy65;
				} else {
					if (yych == 'h') goto yy63;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy788;
				if (yych <= 's') goto yy61;
				goto yy790;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy67;
				} else {
					if (yych == 'y') goto yy66;
				}
			}
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy804;
			goto yy805;
		} else {
			if (yych <= '9') goto yy806;
			if (yych <= 'G') goto yy56;
			goto yy69;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy70;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy69;
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych >= '2') goto yy792;
		} else {
			if (yych <= '9') goto yy793;
			if (yych <= 'G') goto yy56;
			goto yy69;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy70;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy69;
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy798;
	if (yych <= '9') goto yy793;
	goto yy56;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy798;
	if (yych <= '5') goto yy794;
	goto yy56;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy796;
	if (yych <= '6') goto yy797;
	goto yy56;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy781;
	goto yy56;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy781;
	goto yy56;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy799;
	if (yych <= '9') goto yy795;
	goto yy56;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy800;
	if (yych <= '6') goto yy801;
	if (yych <= '9') goto yy795;
	goto yy56;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy802;
	if (yych <= '6') goto yy803;
	if (yych <= '9') goto yy781;
	goto yy56;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy802;
	if (yych <= '5') goto yy796;
	if (yych <= '6') goto yy797;
	goto yy56;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy781;
	goto yy782;
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy781;
	goto yy782;
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy813;
	if (yych <= '9') goto yy806;
	if (yych <= ':') goto yy807;
	goto yy56;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy813;
		goto yy794;
	} else {
		if (yych == ':') goto yy807;
		goto yy56;
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy794;
	if (yych != ':') goto yy56;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy811;
	if (yych <= '6') goto yy812;
	goto yy56;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy781;
	goto yy56;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy781;
	goto yy56;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy799;
	if (yych <= '9') goto yy795;
	if (yych <= ':') goto yy807;
	goto yy56;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy816;
		goto yy785;
	} else {
		if (yych <= '3') goto yy786;
		if (yych <= '9') goto yy760;
		goto yy60;
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy784;
		goto yy785;
	} else {
		if (yych <= '3') goto yy786;
		if (yych <= '9') goto yy760;
		goto yy60;
	}
yy816:
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy787;
	goto yy60;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy818;
	if (yych != 'c') goto yy56;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy819;
	if (yych != 'e') goto yy733;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy820;
	if (yych != 'm') goto yy56;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy821;
	if (yych != 'b') goto yy56;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy822;
	if (yych != 'e') goto yy56;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych != 'r') goto yy56;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy733;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy825;
	if (yych != 'v') goto yy56;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy826;
	if (yych != 'e') goto yy733;
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy827;
	if (yych != 'm') goto yy56;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy828;
	if (yych != 'b') goto yy56;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy829;
	if (yych != 'e') goto yy56;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych == 'r') goto yy823;
	goto yy56;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy831;
	if (yych != 't') goto yy56;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy832;
	if (yych != 'o') goto yy733;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy833;
	if (yych != 'b') goto yy56;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy834;
	if (yych != 'e') goto yy56;
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych == 'r') goto yy823;
	goto yy56;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy128;
		if (yych <= 'O') goto yy56;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy128;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy837;
	if (yych != 't') goto yy733;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy838;
	if (yych != 'e') goto yy733;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy839;
	if (yych != 'm') goto yy56;
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy840;
	if (yych != 'b') goto yy56;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy841;
	if (yych != 'e') goto yy56;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych == 'r') goto yy823;
	goto yy56;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy846;
	if (yych == 'g') goto yy846;
	goto yy56;
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy844;
	if (yych != 'r') goto yy56;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy845;
	if (yych != 'i') goto yy733;
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy823;
	if (yych == 'l') goto yy823;
	goto yy56;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy847;
	if (yych != 'u') goto yy733;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy848;
	if (yych != 's') goto yy56;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy823;
	if (yych == 't') goto yy823;
	goto yy56;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy850;
		if (yych <= 'X') goto yy56;
		goto yy823;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy823;
			goto yy56;
		}
	}
yy850:
	YYDEBUG(850, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy851;
	if (yych != 'c') goto yy733;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy823;
	if (yych == 'h') goto yy823;
	goto yy56;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy853;
	if (yych != 'b') goto yy56;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy854;
	if (yych != 'r') goto yy733;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy855;
	if (yych != 'u') goto yy56;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy856;
	if (yych != 'a') goto yy56;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy857;
	if (yych != 'r') goto yy56;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy823;
	if (yych == 'y') goto yy823;
	goto yy56;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy865;
		if (yych <= 'M') goto yy56;
		goto yy864;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy865;
		} else {
			if (yych == 'n') goto yy864;
			goto yy56;
		}
	}
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy860;
	if (yych != 'n') goto yy56;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy861;
	if (yych != 'u') goto yy733;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy862;
	if (yych != 'a') goto yy56;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy863;
	if (yych != 'r') goto yy56;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy823;
	if (yych == 'y') goto yy823;
	goto yy56;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy823;
	if (yych == 'e') goto yy823;
	goto yy733;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy823;
	if (yych == 'y') goto yy823;
	goto yy733;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy823;
	goto yy733;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy733;
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy823;
	goto yy733;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy823;
	goto yy733;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy885;
	if (yych <= '9') goto yy884;
	goto yy56;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy883;
	goto yy56;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy881;
	if (yych <= '6') goto yy880;
	goto yy56;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy852;
	if (yych == 'e') goto yy852;
	goto yy56;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy849;
	if (yych == 'a') goto yy849;
	goto yy56;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy879;
	if (yych == 'e') goto yy879;
	goto yy56;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy817;
	if (yych == 'e') goto yy817;
	goto yy56;
yy877:
	YYDEBUG(877, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy878:
	YYDEBUG(878, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy877;
	case 'A':
	case 'a':	goto yy739;
	case 'D':
	case 'd':	goto yy876;
	case 'F':
	case 'f':	goto yy873;
	case 'I':	goto yy732;
	case 'J':
	case 'j':	goto yy736;
	case 'M':
	case 'm':	goto yy874;
	case 'N':
	case 'n':	goto yy742;
	case 'O':
	case 'o':	goto yy741;
	case 'S':
	case 's':	goto yy875;
	case 'V':	goto yy734;
	case 'X':	goto yy735;
	default:	goto yy56;
	}
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy836;
	if (yych == 'p') goto yy836;
	goto yy56;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy882;
	goto yy56;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy761;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy882;
	goto yy56;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy882;
	goto yy56;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy882;
	goto yy56;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy889;
	if (yych <= '9') goto yy897;
	goto yy56;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy889;
	if (yych <= '2') goto yy897;
	goto yy56;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy890;
	if (yych <= '3') goto yy891;
	if (yych <= '9') goto yy892;
	goto yy56;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '9') goto yy892;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy891:
	YYDEBUG(891, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '1') goto yy892;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy892:
	YYDEBUG(892, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy894;
		goto yy394;
	} else {
		if (yych <= 'r') goto yy895;
		if (yych <= 's') goto yy893;
		if (yych <= 't') goto yy896;
		goto yy394;
	}
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy393;
	goto yy56;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy393;
	goto yy56;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy393;
	goto yy56;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy393;
	goto yy56;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy900;
	} else {
		if (yych <= '3') goto yy901;
		if (yych <= '9') goto yy892;
		goto yy56;
	}
	YYDEBUG(899, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '9') goto yy902;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy900:
	YYDEBUG(900, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '9') goto yy902;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy901:
	YYDEBUG(901, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '1') goto yy902;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy902:
	YYDEBUG(902, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy393;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy983;
		if (yych <= 'T') goto yy56;
		goto yy982;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy983;
		} else {
			if (yych == 'u') goto yy982;
			goto yy56;
		}
	}
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy980;
	if (yych == 'e') goto yy980;
	goto yy56;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy977;
	if (yych == 'a') goto yy977;
	goto yy56;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy974;
		if (yych <= 'T') goto yy56;
		goto yy973;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy974;
		} else {
			if (yych == 'u') goto yy973;
			goto yy56;
		}
	}
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy970;
	if (yych == 'e') goto yy970;
	goto yy56;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy968;
	if (yych == 'c') goto yy968;
	goto yy56;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy966;
	if (yych == 'o') goto yy966;
	goto yy56;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy964;
	if (yych == 'e') goto yy964;
	goto yy56;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy750;
	if (yych <= '4') goto yy751;
	if (yych <= '5') goto yy752;
	goto yy56;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy916;
	if (yych <= '/') goto yy913;
	if (yych <= '9') goto yy935;
yy913:
	YYDEBUG(913, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy914:
	YYDEBUG(914, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy916;
	if (yych <= '/') goto yy913;
	if (yych <= '2') goto yy935;
	goto yy913;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy913;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy917;
	if (yych <= '3') goto yy918;
	if (yych <= '9') goto yy919;
	goto yy56;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy596;
			goto yy919;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy918:
	YYDEBUG(918, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy596;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy919:
	YYDEBUG(919, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy924;
		if (yych <= 'm') goto yy596;
		goto yy921;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy934;
	goto yy56;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy934;
	goto yy56;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy934;
	goto yy56;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy934;
	goto yy56;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy925;
	if (yych <= '2') goto yy926;
	if (yych <= '9') goto yy927;
	goto yy56;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy927;
	if (yych <= ':') goto yy928;
	goto yy56;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy927;
	if (yych == ':') goto yy928;
	goto yy56;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy929;
	if (yych <= '9') goto yy930;
	goto yy56;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy930;
	if (yych <= ':') goto yy931;
	goto yy56;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy932;
	if (yych <= '6') goto yy933;
	if (yych <= '9') goto yy781;
	goto yy56;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy781;
	goto yy782;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy781;
	goto yy782;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy924;
	goto yy596;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy913;
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy938;
	} else {
		if (yych <= '3') goto yy939;
		if (yych <= '9') goto yy919;
		goto yy56;
	}
	YYDEBUG(937, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy596;
			goto yy940;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy938:
	YYDEBUG(938, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy596;
			goto yy940;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy596;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy940:
	YYDEBUG(940, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy941;
		if (yych <= 'm') goto yy394;
		goto yy921;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy394;
		}
	}
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy942;
	if (yych <= '2') goto yy943;
	if (yych <= '9') goto yy927;
	goto yy56;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy944;
	if (yych <= ':') goto yy928;
	goto yy56;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy944;
	if (yych == ':') goto yy928;
	goto yy56;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy946;
	if (yych <= '9') goto yy930;
	goto yy56;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy947;
	if (yych <= ':') goto yy931;
	goto yy56;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy949;
	if (yych <= '6') goto yy950;
	if (yych <= '9') goto yy781;
	goto yy56;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy951;
	goto yy782;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy782;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy782;
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yyaccept = 22;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(954, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy956;
		if (yych <= ',') goto yy782;
		goto yy956;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy782;
			goto yy953;
		} else {
			if (yych != 'G') goto yy782;
		}
	}
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy962;
	goto yy56;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy957;
	if (yych <= '2') goto yy958;
	if (yych <= '9') goto yy959;
	goto yy56;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy959;
	if (yych <= ':') goto yy960;
	goto yy782;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy782;
		if (yych >= '5') goto yy961;
	} else {
		if (yych <= '9') goto yy781;
		if (yych <= ':') goto yy960;
		goto yy782;
	}
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '5') goto yy961;
	if (yych <= '9') goto yy781;
	if (yych >= ';') goto yy782;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '5') goto yy961;
	if (yych <= '9') goto yy781;
	goto yy782;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy781;
	goto yy782;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy956;
	if (yych == '-') goto yy956;
	goto yy56;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy965;
	if (yych != 'c') goto yy56;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'E') goto yy819;
		if (yych == 'e') goto yy819;
		goto yy733;
	}
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy967;
	if (yych != 'v') goto yy56;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'E') goto yy826;
		if (yych == 'e') goto yy826;
		goto yy733;
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy969;
	if (yych != 't') goto yy56;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'O') goto yy832;
		if (yych == 'o') goto yy832;
		goto yy733;
	}
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy971;
	if (yych != 'p') goto yy56;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'T') goto yy972;
		if (yych != 't') goto yy733;
	}
yy972:
	YYDEBUG(972, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'E') goto yy838;
		if (yych == 'e') goto yy838;
		goto yy733;
	}
yy973:
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy976;
	if (yych == 'g') goto yy976;
	goto yy56;
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy975;
	if (yych != 'r') goto yy56;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'I') goto yy845;
		if (yych == 'i') goto yy845;
		goto yy733;
	}
yy976:
	YYDEBUG(976, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'U') goto yy847;
		if (yych == 'u') goto yy847;
		goto yy733;
	}
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy978;
		if (yych <= 'X') goto yy56;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy979;
			goto yy56;
		}
	}
yy978:
	YYDEBUG(978, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'C') goto yy851;
		if (yych == 'c') goto yy851;
		goto yy733;
	}
yy979:
	YYDEBUG(979, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy706;
	goto yy733;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy981;
	if (yych != 'b') goto yy56;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'R') goto yy854;
		if (yych == 'r') goto yy854;
		goto yy733;
	}
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy986;
		if (yych <= 'M') goto yy56;
		goto yy985;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy986;
		} else {
			if (yych == 'n') goto yy985;
			goto yy56;
		}
	}
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy984;
	if (yych != 'n') goto yy56;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'U') goto yy861;
		if (yych == 'u') goto yy861;
		goto yy733;
	}
yy985:
	YYDEBUG(985, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'E') goto yy823;
		if (yych == 'e') goto yy823;
		goto yy733;
	}
yy986:
	YYDEBUG(986, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'Y') goto yy823;
		if (yych == 'y') goto yy823;
		goto yy733;
	}
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy517;
			goto yy670;
		} else {
			if (yych <= ',') goto yy517;
			if (yych <= '-') goto yy671;
			goto yy670;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy669;
			if (yych <= 'T') goto yy517;
			goto yy77;
		} else {
			if (yych == 'u') goto yy77;
			goto yy517;
		}
	}
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy128;
		if (yych <= 'O') goto yy56;
		goto yy525;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy128;
		} else {
			if (yych == 'p') goto yy525;
			goto yy56;
		}
	}
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy991;
			goto yy993;
		} else {
			if (yych <= '-') goto yy990;
			if (yych <= '.') goto yy670;
			if (yych <= '/') goto yy669;
			goto yy680;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy409;
			goto yy993;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 's') goto yy403;
			if (yych <= 't') goto yy407;
			goto yy993;
		}
	}
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy994;
	case '1':	goto yy995;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy557;
	case 'A':
	case 'a':	goto yy561;
	case 'D':
	case 'd':	goto yy565;
	case 'F':
	case 'f':	goto yy559;
	case 'J':
	case 'j':	goto yy558;
	case 'M':
	case 'm':	goto yy560;
	case 'N':
	case 'n':	goto yy564;
	case 'O':
	case 'o':	goto yy563;
	case 'S':
	case 's':	goto yy562;
	default:	goto yy517;
	}
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy993;
	if (yych <= '0') goto yy675;
	if (yych <= '1') goto yy676;
	if (yych <= '9') goto yy677;
	goto yy993;
yy992:
	YYDEBUG(992, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy993:
	YYDEBUG(993, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy992;
	case '-':
	case '.':	goto yy516;
	case 'A':
	case 'a':	goto yy513;
	case 'D':
	case 'd':	goto yy405;
	case 'F':
	case 'f':	goto yy406;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy414;
	case 'J':
	case 'j':	goto yy418;
	case 'M':
	case 'm':	goto yy404;
	case 'N':
	case 'n':	goto yy421;
	case 'O':
	case 'o':	goto yy420;
	case 'S':
	case 's':	goto yy402;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy416;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy417;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy594;
		goto yy541;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy996;
		goto yy56;
	}
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy594;
		goto yy541;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy997;
	if (yych <= '.') goto yy541;
	goto yy56;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy999;
	} else {
		if (yych <= '3') goto yy1000;
		if (yych <= '9') goto yy598;
		goto yy56;
	}
	YYDEBUG(998, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy1001;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy999:
	YYDEBUG(999, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy1001;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy596;
		} else {
			if (yych <= '9') goto yy543;
			if (yych <= 'm') goto yy596;
			goto yy600;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy703;
		if (yych <= '9') goto yy544;
		if (yych <= 'm') goto yy703;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy703;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy703;
		}
	}
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy991;
			if (yych <= ',') goto yy993;
			goto yy990;
		} else {
			if (yych <= '.') goto yy1003;
			if (yych <= '/') goto yy669;
			if (yych <= '5') goto yy1005;
			goto yy680;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1004;
			if (yych == 'n') goto yy409;
			goto yy993;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 's') goto yy403;
			if (yych <= 't') goto yy407;
			goto yy993;
		}
	}
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy517;
		if (yych <= '0') goto yy1027;
		goto yy1028;
	} else {
		if (yych <= '5') goto yy1029;
		if (yych <= '9') goto yy1030;
		goto yy517;
	}
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1022;
	if (yych <= '9') goto yy1023;
	goto yy56;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy724;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
	YYDEBUG(1006, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy730;
	case '-':	goto yy727;
	case '.':	goto yy731;
	case '/':	goto yy728;
	case '0':	goto yy1008;
	case '1':	goto yy1009;
	case '2':	goto yy1010;
	case '3':	goto yy1011;
	case '4':
	case '5':	goto yy1012;
	case '6':	goto yy1013;
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy746;
	case 'W':	goto yy749;
	default:	goto yy1007;
	}
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1020;
	if (yych <= '9') goto yy1021;
	goto yy60;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy1019;
	if (yych <= '9') goto yy1018;
	goto yy60;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1018;
	goto yy60;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy1016;
	if (yych <= '6') goto yy1017;
	if (yych <= '9') goto yy1014;
	goto yy60;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1014;
	goto yy60;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1014;
	if (yych <= '9') goto yy54;
	goto yy60;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'R') goto yy1015;
				if (yych <= 'T') goto yy60;
				if (yych >= 'W') goto yy60;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych >= 'd') goto yy60;
			} else {
				if (yych == 'f') goto yy60;
				if (yych >= 'h') goto yy60;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych >= 's') goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy60;
				} else {
					if (yych == 'y') goto yy60;
				}
			}
		}
	}
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '/') goto yy1015;
				if (yych <= '9') goto yy760;
				if (yych <= 'C') goto yy1015;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1015;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1015;
					if (yych <= 'T') goto yy60;
					goto yy1015;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1015;
				if (yych <= 'Y') goto yy60;
				goto yy1015;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1015;
				} else {
					if (yych == 'g') goto yy1015;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1015;
					goto yy760;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy1015;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1015;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1015;
					if (yych <= 'T') goto yy60;
					goto yy1015;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1015;
				if (yych <= 'Y') goto yy60;
				goto yy1015;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1015;
				} else {
					if (yych == 'g') goto yy1015;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '/') goto yy1015;
				if (yych <= '9') goto yy760;
				if (yych <= 'C') goto yy1015;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1015;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1015;
					if (yych <= 'T') goto yy60;
					goto yy1015;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1015;
				if (yych <= 'Y') goto yy60;
				goto yy1015;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1015;
				} else {
					if (yych == 'g') goto yy1015;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1015;
					goto yy784;
				} else {
					if (yych <= '2') goto yy785;
					if (yych <= '3') goto yy786;
					goto yy760;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1015;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1015;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1015;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1015;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1015;
					goto yy816;
				} else {
					if (yych <= '2') goto yy785;
					if (yych <= '3') goto yy786;
					goto yy760;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1015;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1015;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1015;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1015;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1015;
					goto yy784;
				} else {
					if (yych <= '2') goto yy785;
					if (yych <= '3') goto yy786;
					goto yy760;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1015;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1015;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1015;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1015;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1024;
		goto yy430;
	} else {
		if (yych <= '9') goto yy1023;
		if (yych <= ':') goto yy1024;
		goto yy430;
	}
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1024;
	if (yych != ':') goto yy430;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1025;
	if (yych <= '6') goto yy1026;
	if (yych <= '9') goto yy435;
	goto yy56;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy435;
	goto yy430;
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych == '0') goto yy435;
	goto yy430;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy1031;
	} else {
		if (yych <= '/') goto yy430;
		if (yych <= '9') goto yy1030;
		if (yych <= ':') goto yy1024;
		goto yy430;
	}
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		if (yych <= '.') goto yy1031;
		goto yy430;
	} else {
		if (yych <= '2') goto yy1030;
		if (yych <= '9') goto yy1023;
		if (yych <= ':') goto yy1024;
		goto yy430;
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy1031;
	} else {
		if (yych <= '/') goto yy430;
		if (yych <= '9') goto yy1023;
		if (yych <= ':') goto yy1024;
		goto yy430;
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
	} else {
		if (yych == ':') goto yy1024;
		goto yy430;
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1032;
	if (yych <= '6') goto yy1033;
	if (yych <= '9') goto yy549;
	goto yy56;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy1034;
	goto yy430;
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy436;
		goto yy430;
	} else {
		if (yych <= '0') goto yy1034;
		if (yych <= '9') goto yy550;
		goto yy430;
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy544;
	goto yy430;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy399;
			if (yych <= ',') goto yy401;
			goto yy990;
		} else {
			if (yych <= '.') goto yy413;
			if (yych <= '/') goto yy411;
			if (yych <= '5') goto yy1005;
			goto yy680;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy422;
			if (yych == 'n') goto yy409;
			goto yy401;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 's') goto yy403;
			if (yych <= 't') goto yy407;
			goto yy401;
		}
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy991;
			if (yych <= ',') goto yy993;
			goto yy990;
		} else {
			if (yych <= '.') goto yy1003;
			if (yych <= '/') goto yy411;
			if (yych <= '5') goto yy1005;
			goto yy680;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1004;
			if (yych == 'n') goto yy409;
			goto yy993;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 's') goto yy403;
			if (yych <= 't') goto yy407;
			goto yy993;
		}
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1038;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy142;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'v') goto yy1039;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy143;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'i') goto yy1040;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy144;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'o') goto yy1041;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1042;
		if (yych != 'u') goto yy3;
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1043;
	if (yych != 's') goto yy56;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1044;
	if (yych != ' ') goto yy56;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1044;
				if (yych <= 0x1F) goto yy56;
				goto yy1044;
			} else {
				if (yych == 'D') goto yy1049;
				if (yych <= 'E') goto yy56;
				goto yy1050;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1048;
				if (yych <= 'L') goto yy56;
				goto yy1047;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
				} else {
					if (yych <= 'T') goto yy1053;
					if (yych <= 'V') goto yy56;
					goto yy1052;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1051;
				if (yych <= 'c') goto yy56;
				goto yy1049;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy1050;
				} else {
					if (yych == 'h') goto yy1048;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1047;
				if (yych <= 'r') goto yy56;
				if (yych >= 't') goto yy1053;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
					goto yy1052;
				} else {
					if (yych == 'y') goto yy1051;
					goto yy56;
				}
			}
		}
	}
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1118;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1119;
			if (yych <= 'T') goto yy56;
			goto yy1117;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1118;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1119;
			if (yych == 'u') goto yy1117;
			goto yy56;
		}
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy1109;
		if (yych <= 'N') goto yy56;
		goto yy1108;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy56;
			goto yy1109;
		} else {
			if (yych == 'o') goto yy1108;
			goto yy56;
		}
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1106;
	if (yych == 'o') goto yy1106;
	goto yy56;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1105;
	if (yych == 'a') goto yy1105;
	goto yy56;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1090;
		if (yych <= 'Q') goto yy56;
		goto yy1089;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy1090;
		} else {
			if (yych == 'r') goto yy1089;
			goto yy56;
		}
	}
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1086;
	if (yych == 'e') goto yy1086;
	goto yy56;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1072;
	if (yych == 'e') goto yy1072;
	goto yy56;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1054;
		if (yych <= 'T') goto yy56;
		goto yy1055;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy1055;
			goto yy56;
		}
	}
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1067;
	if (yych == 'u') goto yy1067;
	goto yy56;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1056;
	if (yych != 'e') goto yy56;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych >= ' ') goto yy1058;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1060;
		} else {
			if (yych == 's') goto yy1060;
		}
	}
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1059, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy56;
		goto yy1058;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1064;
		} else {
			if (yych == 'o') goto yy1064;
			goto yy56;
		}
	}
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1061;
	if (yych != 'd') goto yy56;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1062;
	if (yych != 'a') goto yy56;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych != 'y') goto yy56;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1058;
	if (yych == ' ') goto yy1058;
	goto yy1057;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1065;
	if (yych != 'f') goto yy56;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1066, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1057;
		} else {
			if (yych != 'r') goto yy1057;
		}
	}
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1069;
	if (yych != 's') goto yy56;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1070;
	if (yych != 'd') goto yy56;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1071;
	if (yych != 'a') goto yy56;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1074;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1074;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1080;
	if (yych == 'k') goto yy1080;
	goto yy56;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1057;
		} else {
			if (yych != 'n') goto yy1057;
		}
	}
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1076;
	if (yych != 'e') goto yy56;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1077;
	if (yych != 's') goto yy56;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1078;
	if (yych != 'd') goto yy56;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1079;
	if (yych != 'a') goto yy56;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1083;
		if (yych >= 'S') goto yy1082;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1083;
		} else {
			if (yych == 's') goto yy1082;
		}
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1057;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1084;
	if (yych != 'a') goto yy56;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1085;
	if (yych != 'y') goto yy56;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1082;
	if (yych == 's') goto yy1082;
	goto yy1057;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1087;
	if (yych != 'a') goto yy56;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1088;
	if (yych != 'r') goto yy56;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1082;
	if (yych == 's') goto yy1082;
	goto yy1057;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1102;
	if (yych == 'i') goto yy1102;
	goto yy56;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1091;
	if (yych != 'r') goto yy56;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1092;
	if (yych != 't') goto yy56;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1094;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1094;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1099;
	if (yych == 'i') goto yy1099;
	goto yy56;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1095;
	if (yych != 'n') goto yy56;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1096;
	if (yych != 'i') goto yy56;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1097;
	if (yych != 'g') goto yy56;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1098;
	if (yych != 'h') goto yy56;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1088;
	if (yych == 't') goto yy1088;
	goto yy56;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1100;
	if (yych != 'g') goto yy56;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1101;
	if (yych != 'h') goto yy56;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1088;
	if (yych == 't') goto yy1088;
	goto yy56;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1057;
		} else {
			if (yych != 'd') goto yy1057;
		}
	}
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1104;
	if (yych != 'a') goto yy56;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1088;
	if (yych == 'y') goto yy1088;
	goto yy56;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1107;
	if (yych != 'u') goto yy56;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1088;
	if (yych == 'r') goto yy1088;
	goto yy56;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1113;
	if (yych == 'n') goto yy1113;
	goto yy56;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1110;
	if (yych != 'n') goto yy56;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1082;
		if (yych <= 'T') goto yy1057;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1057;
			goto yy1082;
		} else {
			if (yych != 'u') goto yy1057;
		}
	}
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1112;
	if (yych != 't') goto yy56;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1088;
	if (yych == 'e') goto yy1088;
	goto yy56;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1058;
			goto yy1057;
		} else {
			if (yych <= ' ') goto yy1058;
			if (yych <= 'C') goto yy1057;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1115;
			goto yy1057;
		} else {
			if (yych <= 'd') goto yy1114;
			if (yych == 't') goto yy1115;
			goto yy1057;
		}
	}
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1116;
	if (yych == 'a') goto yy1116;
	goto yy56;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1088;
	if (yych == 'h') goto yy1088;
	goto yy56;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1128;
	if (yych == 'n') goto yy1128;
	goto yy56;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1123;
	if (yych == 't') goto yy1123;
	goto yy56;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1120;
	if (yych != 'c') goto yy56;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1121;
		if (yych <= 'R') goto yy1057;
		goto yy1082;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1057;
		} else {
			if (yych == 's') goto yy1082;
			goto yy1057;
		}
	}
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1122;
	if (yych != 'n') goto yy56;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1088;
	if (yych == 'd') goto yy1088;
	goto yy56;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1057;
		} else {
			if (yych != 'u') goto yy1057;
		}
	}
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1125;
	if (yych != 'r') goto yy56;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1126;
	if (yych != 'd') goto yy56;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1127;
	if (yych != 'a') goto yy56;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1057;
		} else {
			if (yych != 'd') goto yy1057;
		}
	}
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1130;
	if (yych != 'a') goto yy56;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1038;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1132;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1039;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'v') goto yy1133;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1040;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy1134;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1041;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'o') goto yy1135;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1042;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1136;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1043;
	if (yych != 's') goto yy154;
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1044;
		} else {
			if (yych == ' ') goto yy1044;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy56;
		}
	}
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy1152;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy1152;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1140;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy142;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'v') goto yy1141;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1142;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy144;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'n') goto yy1143;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1144;
		if (yych != 't') goto yy3;
	}
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1145;
	if (yych != 'h') goto yy56;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1146;
	if (yych != ' ') goto yy56;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1146;
				if (yych <= 0x1F) goto yy56;
				goto yy1146;
			} else {
				if (yych == 'D') goto yy1049;
				if (yych <= 'E') goto yy56;
				goto yy1050;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1048;
				if (yych <= 'L') goto yy56;
				goto yy1047;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
					goto yy1046;
				} else {
					if (yych <= 'T') goto yy1053;
					if (yych <= 'V') goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1051;
				if (yych <= 'c') goto yy56;
				goto yy1049;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy1050;
				} else {
					if (yych == 'h') goto yy1048;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1047;
				if (yych <= 'r') goto yy56;
				if (yych <= 's') goto yy1046;
				goto yy1053;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
				} else {
					if (yych == 'y') goto yy1051;
					goto yy56;
				}
			}
		}
	}
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1149;
	if (yych != 'e') goto yy56;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1074;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1074;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1151;
	if (yych != 'k') goto yy56;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1083;
		if (yych <= 'R') goto yy56;
		goto yy1082;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy1083;
		} else {
			if (yych == 's') goto yy1082;
			goto yy56;
		}
	}
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy142;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'h') goto yy1153;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1154;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1146;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1146;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1155;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1155;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1146;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1146;
		if (yych == ')') goto yy139;
		goto yy3;
	}
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1152;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'g') goto yy1164;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1140;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1158;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1141;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'v') goto yy1159;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1142;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1160;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1143;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'n') goto yy1161;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1144;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 't') goto yy1162;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1145;
	if (yych != 'h') goto yy154;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1146;
		} else {
			if (yych == ' ') goto yy1146;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy56;
		}
	}
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1153;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'h') goto yy1165;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1154;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1166;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1146;
			} else {
				if (yych == ' ') goto yy1146;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy147;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'H') goto yy1155;
				if (yych <= 'Z') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1167;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1146;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1146;
			if (yych <= '(') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy147;
			goto yy3;
		} else {
			if (yych <= '/') goto yy147;
			if (yych == '_') goto yy147;
			goto yy3;
		}
	}
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1184;
				goto yy141;
			} else {
				if (yych <= 'P') goto yy1186;
				if (yych <= 'U') goto yy141;
				goto yy1185;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1184;
				goto yy141;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1186;
				goto yy141;
			} else {
				if (yych <= 'v') goto yy1185;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
			goto yy1179;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy1179;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy141;
			goto yy1176;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'x') goto yy1176;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1172;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1173;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1174;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy139;
	goto yy166;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1177;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1146;
		} else {
			if (yych == ' ') goto yy1146;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'T') goto yy142;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'u') goto yy1180;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1181;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1182;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1183;
		if (yych != 'a') goto yy3;
	}
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy142;
			goto yy1195;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy1195;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy142;
			goto yy1192;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy1192;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'T') goto yy142;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 't') goto yy1187;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'E') goto yy143;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy1188;
				if (yych <= 'z') goto yy143;
				goto yy193;
			}
		}
	}
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy144;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') goto yy1189;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1190;
		if (yych != 'b') goto yy3;
	}
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1191;
	if (yych != 'e') goto yy56;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy204;
	goto yy56;
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1193;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1194;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1145;
		if (yych == 'h') goto yy1145;
		goto yy3;
	}
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1196;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
			goto yy1155;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1155;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy147;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy141;
				goto yy1184;
			} else {
				if (yych == 'P') goto yy1186;
				goto yy141;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1185;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1213;
				if (yych <= 'o') goto yy146;
				goto yy1215;
			} else {
				if (yych == 'v') goto yy1214;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1179;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 't') goto yy1208;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1176;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'x') goto yy1205;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1172;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1201;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1173;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1202;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1174;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1203;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1204;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy139;
		if (yych <= ',') goto yy166;
		goto yy147;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy166;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy166;
		}
	}
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1177;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1206;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1146;
			if (yych <= 0x1F) goto yy3;
			goto yy1146;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1180;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy1209;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1181;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1210;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1182;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1211;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1183;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1212;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1195;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy1224;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1192;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy1221;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'T') goto yy1187;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1216;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy143;
			} else {
				if (yych <= 'E') goto yy1188;
				if (yych <= 'Z') goto yy143;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1217;
				if (yych <= 'z') goto yy151;
				goto yy193;
			}
		}
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1189;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'm') goto yy1218;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1190;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1219;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1191;
	if (yych != 'e') goto yy154;
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy316;
	goto yy154;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1193;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1222;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1194;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1223;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1145;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1163;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1196;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1225;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1155;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1167;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy141;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy1227;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy142;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'k') goto yy1228;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1229;
		if (yych <= '(') goto yy3;
		goto yy139;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1230;
	if (yych != 'o') goto yy56;
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1231;
	if (yych != 'f') goto yy56;
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1233;
	if (yych <= '2') goto yy1235;
	if (yych <= '9') goto yy1236;
	goto yy56;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1237;
		} else {
			if (yych <= ' ') goto yy1237;
			if (yych <= '/') goto yy1234;
			if (yych <= '9') goto yy1236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1239;
			if (yych == 'P') goto yy1239;
		} else {
			if (yych <= 'a') goto yy1239;
			if (yych == 'p') goto yy1239;
		}
	}
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1237;
			goto yy1234;
		} else {
			if (yych <= ' ') goto yy1237;
			if (yych <= '/') goto yy1234;
			if (yych >= '5') goto yy1234;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1239;
			if (yych == 'P') goto yy1239;
			goto yy1234;
		} else {
			if (yych <= 'a') goto yy1239;
			if (yych == 'p') goto yy1239;
			goto yy1234;
		}
	}
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy1234;
		} else {
			if (yych <= ' ') goto yy1237;
			if (yych <= '@') goto yy1234;
			goto yy1239;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1239;
			goto yy1234;
		} else {
			if (yych <= 'a') goto yy1239;
			if (yych == 'p') goto yy1239;
			goto yy1234;
		}
	}
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1238, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1237;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy1237;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy1239;
			if (yych != 'p') goto yy56;
		}
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1241;
		if (yych == 'm') goto yy1241;
		goto yy56;
	}
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1241;
	if (yych != 'm') goto yy56;
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1243;
		if (yych == '\t') goto yy1243;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1243;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1243;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1234;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1227;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'c') goto yy1245;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1228;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'k') goto yy1246;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1229;
			goto yy3;
		} else {
			if (yych <= ')') goto yy139;
			if (yych == '-') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy147;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy1248;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1249;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1044;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1251;
	if (yych != 'd') goto yy1045;
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1252;
	if (yych != 'a') goto yy56;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1253;
	if (yych != 'y') goto yy56;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1057;
	} else {
		if (yych <= 'S') goto yy1082;
		if (yych == 's') goto yy1082;
		goto yy1057;
	}
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1255;
	if (yych != 'o') goto yy56;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1256;
	if (yych != 'f') goto yy56;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1257, *YYCURSOR);
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1248;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 's') goto yy1259;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1249;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1260;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1044;
			if (yych <= 0x1F) goto yy3;
			goto yy1250;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
			goto yy1298;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'b') goto yy1298;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1288;
			if (yych <= 'Q') goto yy141;
			goto yy1287;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy141;
			goto yy1288;
		} else {
			if (yych == 'r') goto yy1287;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy141;
			goto yy1284;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'u') goto yy1284;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1266;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy141;
			goto yy1266;
		} else {
			if (yych == 'o') goto yy1265;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
			goto yy1269;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1269;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1267;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1268;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
			goto yy1175;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1270;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1271;
		if (yych <= '(') goto yy3;
		goto yy139;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1272;
	if (yych != 'o') goto yy56;
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1273;
	if (yych != 'f') goto yy56;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(1274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1275;
	if (yych <= '2') goto yy1276;
	if (yych <= '9') goto yy1277;
	goto yy56;
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1278;
			goto yy1234;
		} else {
			if (yych <= ' ') goto yy1278;
			if (yych <= '/') goto yy1234;
			if (yych <= '9') goto yy1277;
			goto yy1234;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1280;
			if (yych == 'P') goto yy1280;
			goto yy1234;
		} else {
			if (yych <= 'a') goto yy1280;
			if (yych == 'p') goto yy1280;
			goto yy1234;
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1278;
			goto yy1234;
		} else {
			if (yych <= ' ') goto yy1278;
			if (yych <= '/') goto yy1234;
			if (yych >= '5') goto yy1234;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1280;
			if (yych == 'P') goto yy1280;
			goto yy1234;
		} else {
			if (yych <= 'a') goto yy1280;
			if (yych == 'p') goto yy1280;
			goto yy1234;
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy1234;
		} else {
			if (yych <= ' ') goto yy1278;
			if (yych <= '@') goto yy1234;
			goto yy1280;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1280;
			goto yy1234;
		} else {
			if (yych <= 'a') goto yy1280;
			if (yych == 'p') goto yy1280;
			goto yy1234;
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1279, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1278;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy1278;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy1280;
			if (yych != 'p') goto yy56;
		}
	}
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1282;
		if (yych == 'm') goto yy1282;
		goto yy56;
	}
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1282;
	if (yych != 'm') goto yy56;
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1243;
		if (yych == '\t') goto yy1243;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1243;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(1283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1243;
		if (yych <= 0x08) goto yy56;
		goto yy1243;
	} else {
		if (yych == ' ') goto yy1243;
		goto yy56;
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy142;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1285;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1286;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy144;
			goto yy1155;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy1155;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy142;
			goto yy1290;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1290;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1289;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1178;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1291;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1146;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1293;
	if (yych != 'd') goto yy1147;
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1294;
	if (yych != 'a') goto yy56;
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1295;
	if (yych != 'y') goto yy56;
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1057;
	} else {
		if (yych <= 'S') goto yy1082;
		if (yych == 's') goto yy1082;
		goto yy1057;
	}
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1297;
	if (yych != 'o') goto yy56;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1256;
	if (yych == 'f') goto yy1256;
	goto yy56;
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'R') goto yy142;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'r') goto yy1299;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy143;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'u') goto yy1300;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1301;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1302;
		if (yych != 'r') goto yy3;
	}
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy204;
	if (yych == 'y') goto yy204;
	goto yy56;
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1298;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'b') goto yy1321;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1288;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1287;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1317;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy1316;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1284;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1313;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1266;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1265;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1308;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy1307;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1269;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1311;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1267;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1309;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1268;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1310;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1204;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1270;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1312;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1271;
			goto yy3;
		} else {
			if (yych <= ')') goto yy139;
			if (yych == '-') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy147;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1285;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1314;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1286;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1315;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1155;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1167;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1290;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 's') goto yy1319;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1289;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1318;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1291;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1320;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1146;
			if (yych <= 0x1F) goto yy3;
			goto yy1292;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'R') goto yy1299;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1322;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1300;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'u') goto yy1323;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1301;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1324;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1302;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1325;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy204;
	if (yych == 'y') goto yy316;
	goto yy154;
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1328, *YYCURSOR);
	if (yych <= '/') goto yy1329;
	if (yych <= '9') goto yy1327;
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
			goto yy1371;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1371;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1363;
			if (yych <= 'T') goto yy141;
			goto yy1364;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy141;
			goto yy1363;
		} else {
			if (yych == 'u') goto yy1364;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1352;
			if (yych <= 'L') goto yy141;
			goto yy1353;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy141;
			goto yy1352;
		} else {
			if (yych == 'm') goto yy1353;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy1348;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1348;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy1344;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1344;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1004;
		goto yy56;
	} else {
		if (yych <= '9') goto yy1338;
		if (yych <= ':') goto yy1004;
		goto yy56;
	}
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1004;
		goto yy56;
	} else {
		if (yych <= '4') goto yy1338;
		if (yych == ':') goto yy1004;
		goto yy56;
	}
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1004;
	if (yych == ':') goto yy1004;
	goto yy56;
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1004;
		goto yy56;
	} else {
		if (yych <= '5') goto yy1339;
		if (yych == ':') goto yy1004;
		goto yy56;
	}
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1340, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1007;
	if (yych <= '5') goto yy1341;
	if (yych <= '6') goto yy1342;
	goto yy1007;
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1343;
	goto yy56;
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1015;
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy142;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'l') goto yy1345;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy143;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'f') goto yy1346;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1347;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1145;
		if (yych == 'h') goto yy1145;
		goto yy3;
	}
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'R') goto yy142;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1349;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1350;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1351;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy172;
		if (yych == 'y') goto yy172;
		goto yy3;
	}
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1360;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy142;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1360;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy142;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy1354;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1355;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1356;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1357;
		if (yych != 'o') goto yy3;
	}
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1358;
	if (yych != 'w') goto yy56;
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	++YYCURSOR;
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy143;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'y') goto yy1361;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy1362;
		if (yych <= 'z') goto yy144;
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy142;
			if (yych <= 'R') goto yy1369;
			goto yy1370;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1369;
			if (yych <= 's') goto yy1370;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'Q') goto yy142;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1365;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 's') goto yy1366;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1367;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1368;
		if (yych != 'a') goto yy3;
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
			goto yy1178;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1044;
		} else {
			if (yych == ' ') goto yy1044;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1372;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1178;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1371;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1403;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1363;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1364;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1395;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1396;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1352;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1353;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1386;
				goto yy146;
			} else {
				if (yych <= 'm') goto yy1387;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1348;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1382;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1344;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1378;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1345;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'l') goto yy1379;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1346;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'f') goto yy1380;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1347;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1381;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1381:
	YYDEBUG(1381, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1145;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1163;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1349;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 's') goto yy1383;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1350;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1384;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1351;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1385;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy172;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy185;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1386:
	YYDEBUG(1386, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1360;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1393;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1354;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy1388;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1355;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1389;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1356;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1390;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1357;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1391;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1358;
	if (yych != 'w') goto yy154;
	YYDEBUG(1392, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1359;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1359;
	}
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1361;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'y') goto yy1394;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1394:
	YYDEBUG(1394, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1362;
		} else {
			if (yych == '.') goto yy1362;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1362;
			if (yych <= 'Z') goto yy144;
			goto yy1362;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1362;
			if (yych <= 'z') goto yy152;
			goto yy1362;
		}
	}
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy147;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy142;
				goto yy1369;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1370;
				goto yy142;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy150;
				goto yy1401;
			} else {
				if (yych <= 's') goto yy1402;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1396:
	YYDEBUG(1396, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1365;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1397;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1366;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 's') goto yy1398;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1398:
	YYDEBUG(1398, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1367;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1399;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1368;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1400;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1044;
			if (yych <= 0x1F) goto yy3;
			goto yy1044;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1372;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1404;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1417;
			if (yych <= 'X') goto yy141;
			goto yy1418;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy141;
			goto yy1417;
		} else {
			if (yych == 'y') goto yy1418;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
			goto yy1411;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy1411;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1408;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1408:
	YYDEBUG(1408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1409;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1410;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
			goto yy1175;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1411:
	YYDEBUG(1411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1412;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy143;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'i') goto yy1413;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1413:
	YYDEBUG(1413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy144;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') goto yy1414;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1415;
		if (yych != 'h') goto yy3;
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1416;
	if (yych != 't') goto yy56;
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1362;
yy1417:
	YYDEBUG(1417, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych == 'C') goto yy1419;
				goto yy142;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'c') goto yy1419;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy193;
			goto yy196;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy142;
			goto yy193;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy335;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy335;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1420:
	YYDEBUG(1420, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1417;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1418;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1432;
				goto yy146;
			} else {
				if (yych <= 'y') goto yy1433;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1421:
	YYDEBUG(1421, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1411;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'd') goto yy1426;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1422:
	YYDEBUG(1422, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1408;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1423;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1423:
	YYDEBUG(1423, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1409;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1424;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1424:
	YYDEBUG(1424, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1410;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1425;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1425:
	YYDEBUG(1425, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1204;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1426:
	YYDEBUG(1426, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1412;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1427;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1427:
	YYDEBUG(1427, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1413;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy1428;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1428:
	YYDEBUG(1428, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1414;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'g') goto yy1429;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1429:
	YYDEBUG(1429, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1415;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1430;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1430:
	YYDEBUG(1430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1416;
	if (yych != 't') goto yy154;
	YYDEBUG(1431, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1362;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1362;
	}
yy1432:
	YYDEBUG(1432, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'C') goto yy1419;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'c') goto yy1434;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1433:
	YYDEBUG(1433, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy311;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy142;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1434:
	YYDEBUG(1434, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy335;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy346;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1435:
	YYDEBUG(1435, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'O') goto yy1443;
			if (yych <= 'U') goto yy141;
			if (yych <= 'V') goto yy1444;
			goto yy1441;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy141;
			goto yy1443;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy141;
				goto yy1444;
			} else {
				if (yych <= 'w') goto yy1441;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy1436:
	YYDEBUG(1436, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy141;
			goto yy1440;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'x') goto yy1440;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1437:
	YYDEBUG(1437, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1438;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1438:
	YYDEBUG(1438, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1439;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1439:
	YYDEBUG(1439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1178;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1440:
	YYDEBUG(1440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
			goto yy1370;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1370;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1441:
	YYDEBUG(1441, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy1442;
		if (yych <= 'z') goto yy142;
	}
yy1442:
	YYDEBUG(1442, *YYCURSOR);
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1443:
	YYDEBUG(1443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
			goto yy1449;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1449;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1444:
	YYDEBUG(1444, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'E') goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy1445;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1445:
	YYDEBUG(1445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy143;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'm') goto yy1446;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1446:
	YYDEBUG(1446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy1447;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1447:
	YYDEBUG(1447, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1448;
		if (yych != 'e') goto yy3;
	}
yy1448:
	YYDEBUG(1448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy204;
	goto yy56;
yy1449:
	YYDEBUG(1449, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy1450;
		if (yych <= 'z') goto yy143;
	}
yy1450:
	YYDEBUG(1450, *YYCURSOR);
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1451:
	YYDEBUG(1451, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy147;
				if (yych <= '@') goto yy3;
				goto yy141;
			} else {
				if (yych <= 'O') goto yy1443;
				if (yych <= 'U') goto yy141;
				goto yy1444;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1441;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1458;
				if (yych <= 'u') goto yy146;
				goto yy1459;
			} else {
				if (yych <= 'w') goto yy1457;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1452:
	YYDEBUG(1452, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1440;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'x') goto yy1456;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1453:
	YYDEBUG(1453, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1438;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1454;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1454:
	YYDEBUG(1454, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1439;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1455;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1455:
	YYDEBUG(1455, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1456:
	YYDEBUG(1456, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1370;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1402;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1457:
	YYDEBUG(1457, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1442;
		} else {
			if (yych == '.') goto yy1442;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1442;
			if (yych <= 'Z') goto yy142;
			goto yy1442;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1442;
			if (yych <= 'z') goto yy150;
			goto yy1442;
		}
	}
yy1458:
	YYDEBUG(1458, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1449;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1464;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1459:
	YYDEBUG(1459, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy1445;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy1460;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1460:
	YYDEBUG(1460, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1446;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'm') goto yy1461;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1461:
	YYDEBUG(1461, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1447;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy1462;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1462:
	YYDEBUG(1462, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1448;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1463;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1463:
	YYDEBUG(1463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy316;
	goto yy154;
yy1464:
	YYDEBUG(1464, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1450;
		} else {
			if (yych == '.') goto yy1450;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1450;
			if (yych <= 'Z') goto yy143;
			goto yy1450;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1450;
			if (yych <= 'z') goto yy151;
			goto yy1450;
		}
	}
yy1465:
	YYDEBUG(1465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy1466;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1466:
	YYDEBUG(1466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1467;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1467:
	YYDEBUG(1467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1468;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1468:
	YYDEBUG(1468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1469;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1469:
	YYDEBUG(1469, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1470;
		if (yych != 'd') goto yy3;
	}
yy1470:
	YYDEBUG(1470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1471;
	if (yych != 'a') goto yy56;
yy1471:
	YYDEBUG(1471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1472;
	if (yych != 'y') goto yy56;
yy1472:
	YYDEBUG(1472, *YYCURSOR);
	++YYCURSOR;
yy1473:
	YYDEBUG(1473, *YYCURSOR);
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1474:
	YYDEBUG(1474, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1466;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 's') goto yy1475;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1475:
	YYDEBUG(1475, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1467;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1476;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1476:
	YYDEBUG(1476, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1468;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1477;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1477:
	YYDEBUG(1477, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1469;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1478;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1478:
	YYDEBUG(1478, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1470;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1479;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1479:
	YYDEBUG(1479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1471;
	if (yych != 'a') goto yy154;
	YYDEBUG(1480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1472;
	if (yych != 'y') goto yy154;
	YYDEBUG(1481, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1473;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1473;
	}
}

}

#define YYMAXFILL 33

timelib_time* timelib_strtotime(char *s, size_t len, struct timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->f = 0.0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->f == TIMELIB_UNSET ) time->f = 0.0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case 's': /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case 'u': /* up to six digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, "A six digit millisecond could not be found", string, begin);
					} else {
						s->time->f = (f / pow(10, (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->f = 0.0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, "Data missing", string, ptr);
					done = 1;
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
